//*****************************************************************************
//                                 Demo2.prg
// Ŀ
//          Simple (trivial) demo application created with OBJECT.lib        
//        Length of source code is (without notes) 75 lines, 2520 bytes      
// 
//                        (c) 1991, JHK, JHK-Software, Piestany
//
//                Author:
//                          Jan Hercek
//                          JHK-Software
//                          N.Teslu 26
//                  92101   Piestany
//                          Slovak republic
//                          (in central Europe)
//
//                          (tel: +42/838/21782)
//
//                Compile with Clipper.exe, switches: /N/M/W/A
//                Link command: RtLink FI Demo2 LIB Object
//                          or: RtLink FI Demo2 PLL Object
//*****************************************************************************

#include "Set.ch"
#include "InKey.ch"
#include "Object.ch"

static oD,oV,oS,oM      //objects: Database, View, mask (Say get), Menu

procedure Main(clr)
  ObjectInit(clr,"Demo2",2,1992,"every Clipper programmer",,"evaluating version 0.02")
  object oD of Dbf  init DInit()
  object oV of View init VInit()
  object oS of Mask init SInit()   //new "say_get" object
  object oM of Menu init MInit()
  oM:Process()
  ObjectDone()
  return

procedure DInit()
  oD:AddDbf("Employ")
  oD:AddField("Name", "C",20)
  oD:AddField("Birth","D");     oD:ChValid({||Alert("Changed field"),true})  //validation after any change
  oD:AddField("Pay",  "N",8,2); oD:Range(0,99000)  //range of good values
  oD:AddField("Note", "M")
  oD:AddNtx(,"Emp_name","Name")  //file_name,index_key
  return

procedure VInit()
  oV:Select("Employ")
  oV:AddField("First & last name","Name", "field->Name")
  oV:AddField("Annual pay",       "Pay",  "field->Pay")
  oV:AddField("Birth date",       "Birth","field->Birth")
  oV:AddMemo( "Remarks",          "Rem.", "field->Note")
  *
  oV:AddReport("~1.Employees")
  oV:AddRTop("Short view of employees;(only names, pays and birth dates)")
  oV:AddRField("First & last name","Name")
  oV:AddRField("Annual pay",       "Pay",,true)
  oV:AddRField("Birth date",       "Birth")
  oV:AddRBottom("Created by Jan Hercek, Piestany")
  *
  oV:AddAction(K_ALT_U,{||Alert("User action in oV-object")},"ALT_U=Action")
  oV:AddFilter("~1.Only records<5","RecNo()<5")
  oV:SetConfirm(false) //local confirmation for this object
  oV:IndexNo:=1        //local active index for this object
  return

procedure SInit()                                    //say_get window, all next items are relative into the window.
  oS:Select("Employ")                                //primary database
  oS:DefWindow("Programmer defined window",,,10,48)  //Window_name,Row,Col,RowSize,ColSize
  oS:AddSay( 2,11,"First and last name")             //Row,Col,Text
  oS:AddSay( 4,13,"Annual pay")
  oS:AddSay( 6,15,"Birth date")
  oS:AddSay( 8,17,"Remarks")
  oS:AddField( 3,12,"Name",   "field->Name")   //Row,Col,Column_title,Field_name
  oS:AddField( 5,14,"Pay",    "field->Pay")
  oS:AddField( 7,16,"Birth",  "field->Birth")
  oS:AddMemo(  9,18,"Remarks","field->Note")
  *
  oS:AddAction(K_ALT_U,{||Alert("Action in oS-object")},"ALT_U=Action")
  return

procedure MInit()
  oM:AddBar("~File")
    oM:AddView("~Employees","Employees", oV)
    oM:AddView("E~mployees",, oS)                       //new object into the menu
    oM:AddItem("Text ~file",   {||FInfoShow()})
    oM:AddItem("E~xit  Alt-X", {||oM:Done()}, K_ALT_X)
  oM:AddBar("~Archiv")
    oM:AddItem("~Save on disk a:", {||oD:Save("a:")})
    oM:AddItem("~Restore from disk a:", {||oD:Load("a:")})
  oM:AddBar("~Problems?")
    oM:AddItem("~Reindex", {||oD:ReIndex()})
    oM:AddItem("~Pack", {||oD:Pack()})
    oM:AddItem("~Change password", {|i|oM:Password(i)})
    oM:AddCheck("~Wrap menu", {|i,v|Set(_SET_WRAP,v)})
  return

//
//All program is only linear describe of desired actions,
//without any jumps, loops, ...
//without any screen positionning commands,
//with the minimal possibility to create any error.
//
//Remember: 
//this is a NET version, a program created by with OBJECT.lib has NET capability
//
//Excuse me, please, for my terrible english. Many thanks.
//(Have you any job for me?)
//
// it is REALLY end of program 

