//*****************************************************************************
//                                 Demo3.prg
// Ŀ
//          Simple (trivial) demo application created with OBJECT.lib        
//        Length of source code is (without notes) 90 lines, 3197 bytes      
// 
//                        (c) 1991, JHK, JHK-Software, Piestany
//
//                Author:
//                          Jan Hercek
//                          JHK-Software
//                          N.Teslu 26
//                  92101   Piestany
//                          Slovak republic
//                          (in central Europe)
//
//                          (tel: +42/838/21782)
//
//                Compile with Clipper.exe, switches: /N/M/W/A
//                Link command: RtLink FI Demo3 LIB Object
//                          or: RtLink FI Demo3 PLL Object
//*****************************************************************************

#include "Set.ch"
#include "InKey.ch"
#include "Object.ch"

static oD,oV,oU,oM  //objects: Database, View (employees), View (tasks), Menu

procedure Main(clr)
  NetLimit(2)  //in the same time can work max two users
  ObjectInit(clr,"Demo3",2,1992,"every Clipper programmer",,"evaluating version 0.03")
  object oD of Dbf  init DInit()
  object oV of View init VInit()
  object oU of View init UInit()
  object oM of Menu init MInit()
  oM:Process()
  ObjectDone()
  return

procedure DInit()
  oD:AddDbf("Employ")
  oD:AddField("Name", "C",20)
  oD:AddField("Birth","D");    oD:ChValid({||Alert("Changed field"),true})
  oD:AddField("Pay",  "N",8,2);oD:Range(0,99000)
  oD:AddField("Note", "M")
  oD:AddField("EmpNo","N",3); oD:ChValid({|g,l,v|upDateRel(g:VarGet(),v)}) //employee number; keep relation field in database Tasks
  oD:AddNtx("~1.Name","Emp_name","Name")           //menu_item, file_name, index_key
  oD:AddNtx("~2.Emp. number","Emp_No","EmpNo")
  *
  oD:AddDbf("Tasks")
  oD:AddField("EmpNo",   "N",3); oD:Valid({|Get|DbfValid(,Get,"Employ",2,{||Employ->EmpNo})}) //select from the Employ database
  oD:AddField("Task",    "C",20)
  oD:AddField("Descript","M")
  oD:AddNtx("~1.Emp. number","TskEmpNo","EmpNo")
  oD:AddRelation("EmpNo","Employ",2)  //key_expression, database, index_order
  return

function updateRel(newEmpNo,oldEmpNo)                   //after change Employ->EmpNo we must to change
  net replace EmpNo:=newEmpNo in Tasks,1 seek oldEmpNo  //all records Tasks->EmpNo (relation integrity!)
  return true

procedure VInit()
  oV:Select("Employ")
  oV:AddField("First & last name","Name",  "field->Name")
  oV:AddField("Annual pay",       "Pay",   "field->Pay")
  oV:AddField("Birth date",       "Birth", "field->Birth")
  oV:AddMemo( "Remarks",          "Rem.",  "field->Note")
  oV:AddField("Emp. number",      "Emp.no","field->EmpNo")
  *
  oV:AddReport("~1.Employees")
  oV:AddRTop("Short view of employees;(only names, pays and birth dates)")
  oV:AddRField("First & last name","Name")
  oV:AddRField("Annual pay","Pay",,true)
  oV:AddRField("Birth date","Birth")
  oV:AddRBottom("Created by Jan Hercek, Piestany")
  *
  oV:AddAction(K_ALT_U,{||Alert("User action in oV-object")},"ALT_U=Action")
  oV:AddFilter("~1.Only records<5","RecNo()<5")
  oV:DelBlock:={|o|DoDelete(o)} //after delete employee record in Employ database
  return                        //we must deleted all records with this EmpNo in database Tasks
                                //(relation integrity!)
function DoDelete(obj)
  local p:=Employ->EmpNo
  returnif Alert("Do you want to delete this Employee?",{"Yes","No"})<>1 with false
  net delete continue return false            //delete his in database Employ
  net delete in Uloha,1 seek p return false   //delete all his (her) tasks
  obj:Tb:RefreshAll()                         //refresh view window
  return true

procedure UInit()
  oU:Select("Tasks")
  oU:AddField("Emp. number",     "Emp.no","field->EmpNo")
  oU:AddField("Firs & last name","Name",  "Employ->Name",,{||false})   //set when to false (locally for this view)
  oU:AddField("Task name",       "Task",  "field->Task")
  oU:AddMemo( "Task description","Descr.","field->Descript")
  oU:AddAction(K_ALT_U,{||Alert("Action in Tasks")},"ALT_U=Action")
  return

procedure MInit()
  oM:AddBar("~File")
    oM:AddView("~Employees","Employees", oV)
    oM:AddView("~Tasks",, oU)                       //new object into the menu
    oM:AddItem("Text ~file",   {||FInfoShow()})
    oM:AddItem("E~xit  Alt-X", {||oM:Done()}, K_ALT_X)
  oM:AddBar("~Archiv")
    oM:AddItem("~Save on disk a:", {||oD:Save("a:")})
    oM:AddItem("~Restore from disk a:", {||oD:Load("a:")})
  oM:AddBar("~Problems?")
    oM:AddItem("~Reindex", {||oD:ReIndex()})
    oM:AddItem("~Pack", {||oD:Pack()})
    oM:AddItem("~Change password", {|i|oM:Password(i)})
    oM:AddCheck("~Wrap menu", {|i,v|Set(_SET_WRAP,v)})
  return

//
//All program is only linear describe of desired actions,
//without any jumps, loops, ...
//without any screen positionning commands,
//with the minimal possibility to create any error.
//
//Remember: 
//this is a NET version, a program created by with OBJECT.lib has NET capability
//
//Excuse me, please, for my terrible english. Many thanks.
//(Have you any job for me?)
//
// it is REALLY end of program 

