/***
*	Errorsys.prg
*	Standard Clipper 5.0 error handler
*	Copyright (c) 1990 Nantucket Corp.  All rights reserved.
*
*       Modified by JHK, JHK-Software, Piestany.
*
*	Compile:  /m/n/w
*/

#include "error.ch"
#include "fileio.ch"

// put messages to STDERR
#command ? <list,...>   =>  ?? Chr(13) + Chr(10) ; ?? <list>
#command ?? <list,...>  =>  OutErr(<list>)


// used below
#define NTRIM(n)            ( LTrim(Str(n)) )
#define CR_LF               (chr(13)+chr(10))


static ErrFile:=""          //new Ŀ
static BreakStack:={}       //new >> JHK


//*****************************************************************************
// see Object.ch break exception
//
procedure PushBreak(Br)
  AAdd(BreakStack,Br)
  return

function TopBreak()
  return(ATail(BreakStack))

function PopBreak()
  return(ATailDel(BreakStack))

procedure DoBreak(o)
  break o; return


/***
*       ErrorSys()
*
*       Note:  automatically executes at startup
*/
procedure ErrorSys()
  ErrorBlock({|e|Abort(e)}); return



//*****************************************************************************
// UserID( cUserID )
// UserNo( nRecNo_in_database_(cIFR) )
// UserLevel( nLevel_for_programmer_(defined_by_supervisor) )
//
function UserID(new)
  static old:=""
  local tmp:=old
  if !Empty(new); old:=AllTrim(new); endif
  return(tmp)

function UserNo(new)
  static old:=0
  local tmp:=old
  if !Empty(new); old:=new; endif
  return(tmp)

function UserLevel(new)
  static old:=0
  local tmp:=old
  if !Empty(new); old:=new; endif
  return(tmp)



/***
*       Abort()
*/
function Abort(e)
local i, cMessage, aOptions, nChoice, cDateTime, fhandle, nFirstProc


        if ValType(e)=="C"   //build error message

          cMessage:="Error OBJECT/ABORT  "+e
          Alert(cMessage,{"Quit"})
          nFirstProc:=1

        else //standart clipper message

          //first procedure (called from...)
          nFirstProc:=2

          // by default, division by zero yields zero
          if ( e:genCode == EG_ZERODIV )
                  return (0)
          end


          // for network open error, set NETERR() and subsystem default
          if ( e:genCode == EG_OPEN .and. e:osCode == 32 .and. e:canDefault )

                  NetErr(.t.)
                  return (.f.)                                                                    // NOTE

          end


          // for lock error during APPEND BLANK, set NETERR() and subsystem default
          if ( e:genCode == EG_APPENDLOCK .and. e:canDefault )

                  NetErr(.t.)
                  return (.f.)                                                                    // NOTE

          end



          // build error message
          cMessage := ErrorMessage(e)


          // build options array
          // aOptions := {"Break", "Quit"}
          aOptions := {"Quit"}

          if (e:canRetry)
                  AAdd(aOptions, "Retry")
          end

          if (e:canDefault)
                  AAdd(aOptions, "Default")
          end


          // put up alert box
          nChoice := 0
          while ( nChoice == 0 )

                  if ( Empty(e:osCode) )
                          nChoice := Alert( cMessage, aOptions )

                  else
                          nChoice := Alert( cMessage + ;
                                                          ";(DOS Error " + NTRIM(e:osCode) + ")", ;
                                                          aOptions )
                  end


                  if ( nChoice == NIL )
                          exit
                  end

          end


          if ( !Empty(nChoice) )

                  // do as instructed
                  if ( aOptions[nChoice] == "Break" )
                          Break(e)

                  elseif ( aOptions[nChoice] == "Retry" )
                          return (.t.)

                  elseif ( aOptions[nChoice] == "Default" )
                          return (.f.)

                  end

          end


          // display message and traceback
          if ( !Empty(e:osCode) )
                  cMessage += " (DOS Error " + NTRIM(e:osCode) + ") "
          end


        endif  //abort enhancement.


        cMessage+=" "
        cDateTime:="Date="+DtoC(Date())+"  Time="+Time()+" "

        ? "UserID="+UserID()+" "
        if !Empty(NetName());  ? "Net_name="+NetName()+" ";  endif
        ? cDateTime
        ? cMessage
        i := nFirstProc
	while ( !Empty(ProcName(i)) )
          ? "Called from", Trim(ProcName(i)) + "(" + NTRIM(ProcLine(i)) + ") "
          i++
	end

        //attempt out message into error file
        ErrorLevel(1)

        LogOff()                        //work around crash test!
        close all

        ErrorBlock( {|| __Quit()} )     //disable recursived call this proc. (force quit)

        if !Empty(ErrFile)

          if File(ErrFile)
            fhandle:=FOpen(ErrFile,FO_WRITE)
            FSeek(fhandle,0,FS_END)
          else
            fhandle:=FCreate(ErrFile,FC_NORMAL)
          endif

          if fhandle<>F_ERROR

            FWrite(fhandle,"UserID="+UserID()+" "+CR_LF)
            if !Empty(NetName()); FWrite(fhandle,"Net_name="+NetName()+" "+CR_LF); endif
            FWrite(fhandle,cDateTime+CR_LF)
            FWrite(fhandle,cMessage+CR_LF)

            i := nFirstProc
            while ( !Empty(ProcName(i)) )
              FWrite(fhandle, "Called from "+AllTrim(ProcName(i))+"("+NTRIM(ProcLine(i))+") "+CR_LF )
              i++
            end

            FWrite(fhandle,CR_LF)
            FClose(fhandle)

          endif

        endif

	// give up
	QUIT

return (.f.)




/***
*	ErrorMessage()
*/
function ErrorMessage(e)
local cMessage


	// start error message
        cMessage := if( e:severity > ES_WARNING, "Error", "Warning" )
        cMessage += " CLIPPER/"


	// add subsystem name if available
	if ( ValType(e:subsystem) == "C" )
		cMessage += e:subsystem()
	else
		cMessage += "???"
	end


	// add subsystem's error code if available
	if ( ValType(e:subCode) == "N" )
		cMessage += ("/" + NTRIM(e:subCode))
	else
		cMessage += "/???"
	end


	// add error description if available
	if ( ValType(e:description) == "C" )
		cMessage += ("  " + e:description)
	end


	// add either filename or operation
	if ( !Empty(e:filename) )
		cMessage += (": " + e:filename)

	elseif ( !Empty(e:operation) )
		cMessage += (": " + e:operation)

	end


return (cMessage)




function SetErrFile( FName )
  local OFName:=ErrFile
  if FName<>nil;  ErrFile:=FName;  endif
  return(OFName)

//.......................................................... eof ..............

