//*****************************************************************************
// C_Window.prg
// Window class for OBJECT v2.03
// Copyright (c) 1991, JHK, JHK-Software, Piestany
// Compile with: /N/M/W/A
//-----------------------------------------------------------------------------

#include "Object.ch"

static WList:={}       //this stack contain all visible windows
static MinStack:={}    //stack for minimized windows

create class Window from Box    //Usage sequence: Init,Paint, (Drag,Max,Min,..) Done
  export:
  var ID       //0                   //window ID (1..x)
  var WRow     //3                   //saved window coord. for Restore()
  var WCol     //4                   //...
  var WRowSize //MaxRow()-7          //...
  var WColSize //MaxCol()-9          //...
  var IsMax    //false               //current state of window (is maximize?)
  var IsMin    //false               //...
  var MaxRows  //MaxRow()-3          //maximum available RowSize
  var MaxCols  //MaxCol()-1          //maximum available ColSize
  var MinRows  //1                   //minimum available RowSize
  var MinCols  //5                   //minimum available ColSize
  var UpFlag   //false               //if is true then not show Window:ID
  var Screen   //""                  //saved screen before painting UpWindow
  var UpScreen //""                  //Up color atributes,speed optimization
  var BkScreen //""                  //BackGround color atributes, speed optimization
  var RCInfo   //""                  //... used as flag for changed window coord.
  var InfoMsg  //""                  //show this message into bottom of window (if !empty())
  var Frame    //(object of Frame)   //need for Drag()
  method New=WindowNew            //o:New()
  method Init=WindowInit          //o:Init(Name,R,C,Rs,Cs,Clr,Shadow)
  method GoodInit=WindowGoodInit  //o:GoodInit(Name,R,C,Rs,Cs,CurSize,Clr,Shadow)
  method VPaint=WindowVPaint      //o:VPaint()             //virtual paint, use (overwrite) in child classes for redrawing window.
  method SaveIn=WindowSaveIn      //o:SaveIn()             //save screen inside window, speed optimization
  method DoInfo=WindowDoInfo      //o:DoInfo()             //write any info into bottom of window (if exist)
  method Paint=WindowPaint        //o:Paint(IsTop)         //if not on top of stack then color is Desk (not selected)
  method Top=WindowTop            //o:Top(lRePaint)        //move window on top of stack, and paint it.
  method RePaint=WindowRePaint    //o:RePaint(lClearDesk)  //redraw all visible window
  method Drag=WindowDrag          //o:Drag(lCanSize)       //move size current window
  method Maximize=WindowMaximize  //o:Maximize()           //maximize window
  method Minimize=WindowMinimize  //o:Minimize(lShow)      //minimize, if lShow is false then no RePaint() is invoked.
  method Restore=WindowRestore    //o:Restore()            //restore window.
  method Done=WindowDone          //o:Done(lRePaint)       //work around MinStack
  endclass

//-----------------------------------------------------------------------------
// GetWList() --> WList
// return window list
//
function GetWList()
  return(WList)


//-----------------------------------------------------------------------------
// RePaintDesktop() --> nil
// redraw entire screen
//
procedure RePaintDesktop()
  SaveDOut(ResTxt(172))
    DispBegin()
    @ 1,0,MaxRow()-1,MaxCol() box "" color m->Color:Desk   //create background
    if !Empty(WList); WList[1]:Paint(); endif
    DispEnd()
    AEval(WList,{|w|w:Paint()},2)
  RestDOut()
  return


//*****************************************************************************
// Window:New() --> self
// default values for this object
//
constructor WindowNew()
  ::ID:=0
  ::WRow:=3
  ::WCol:=4
  ::WRowSize:=MaxRow()-7
  ::WColSize:=MaxCol()-9
  ::IsMax:=false
  ::IsMin:=false
  ::MaxRows:=MaxRow()-3
  ::MaxCols:=MaxCol()-1
  ::MinRows:=1
  ::MinCols:=5
  ::UpFlag:=false
  ::Screen:=""
  ::UpScreen:=""
  ::BkScreen:=""
  ::RCInfo:=""
  ::InfoMsg:=""
  ::Frame:=(object of Frame)
  return(self)


//*****************************************************************************
// Window:Init(Name,R,C,Rs,Cs,Clr,Shadow) --> true
// initialize new window.
//
method function WindowInit(Name,R,C,Rs,Cs,Clr,Shadow)
  ::super(Box):Init(Name,R,C,Rs,Cs,Clr,Shadow)
  return(EndInit(self))


//*****************************************************************************
// Window:GoodInit(Name,R,C,Rs,Cs,CurSize,Clr,Shadow) --> true
// initialize new window.
//
method function WindowGoodInit(Name,R,C,Rs,Cs,CurSize,Clr,Shadow)
  ::super(Box):GoodInit(Name,R,C,Rs,Cs,CurSize,Clr,Shadow)
  return(EndInit(self))


//-----------------------------------------------------------------------------
// Window::EndInit() --> true
// initialize Window extension instvars.
//
static function EndInit(Window)
  local i:=1
  Window:RowSize:=Min(Window:RowSize,Window:MaxRows)
  Window:ColSize:=Min(Window:ColSize,Window:MaxCols)
  Window:WRow:=Window:Row
  Window:WCol:=Window:Col
  Window:WRowSize:=Window:RowSize
  Window:WColSize:=Window:ColSize
  while AScan(WList,{|e|e:ID==i})>0; i++; endwhile
  Window:ID:=i
  AAdd(WList,Window)
  return(true)


//*****************************************************************************
// Window:VPaint() --> true
// virtual method for writting users data into inside of window.
//
method function WindowVPaint()    //I reccomend You will overwrite it
  return(true)                    //this method in derived classes.


//*****************************************************************************
// Window:SaveIn() --> true
// save screen inside window for speed
//
method function WindowSaveIn()
  if !::IsMin
    ::RCInfo:=NTrim(::RowSize)+NTrim(::ColSize)
    ::UpScreen:=SaveScreen(::Row+1,::Col+1,::Row+::RowSize,::Col+::ColSize)
    ::BkScreen:=Transform(::UpScreen,Replicate("X"+Chr(Color2Num(m->Color:Desk)),Len(::UpScreen)/2))
  endif
  return(true)


//*****************************************************************************
// Window:DoInfo(IsTop) --> true
// write any info into bottom of window (if exist)
//
method function WindowDoInfo(IsTop)
  local R,C,s
  if !Empty(::InfoMsg)
    default IsTop to (::ID==ATail(WList):ID)
    R:=Row()
    C:=Col()
    s:=Left(::InfoMsg,::ColSize-2)
    s+=Replicate(if(IsTop,"",""),::ColSize-2-Len(s))
    @ ::Row+::RowSize+1,::Col+2 say s color ::Color
    SetPos(R,C)
  endif
  return(true)


//*****************************************************************************
// Window:Paint(IsTop) --> true
// physically write window into screen.
//
method function WindowPaint(IsTop)
  local Clr:=::Color
  default IsTop to (::ID==ATail(WList):ID)
  if ::UpFlag and Empty(::Screen); ::Screen:=SaveScr(); endif
  if ::IsMin
    @ ::Row,::Col say "("+NTrim(::ID)+")[ "+::Name+" ]" color ListAsArray(m->Color:Edit)[if(IsTop,nEnhanced,nNormal)]
  else
    DispBegin()
    ::super(Box):Paint(IsTop)
    if !Empty(::InfoMsg)
      @ ::Row+::RowSize+1,::Col+2 say Left(::InfoMsg,::ColSize-2) color ::Color
    endif
    if !::UpFlag
      @ ::Row,::Col+1 say "("+NTrim(::ID)+if(::ID<=9,")","") color ::Color
      @ ::Row,::Col+::ColSize-if(::IsMax,2,3) say if(::IsMax,"()","()") color ::Color
    endif
    if !(::RCInfo==(NTrim(::RowSize)+NTrim(::ColSize)))
      if !IsTop; ::Color:=m->Color:Desk; endif  //grayed unselect window
      ::VPaint()
      ::Color:=Clr
      if IsTop; ::SaveIn(); endif
    else
      if IsTop
        RestScreen(::Row+1,::Col+1,::Row+::RowSize,::Col+::ColSize,::UpScreen)
      else
        RestScreen(::Row+1,::Col+1,::Row+::RowSize,::Col+::ColSize,::BkScreen)
      endif
    endif
    DispEnd()
  endif
  if ::IsMin
    SetPos(::Row-1,::Col+2)
  else
    SetPos(::Row+1,::Col+1)
  endif
  ShowTime()
  return(true)


//*****************************************************************************
// Window:Top(lRePaint) --> true
// moving window on top of window stack and paint it.
//
method function WindowTop(lRePaint)
  local i:=AScan(WList,{|e|e:ID==::ID})    //find the window in WindowList
  default lRePaint to true
  if ::UpFlag and Empty(::Screen)
    ::Screen:=SaveScr()
  endif
  ADel(WList,i)             //delete from WList
  WList[Len(WList)]:=self   //push on top WList
  if lRePaint
    ::RePaint(true)         //repaint all windows
  else
    if Len(WList)>=2
      WList[Len(WList)-1]:Paint(false)  //paint (unselected colors) last active window
    endif
    ::Paint(true)                  //top = paint new selected windows
  endif
  return(true)


//*****************************************************************************
// Window:RePaint(lClearDesk) --> true
// repaint all windows.
//
method function WindowRePaint(lClearDesk)
  default lClearDesk to true
  SaveDOut(ResTxt(172))
    DispBegin()
      if ::UpFlag and Empty(::Screen)
        ::Screen:=SaveScr()
      endif
      if lClearDesk
        @ 1,0,MaxRow()-1,MaxCol() box "" color m->Color:Desk   //create background
      endif
      if !Empty(WList); WList[1]:Paint(); endif
    DispEnd()
    AEval(WList,{|w|w:Paint()},2)
  RestDOut()
  return(true)


//*****************************************************************************
// Window:Drag(lCanSize) --> true
// moving window in screen area.
//
method function WindowDrag(lCanSize)
  default lCanSize to !::IsMin
  if ::IsMin
    ::Frame:Init(::Row,::Col,-1,Len(NTrim(::ID))+Len(::Name)+4)
  else
    ::Frame:Init(::Row,::Col,::RowSize,::ColSize)
  endif
  ::Frame:MaxRows:=::MaxRows
  ::Frame:MaxCols:=::MaxCols
  ::Frame:MinRows:=::MinRows
  ::Frame:MinCols:=::MinCols
  if ::Frame:Drag(lCanSize)
    ::Row:=::Frame:Row             //save
    ::Col:=::Frame:Col
    if ! ::IsMin
      ::RowSize:=::Frame:RowSize
      ::ColSize:=::Frame:ColSize
      SaveCoords(self)           //i am not sure that this line must exist...
    endif
    ::RePaint()                    //repaint
  endif
  return(true)


//*****************************************************************************
// Window:Maximize() --> true
// maximize window in screen area.
//
method function WindowMaximize()
  NoMinimize(self)
  SaveCoords(self)
  ::IsMax:=true
  ::RowSize:=::MaxRows
  ::ColSize:=::MaxCols
  ::Row:=Int((MaxRow()-3-::MaxRows)/2)+1
  ::Col:=Int((MaxCol()-1-::MaxCols)/2)
  if ::MaxRows==MaxRow()-3 and ::MaxCols==MaxCol()-1
    ::Paint(true)
  else
    ::RePaint()
  endif
  return(true)


//*****************************************************************************
// Window:Minimize(lRePaint) --> true
// minimize window in screen area, if lShow==false then no write into screen!
//
method function WindowMinimize(lRePaint)
  local R:=MaxRow()-1
  local C:=1
  default lRePaint to true
  if ! ::IsMin
    while AScan(MinStack,{|w| (w:Row==R)and(w:Col==C) })>0
      C+=Int(MaxCol()/2)
      if C>=MaxCol(); R--; C:=1; endif
    endwhile
    SaveCoords(self)
    ::Row:=R
    ::Col:=C
    AAdd(MinStack,self)
    ::IsMin:=true
    if lRePaint; ::RePaint(); endif
  endif
  return(true)


//*****************************************************************************
// Window:Restore() --> true
// restore origin window size and repaint it.
//
method function WindowRestore()
  NoMinimize(self)
  ::RowSize:=::WRowSize
  ::ColSize:=::WColSize
  ::IsMax:=false
  ::RePaint()
  return(true)


//*****************************************************************************
// Window:Done(lRePaint) --> true
// destroy the window.
//
method function WindowDone(lRePaint)
  default lRePaint to false
  NoMinimize(self)
  ATrueDel(WList,AScan(WList,{|e|e:ID==::ID}))
  if ::UpFlag and !Empty(::Screen)
    RestScr(::Screen)
  else
    if lRePaint; ::RePaint(); endif
  endif
  return(true)


//-----------------------------------------------------------------------------
// Window::NoMinimize() --> true
// work around un_minimize window.
//
static function NoMinimize(Window)
  Window:Row:=Window:WRow
  Window:Col:=Window:WCol
  if Window:IsMin
    ATrueDel(MinStack,AScan(MinStack,{|e|e:ID==Window:ID}))
    Window:IsMin:=false
  endif
  return(true)


//-----------------------------------------------------------------------------
// Window::SaveCoords() --> true
// save current window coords.
//
static function SaveCoords(Window)
  Window:WRow:=Window:Row                    //save for Maximize/Minimize
  Window:WCol:=Window:Col
  Window:WRowSize:=Window:RowSize
  Window:WColSize:=Window:ColSize
  return(true)

//------------------------------------------------------- eof (c)JHK ----------

