//*****************************************************************************
// C_Stack.prg
// Stack class for OBJECT v2.03
// Copyright (c) 1991, JHK, JHK-Software, Piestany
// Please compile with: /N/M/W/A
//-----------------------------------------------------------------------------

#include "Object.ch"

create class Stack
  export:
  var Data    // {}
  method New=StackNew              //o:New()
  method Init=StackInit            //o:Init()
  method Push=StackPush            //o:Push(val)
  method Pop=StackPop              //o:Pop()
  method Top=StackTop              //o:Top()
  method IsEmpty=StackIsEmpty      //o:IsEmpty()
  method Done=StackDone            //o:Done()
  endclass


//*****************************************************************************
// Stack:New() --> self
// initialize new object
//
constructor StackNew()
  ::Data:= {}
  return(self)


//*****************************************************************************
// Stack:Init() --> true
// clear (make empty) the stack.
//
method function StackInit()
  ::Data:={}
  return(true)


//*****************************************************************************
// Stack:Push(xVal) --> xVal
// push new value into stack.
//
method function StackPush(xVal)
  AAdd(::Data,xVal)
  return(xVal)


//*****************************************************************************
// Stack:Pop() --> xVal
// take last entered value from stack.
//
method function StackPop()
  return(ATailDel(::Data))


//*****************************************************************************
// Stack:Top() --> xVal
// get last entered value from stack, do not erased it from stack.
//
method function StackTop()
  return(ATail(::Data))


//*****************************************************************************
// Stack:IsEmpty() --> true/false
// return true if the stack is empty.
//
method function StackIsEmpty()
  return(Empty(::Data))


//*****************************************************************************
// Stack:Done() --> true
// destroy the stack.
//
method function StackDone()
  return(true)

//------------------------------------------------------- eof (c)JHK ----------

