//*****************************************************************************
// C_Mask.prg
// Mask class for OBJECT v2.03
// Copyright (c) 1991, JHK, JHK-Software, Piestany
// Please compile with: /N/M/W/A
//-----------------------------------------------------------------------------

#include "Object.ch"

create class Mask from View
  export:
  var Initialized  //false
  var SayData      //{{Row,Col,Text},...}
  var GetData      //{{Row,Col},...}
  method New=MaskNew              //o:New() --> self
  method CreateObj=MaskCreateObj  //o:CreateObj() --> new object of this class
  method Copy=MaskCopy            //o:Copy() --> self
  method AddSay=MaskAddSay        //o:AddSay(R,C,Text)
  method AddBlock=MaskAddBlock    //o:AddBlock(R,C,cShortName,cVarName,bBlock,bDoGet,cPicture,bWhen,bValid)
  method AddMemo=MaskAddMemo      //o:AddMemo(R,C,cShortName,cField,bWhen,bValid,nRowSize,nColSize)
  method AddField=MaskAddField    //o:AddField(R,C,cShortName,cField,cPicture,bWhen,bValid)
  method PostInit=MaskPostInit    //o:PostInit()
  method MaskPaint=MaskMaskPaint  //definition of abstract class: o:MaskPaint()
  endclass


//*****************************************************************************
// Mask:New() --> self
// default values for this object
//
constructor MaskNew()
  ::Initialized:=false
  ::MaskFeature:=true        //Important! See also the Browse class.
  ::FormActive:=true         //... 
  ::SayData:={}              //{{Row,Col,Text},...}
  ::GetData:={}              //{{Row,Col},...}
  return(self)


//*****************************************************************************
// Mask:CreateObj() --> self
// default values for this object
//
method function MaskCreateObj()
  return(object of Mask)


//*****************************************************************************
// Mask:Copy() --> self
// return copy of this object
//
method function MaskCopy()
  local o:=::super(View):Copy()
  o:Initialized := ::Initialized
  o:MaskFeature := ::MaskFeature
  o:SayData     := AClone(::SayData)
  o:GetData     := AClone(::GetData)
  return(o)


//*****************************************************************************
// Mask:AddSay(R,C,Text)
// add say text into object
//
method function MaskAddSay(R,C,Text)
  AAdd(::SayData,{R,C,Text})
  return(true)


//*****************************************************************************
// Mask:AddBlock(R,C,cShortName,cVarName,bBlock,bDoGet,cPicture,bWhen,bValid)
// default values for this object
//
method function MaskAddBlock(R,C,cShortName,cVarName,bBlock,bDoGet,cPicture,bWhen,bValid)
  ::super(View):AddBlock(,cShortName,cVarName,bBlock,bDoGet,cPicture,bWhen,bValid)
  AAdd(::GetData,{R,C})
  return(true)


//*****************************************************************************
// Mask:AddMemo(R,C,cShortName,cField,bWhen,bValid,nRowSize,nColSize)
// default values for this object
//
method function MaskAddMemo(R,C,cShortName,cField,bWhen,bValid,nRowSize,nColSize)
  local Get
  ::super(View):AddMemo(,cShortName,cField,bWhen,bValid,nRowSize,nColSize)
  AAdd(::GetData,{R,C})
  return(true)


//*****************************************************************************
// Mask:AddField(R,C,cShortName,cField,cPicture,bWhen,bValid)
// default values for this object
//
method function MaskAddField(R,C,cShortName,cField,cPicture,bWhen,bValid)
  local Get
  ::super(View):AddField(,cShortName,cField,cPicture,bWhen,bValid)
  AAdd(::GetData,{R,C})
  return(true)


//*****************************************************************************
// Mask:MaskPaint() --> true
// VPaint() for Mask
//
method function MaskMaskPaint()
  local i,cg
  local uns:=ListAsArray(::Color)[nUnSelect]
  if !::Initialized
    for i:=1 to Len(::GetData)
      cg:=::GetList[i]:Cargo
      cg[nRowOffset]:=::GetData[i,1]
      cg[nColOffset]:=::GetData[i,2]
    endfor
    ::Initialized:=true
  endif
  AEval(::SayData,{|e|DevPos(::Row+e[1],::Col+e[2]),DevOut(e[3],::Color)})
  AEval(::GetList,{|g| ;
         DevPos(::Row+g:Cargo[nRowOffset],::Col+g:Cargo[nColOffset]),;
         DevOut(Transform(g:VarGet(),g:Picture), uns) };
       )
  return(true)


//*****************************************************************************
// Mask:PostInit() --> true
// PostInit() for Mask
//
method function MaskPostInit()
   local R:=::Form:Row
   local C:=::Form:Col
   local Rs:=::Form:RowSize
   local Cs:=::Form:ColSize
   ::super(View):PostInit()
   if ::FormActive
     ::Row     := R    //Mask window cannot be "sizeable"
     ::Col     := C
     ::RowSize := Rs
     ::ColSize := Cs
     ::MaxRows := Rs
     ::MaxCols := Cs
     ::MinRows := Rs
     ::MinCols := Cs
   else
     ::Form:Row     := R
     ::Form:Col     := C
     ::Form:RowSize := Rs
     ::Form:ColSize := Cs
     ::Form:MaxRows := Rs
     ::Form:MaxCols := Cs
     ::Form:MinRows := Rs
     ::Form:MinCols := Cs
   endif
   return(true)

//------------------------------------------------------- eof (c)JHK ----------

