//*****************************************************************************
// C_DBrows.prg
// Database Browse class for OBJECT v2.03
// Copyright (c) 1991, JHK, JHK-Software, Piestany
// Please compile with: /N/M/W/A
//-----------------------------------------------------------------------------

#include "Set.ch"
#include "InKey.ch"
#include "Object.ch"

create class DBrowse from Browse
  export:
    var Alias      // ""                    //work area for master database
    var RecNo      // 0                     //RecNo for master database
    var IndexNo    // 0                     //index order for this master database
    var FilterNo   // 0                     //filter # in filter list in this view
    var FilterExp  // ""                    //filter expression associated with 
    var FilterBExp // {||false}             //color code block for TbColumnNew:ColorBlock
    var FilterMark // false                 //to_Mark/to_Hide filtered items
    var OneDbf     // (object of OneDbf)    //update relation area(s)
    method New=DBrowseNew                 //o:New()
    method DoGet=DBrowseDoGet             //o:DoGet()
    method PostInit=DBrowsePostInit       //o:PostInit()         //need for saving selected work area
    method SwapForm=DBrowseSwapForm       //o:SwapForm()         //must be changed for speed optimizing (filter)
    method UpDatabase=DBrowseUpDatabase   //o:UpDatabase()       //set clipper system areas for corectly working this DBrowse
    method UpFilter=DBrowseUpFilter       //o:UpFilter()         //as above...
    method Paint=DBrowsePaint             //o:Paint(isTop)       //allow ::Maximize() before ::Process()
    method VPaint=DBrowseVPaint           //o:VPaint()           //swap database
    method VProcess=DBrowseVProcess       //o:VProcess()         //save RecNo
    private:
    method MakeGet=DBrowseMakeGet         //o:MakeGet(Get)       //local function for o:DoGet()
    endclass

//*****************************************************************************
// DBrowse:New() --> self
// initialize new object
//
constructor DBrowseNew()
  ::Alias:= ""
  ::RecNo:= 0
  ::IndexNo:= 0
  ::FilterNo:= 0
  ::FilterExp:= ""
  ::FilterBExp:= {||false}
  ::FilterMark:= false
  ::OneDbf:= (object of OneDbf)
  ::InsBlock:= {|o|DoInsert(o)}
  ::DelBlock:= {|o|DoDelete(o)}
  ::InfoBlock:= {|o|DoInfo(o)}
  ::TestVRecord:={|o,Get|TestVRecord(o,Get)}
  return(self)


//-----------------------------------------------------------------------------
// DBrowse::DoInsert() --> true/false
// insert new row into database
//
static function DoInsert(DBrowse)
  local i,Rn
  returnif DBrowse:FilterNo>0 with (Alert(ResTxt(192)),false)
  if !DBrowse:SetConfirm or Alert(ResTxt(104),ResTxt(123))==1
    net append blank continue return false
    Rn:=RecNo()
    DBrowse:RecNo:=Rn
    if DBrowse:FormActive
      if DBrowse:MaskFeature
        DBrowse:MaskPaint()
      else
        DBrowse:FormPaint()
      endif
      Eval(DBrowse:InfoBlock,DBrowse)
      DBrowse:SaveIn()
    else
      DBrowse:Tb:Home()
      if IndexOrd()==0
        DBrowse:Tb:GoBottom()
      else
        DBrowse:Tb:GoTop()
        go Rn
      endif
      DBrowse:Tb:RefreshAll()
      StuffKey(K_LEFT)
    endif
    return(true)
  endif
  return(false)


//-----------------------------------------------------------------------------
// DBrowse::DoDelete() --> true/false
// delete current row from database
//
static function DoDelete(DBrowse)
  if !DBrowse:SetConfirm or Alert(ResTxt(105),ResTxt(123))==1
    net delete continue
    while Deleted(); skip; endwhile Eof()
    if Eof(); go top; endif
    DBrowse:RecNo:=RecNo()
    DBrowse:Tb:Home()
    DBrowse:Tb:RefreshAll()
    return(true)
  endif
  return(false)


//-----------------------------------------------------------------------------
// DBrowse::DoInfo() --> true
// show Recno,Index,Filter information
//
static function DoInfo(DBrowse)
  DBrowse:InfoMsg:=" "+ResTxt(051)+"="+NTrim(RecNo())+"/"+NTrim(LastRec())+;
                   " "+ResTxt(053)+"="+NTrim(IndexOrd())+;
                   " "+ResTxt(054)+"="+NTrim(DBrowse:FilterNo)+" "
  DBrowse:DoInfo()
  return(true)


//-----------------------------------------------------------------------------
// DBrowse::TestVRecord(Get) --> true/false
// test is it the record virtual?
//
static function TestVRecord(DBrowse,Get)
  local Ch,n
  default Get to DBrowse:GetList[DBrowse:Tb:ColPos]
  n:=Select(Get:Cargo[nAlias])
  if DBrowse:CanEdit and n>0 and (n)->(RecNo())>(n)->(LastRec())
    if DBrowse:FormActive
      if (n)->(RecNo())>(n)->(LastRec()) and DBrowse:CanAppend
        (n)->(DbGoTop())
        if (n)->(RecNo())>(n)->(LastRec())
          Eval(DBrowse:InsBlock, DBrowse)
        endif
      endif
      if (n)->(RecNo())>(n)->(LastRec())             //record not appended
        Ch:=Alert(ResTxt(079),ResTxt(131))
        do case
          case Ch==2; SetLastKey(K_ESC)                   //close
          case Ch==3; Eval(SetKey(K_ALT_0)); InKeyWait()  //task_list
          case Ch==4; Eval(SetKey(K_F10));   InKeyWait()  //main_menu
          otherwise;  Eval(SetKey(K_F5));    InKeyWait()  //minimize
        endcase
      else
        return(true) //new record appended, ok.
      endif
    else
      Alert(ResTxt(079)) //Browse mode!
    endif
    return(false) //edit not allowed, this is a virtual record!
  endif
  return(true) //ok, edit allowed


//*****************************************************************************
// DBrowse:DoGet() --> true/false
// checking virtual record and update child relations fields
//
method function DBrowseDoGet()
  local g:=::GetList[::Tb:ColPos]
  returnif !Eval(::TestVRecord,self,g) with false
  return(::MakeGet(g))


method function DBrowseMakeGet(g)   //need for record_lock (networking)
  local Ch
  local Ok:=true
  if !::CanEdit
    Ok:=::super(Browse):DoGet()
    return(Ok)
  endif
  if (g:Cargo[nAlias])->(NetRLock(true))
    Ok:=::super(Browse):DoGet()
    commit
    (g:Cargo[nAlias])->(DbUnLock())
    if !::FormActive and ::IndexNo>0 and ;
       GetField(g:Name) $ (g:Cargo[nAlias])->(IndexKey(::IndexNo))
      ::Tb:RefreshAll()
    endif
  elseif ::FormActive
    Ch:=Alert(ResTxt(121),ResTxt(130))
    if Ch==2
      SetLastKey(K_ESC)
      Ok:=false
    elseif Ch==3 or Ch==4
      ::SaveIn()
      ::Minimize()
      Eval(SetKey(if(Ch==3,K_ALT_0,K_F10)))
      InKeyWait() //remove nSwapTask
      Ok:=false
    endif
  endif
  return(Ok)


//*****************************************************************************
// DBrowse:PostInit() --> true
// save/set Alias, go task process
//
method function DBrowsePostInit()
  fill empty ::Alias with Alias()
  fill empty ::OneDbf with GetONeDbf(::Alias)
  return(::super(Browse):PostInit())


//*****************************************************************************
// DBrowse:SwapForm() --> true
// need for speed optimizing; filter problem, see also DBrowse:UpDatabase()
//
method function DBrowseSwapForm()
  ::RecNo:=RecNo()
  if (::FormActive or ::CanSkip) and ;
     (!(DbFilter()==::FilterExp) or ( ::FilterMark and !Empty(::FilterExp)) )
    SaveDOut(ResTxt(170))
    GoUpFilter(self)
    skip 0
    ::Tb:Configure()
    RestDOut()
  endif
  return(::super(Browse):SwapForm())


//*****************************************************************************
// DBrowse:UpDatabase() --> true
// set Alias (select), Order (index), filter
//
method function DBrowseUpDatabase()
  if Select()<>Select(::Alias)
    AEval(::OneDbf:Rel,{|e|DbSelectArea(e[2]),DbClearFilter(nil),DbSetOrder(e[3])})
    select (::Alias)
  endif
  set order to (::IndexNo)
  ::UpFilter()
  if ::RecNo==0
    go top
  else
    go ::RecNo
    while Deleted(); skip; endwhile Eof()
    if Eof(); go top; endif
  endif
  ::RecNo:=RecNo()
  return(true)


//*****************************************************************************
// DBrowse:UpFilter() --> true
// set need filter
//
method function DBrowseUpFilter()
  local i
  if !Empty(::FilterExp)
    if (::FormActive or ::CanSkip) and ;
       (!(DbFilter()==::FilterExp) or ( ::FilterMark and !Empty(::FilterExp)) )
      SaveDOut(ResTxt(170))
      GoUpFilter(self)       //problem!?!? musi byt filter nastaveny aj v relacnych databazach ???
      RestDOut()
    endif
  else
    for i:=1 to ::Tb:ColCount
      (::Tb:GetColumn(i)):ColorBlock:=nil
    endfor
    set filter to
  endif
  return(true)


static procedure GoUpFilter(DBrowse)
  local i
  if DBrowse:FilterMark
    for i:=1 to DBrowse:Tb:ColCount
      (DBrowse:Tb:GetColumn(i)):ColorBlock:={||if(Eval(DBrowse:FilterBExp),{if(m->tColor>0,nNormal,nNotUse),nUnSelect},{nExtension,nUnSelect})}
    endfor
    set filter to
  else
    set filter to &(DBrowse:FilterExp)
    for i:=1 to DBrowse:Tb:ColCount
      (DBrowse:Tb:GetColumn(i)):ColorBlock:=nil
    endfor
  endif
  return


//*****************************************************************************
// DBrowse:Paint(isTop) --> true
// swap database and repaint screen
//
method function DBrowsePaint(isTop)
  if !::SetUp; ::PostInit(); endif
  return(::super(Browse):Paint(isTop))


//*****************************************************************************
// DBrowse:VPaint() --> true
// swap database and repaint screen
//
method function DBrowseVPaint()
  ::UpDatabase()
  return(::super(Browse):VPaint())


//*****************************************************************************
// DBrowse:VProcess() --> true
// save RecNo
//
method function DBrowseVProcess()
  ::UpDatabase()
  ::super(Browse):VProcess()
  ::RecNo:=RecNo()
  return(true)

//------------------------------------------------------- eof (c)JHK ----------

