//*****************************************************************************
// C_ABrows.prg
// Array_Browse class for OBJECT v2.03
// Copyright (c) 1991, JHK, JHK-Software, Piestany
// Please compile with: /N/M/W/A
//-----------------------------------------------------------------------------

#include "Object.ch"

create class ABrowse from Browse
  export:
  var N           // 1                    //index into ABrowse:Arr[N,i]
  var Arr         // {}                   //array for ABrowse
  method New=ABrowseNew                   //o:New()
  method Init=ABrowseInit                 //o:Init(Name,R,C,Rs,Cs,Clr,Shadow)
  method GoodInit=ABrowseGoodInit         //o:GoodInit(Name,R,C,Rs,Cs,CurSize,Clr,Shadow)
  method Paint=ABrowsePaint               //o:Paint(IsTop)
  endclass


//*****************************************************************************
// ABrowse:New() --> self
// initialize new object
//
constructor ABrowseNew()
  ::N:= 1
  ::Arr:= {}
  ::CanSwap:= false               //override
  ::InsBlock:= {|o|DoInsert(o)}   //override
  ::DelBlock:= {|o|DoDelete(o)}   //override
  return(self)


//*****************************************************************************
// ABrowse:Init(Name,R,C,Rs,Cs,Clr,Shadow) --> true
// initialize new view object
//
method function ABrowseInit(Name,R,C,Rs,Cs,Clr,Shadow)
  ::super(Browse):Init(Name,R,C,Rs,Cs,Clr,Shadow)
  return(EndInit(self))


//*****************************************************************************
// ABrowse:GoodInit(Name,R,C,Rs,Cs,CurSize,Clr,Shadow) --> true
// initialize new view object
//
method function ABrowseGoodInit(Name,R,C,Rs,Cs,CurSize,Clr,Shadow)
  ::super(Browse):GoodInit(Name,R,C,Rs,Cs,CurSize,Clr,Shadow)
  return(EndInit(self))


//-----------------------------------------------------------------------------
// ABrowse::EndInit() --> true
// initialize ABrowse extension intances
//
static function EndInit(ABrowse)
  ABrowse:Tb:SkipBlock:={|n|ASkipper(n,ABrowse)}
  ABrowse:Tb:SkipBlock:={|x,k,n,l|;
                          n:=ABrowse:N,;
                          l:=Len(ABrowse:Arr),;
                          k:=if(abs(x)>=if(x>=0,l-n,n-1),if(x>=0,l-n,1-n),x),;
                          ABrowse:N+=k,;
                          k;
                        }
  ABrowse:Tb:GoTopBlock:={||ABrowse:N:=1}
  ABrowse:Tb:GoBottomBlock:={||ABrowse:N:=Len(ABrowse:Arr)}
  return(true)


//-----------------------------------------------------------------------------
// ABrowse::ASkipper(x,ABrowse) --> nSkipped
// array skipper function.
// x == request for skip
// ABrowse == self object
//
static function ASkipper(x,ABrowse)
  local k,n,l
  if Eval(ABrowse:PreSkip,ABrowse)
    n:=ABrowse:N
    l:=Len(ABrowse:Arr)
    k:=if(abs(x)>=if(x>=0,l-n,n-1),if(x>=0,l-n,1-n),x)
    ABrowse:N+=k
    Eval(ABrowse:PostSkip,ABrowse)
  endif
  return(k)


//-----------------------------------------------------------------------------
// ABrowse::DoInsert() --> true
// insert new row into array
//
static function DoInsert(ABrowse)
  if Alert(ResTxt(104),ResTxt(123))==1
    ATrueIns(ABrowse:Arr,ABrowse:N,if(ValType(ABrowse:Arr[ABrowse:N])=="A",;
                                      AClone(ABrowse:Arr[ABrowse:N]),;
                                      ABrowse:Arr[ABrowse:N]))
    ABrowse:Tb:RefreshAll()
  endif
  return(true)


//-----------------------------------------------------------------------------
// ABrowse::DoDelete() --> true
// delete current row from array
//
static function DoDelete(ABrowse)
  if Alert(ResTxt(105),ResTxt(123))==1
    ATrueDel(ABrowse:Arr,ABrowse:N)
    ABrowse:Tb:RefreshAll()
  endif
  return(true)


//*****************************************************************************
// ABrowse:Paint(isTop) --> true
// before ::Paint() must be done ::PostInit().
//
method function ABrowsePaint(isTop)
  if !::SetUp; ::PostInit(); endif
  if !Empty(::PreSkip)
    ::Tb:SkipBlock:={|n|ASkipper(n,self)}
  endif
  return(::super(Browse):Paint(isTop))


//------------------------------------------------------- eof (c)JHK ----------

