//*****************************************************************************
// OBJECT3.PRG
// Various functions for OBJECT v2.03
// Copyright (c) 1991, JHK, JHK-Software, Piestany
// Please compile with: /N/M/W/A
//-----------------------------------------------------------------------------

#include "Set.ch"
#include "Box.ch"
#include "InKey.ch"
#include "error.ch"
#include "FileIo.ch"
#include "SetCurs.ch"
#include "MemoEdit.ch"
#include "Object.ch"

static DatabInfo:={}   //database info array for save/restore the database state
static aMessages:={}   //dialog_out_lines
static CurColSize      //current memo
static CurLastKey      //current memo

//*****************************************************************************
// IncludeFunctions() --> true
// this fnc isn't called from anything other fnc!
// it is used only for linking need functions for entering
// Filter & Index expressions
//
function IncludeFunctions()
  local c,n,d,l,e
  Abs(n);      AllTrim(c);   Asc(n);        At(c,c);    CdoW(d);    Chr(c)
  CMonth(d);   CtoD(c);      Date();        Day(d);     Descend(e); DoW(d)
  DtoC(d);     DtoS(d);      Empty(e);      Exp(n);     GetEnv(c);  If(l,e,e)
  IsAlpha(c);  IsDigit(c);   IsLower(c);    IsUpper(c); Left(c,n);  Log(n)
  Lower(c);    LTrim(c);     Max(n,n);      Min(n,n);   Month(d);   PadC(e,n,c)
  PadL(e,n,c); PadR(e,n,c);  Right(c,n);    Round(n,n); RTrim(c);   Sqrt(n)
  Str(n,n,n);  StrTran(c,c); SubStr(c,n,n); Trans(e,c); Type(e);    Upper(c)
  Val(c);      ValType(e);   Year(d);       FError()
  return(true)


//*****************************************************************************
// AValid(Name,Get,Array,Block,EmptyAllowed) --> true/false
// validation from string array, block usage: Eval(Block,e)==Get:VarGet()
// e ... one_element_from_Array
//
function AValid(Name,Get,Array,Block,EmptyAllowed)
  local Ch,Var,Ln
  default Name to ResTxt(034)
  default EmptyAllowed to false
  default Get:ExitState to true
  if !Get:Changed and EmptyAllowed; return(true); endif
  if Empty(Array); return(false); endif
  Var:=if(Empty(Get:Picture),Get:VarGet(),Transform(Get:VarGet(),Get:Picture))
  default Block to {|e|e}
  if AScan(Array,{|e|Eval(Block,e)==Var})>0; return(true); endif
  object Ch of Choice
  Ln:=Len(Var)
  Ch:FastInit(Name,Row(),Col()+Ln,Ln,Array)
  Ch:Process()
  if Ch:Choice>0
    if !Get:ExitState; Get:VarPut(Eval(Block,Array[Ch:Choice])); endif
    Ch:Done()
    SetLastKey(K_ENTER)
    return(true)
  endif
  Ch:Done()
  if LastKey()==K_ESC; SetLastKey(0); endif
  return(false)


//*****************************************************************************
// DbfValid(Name,Get,DbfName,Index,Block,EmptyAllowed,Fields)
// validation from database, must be indexed!
// block usage: Eval(Block)==Get:VarGet()  //RecNo() is correctly setted.
//
function DbfValid(Name,Get,DbfName,Index,Block,EmptyAllowed,Fields)
  local s,o,Db,w,k,Rv,i
  default EmptyAllowed to false
  if !Get:Changed and EmptyAllowed; return(true); endif
  default Name to ResTxt(034)
  default Get:ExitState to true
  s:=Select()
  select (DbfName)
  o:=IndexOrd()
  if Index<>nil; set order to Index; endif
  seek if(Empty(Get:Picture),Get:VarGet(),Transform(Get:VarGet(),Get:Picture))
  if Found()
    set order to (o)
    select (s)
    skip 0
    return(true)
  endif
  *
  SetCursor(SC_NONE)
  w:=0
  if Empty(Fields)
    Fields:={}
    for i:=1 to FCount()
      if( !(ValType(FieldGet(i))=="M"), AAdd(Fields,FieldName(i)), )
    endfor
  endif
  AEval(Fields,{|e|w+=3+Max(Len(Transform(&(e),)),Len(e))})
  object Db of UpDBrowse
  Db:GoodInit(Name,Row(),Col(),Min(LastRec()+2,MaxRow()-5),Min(w,MaxCol()-9),1)
  AEval(Fields,{|e|Db:AddBlock(,e,DbfName+"->"+e,FieldBlock(e))})
  go top
  if Eof(); set order to (o); select (s); return(false); endif
  Db:Alias:=DbfName
  Db:RecNo:=RecNo()
  Db:CanEdit:=false
  Db:CanSwap:=false
  Db:FormActive:=false
  Db:IndexNo:=if(Empty(Index),IndexOrd(),Index)
  Db:FilterExp:=DbFilter()
  Db:Paint()
  k:=SetKey(K_ENTER,{||StuffKey(K_CTRL_RET)})
  Db:Process()
  SetKey(K_ENTER,k)
  if LastKey()==K_CTRL_RET or LastKey()==K_ENTER
    if !Get:ExitState; Get:VarPut(Eval(Block)); endif
    SetLastKey(K_ENTER)
    Rv:=true
  else
    if LastKey()==K_ESC; SetLastKey(0); endif
    Rv:=false
  endif
  Db:Done()
  set order to (o)
  select (s)
  skip 0
  return(Rv)


//*****************************************************************************
// OAlert(cMessage,aOptions,nRow,nInitItem) --> nChoice
// standart alert with shadow
//
function OAlert(cMessage,aOptions,nRow,nInitItem)
  local k1,ks1
  local R,C,Rs,Cs,R2,C2,Scr,nChoice,m,i
  local ClrMnu,ClrBox
  local OldRow:=Row()
  local OldCol:=Col()
  default aOptions to {"Ok"}
  m:=SetDialog(.t.)
  Rs:=3+Len(cMessage)-Len(StrTran(cMessage,";"))
  Cs:=Max(2+GetMaxRow(cMessage),4+ACount(aOptions))
  R:=if(nil<>nRow,nRow,Int((MaxRow()-Rs-1)/2))
  C:=Int((MaxCol()-Cs-1)/2)
  R2:=R+Rs+1
  C2:=C+Cs+1
  SaveDOut(if(Len(aOptions)>1,ResTxt(138),ResTxt(137)))
  Scr:=SaveScr(R,C,R2+1,C2+1)
    if m->tColor==3  //true color
      i:=ListAsArray(m->Color:Edit)
      ClrBox:=GetFore(m->Color:Desk)+"/"+GetBack(i[nEnhanced])
      ClrMnu:=i[nEnhanced]+","+GetFore(ListAsArray(m->Color:Menu)[nLetter])+"/"+GetBack(i[nNormal])
    else
      ClrBox:="n/w"
      ClrMnu:="n/w,w+/n"
    endif
    SetColor(ClrMnu)
    @ R,C,R2,C2 box B_SINGLE+" " color ClrBox
    AEval(ListAsArray(cMessage,";"),{|e,i|DevPos(R+i,C+1),DevOut(PadC(e,Cs))})
    i:=0
    AEval(aOptions,{|e,j|aOptions[j]:=" "+AllTrim(e)+" ",i+=1+Len(aOptions[j])})
    SetPos(Row()+2,C+(Cs-i)/2+1)
    AEval(aOptions,{|e|MyMenuTo(Row(),Col()+1,e)})   //@ Row,Col PROMPT ...
    if m->tColor<>0; BoxShadow(R,C,R2,C2); endif
    k1:=SetKey(K_F1,nil)
    ks1:=SetKey(K_SH_F1,nil)
    nChoice:=MyMenuTo(nInitItem)  //MENU TO
    SetKey(K_F1,k1)
    SetKey(K_SH_F1,ks1)
  RestScr(Scr)
  RestDOut()
  SetDialog(m)
  SetPos(OldRow,OldCol)
  return(nChoice)

static function GetMaxRow(cMsg)
  return(if(At(";",cMsg)>0, AWidth(ListAsArray(cMsg,";")), Len(cMsg)+4))

static function ACount(aOpt)
  local n:=0
  AEval(aOpt,{|e|n+=4+Len(e)})
  return(n-2)

static function MyMenuTo(R,C,S)
  static Items:={}
  local i,j,Ch,nChoice
  local Norm:=SetColor()
  local Enh:=ListAsArray(SetColor())[nEnhanced]
  local Curs:=SetCursor(SC_NONE)
  if PCount()==3  //AtPrompt
    @ R,C say S
    AAdd(Items,{R,C,S})
  else //MenuTo
    i:=if(Empty(R),1,R)
    repeat
      SetCursor(SC_NONE)
      @ Items[i,1],Items[i,2] say Items[i,3] color Enh
      nChoice:=PauseKey(0)
      do case
        case nChoice==K_ENTER; nChoice:=i; exit
        case nChoice==K_ESC;   nChoice:=0; exit
        otherwise
          Ch:=Upper(Chr(nChoice))
          j:=AScan(Items,{|e|Upper(SubStr(e[3],2,1))==Ch},i)
          if j==0; j:=AScan(Items,{|e|Upper(SubStr(e[3],2,1))==Ch}); endif
          if j>0; nChoice:=j; exit; endif
      endcase
      @ Items[i,1],Items[i,2] say Items[i,3] color Norm
      do case
        case nChoice==K_LEFT;  if( i>1, i--, if(Set(_SET_WRAP),i:=Len(Items),))
        case nChoice==K_RIGHT; if( i<Len(Items), i++, if(Set(_SET_WRAP),i:=1,))
      endcase
    endrepeat
    Items:={}
  endif
  SetCursor(Curs)
  return nChoice


//*****************************************************************************
// Memo(bVar,lEdit,cTitle,Row,Col,RowSize,ColSize,CurSize,Color,lShadow) --> true ???
// windowed edit one memo variable
//
function Memo(bVar,lEdit,cTitle,Row,Col,RowSize,ColSize,CurSize,Color,lShadow)
  local OldCs,OldKey,OldWFK
  local OldC:=SetColor()
  local object Win of Win
  local object Cursor of Cursor; Cursor:Get()
  default cTitle to ResTxt(021)
  default CurSize to Len(ResTxt(134))-2
  default Row to Row()
  default Col to Col()+CurSize+1
  default RowSize to Int(MaxRow()/3)
  default ColSize to Int(MaxCol()/2)
  default Color to if(lEdit,m->Color:Edit,m->Color:View)
  SaveHelpIdx(if(lEdit,{12},{15,11}))
  SaveDOut(ResTxt(148)+if(!Empty(SetDMsg()),","+SetDMsg(),""))
  Win:GoodInit(cTitle,Row,Col,RowSize,ColSize,CurSize,Color,lShadow)
  OldCs:=CurColSize
  Row:=Win:Row
  Col:=Win:Col
  RowSize:=Win:RowSize
  ColSize:=CurColSize:=Win:ColSize
  Win:Paint()
  if m->tColor==3
    Color:=ListAsArray(Color)
    Color:=GetFore(Color[nUnSelect])+"/"+GetBack(Color[nNormal])
  endif
  SetColor(Color)
  OldWFK:=SetKey(nWaitForKey,{||WaitKey()})
  if lEdit
    SetCursor(if(ReadInsert(),SC_INSERT,SC_NORMAL))
    CurLastKey:=nil
    OldKey:=SetKey(nSwapTask,{||StuffKey(K_CTRL_W),CurLastKey:=nSwapTask})
    begin sequence
    Eval(bVar,MemoEdit(Eval(bVar), Row+1,Col+1, Row+RowSize,Col+ColSize, true,"MemoEditFnc",if(SetMemoWrap(),ColSize,250)))
    end sequence
    SetKey(nSwapTask,OldKey)
    if CurLastKey<>nil; SetLastKey(CurLastKey); endif
  else
    MemoViewFnc(-1)  //preInit
    begin sequence
    MemoEdit(Eval(bVar), Row+1,Col+1, Row+RowSize,Col+ColSize, false,"MemoViewFnc",if(SetMemoWrap(),ColSize,250),4, RowSize,0,RowSize)
    end sequence
  endif
  SetKey(nWaitForKey,OldWFK)
  SetCursor(SC_NONE)
  CurColSize:=OldCs
  Win:Done()
  RestHelpIdx()
  RestDOut()
  SetColor(OldC)
  Cursor:Set()
  return(true)


static procedure WaitKey()
  while NextKey()==0; ShowTime(); endwhile
  return


function MemoEditFnc(nMode)
  local nKey:=LastKey()
  if nKey==nSwapTask or nKey==K_CTRL_RET
    CurLastKey:=nKey
    StuffKey(K_CTRL_W)
    return(ME_DEFAULT)
  endif
  if nKey==K_INS
    SetCursor(if(Set(_SET_INSERT),SC_NORMAL,SC_INSERT))
  endif
  if( nKey<>K_CTRL_W and nKey<>K_ESC and nKey<>K_CTRL_RET and NextKey()==0, StuffKey(nWaitForKey), )
  return(ME_DEFAULT)


function MemoViewFnc(nMode)
  static initialized:=false
  local nKey:=LastKey()
  breakif nKey==nSwapTask or nKey==K_CTRL_RET
  if nMode==ME_INIT
    returnif initialized with ME_DEFAULT
    initialized:=true
    SetCursor(SC_SPECIAL1)
    return ME_TOGGLESCROLL
  elseif nMode==-1
    initialized:=false  //preInit
  endif
  if( nKey<>K_CTRL_W and nKey<>K_ESC and nKey<>K_CTRL_RET and NextKey()==0, StuffKey(nWaitForKey), )
  return(ME_DEFAULT)


function SetMemoWrap(new)
  static old:=true
  return old update with new


//*****************************************************************************
// EditGetMsg(get,lCanEdit) --> true
// edit one get object, with messages
//
function EditGetMsg(Get,CanEdit)
  local Msg,ah
  Default CanEdit to true
  Msg:=if(CanEdit,ResTxt(152),ResTxt(153))
  SaveDOut(Msg+if(!Empty(SetDMsg()),","+SetDMsg(),""))
  if (Upper(ProcName(1))=="EDITIT")
    ah:={if(CanEdit,18,17)}
  else
    ah:={if(CanEdit,10,9),1}
  endif
  SaveHelpIdx(ah)
  EditGet(get,CanEdit)
  RestHelpIdx()
  RestDOut()
  return(true)


//*****************************************************************************
// EditGet(get,lCanEdit) --> true
// edit one get object
//
function EditGet(Get,CanEdit)
  local Ch,IsMemo,oldValue
  default CanEdit to true
  if GetPreValidate(Get,@CanEdit)
    IsMemo:=Transform(Get:VarGet(),)==ResTxt(134)
    ReadHelpVar(Get:Name)
    Get:SetFocus()
    oldValue:=Get:VarGet()
    repeat
      Get:ExitState:=false
      SetCursor(if(ReadInsert(),SC_INSERT,SC_NORMAL))
      GetApplyKey(Get,GetKey(0),@CanEdit,IsMemo)
    until Get:ExitState and GetPostValidate(Get,@CanEdit,IsMemo,oldValue)
    Get:KillFocus()
    ReadHelpVar("")
    SetCursor(SC_NONE)
  else
    InKey()  //need for c_browse.prg, disable endless loop ???
  endif
  return(true)

static function GetPreValidate(Get,CanEdit)
  local When:=true
  if Get:PreBlock<>nil
    Get:ExitState:=!CanEdit
    When:=Eval(Get:PreBlock,Get,@CanEdit)
    Get:Display()
  endif
  return(When)

static function GetPostValidate(Get,CanEdit,IsMemo,oldValue)
  local Valid:=true
  if Get:BadDate(); Get:Home(); return(!CanEdit); endif
  if Get:Changed(); Get:Assign(); endif
  Get:Reset()
  if Get:PostBlock<>nil and !(LastKey()==K_CTRL_RET and IsMemo)
    Get:ExitState:=!CanEdit
    Valid:=Eval(Get:PostBlock,Get,@CanEdit,oldValue)
    Get:UpdateBuffer()
  endif
  return(Valid or (!CanEdit and !IsMemo))

static function GetApplyKey(Get,Ch,CanEdit,IsMemo)
  if SetKey(Ch)<>nil; GetDoSetKey(Ch,Get); return(true); endif
  do case
    case Ch==K_INS;         Set(_SET_INSERT,!Set(_SET_INSERT))
    case Ch==K_HOME;        Get:Home()
    case Ch==K_END;         Get:End()
    case Ch==K_LEFT;        Get:Left()
    case Ch==K_RIGHT;       Get:Right()
    case Ch==K_CTRL_LEFT;   Get:WordLeft()
    case Ch==K_CTRL_RIGHT;  Get:WordRight()
    case Ch==K_BS;          Get:BackSpace()
    case Ch==K_DEL;         Get:Delete()
    case Ch==K_CTRL_BS;     Get:DelWordLeft()
    case Ch==K_CTRL_T;      Get:DelWordRight()
    case Ch==K_CTRL_Y;      Get:DelEnd()
    otherwise
      if Ch<32 or Ch>254; GetDone(Get); return(true); endif
      if CanEdit and !IsMemo
        Ch:=Chr(Ch)
        if Get:Type=="N" and Ch$".,"
          Get:ToDecPos()
        else
          if Set(_SET_INSERT); Get:Insert(Ch); else; Get:Overstrike(Ch); endif
        endif
      endif
  endcase
  if Get:TypeOut and !Set(_SET_CONFIRM)
    if Set(_SET_BELL); Bell(); endif
    Get:ExitState:=true
    SetLastKey(K_ENTER)
  endif
  return(true)

static function GetDoSetKey(Ch,Get)
  if Get:Changed; Get:Assign(); endif
  Eval(SetKey(Ch),ProcName(3),ProcLine(3),Get:Name)
  Get:UpdateBuffer()
  return(true)

static function GetDone(Get)
  if Get:Changed; Get:Assign(); endif
  Get:ExitState:=true
  return(true)


//*****************************************************************************
// EditIt(xValue,cMessage,cPicture,Row,Col,Color,cVarName,IsPassword) --> xEditedValue
// edit one variable
//
function EditIt(xVal,cMsg,cPic,R,C,Clr,VarName,IsPsw)
  local rv
  SaveDOut("")
  rv:=EditItPrim(xVal,cMsg,cPic,R,C,Clr,VarName,IsPsw)
  RestDOut()
  return(rv)


//*****************************************************************************
// EditItPrim(xValue,cMessage,cPicture,Row,Col,Color,cVarName,IsPassword) --> xEditedValue
// Primitive of EditIt; edit one variable, don't clear dialog line
//
function EditItPrim(xVal,cMsg,cPic,R,C,Clr,VarName,IsPsw)
  local R2,C2,Cs,Scr
  local GetList:={}
  local Ch
  Cs:=ValType(xVal)
  do case
    case Cs=="D"; Cs:=Len(DtoC(xVal))
    case Cs=="N"; Cs:=Len(Str(xVal))
    otherwise;    Cs:=Len(xVal)
  endcase
  Cs+=Len(cMsg)+4
  default R to Int(MaxRow()/2)
  default C to Int((MaxCol()-Cs)/2)
  default Clr to m->Color:Edit
  default IsPsw to false
  R2:=R+2
  C2:=C+Cs
  Scr:=SaveScr(R,C,R2+1,C2+1)
  DispBegin()
    @ R,C,R2,C2 box B_DOUBLE+" " color Clr
    if m->tColor<>0; BoxShadow(R,C,R2,C2,ListAsArray(Clr)[nShadow]); endif
    @ R+1,C+2 say cMsg color Clr get xVal picture cPic color Clr
    default VarName:=DISABLE
    GetList[1]:Name:=VarName  //save it for help system
  DispEnd()
  if IsPsw
    clear gets
    SaveDOut(ResTxt(144))
    Clr:=ListAsArray(Clr)[nEnhanced]
    R++
    C+=3+Len(cMsg)
    @ R,C say Replicate(" ",Len(xVal)) color Clr
    xVal:=""
    SetPos(R,C)
    SetCursor(SC_INSERT)
    ReadHelpVar(VarName)
    repeat
      Ch:=Chr(PauseKey(0))
      do case
        case Ch==Chr(K_ESC)
        case Ch==Chr(K_ENTER)
        case Ch==Chr(nSwapTask);  Ch:=Chr(K_ESC)
        case Ch==Chr(K_CTRL_RET); Ch:=Chr(K_ENTER)
        case Ch==Chr(K_BS)
          if !Empty(xVal)
            xVal:=Left(xVal,Len(xVal)-1)
            C--
            @ R,C say " " color Clr
            SetPos(R,C)
          endif
        case ("0"<=Ch and Ch<="9") or ("A"<=Upper(Ch) and Upper(Ch)<="Z")
          if C+2<C2
            xVal+=Ch
            C++
            DispOut("*",Clr)
          endif
      endcase
    until Ch==Chr(K_ESC) or Ch==Chr(K_ENTER)
    ReadHelpVar("")
    if Ch==Chr(K_ESC); xVal:=""; endif
    RestDOut()
  else
    EditGetMsg(GetList[1],true)
  endif
  RestScr(Scr)
  return(xVal)


//*****************************************************************************
// BoxShadow(R,C,R2,C2,Clr) --> true
// draw a shadow around box.
// color for shadowing is swapped nShadow element from Clr.
//
function BoxShadow(R,C,R2,C2,Clr)
  local OldR:=R
  if (R2+1)>=MaxRow(); return(false); endif
  if C2>=MaxCol(); return(false); endif
  default Clr to ListAsArray(SetColor())[nShadow]
  Clr:="X"+chr(Color2Num(Clr,true))                 //numeric Shadow color
  R:=R2:=Min(R2+1,MaxRow())
  C++
  C2:=Min(C2+1,MaxCol())
  RestScreen(R,C,R2,C2,Transform(SaveScreen(R,C,R2,C2),Replicate(Clr,C2-C+1)))
  R:=OldR+1
  R2--
  C:=C2
  RestScreen(R,C,R2,C2,Transform(SaveScreen(R,C,R2,C2),Replicate(Clr,R2-R+1)))
  return(true)


//*****************************************************************************
// Color2Num(cColor,lSwap) --> nByte_DOS_Color
// Evaluate a color on the MS_DOS system color representation (numeric)
// e.g. "W/N"   --> 07 (hex)
// e.g. "GR+/B" --> 1E (hex)
//
function Color2Num(cColor,lSwap)
  local nI,nJ,cFore,cBack
  default lSwap to false       //true: Swap foreground and background color!
  cColor:=StrTran(cColor," ")                             //delete spaces
  if (nI:=At("/",cColor))<2; nI:=2; cColor:="n/w"; endif  //Extract first color
  cFore:=Left(cColor,nI-1)
  nJ:=At(",",cColor)                                      //Extract back colors
  nJ:=iif(nJ=0, Len(cColor)+1, nJ)
  cBack:=SubStr(cColor,nI+1,nJ-nI-1)
  if lSwap
    return(16*Ch2Num(cFore)+Ch2Num(cBack))
  endif
  return(16*Ch2Num(cBack)+Ch2Num(cFore))


//-----------------------------------------------------------------------------
//  Ch2Num(Char)
//  conversion ONE clipper color into numeric MS_DOS value
//
static function Ch2Num(cC)
  local nNum
  nNum:=0
  cC:=Upper(cC)
  nNum+=iif(cC=="B", 1,0)
  nNum+=iif(cC=="G", 2,0)
  nNum+=iif(cC=="BG",3,0)
  nNum+=iif(cC=="R", 4,0)
  nNum+=iif(cC=="RB",5,0)
  nNum+=iif(cC=="GR",6,0)
  nNum+=iif(cC=="W", 7,0)
  nNum+=iif(cC=="N+",  8,0)
  nNum+=iif(cC=="B+",  9,0)
  nNum+=iif(cC=="G+", 10,0)
  nNum+=iif(cC=="BG+",11,0)
  nNum+=iif(cC=="R+", 12,0)
  nNum+=iif(cC=="RB+",13,0)
  nNum+=iif(cC=="GR+",14,0)
  nNum+=iif(cC=="W+", 15,0)
  if (nNum=0).and. !(cC=="N"); nNum:=7; endif
  return(nNum)


//*****************************************************************************
// DOut(cMsg)
// output a message into dialogue line. (overwrite old message)
//
procedure DOut( cMsg )
  local OldRow:=Row()
  local OldCol:=Col()
  if SetDialog()
    SetDMsg(cMsg)
    @ MaxRow(),0 say PadC( Left(cMsg,MaxCol()+1), MaxCol()+1 ) color m->Color:Menu
    SetPos(OldRow,OldCol)
  endif
  return


//*****************************************************************************
// SaveDOut(cMsg)
// output a message into dialogue line. (save old message)
//
procedure SaveDOut( cMsg )
  if SetDialog()
    AAdd( aMessages, SetDMsg() )
    DOut( cMsg )
  endif
  return


//*****************************************************************************
// RestDOut(cMsg)
// restore old message.
//
procedure RestDOut()
  if !Empty(aMessages) and SetDialog()
    DOut( ATailDel(aMessages) )
  endif
  return


//*****************************************************************************
// SetDMsg(cNew) --> OldString
// save, return last dialog message
//
function SetDMsg(cNew)
  static cOld:=""
  local cc:=cOld
  if SetDialog()
    store value cNew into cOld
  endif
  return(cc)


//*****************************************************************************
function SetDialog(lNew)
  static lShowDOut:=true
  return lShowDOut update with lNew


//#############################################################################
// LOW LEVEL INTERFACE
//#############################################################################
//
function SkipDeleted()
  local Rn:=RecNo()
  while !Eof() and Deleted(); skip; endwhile
  if Eof()
    go top
    while Deleted() and RecNo()<Rn; skip; endwhile
    if RecNo()>=Rn
      go bottom
      skip
      return(false)
    endif
  endif
  return(true)


//*****************************************************************************
function MidStr(S,l,r)
  default l to 1, r to 1
  return(SubStr(S,l,Len(S)+2-l-r))


//*****************************************************************************
function AWidth(aArray,bWidth)          //author Mike Schinkel (Nantucket news vol.4, No.4, 1991), modified by JHK.
  local nWidth:=0
  default bWidth to {|e| Len(e)}
  AEval(aArray,{|e|nWidth:=Max(nWidth,Eval(bWidth,e))})
  return(nWidth)


//*****************************************************************************
function ListAsArray(cList,cDelimiter)  //copyright Nantucket Corporation, 1990, modified by JHK.
  local i,aList:={}
  if Empty(cList); return(aList); endif
  default cDelimiter to ","
  while (i:=At(cDelimiter,cList))<>0
    AAdd(aList,SubStr(cList,1,i-1))
    cList:=SubStr(cList,i+1)
  endwhile
  AAdd(aList,cList)
  return(aList)


//*****************************************************************************
function SwapColor(Clr)
  return(SubStr(Clr,1+At("/",Clr))+"/"+Left(Clr,At("/",Clr)-1))


//*****************************************************************************
function GetFore(Clr)                    //color
  return(Left(Clr,At("/",Clr)-1))


//*****************************************************************************
function GetBack(Clr)                    //color
  return(SubStr(Clr,At("/",Clr)+1))


//*****************************************************************************
function GetField(c)                          //select->FIELD
  return(AllTrim(SubStr(c,At(">",c)+1)))


//*****************************************************************************
function GetSelect(c)                         //SELECT->field
  local i
  if (i:=At("->",c))>0; c:=AllTrim(SubStr(c,1,i-1)); endif
  return(c)


//*****************************************************************************
function GetAlias(c)                          //a:\dir1\dirn\ALIAS.dbf
  local i
  c:=SubStr(c,RAt("\",c)+1)
  c:=SubStr(c,RAt(":",c)+1)
  if (i:=At(".",c))>0; c:=SubStr(c,1,i-1); endif
  return(c)


//*****************************************************************************
function IEval(nCount,bBlock)        //copyright Nantucket Corporation, 1990
  local ValResult,i
  for i:=1 to nCount; ValResult:=Eval(bBlock,i); endfor
  return(ValResult)


//*****************************************************************************
function WEval(bExpression,bBlock)
  while Eval(bExpression)
    returnif !Eval(bBlock) with false
  endwhile
  return true


//*****************************************************************************
function ATrueDel(aArray,nPosition)   //copyright Nantucket Corporation, 1990
  local x:=aArray[nPosition]          //modified by JHK, JHK-Software
  ADel(aArray,nPosition)
  ASize(aArray,Len(aArray)-1)
  return(x)


//*****************************************************************************
function ATrueIns(aArray,nPosition,xValue)
  AAdd(aArray,nil)
  fill empty nPosition with Len(aArray)
  AIns(aArray,nPosition)
  store value xValue into aArray[nPosition]
  return(aArray)


//*****************************************************************************
function ATailDel(aArray)
  local x:=ATail(aArray)
  ASize(aArray,Len(aArray)-1)
  return(x)


//*****************************************************************************
function PrintCodes(cCtrlCode)     //copyright Nantucket Corporation, 1990
  local nRow := PRow()
  local nCol := PCol()
  local lPrinter := Set(_SET_PRINTER, .T.)     // SET PRINTER ON
  local lConsole := Set(_SET_CONSOLE, .F.)     // SET CONSOLE OFF
  ?? cCtrlCode
  SetPrc(nRow, nCol)
  Set(_SET_PRINTER, lPrinter)                  // Restore printer setting
  Set(_SET_CONSOLE, lConsole)                  // Restore console setting
  return(true)


//*****************************************************************************
function SetShowTime(new)
  static old:=true
  return old update with new


//*****************************************************************************
function SetShowText(new)
  static old:=true
  return old update with new


//*****************************************************************************
function ShowText(Txt)
  static old:=""
  local CurSize,S,R,C
  if !Empty(Txt)
    S:=if(Len(Txt)<Len(old),Space(Len(old)-Len(txt)),"")+;
       if(Empty(AllTrim(Txt)),"  "," ")+Txt+" "
    old:=if(Empty(AllTrim(Txt)),"",Txt)
  else
    S:=if(Empty(old),""," "+old+" ")
  endif
  if !Empty(S) and SetShowText()
    R:=Row()
    C:=Col()
    DispBegin()
    CurSize:=SetCursor(SC_NONE)
    @ 0,MaxCol()-Len(S)+1 say S color m->Color:Menu
    SetPos(R,C)
    SetCursor(CurSize)
    DispEnd()
  endif
  return(old)


//*****************************************************************************
function ShowTime(Tm)
  static oTm:="00:00:00"
  returnif !SetShowTime() with ShowText()
  default Tm:=Time()
  if !(oTm==Tm)
    oTm:=Tm
    ShowText(Tm)
  endif
  return(Tm)


//*****************************************************************************
function GetKey(nSecs)
  local n, nKey
  default nSecs:=0.001
  if( nSecs==0, nSecs:=9999999, )
  n:=Seconds()
  repeat
    ShowTime()
    nKey:=Inkey()
  until nKey<>0 or (Seconds()-n)>=nSecs
  return(nKey)


//*****************************************************************************
function InKeyWait( nSecs )          //copyright Nantucket Corporation, 1990
  local nKey, bKeyBlock              //modified by JHK, JHK-Software, Piestany
  nKey:=GetKey(nSecs)
  if (bKeyBlock:=SetKey(nKey)) != nil
    Eval(bKeyBlock, ProcName(2), ProcLine(2))
  endif
  return(nKey)


//*****************************************************************************
function PauseKey( nSecs )           //idea from Nantucket Corporation, 1990
  local nKey                         //written by JHK, JHK-Software, Piestany.
  repeat
    nKey:=InKeyWait(nSecs)
  until SetKey(nKey)==nil
  return(nKey)


//*****************************************************************************
function StuffKey( nKey )
  local c:=Chr(nKey)
  while NextKey()<>0; c+=Chr(InKey()); endwhile
  __Keyboard(c)
  return(true)


//*****************************************************************************
function StuffKeys( cKeys )
  while NextKey()<>0; cKeys+=Chr(InKey()); endwhile
  __Keyboard(cKeys)
  return(true)


//*****************************************************************************
function SetLastKey( nKey )
  StuffKey(nKey)
  return(InKey())


//*****************************************************************************
function SetQuickEsc( lNew )
  static lQuickEsc:=true
  return lQuickEsc update with lNew


//*****************************************************************************
function SetDateTime( lNew )
  static lDateTime:=false
  return lDateTime update with lNew


//*****************************************************************************
procedure RefreshRow()
  local vue,tb
  vue:=ATail(GetWList())
  if !vue:FormActive
    tb:=vue:Tb
    tb:RefreshCurrent()
    while !tb:Stabilize(); endwhile
  endif
  return


//*****************************************************************************
procedure RefreshTable()
  local vue,tb
  vue:=ATail(GetWList())
  if !vue:FormActive
    SaveDOut("Prekreslujem okno...")
    DispBegin()
      tb:=vue:Tb
      tb:RefreshAll()
      while !tb:Stabilize(); endwhile
    DispEnd()
    RestDOut()
  endif
  return


//*****************************************************************************
// Vypocita pocet dni v danom mesiaci
//
function DaysInMonth(Month,Year)
  local r4,Days
  default Year:=Year(Date())
  r4:=Year/4
  do case
    case Month==1;  Days:=31
    case Month==2;  Days:=if(Int(r4)==r4,29,28)
    case Month==3;  Days:=31
    case Month==4;  Days:=30
    case Month==5;  Days:=31
    case Month==6;  Days:=30
    case Month==7;  Days:=31
    case Month==8;  Days:=31
    case Month==9;  Days:=30
    case Month==10; Days:=31
    case Month==11; Days:=30
    case Month==12; Days:=31
  endcase
  return(Days)


//*****************************************************************************
// GoodBye() --> true
// write text and play the song
//
function GoodBye()
  SetCursor(SC_NORMAL)
  SetColor(m->Color:Black)
  clear screen
  replicate(chr(13)+chr(10),5)
  ? "                                                                            "
  ? "                                                                "
  ? "                                                                       "
  ? "                                                                        "
  ? "                                                                        "
  ? "                                                      "
  ? "                                                          "
  ? "                                                          "
  ? "                                                              "
  ? "                                                  "
  ? "                                                                           "
  ? "                                                                    (c)JHK "
  ?
  ?
  BlueDanu()
  return(true)


//-----------------------------------------------------------------------------
//                            Author: Greg Lief
//                         Copyright (c) 1989, Greg Lief
//                         Plays the Blue Danube Waltz
procedure BlueDanu()
  local tonestr, durstr, xx
  tonestr = ' 293 293 370 440 440 015 880 880 015 740 740 015 293 293 370'
  tonestr = tonestr + ' 440 440 015 880 880 015 784 784 015 277 277 329 493'
  tonestr = tonestr + ' 493 015 986 986 015 784 784 015 277 277 329 493 493'
  tonestr = tonestr + ' 015 986 986 015 740 740 015 293 293 370 440 587 015'
  tonestr = tonestr + '11741174 015 880 880 015 293 293 370 440 587 015'
  tonestr = tonestr + '11741174 015 987 987 015 329 329 392 493'
  tonestr = tonestr + ' 493 415 440 740 587 370 370 329 493 440 293 370 440 587'
  durstr = Replicate('04', 76) + '1604041604040804080404040404'
  for xx:=1 to 6
    Tone(Val(SubStr(tonestr,(xx-1)*4+1,4)),Val(SubStr(durstr,(xx-1)*2+1,2)))
  endfor
  do while NextKey()==0
     Tone(Val(SubStr(tonestr,(xx-1)*4+1,4)),Val(SubStr(durstr,(xx-1)*2+1,2)))
     xx:=if(xx>90, 1, xx+1)
  enddo
  if NextKey()<>0;  InKeyWait(0);  endif
  return


//*****************************************************************************
// Turn clipper output device to screen, printer or file.
//
procedure OutputDevice(What,lAdditive)
  default lAdditive to false
  do case
    case What==OD_SCREEN
      set printer to
      set printer off
      set device to screen
      set console on
    case What==OD_PRINTER
      set device to printer
      set printer on
      set printer to
      set console off
    otherwise //file
      set device to printer
      set printer on
      set console off
      if lAdditive
        set printer to (What) Additive
      else
        set printer to (What)
      endif
  endcase
  return


//*****************************************************************************
// PrintFunctions...
//
procedure PrintOn()
  OutputDevice(OD_PRINTER)
  return

procedure PrintOff()
  OutputDevice(OD_SCREEN)
  return

function PageLength(new)  
  static old:=65
  return old update with new

#define READ_EOF   -1
#define READ_OK     0
#define READ_ERROR +1
#define READ_ABORT +2

function PrintFile(FName)
  local fd,i,j,k
  local OfsPage,Oe
  local PageNo:=EditIt(1,ResTxt(195),"999",,,,"SYS:->PAGE_NO")
  returnif LastKey()==K_ESC with false
  SaveDOut(ResTxt(197))  //please wait, printing...
  fd:=FOpen(FName)
  returnif FError()<>0 with Alert(ResTxt(198)+NTrim(FError())),RestDOut(),false
  SetLastKey(0)
  PrintOn()
    //skip requested pages
    for i:=2 to PageNo
      for j:=1 to PageLength()
        k:=ReadLine(fd)
        returnif k==READ_EOF   with DonePrint(),Alert(ResTxt(199)+NTrim(PageNo)+ResTxt(200)),false
        returnif k==READ_ERROR with DonePrint(),Alert(ResTxt(201)+NTrim(FError())),false
        returnif k==READ_ABORT with DonePrint(),false
      endfor
    endfor
    //out of next pages
    k:=READ_OK //assume
    repeat
    begin break
      OfsPage:=FSeek(fd,0,FS_RELATIVE)
      ?? ResTxt(203)+NTrim(PageNo)+cr_lf  //PageNo=
      i:=2                                //current line
      repeat
        k:=ReadLine(fd,@j)
        if( k==READ_OK, QQOut(j), )
        i++
      until k<>READ_OK or i>PageLength()
      eject
      PageNo++
    recover break using Oe
      PrintOff()
      if(Oe:genCode<>EG_PRINT, Eval(ErrorBlock(),Oe), )
      if(Alert(ResTxt(204),ResTxt(205))==2, k:=READ_ABORT, )
      FSeek(fd,OfsPage,FS_SET)
      PrintOn()
    end break
    until k<>READ_OK
  DonePrint()
  return true

static procedure DonePrint(fd)
  PrintOff()
  FClose(fd)
  RestDOut()
  return
  
static function ReadLine(fd,line)  //return: READ_OK | READ_EOF | READ_ERROR | READ_ABORT
  local buffer,i
  local origin:=FSeek(fd,0,FS_RELATIVE)
  local bottom:=FSeek(fd,0,FS_END)
  returnif origin==bottom with READ_EOF
  buffer:=Space(nMaxPrintCols)
  FSeek(fd,origin,FS_SET)
  FRead(fd,@buffer,nMaxPrintCols)
  i:=At(cr_lf,buffer)
  line:=if(i==0,buffer,Left(buffer,i+1))
  FSeek(fd,origin+Len(line),FS_SET)
  returnif FError()>0 with READ_ERROR
  if NextKey()==K_ESC
    Inkey(0)
    PrintOff()
    returnif Alert(ResTxt(202),ResTxt(123))==1 with READ_ABORT
    PrintOn()
  endif
  return READ_OK



//*****************************************************************************
// Don't allow to running program after the date...
//
function DateLimit(new)
  static  old:=nil
  return old update with new


//*****************************************************************************
// Save the database state, no all values, only minimum for select and seek.
//
procedure SwapDatabase(cAlias,nOrder)
  local s:=Select()
  local r:=RecNo()
  select (cAlias)
  AAdd(DatabInfo,{s,r,RecNo(),IndexOrd()}) //origin_Select, origin_RecNo, new_RecNo, new_Order
  if nil<>nOrder; set order to nOrder; endif
  return


//-----------------------------------------------------------------------------
// Restore (previous saved) database state
//
procedure RestDatabase()
  local x:=ATailDel(DatabInfo)
  set order to (x[4])
  go (x[3])
  select (x[1])
  go (x[2])
  return


//*****************************************************************************
// Swap display modes.
//
procedure SwapVGALine()
  SetMode( if(MaxRow()>25,25,50), 80 )
  RePaintDesktop()
  return

procedure SwapEGALine()
  SetMode( if(MaxRow()>25,25,43), 80 )
  RePaintDesktop()
  return



//#############################################################################
// NET SUPPORT:
// all functions vill be return !NETERR() and keep correct NETERR()
//
//-----------------------------------------------------------------------------
function NetDbCreate(cFile,aStructure,lContinue)
  if Right(AllTrim(Upper(cFile)),4)==".DBF"
    cFile:=MidStr(cFile,,5)  //forget extension
  endif
  if !NetFErase(cFile+".DBF",lContinue); return(false); endif
  if !NetFErase(cFile+".DBT",lContinue); return(false); endif
  retur( NetProcedure( {||DbCreate(cFile,aStructure),!NetErr()}, ResTxt(112)+" "+cFile, lContinue ))


//-----------------------------------------------------------------------------
function NetCreateFrom(cFile1,cFile2,lContinue)
  if Right(AllTrim(Upper(cFile1)),4)==".DBF"
    cFile1:=MidStr(cFile1,,5)  //forget extension
  endif
  if !NetFErase(cFile1+".DBF",lContinue); return(false); endif
  if !NetFErase(cFile1+".DBT",lContinue); return(false); endif
  return(NetProcedure( {||__DbCreate(cFile1,cFile2),!NetErr()}, ResTxt(112)+" "+cFile1, lContinue ))


//-----------------------------------------------------------------------------
function NetDbUseArea(new,rdd,db,a,shex,ro,lContinue)
  return(NetProcedure( {||DbUseArea(new,rdd,db,a,shex,ro),!NetErr()}, ResTxt(113)+" "+db, lContinue ))


//-----------------------------------------------------------------------------
function NetIndexOn(cFile,cKey,bKey,lUnique,lContinue)
  if !NetFErase(GetAlias(cFile)+".ntx",lContinue); return(false); endif
  return(NetProcedure( {||DbCreateIndex(cFile,cKey,bKey,lUnique),!NetErr()}, ResTxt(108)+" "+cFile+".ntx", lContinue ))


//----------------------------------------------------------------------------
function NetSetIndex(cListFiles,lContinue)
  if Left(cListFiles,1)=='"'; cListFiles:=MidStr(cListFiles,2,2); endif
  return(NetProcedure( {||SetIndexBlock(cListFiles)}, ResTxt(109)+" "+cListFiles, lContinue ))

static function SetIndexBlock(cListFiles)
  DbClearIndex()
  AEval(ListAsArray(cListFiles),{|e|DbSetIndex(if(Left(e,1)=='"',MidStr(e,2,2),e))})
  return(!NetErr())


//-----------------------------------------------------------------------------
function NetDbAppend(lContinue)
  return(NetProcedure( {||DbAppend(),DbCommit(),!NetErr()}, ResTxt(114), lContinue ))


//-----------------------------------------------------------------------------
function NetDbDelete(lContinue)
  return(NetProcedure( {||if(RLock(),(DbDelete(),DbCommit(),DbUnLock(),true),false)}, ResTxt(116), lContinue ))


//-----------------------------------------------------------------------------
function NetDbRecall(lContinue)
  return(NetProcedure( {||if(RLock(),(DbRecall(),DbCommit(),DbUnLock(),true),false)}, ResTxt(115), lContinue ))


//-----------------------------------------------------------------------------
function NetReplace(bRepl,lContinue)
  return(NetProcedure( {||if(RLock(),(Eval(bRepl),DbCommit(),DbUnLock(),true),false)}, ResTxt(111), lContinue ))


//-----------------------------------------------------------------------------
function NetReplSeek(bRepl,xExpr,lContinue)
  seek xExpr
  while Found()
    returnif !NetProcedure( {||if(RLock(),(Eval(bRepl),DbCommit(),DbUnLock(),true),false)}, ResTxt(111), lContinue ) with false
    seek xExpr
  endwhile
  return true


//-----------------------------------------------------------------------------
function NetRLock(lContinue)
  return(NetProcedure( {||RLock()}, ResTxt(111), lContinue ))


//-----------------------------------------------------------------------------
function NetFLock(lContinue)
  return(NetProcedure( {||FLock()}, ResTxt(110), lContinue ))


//-----------------------------------------------------------------------------
function NetFErase(cFile,lContinue)
  if !File(cFile); NetErr(false); return(true); endif
  return(NetProcedure( {||FErase(cFile)==0}, ResTxt(107)+" "+cFile, lContinue ))


//-----------------------------------------------------------------------------
function NetReIndex(lContinue)
  local l:=true
  begin break
    reindex
  recover break
    l:=GetOneDbf(Alias()):ReIndex(lContinue)
  end break
  return(l)


//-----------------------------------------------------------------------------
function NetPack(lContinue)
  local l:=true
  begin break
    pack
  recover break
    l:=GetOneDbf(Alias()):Pack(lContinue)
  end break
  return(l)


//-----------------------------------------------------------------------------
function NetZap(lContinue)
  local l:=true
  begin break
    zap
  recover break
    l:=GetOneDbf(Alias()):Zap(lContinue)
  end break
  return(l)


//-----------------------------------------------------------------------------
static function NetProcedure(bProc,cAlertText,lContinue)
  local cChoice,nChoice,nWaitSec,x
  default lContinue to true
  cChoice:=if(lContinue,ResTxt(127),ResTxt(126))
  repeat
    nWaitSec:=nNetWaitSec
    while nWaitSec>0
      begin break
        x:=false
        x:=Eval(bProc)
      end break
      if x; NetErr(false); return(true); endif
      InKeyWait(.1)
      nWaitSec-=.2
    endwhile
    nChoice:=Alert(cAlertText,cChoice)
    if nChoice==2 and !lContinue; nChoice++; endif
    if nChoice==3
      if Alert(ResTxt(106),ResTxt(123))<>1; nChoice:=1; endif
    endif
  until nChoice<>1
  if nChoice==3; ObjectDone(); quit; endif
  NetErr(true)
  return(false)


//*****************************************************************************
// LogOn()
// increment users counter for tracking index files integrity. (see Dbf:Open())
//
function LogOn()
  return(LogActivity({||field->ViewID++}))


//*****************************************************************************
// LogOff()
// decrement users counter for tracking index files integrity. (see Dbf:Done())
//
function LogOff()
  return(LogActivity({||field->ViewID--}))


//*****************************************************************************
// LogClear()
// zeroes users counter for tracking index files integrity. (see Dbf:Load())
//
function LogClear()
  return(LogActivity({||field->ViewID:=0}))


//*****************************************************************************
// LogSet([nUsers])
// set users counter.
//
function LogSet(nUsers)
  local tmp:=LogActivity({||field->ViewID},true)
  if( !Empty(nUsers), LogActivity( {||field->ViewID:=nUsers} ), )
  return(tmp)


//*****************************************************************************
// NetLimit([new_limit])
// maximum users currently working  with the program.
//
function NetLimit(new)
  static old:=990      //999 is RESERVED AS LOADING MARK !!!
  return old update with new


//*****************************************************************************
// LogActivity(Block,Return_request)
// work around tracking index files integrity
// I wish to thank mr. Saferna (OKD Ostrava) for good idea
// about 'multiuser crash test' implemented into this object.lib
//
static function LogActivity(Block,ret_req)
  local r,s:=Select()
  default ret_req:=false
  begin break
    select (cIFR)
    go 1
    net rlock
    r:=Eval(Block)
    net unlock
  recover break
    begin break
      use (cIFR) exclusive new
      go 1
      r:=Eval(Block)
      close
    recover break
      select (s)
      return(if(ret_req,r,false))
    end break
  end break
  select (s)
  return(if(ret_req,r,true))


//-------------------------------------------------- eof (c)JHK ---------------

