//*****************************************************************************
// C_OneDbf.prg
// OneDbf class for OBJECT v2.03
// Copyright (c) 1991, JHK, JHK-Software, Piestany
// Please compile with: /N/M/W/A
//-----------------------------------------------------------------------------

#include "Object.ch"


create class OneDbf       //help class for Dbf, work around one database
  export:
  var File       // ""    //full path file name
  var Name       // ""    //alias = file name
  var Struc      // {}    //{{cName,cType,nLen,nDec},...}
  var Pict       // {}    //{cPicture,...}
  var PreBlock   // {}    //{bWhen,...}
  var PostBlock  // {}    //{bValid,...}
  var Ntx        // {}    //{{cName,cFile,cKey,lUnique,lUser},...}
  var Rel        // {}    //{{xKey,cAlias,nOrder},...} relation(s) from this Dbf into another
  method New=OneDbfNew             //o:New()
  method Init=OneDbfInit           //o:Init()
  method Create=OneDbfCreate       //o:Create(lContinue)             //create the database and its indexes
  method Open=OneDbfOpen           //o:Open(lShared,lContinue,lNew)  //open ...
  method NtxOpen=OneDbfNtxOpen     //o:NtxOpen(lContinue)            //open indexes (database must be opened)
  method ReIndex=OneDbfReIndex     //o:ReIndex(lContinue)            //recreate exist indexes
  method Pack=OneDbfPack           //o:Pack(lContinue)
  method Zap=OneDbfZap             //o:Zap(lContinue)
  method SetRelation=OneDbfSetRelation      //o:SetRelation()                    //all need databases must be opened
  method AddField=OneDbfAddField            //o:AddField(cName,cType,nLen,nDec)
  method AddNtx=OneDbfAddNtx                //o:AddNtx(cName,cFile,cKey,lUnique,lUser) //cName & lUser are for View-Index-Menu
  method AddRelation=OneDbfAddRelation      //o:AddRelation(xKey,cAlias,nOrder)        //xKey from current dbf into cAlias with nOrder
  method Picture=OneDbfPicture              //o:Picture(cPict)
  method Range=OneDbfRange                  //o:Range(nLo,nHi)
  method When=OneDbfWhen                    //o:When(bWhen)
  method Valid=OneDbfValid                  //o:Valid(bValid)    //standart validation
  method ChValid=OneDbfChValid              //o:ChValid(bValid)    //eval bValid only if Get:Changed==true
  endclass


//*****************************************************************************
// OneDbf:New() --> self
// initialize new object
//
constructor OneDbfNew()
  ::File:= ""
  ::Name:= ""
  ::Struc:= {}
  ::Pict:= {}
  ::PreBlock:= {}
  ::PostBlock:= {}
  ::Ntx:= {}
  ::Rel:= {}
  return(self)


//*****************************************************************************
// OneDbf:Init() --> true
// dummy initialize (new) object from OneDbf class.
//
method function OneDbfInit()
  return(true)


//*****************************************************************************
// OneDbf:Create(lContinue) --> true/false
// create and Open one database and her associated indexes.
//
method function OneDbfCreate(lContinue)
  local i
  default lContinue to true
  SaveDOut(ResTxt(157)+::File+" ...")
  select 0
  NetDbCreate(::File,::Struc,lContinue)
    if NetErr(); RestDOut(); return(false); endif
  NetdbUseArea(true,,::File,::Name,true,false,lContinue)  //new,rdd,db,alias,share,read_only,lContinue
    if NetErr(); RestDOut(); return(false); endif
  ::ReIndex(lContinue)
  RestDOut()
  return(true)


//*****************************************************************************
// OneDbf:Open(lShared,lContinue,lNew) --> true/false
// open one database and her associated indexes
// *.dbf must be exist, *.ntx may be created
//
method function OneDbfOpen(lShared,lContinue,lNew)
  local i
  local cIndexes:=""
  default lShared to true
  default lContinue to true
  default lNew to true
  SaveDOut(ResTxt(159)+::File+if(!lShared," exclusive","")+" ...")
  if !File(::File)
    Abort("File "+::File+" not found!")
  endif
  NetDbUseArea(lNew,,::File,::Name,lShared,false,lContinue) //new,rdd,db,alias,share,read_only,lContinue
  if NetErr()
    RestDOut()
    return(false)
  endif
  ::NtxOpen(lContinue)
  RestDOut()
  return(!NetErr())


//*****************************************************************************
// OneDbf:NtxOpen(lContinue) --> true/false
// open the indexes
//
method function OneDbfNtxOpen(lContinue)
  local c:=""
  select (::Name)

  DbClearIndex()
  AEval(::Ntx,{|e|if(!File(e[2]+".ntx"),CreateIndex(e,lContinue),nil)})
  AEval(::Ntx,{|e|c+=","+e[2]})
  NetSetIndex(SubStr(c,2),lContinue)
  set order to 0
  return(!NetErr())


//*****************************************************************************
// OneDbf:ReIndex(lContinue) --> true/false
// recreate indexes
//
method function OneDbfReIndex(lContinue)
  local Ok,s,o
  s:=Select()
  select (::Name)
  o:=IndexOrd()
  DbClearIndex()
  AEval(::Rel,{|e|UpDateRelations(e)})
  AEval(::Ntx,{|e|CreateIndex(e,lContinue)})
  if NetErr(); return(false); endif
  Ok:=::NtxOpen(lContinue)
  set order to (o)
  select (s)
  return(Ok)

//-----------------------------------------------------------------------------
static function UpDateRelations(e)
  local s:=Select()
  select (e[2])
  set order to (e[3])
  select (s)
  return(true)

//-----------------------------------------------------------------------------
function CreateIndex(e,lContinue)  //e=={cName,cFile,cKey,lUnique}
  SaveDOut(ResTxt(157)+e[2]+".ntx ...")
  NetIndexOn(e[2],e[3],&("{||"+e[3]+"}"),e[4],lContinue)
  DbClearIndex()
  RestDOut()
  return(!NetErr())


//*****************************************************************************
// OneDbf:SetRelation() --> true
// build the relation scheme for current selected database (alias)
//
method function OneDbfSetRelation()
  local i,r
  select (::Name)
  DbClearRel()
  for i:=1 to Len(::Rel)
    r:=::Rel[i]
    DbSetRelation( r[2], &("{||"+r[1]+"}"), r[1] )
  endfor
  return(true)


//*****************************************************************************
// OneDbf:Pack(lContinue) --> nil
// pack database.
//
method function OneDbfPack(lContinue)
  local s,o
  default lContinue to false
  s:=Select()
  select (::Name)
  if LastRec()>0
    o:=IndexOrd()
    ::Open(false,lContinue,false)  //lshared,lcontinue,lnew
    if !NetErr()
      SaveDOut(ResTxt(160)+::File+" ...")
      pack  //do not use the "net pack" (unterminated recursion loop)
      commit
      RestDOut()
    endif
    ::Open(,false,false)
    ::SetRelation()
    set order to (o)
  endif
  select (s)
  return(true)


//*****************************************************************************
// OneDbf:Zap(lContinue) --> true/false
// zap database.
//
method function OneDbfZap(lContinue)
  local s,o
  default lContinue to false
  s:=Select()
  select (::Name)
  o:=IndexOrd()
  ::Open(false,lContinue,false)  //shared,continue,new
  if !NetErr()
    SaveDOut(ResTxt(161)+::File+" ...")
    zap  //do not use the "net zap" (unterminated recursion loop)
    commit
    RestDOut()
  endif
  ::Open(,false,false)
  ::SetRelation()
  set order to (o)
  select (s)
  return(true)


//*****************************************************************************
// OneDbf:AddField(cName,cType,nLen,nDec) --> true
// add new field info into object.
//
method function OneDbfAddField(cName,cType,nLen,nDec)
  cName:=Upper(cName)
  cType:=Upper(cType)
  do case
    case cType=="C"; default nLen to 10, nDec to 0
    case cType=="N"; default nLen to 10, nDec to 0
    case cType=="D"; default nLen to  8, nDec to 0
    case cType=="M"; default nLen to 10, nDec to 0
    case cType=="L"; default nLen to  1, nDec to 0
  endcase
  AAdd(::Struc,{cName,cType,nLen,nDec})
  AAdd(::Pict,nil)
  AAdd(::PreBlock,nil)
  AAdd(::PostBlock,nil)
  HelpAssoc(::Name+"->"+cName,cName,HelpReserved(,+1))
  return(true)


//*****************************************************************************
// OneDbf:AddNtx(cName,cFile,cKey,lUnique,lUser) --> true
// add new index info into object.
//
method function OneDbfAddNtx(cName,cFile,cKey,lUnique,lUser)
  default cName to "~"+NTrim(Len(::Ntx)+1)+"."+GetAlias(cFile)+" "
  default lUnique to false
  default lUser to false
  if At("'",cKey)==0 and At('"',cKey)==0; cKey:=Upper(cKey); endif
  AAdd(::Ntx,{cName,Upper(cFile),cKey,lUnique,lUser})
  return(true)


//*****************************************************************************
// OneDbf:AddRelation(xKey,cAlias,nOrder) --> true
// add new relation into object.
//
method function OneDbfAddRelation(xKey,cAlias,nOrder)
  if ValType(xKey)=="C"
    if At("'",xKey)==0 and At('"',xKey)==0
      xKey:=Upper(xKey)
      if SubStr(xKey,1,7)=="FIELD->"
        xKey:=::Name+SubStr(xKey,6)
      endif
    endif
  endif
  AAdd(::Rel,{xKey,Upper(cAlias),nOrder})
  return(true)


//*****************************************************************************
// OneDbf:Picture(cPict) --> true
// save picture code for last field into object.
//
method function OneDbfPicture(cPict)
  ::Pict[Len(::Pict)]:=cPict
  return(true)


//*****************************************************************************
// OneDbf:Range(nLo,nHi) --> true
// save range information for last field into object.
//
method function OneDbfRange(nLo,nHi)
  ::PostBlock[Len(::PostBlock)]:={|_1|if(RangeCheck(_1,,nLo,nHi),true,(Alert(ResTxt(099),ResTxt(099)),false))}
  return(true)


//*****************************************************************************
// OneDbf:When(bWhen) --> true
// save when code block for last field into object.
//
method function OneDbfWhen(bWhen)
  ::PreBlock[Len(::PreBlock)]:=bWhen
  return(true)


//*****************************************************************************
// OneDbf:Valid(bValid) --> true
// save valid code block for last field into object.
// standart validation
//
method function OneDbfValid(bValid)
  ::PostBlock[Len(::PostBlock)]:=bValid
  return(true)


//*****************************************************************************
// OneDbf:ChValid(bValid) --> true
// save valid code block for last field into object.
// eval bValid only if Get:Changed==true
//
method function OneDbfChValid(bValid)
  ::PostBlock[Len(::PostBlock)]:={|G,l,v|if(G:Changed,Eval(bValid,G,l,v),true)}
  return(true)

//------------------------------------------------------- eof (c)JHK ----------

