//*****************************************************************************
// C_Info.prg
// Information (memo) class for OBJECT v2.03
// Copyright (c) 1991, JHK, JHK-Software, Piestany
// Please compile with: /N/M/W/A
//-----------------------------------------------------------------------------

#include "InKey.ch"
#include "Object.ch"
#include "SetCurs.ch"
#include "MemoEdit.ch"

static CurInfo              //current active info object
static initialized:=false   //memoedit initialized?
static isTop:=false         //hit top for memoedit?
static isBottom:=false      //...
static needUp:=false        //command after memoedit
static needDown:=false      //...

create class Info from Task
  export:
  var Wrap       // true            //true for info, false for report view
  var FName      // ""              //temp file name if Printed==true
  var CanPrint   // true            //allow print command
  var CanEdit    // false           //allow editting of ::Buff
  var RecNo      // 0               //abstract variable for HelpField()
  var CanErase   // false           //do not erase file (FName)
  var Printed    // false           //look for terminating object
  var SeeTop     // true            //need for child class FInfo (smart reading from file)
  var SeeBottom  // true            //need for child class FInfo (smart reading from file)
  var TextRow    // 1               //current text row
  var TextMax    // 0               //max rows in text
  var Buff       // ""              //text buffer
  method New=InfoNew             //o:New()
  method Init=InfoInit           //o:Init(Name,R,C,Rs,Cs,Clr,Shadow)
  method GoodInit=InfoGoodInit   //o:GoodInit(Name,R,C,Rs,Cs,CurSize,Clr,Shadow)
  method Print=InfoPrint         //o:Print()
  method VPaint=InfoVPaint       //o:VPaint()
  method VProcess=InfoVProcess   //o:VProcess()
  endclass


//*****************************************************************************
// Info:New() --> self
// initialize new object
//
constructor InfoNew()
  ::Color:= m->Color:View   //override
  ::Wrap:= true
  ::FName:= ""
  ::CanPrint:= true
  ::CanEdit:= false
  ::RecNo:=0
  ::CanErase:= false
  ::Printed:= false
  ::SeeTop:= true
  ::SeeBottom:= true
  ::TextRow:= 1
  ::TextMax:= 0
  ::Buff:= ""
  ::DoneBlock:= {|o|DoDone(o)}
  return(self)


//-----------------------------------------------------------------------------
// Info::DoDone() --> true/false
// selectable erasing report file
//
static function DoDone(Info)
  local Ch
  returnif !Info:Printed  with true
  returnif !Info:CanErase with true
  Info:Top(false)
  Ch:=Alert(ResTxt(091)+" "+Info:FName+";"+ResTxt(092),ResTxt(132))
  do case
    case Ch==1
      FErase(Info:FName)
      return(true)
    case Ch==2
      return(true)
    otherwise
      return(false)
  endcase
  return(false)   //dummy line


//-----------------------------------------------------------------------------
// GetReportName() --> cFileName
// look for existing files and return new (unique) report file name
//
function GetNewRepName()  //file name can be: SysRNNNN.txt, NNNN is number from 0001 to 9999
  local a:={}             //array of numbers NNNN of currently existed files
  local i:=1              //will be new number NNNN
  AEval(Directory(cRptFile+"*.txt"),{|e|AAdd(a,Val(SubStr(e[1],5,4)))})
  i:=AScan(ASort(a),{|e|e<>i++})
  fill empty i with Len(a)+1
  return(cRptFile+PadL(NTrim(i),4,"0")+".txt")


//*****************************************************************************
// Info:Init(Name,R,C,Rs,Cs,Clr,Shadow) --> true
// initialize the object
//
method function InfoInit(Name,R,C,Rs,Cs,Clr,Shadow)
  ::super(Task):Init(Name,R,C,Rs,Cs,Clr,Shadow)
  return(EndInit(self))


//*****************************************************************************
// Info:GoodInit(Name,R,C,Rs,Cs,CurSize,Clr,Shadow) --> true
// initialize the object
//
method function InfoGoodInit(Name,R,C,Rs,Cs,CurSize,Clr,Shadow)
  ::super(Task):GoodInit(Name,R,C,Rs,Cs,CurSize,Clr,Shadow)
  return(EndInit(self))


//*****************************************************************************
// Info::EndInit() --> true
// initialize Info extension instvar
//
static function EndInit(Info)
  Info:MinRows:=3
  return(true)


//*****************************************************************************
// Info:Print() --> true/false
// printing all info buffer
//
method function InfoPrint()
  local FName,Handle
  if !::Printed
    FName:=GetNewRepName()
    Handle:=FCreate(FName)
    if Handle==-1; Alert(ResTxt(090)); return(false); endif
    FWrite(Handle,::Buff)
    FClose(Handle)
    ::FName:=FName
    ::Printed:=true
  endif
  PrintFile(FName)
  return(true)


//*****************************************************************************
// Info:VPaint() --> true
// virtual paint
//
method function InfoVPaint()
  local Color:=::Color
  ::TextMax:=MLCount(::Buff,if(::Wrap,::ColSize,250))
  if m->tColor==3
    Color:=ListAsArray(Color)
    Color:=GetFore(Color[nUnSelect])+"/"+GetBack(Color[nNormal])
  endif
  SetColor(Color)
  MemoEdit(::Buff, ::Row+1,::Col+1, ::Row+::RowSize,::Col+::ColSize, false,false,if(::Wrap,::ColSize,250),,::TextRow)
  ShowTime()
  return(true)


//*****************************************************************************
// Info:VProcess() --> true
// virtual process
//
method function InfoVProcess()
  local OldKey,OldWFK
  local Color:=::Color
  local OldInfo:=CurInfo          //save old info object
  CurInfo:=self                   //set new info object (need for TextViewFnc)
  if m->tColor==3
    Color:=ListAsArray(Color)
    Color:=GetFore(Color[nUnSelect])+"/"+GetBack(Color[nNormal])
  endif
  SetColor(Color)
  if ::CanEdit
    SaveDOut(ResTxt(148))
  else
    SaveDOut(ResTxt(147)+if(::CanPrint,","+ResTxt(136),""))
  endif
  SaveHelpIdx({15,1})
  SetPos(::Row+Min(::RowSize,::TextMax),Col())  //cursor in memoedit will be appear here
  SetLastKey(0)
  initialized:=false
  isTop:=false
  isBottom:=false
  needUp:=false
  needDown:=false
  if ::TextRow<1; ::TextRow:=1; endif
  ::TextRow+=::RowSize-1
  if ::CanEdit; SetCursor(if(Set(_SET_INSERT),SC_INSERT,SC_NORMAL)); endif
  DisableHelp()
  OldWFK:=SetKey(nWaitForKey,{||WaitKey()})
  if( ::CanEdit, OldKey:=SetKey(nSwapTask,{||StuffKey(K_CTRL_W)}), )
  begin sequence
  ::Buff:=MemoEdit(::Buff, ::Row+1,::Col+1, ::Row+::RowSize,::Col+::ColSize, ::CanEdit,if(::CanEdit,"MemoEditFnc","TextViewFnc"),if(::Wrap,::ColSize,250),4, ::TextRow,0,::RowSize-1)
  end sequence
  if( ::CanEdit, SetKey(nSwapTask,OldKey), )
  SetKey(nWaitForKey,OldWFK)
  EnableHelp()
  ::TextRow-=Row()-::Row-1
  SetCursor(SC_NONE)
  RestHelpIdx()
  CurInfo:=OldInfo
  RestDOut()
  return(true)

static procedure WaitKey()
  while NextKey()==0; ShowTime(); endwhile
  return


//*****************************************************************************
// TextViewFnc() --> nMemoAction
// memo user function
//
function TextViewFnc(nMode,nRow,nCol)
  local Ch
  CurInfo:TextRow:=nRow
  breakif LastKey()==nSwapTask or LastKey()==K_CTRL_RET
  if nMode==ME_INIT
    returnif initialized with 0
    initialized:=true
    SetCursor(SC_SPECIAL1)
    return ME_TOGGLESCROLL
  endif
  Ch:=LastKey()
  do case
    case Ch==nWaitForKey; while NextKey()==0; ShowTime(); endwhile
    case Upper(Chr(Ch))=="P"
      if CurInfo:CanPrint
        InKey()
        if Alert(ResTxt(093),ResTxt(123))==1; CurInfo:Print(); endif
      endif
    case Ch==K_UP;        if isTop and !CurInfo:SeeTop; needUp:=true; break; endif
    case Ch==K_DOWN;      if isBottom and !CurInfo:SeeBottom; needDown:=true; break; endif
    case Ch==K_PGUP;      if isTop and !CurInfo:SeeTop; needUp:=true; break; endif
    case Ch==K_PGDN;      if isBottom and !CurInfo:SeeBottom; needDown:=true; break; endif
    case Ch==K_CTRL_PGUP; if !CurInfo:SeeTop; needUp:=true; break; endif
    case Ch==K_CTRL_PGDN; if !CurInfo:SeeBottom; needDown:=true; break; endif
  endcase
  isTop:=(nRow==1)
  isBottom:=(nRow==CurInfo:TextMax)
  needUp:=false
  needDown:=false
  if( Ch<>K_CTRL_W and Ch<>K_ESC and Ch<>K_CTRL_RET and NextKey()==0, StuffKey(nWaitForKey), )
  return(0)

//------------------------------------------------------- eof (c)JHK ----------

