//*****************************************************************************
// C_Frame.prg
// Frame class for OBJECT v2.03
// Copyright (c) 1991, JHK, JHK-Software, Piestany
// Compile with: /N/M/W/A
//-----------------------------------------------------------------------------

#include "Box.ch"
#include "InKey.ch"
#include "Object.ch"
                                  //use for move & size frame
create class Frame from Loc       //Magic sequence: Init,  Paint,Hide... Done
  export:                         //            or: Init, Drag, Done
  var RowSize  // MaxRow()-7
  var ColSize  // MaxCol()-9
  var MaxRows  // MaxRow()-3                            //maximum available RowSize
  var MaxCols  // MaxCol()-1                            //maximum available ColSize
  var MinRows  // 1                                     //minimum available RowSize
  var MinCols  // 5                                     //minimum available ColSize
  var Screen   // ""
  var Color    // ListAsArray(m->Color:Edit)[nEnhanced]
  var Visible  // false
  method New=FrameNew         //o:New()
  method Init=FrameInit            //o:Init(R,C,Rs,Cs,Clr)
  method Paint=FramePaint          //o:Paint()
  method Hide=FrameHide            //o:Hide()
  method Move=FrameMove            //o:Move(dR,dC)
  method Size=FrameSize            //o:Size(dR,dC)
  method Drag=FrameDrag            //o:Drag(lCanSize)
  method Done=FrameDone            //o:Done()
  endclass


//*****************************************************************************
// Frame:New() --> self
// initialize new object
//
constructor FrameNew()
  ::RowSize:= MaxRow()-7
  ::ColSize:= MaxCol()-9
  ::MaxRows:= MaxRow()-3
  ::MaxCols:= MaxCol()-1
  ::MinRows:= 1
  ::MinCols:= 5
  ::Screen:= ""
  ::Color:= ListAsArray(m->Color:Edit)[nEnhanced]
  ::Visible:= false
  return(self)


//*****************************************************************************
// Frame:Init(R,C,Rs,Cs,Clr,Shadow) --> true
// initialize new frame, write it into screen.
//
method function FrameInit(R,C,Rs,Cs,Clr)
  ::super(Loc):Init(R,C)
  store value Rs into ::RowSize
  store value Cs into ::ColSize
  store value Clr into ::Color
  return(true)


//*****************************************************************************
// Frame:Paint() --> true
// paint frame.
//
method function FramePaint()
  local R,C,R2,C2,Scr
  if !::Visible
    R:=::Row
    C:=::Col
    R2:=R+::RowSize+1
    C2:=C+::ColSize+1
    ::Screen:=SaveScreen(R,C,R2,C2)
    @ R,C,R2,C2 box "" color ::Color
    ::Visible:=true
  endif
  return(true)


//*****************************************************************************
// Frame:Hide() --> true
// hide the frame.
//
method function FrameHide()
  local R,C,R2,C2
  if ::Visible
    R:=::Row
    C:=::Col
    R2:=R+::RowSize+1
    C2:=C+::ColSize+1
    RestScreen(R,C,R2,C2,::Screen)            //restore background
    ::Visible:=false
  endif
  return(true)


//*****************************************************************************
// Frame:Move(dR,dC)  --> true
// move the frame into new location (and make it visible).
//
method function FrameMove(dR,dC)
  if ::Row+dR<1; dR:=1-::Row; endif
  if ::Col+dC<0; dC:=-::Col; endif
  if ::Row+::RowSize+1+dR>=MaxRow(); dR:=MaxRow()-::Row-::RowSize-2; endif
  if ::Col+::ColSize+1+dC>MaxCol();  dC:=MaxCol()-::Col-::ColSize-1; endif
  DispBegin()
    ::Hide()
    ::Row+=dR
    ::Col+=dC
    ::Paint()
  DispEnd()
  return(true)


//*****************************************************************************
// Frame:Size(dR,dC) --> true
// resize the frame.
//
method function FrameSize(dR,dC)
  if ::RowSize+dR<::MinRows; dR:=::MinRows-::RowSize; endif
  if ::ColSize+dC<::MinCols; dC:=::MinCols-::ColSize; endif
  if ::RowSize+dR>::MaxRows; dR:=::MaxRows-::RowSize; endif
  if ::ColSize+dC>::MaxCols; dC:=::MaxCols-::ColSize; endif
  if ::Row+::RowSize+1+dR>=MaxRow(); dR:=MaxRow()-::Row-::RowSize-2; endif
  if ::Col+::ColSize+1+dC>MaxCol(); dC:=MaxCol()-::Col-::ColSize-1; endif
  DispBegin()
    ::Hide()
    ::RowSize+=dR
    ::ColSize+=dC
    ::Paint()
  DispEnd()
  return(true)


//*****************************************************************************
// Frame:Drag(lCanSize) --> lDragget
// user move&resize this frame.
//
method function FrameDrag(lCanSize,RowMin,ColMin)
  local Ch
  local lDragget:=false  //assume
  default lCanSize to true
  default RowMin to 1
  default ColMin to 5
  if !::Visible; ::Paint(); endif
  SaveDOut(ResTxt(155))
  SaveHelpIdx({13})
  repeat
    DisableHelp()
    Ch:=PauseKey(0)
    EnableHelp()
    do case
      case Ch==K_UP;     lDragget:=true; ::Move(-1,0)
      case Ch==K_DOWN;   lDragget:=true; ::Move(1,0)
      case Ch==K_LEFT;   lDragget:=true; ::Move(0,-1)
      case Ch==K_RIGHT;  lDragget:=true; ::Move(0,1)
      case Ch==Asc("8"); if lCanSize and ::RowSize>::MinRows; lDragget:=true; ::Size(-1,0); endif
      case Ch==Asc("2"); if lCanSize and ::RowSize<::MaxRows; lDragget:=true; ::Size(1,0); endif
      case Ch==Asc("4"); if lCanSize and ::ColSize>::MinCols; lDragget:=true; ::Size(0,-1); endif
      case Ch==Asc("6"); if lCanSize and ::ColSize<::MaxCols; lDragget:=true; ::Size(0,1); endif
      otherwise;         Ch:=nSwapTask
    endcase
  until Ch==nSwapTask
  RestHelpIdx()
  ::Hide()
  RestDOut()
  return(lDragget)


//*****************************************************************************
// Frame:Done()  --> true
// destroy this frame.
//
method function FrameDone()
  ::Hide()
  return(true)

//------------------------------------------------------- eof (c)JHK ----------

