//*****************************************************************************
// C_Dbf.prg
// Dbf class for OBJECT v2.03
// Copyright (c) 1991, JHK, JHK-Software, Piestany
// Please compile with: /N/M/W/A
//-----------------------------------------------------------------------------

#include "Object.ch"
#include "SetCurs.ch"

static LastDbf:={}           //last created Dbf object.
static lNeedReIndex:=false   //any user previously aborted?


create class Dbf
  export:
  var lNew         //false              //true only after creating databases (Create() from Open())
  var Data         //{}                 //array of objects OneDbf
  method New=DbfNew                 //o:New()
  method Password=DbfPassword       //o:Password()
  method Init=DbfInit               //o:Init()
  method Create=DbfCreate           //o:Create()
  method Open=DbfOpen               //o:Open()     //open dbf's, relations, crash test (obasic->N, RecNo=1)
  method ReIndex=DbfReIndex         //o:ReIndex(lContinue)
  method Pack=DbfPack               //o:Pack(lContinue)
  method Zap=DbfZap                 //o:Zap(lContinue)
  method AddDbf=DbfAddDbf           //o:AddDbf(cFile)
  method AddField=DbfAddField       //o:AddField(cName,cType,nLen,nDec)
  method AddNtx=DbfAddNtx           //o:AddNtx(cName,cFile,cKey,lUnique)
  method AddRelation=DbfAddRelation //o:AddRelation(xKey,cAlias,nOrder)
  method Picture=DbfPicture         //o:Picture(cPict)
  method Range=DbfRange             //o:Range(nLo,nHi)
  method When=DbfWhen               //o:When(bWhen)
  method Valid=DbfValid_            //o:Valid(bValid)      //standart validation
  method ChValid=DbfChValid         //o:ChValid(bValid)    //eval bValid only if Get:Changed==true
  method Save=DbfSave               //o:Save(cPath)
  method Load=DbfLoad               //o:Load(cPath)
  method Done=DbfDone               //o:Done()           //close dbf's, crash test (obasic->N, Recno=1)
  endclass


//*****************************************************************************
// Dbf:New() --> self
// initialize new object
//
constructor DbfNew()
  ::lNew:= false
  ::Data:= {}
  return(self)


//-----------------------------------------------------------------------------
// TestAllDbfReIndex() --> true
// called from Menu:Init()
// make ReIndex for all dbf files (if is required from Dbf:Open())
//
function TestAllDbfReIndex()
  if lNeedReIndex
    LastDbf:ReIndex(false)
    lNeedReIndex:=false
  endif
  return(true)


//-----------------------------------------------------------------------------
// GetLastDbf() --> object
// return last created Dbf object
//
function GetLastDbf()
  return(LastDbf)


//-----------------------------------------------------------------------------
// GetOneDbf(cName) --> object of OneDbf
// find & return OneDbf object
//
function GetOneDbf(cName)
  cName:=Upper(cName)
  return(LastDbf:Data[AScan(LastDbf:Data,{|e|e:Name==cName})])


//-----------------------------------------------------------------------------
// CopyOneDbf(cName) --> copy of OneDbf object
// find & return copy of OneDbf object
//
function CopyOneDbf(cName)
  local o1:=GetOneDbf(cName)
  local object o2 of OneDbf
  o2:File      :=o1:File
  o2:Name      :=o1:Name
  o2:Struc     :=AClone(o1:Struc)
  o2:Pict      :=AClone(o1:Pict)
  o2:PreBlock  :=AClone(o1:PreBlock)
  o2:PostBlock :=AClone(o1:PostBlock)
  o2:Ntx       :=AClone(o1:Ntx)
  o2:Rel       :=AClone(o1:Rel)
  return(o2)


//*****************************************************************************
// Dbf:Init() --> true
// save new dbf object
//
method function DbfInit()
  LastDbf:=self
  DOut(ResTxt(167))
  return(true)


//*****************************************************************************
// Dbf:Create() --> true
// create all need dbf files.
//
method function DbfCreate()
  CreateBasic()
  Create1Basic()
  CreateHelp()
  AEval(::Data,{|e|e:Create(false)})
  return(true)


//-----------------------------------------------------------------------------
static function CreateBasic()
  field Field_Name,Field_Type,Field_Len,Field_Dec
  SaveDOut(ResTxt(157)+cBasic+".dbf ...")
  select 0
  NetCreateFrom(cTempFile,,false)
  append blank; Field_Name:="U"; Field_Type:="C"; Field_Len:=nLenPsw; Field_Dec:=0  //user name
  append blank; Field_Name:="P"; Field_Type:="C"; Field_Len:=nLenPsw; Field_Dec:=0  //our password
  append blank; Field_Name:="S"; Field_Type:="C"; Field_Len:=250;     Field_Dec:=0  //our privilegy string (for menu) (1..250)
  append blank; Field_Name:="L"; Field_Type:="N"; Field_Len:=3;       Field_Dec:=0  //our privilegy level for programmer (1..999)
  net close
  NetCreateFrom(cBasic,cTempFile,false)
  NetFErase(cTempFile+".dbf",false)
  append blank
  field->U:=Convert("supervisor",nLenPsw)
  field->P:=Convert("",nLenPsw)
  field->L:=999
  field->S:=Replicate("x",250)             //dummy_data: supervisor can do all!
  append blank
  field->U:=Convert(ResTxt(100),nLenPsw)
  field->P:=Convert("",nLenPsw)            //no password assumed
  field->S:=Replicate("",250)             //default: guest can do all!!!
  field->L:=0
  net close
  net use (cBasic) new
  RestDOut()
  return(true)


//-----------------------------------------------------------------------------
static function Create1Basic()
  field Field_Name,Field_Type,Field_Len,Field_Dec
  SaveDOut(ResTxt(157)+cIFR+".dbf ...")          //indexes,filters,reports
  select 0
  NetCreateFrom(cTempFile,,false)
  append blank; Field_Name:="ViewID"; Field_Type:="N"; Field_Len:=3;  Field_Dec:=0  //determine menu item for current filter/report
  append blank; Field_Name:="Code";   Field_Type:="C"; Field_Len:=1;  Field_Dec:=0  //current filter/report line in item
  append blank; Field_Name:="Data";   Field_Type:="M"; Field_Len:=10; Field_Dec:=0  //operand1
  net close
  NetCreateFrom(cIFR,cTempFile,false)
  NetFErase(cTempFile+".dbf",false)
  append blank
  field->ViewID:=0   //currently working users
  field->Code:="T"   //T=multi user crash Test, I=index, F=filter, R=report
  net close
  net use (cIFR) new
  RestDOut()
  return(true)


//-----------------------------------------------------------------------------
static function CreateHelp()
  local i
  field Field_Name,Field_Type,Field_Len,Field_Dec
  SaveDOut(ResTxt(157)+cHelp+".dbf ...")          //help
  select 0
  NetCreateFrom(cTempFile,,false)
  append blank; Field_Name:="Text";    Field_Type:="M"; Field_Len:=10; Field_Dec:=0  //help text
  append blank; Field_Name:="RowSize"; Field_Type:="N"; Field_Len:=3;  Field_Dec:=0  //window row_size
  append blank; Field_Name:="ColSize"; Field_Type:="N"; Field_Len:=3;  Field_Dec:=0  //window col_size
  net close
  NetCreateFrom(cHelp,cTempFile,false)
  NetFErase(cTempFile+".dbf",false)
  net close
  net use (cHelp) new
  RestDOut()
  return(true)


//-----------------------------------------------------------------------------
function Convert(cOldPsw,LenField,lScramble)
  local cNewPsw, nLen, i
  default LenField to Len(cOldPsw)
  default lScramble to true
  cNewPsw:=""
  cOldPsw:=PadR(cOldPsw,LenField)
  nLen:=Len(cOldPsw)
  for i:=1 to nLen
    cNewPsw+=Chr(Asc(cOldPsw)+if(lScramble,+i,-i))  //must be less than 255 !!!
    cOldPsw:=SubStr(cOldPsw,2)
  endfor
  return(cNewPsw)


//*****************************************************************************
// Dbf:Password() --> true
// read password and check what is ok.
//
method function DbfPassword()
  local UserID,Paswd,Security
  local OldSel:=Select()
  DOut("")
  UserID:=Paswd:=Replicate(" ",nLenPsw)
  if ::lNew
    Alert(ResTxt(103),,MaxRow()-7)
    UserNo(1)
    UserLevel(999)
    UserID("supervisor")
  else
    UserID:=Convert(EditItPrim(UserID,ResTxt(016),,MaxRow()-5),nLenPsw)
    select (cBasic)
    locate for field->U==UserID
    if !Found(); go 2; endif  //guest!
    Security:=field->S
    if RecNo()==1; Security:=Replicate("",Len(Security)); endif  //supervisor can do ALL!
    if At("",Security)==0  //this user are all disabled
      GoodBye()
      LogOff()
      quit
    endif
    if RecNo()<>2 and !Empty(Convert(field->P,nLenPsw,false))
      Paswd:=Convert(EditItPrim(Paswd,ResTxt(017),,MaxRow()-5,,,,true),nLenPsw)
      if !(field->P==Paswd)
        GoodBye() //password failed
        LogOff()
        quit
      endif
    endif
    if RecNo()==2 and Security==Replicate("",Len(Security))
      go 1 //noninitialized password system
    endif
    UserNo(RecNo())
    UserLevel(field->L)
    UserID(Convert(field->U,nLenPsw,false))
  endif
  select (cIFR)
  go top            //field->ViewID == currently worked users in network.
  select (OldSel)
  if !Empty(DateLimit()) and Date()>CtoD(DateLimit())  //out of date...
    GoodBye()
    LogOff()
    quit
  endif
  return(true)


//*****************************************************************************
// Dbf:Open() --> true
// open need dbf (ntx) files, if not exist, then create it
//
method function DbfOpen()
  DOut(ResTxt(156))
  if File(cBasic+".dbf")
    begin break
      use (cIFR) exclusive new
      if LogSet()==999
        Alert(ResTxt(186))
        ObjectDone(false)
      endif
      lNeedReIndex:=field->ViewID<>0
      field->ViewID:=0
      net close
    recover break
      lNeedReIndex:=false
      net close
    end break
    DOut(ResTxt(158)+cBasic+".dbf ..."); net use (cBasic) new
    DOut(ResTxt(158)+cIFR+".dbf ...");   net use (cIFR) new
    DOut(ResTxt(158)+cHelp+".dbf ...");  net use (cHelp) new
    AEval(::Data,{|e|e:Open(,false)})
    if LogSet()==999
      Alert(ResTxt(186))
      ObjectDone(false)
    endif
    if NetLimit()<=LogSet()
      Alert(ResTxt(073))
      ObjectDone(false)
    endif
  else
    ::lNew:=true
    CreateBasic()
    if !File(cIFR+".dbf"); Create1Basic(); else; net use (cIFR) new; endif
    if !File(cHelp+".dbf"); CreateHelp(); else; net use (cHelp) new; endif
    AEval(::Data,{|e|if(File(e:File),e:Open(false),e:Create(false))})
  endif
  DOut(ResTxt(171))
  AEval(::Data,{|e|e:SetRelation()})
  LogOn()
  ::Password()
  DOut(ResTxt(168))
  return(true)


//*****************************************************************************
// Dbf:ReIndex(lContinue) --> true
// reindex all dbf files.
//
method function DbfReIndex(lContinue)
  default lContinue to true
  return(Make(self,{|e,l|e:ReIndex(l)},lContinue))


//*****************************************************************************
// Dbf:Pack(lContinue) --> nil
// pack all dbf files.
//
method function DbfPack(lContinue)
  default lContinue to false
  return(Make(self,{|e,l|e:Pack(l)},lContinue))


//*****************************************************************************
// Dbf:Zap(lContinue) --> nil
// zap all dbf files.
//
method function DbfZap(lContinue,lSelect)
  default lContinue to false
  return(Make(self,{|e,l|e:Zap(l)},lContinue))


//-----------------------------------------------------------------------------
// Dbf::Make(bBlock,lContinue) --> true/false
// common function for ReIndex,Pack and Zap.
//
static function Make(Dbf,bBlock,lContinue)
  local lOk:=true
  if LogSet()<>1
    Alert(ResTxt(072)+";"+ResTxt(071))
    return(false)
  endif
  if !Empty(GetTList()); Alert(ResTxt(117)); return(false); endif
  SaveDOut("")
  AEval(Dbf:Data,{|e|if(lOk,lOk:=Eval(bBlock,e,lContinue),)})
  RestDOut()
  return(lOk)


//*****************************************************************************
// Dbf:AddDbf(cFile,cAlias) --> nil
// add new database into object Dbf
//
method function DbfAddDbf(cFile,cAlias)
  AAdd(::Data, (object of OneDbf) )
  cFile:=AllTrim(Upper(cFile))
  if At(".DBF",cFile)==0; cFile+=".DBF"; endif
  default cAlias:=GetAlias(cFile)
  ::Data[Len(::Data)]:File:=cFile
  ::Data[Len(::Data)]:Name:=cAlias
  return(true)


//*****************************************************************************
// Dbf:AddField(cName,cType,nLen,nDec) --> true
// add new field information into object Dbf
//
method function DbfAddField(cName,cType,nLen,nDec)
  ::Data[Len(::Data)]:AddField(cName,cType,nLen,nDec)   //OneDbf
  return(true)


//*****************************************************************************
// Dbf:AddNtx(cName,cFile,cKey,lUnique) --> true
// add new index file into object Dbf
//
method function DbfAddNtx(cName,cFile,cKey,lUnique)
  ::Data[Len(::Data)]:AddNtx(cName,cFile,cKey,lUnique)   //OneDbf
  return(true)


//*****************************************************************************
// Dbf:AddRelation(xKey,cAlias,nOrder) --> true
// add new relation into object Dbf
//
method function DbfAddRelation(xKey,cAlias,nOrder)
  ::Data[Len(::Data)]:AddRelation(xKey,cAlias,nOrder)   //OneDbf
  return(true)


//*****************************************************************************
// Dbf:Picture(cPict) --> true
// save the picture code of last field into Dbf object.
//
method function DbfPicture(cPict)
  ::Data[Len(::Data)]:Picture(cPict)   //OneDbf
  return(true)


//*****************************************************************************
// Dbf:Range(nLo,nHi) --> true
// save the range information of last field into Dbf object.
//
method function DbfRange(nLo,nHi)
  ::Data[Len(::Data)]:Range(nLo,nHi)   //OneDbf
  return(true)


//*****************************************************************************
// Dbf:When(bWhen) --> true
// save the when code block for last field into Dbf object.
//
method function DbfWhen(bWhen)
  ::Data[Len(::Data)]:When(bWhen)   //OneDbf
  return(true)


//*****************************************************************************
// Dbf:Valid(bValid) --> true
// save the valid code block for last field into Dbf object.
// standart validation
//
method function DbfValid_(bValid)
  ::Data[Len(::Data)]:Valid(bValid)   //OneDbf
  return(true)


//*****************************************************************************
// Dbf:ChValid(bValid) --> true
// save the valid code block for last field into Dbf object.
// eval bValid only if Get:Changed==true
//
method function DbfChValid(bValid)
  ::Data[Len(::Data)]:ChValid(bValid)   //OneDbf
  return(true)


//*****************************************************************************
// Dbf:Save(cPath) --> true
// save all database files in current directory on disk cTarget.
//
method function DbfSave(cPath)
  local UpW,OldC
  Memory(-1)  //undocumented: Garbage collection
  if Memory(2)<nMinMemory; Alert(ResTxt(98)); return(false); endif
  SaveDOut("")
  object UpW of UpWindow; UpW:Init(ResTxt(029)+cPath)
  UpW:Top(false)
  commit
  OldC:=SetCursor(SC_INSERT)
  GoodRun("archiv /w"+NTrim(Color2Num(UpW:Color))+" /s *.dbf *.dbt *.ntx "+cPath)
  SetCursor(OldC)
  clear keyboard
  UpW:Done()
  RestDOut()
  return(true)


//*****************************************************************************
// Dbf:Load(cPath) --> true/false
// load all files in current directory from disk cTarget.
//
method function DbfLoad(cPath)
  local UpW,OldC,nUsers
  if LogSet()<>1; Alert(ResTxt(072)+";"+ResTxt(071)); return(false); endif
  if !Empty(GetTList()); Alert(ResTxt(117)); return(false); endif
  Memory(-1)  //undocumented: Garbage collection
  if Memory(2)<nMinMemory; Alert(ResTxt(098)); return(false); endif
  if Alert(ResTxt(030)+cPath+" ?",ResTxt(123))<>1; return(false); endif
  nUsers:=LogSet(999)   //disable running another user
  SaveDOut("")
  object UpW of UpWindow; UpW:Init(ResTxt(031)+cPath)
  UpW:Top(false)
  close databases
  OldC:=SetCursor(SC_INSERT)
  GoodRun("archiv /w"+NTrim(Color2Num(UpW:Color))+" /l "+cPath)
  SetCursor(OldC)
  clear keyboard
  net use (cIFR) new
  LogSet(nUsers)          //enable other users
  //
  //Quit!
  Alert(ResTxt(070))
  ObjectDone(false)
  return(false) //dummy return
  //
  //Origin program continued, this option is not correct,
  //because i don't know how to do reinitializing the program without
  //changes in Main() function of the program.
  //
  //UpW:Done()
  //RestDOut()
  //::Open()
  //::ReIndex()
  //LogClear()
  //return(true)
  //


//*****************************************************************************
// Dbf:Done() --> true
// destroy the Dbf object, work around crash test (obasic->N, RecNo=1)
//
method function DbfDone()
  LogOff()
  net close all
  return(true)

//------------------------------------------------------- eof (c)JHK ----------

