//*****************************************************************************
// OBJECT2.PRG
// Language depend functions & help system for OBJECT v2.03
// Copyright (c) 1991, JHK, JHK-Software, Piestany
// Please compile with: /N/M/W/A
//-----------------------------------------------------------------------------
// for language convert You can modify two functions: ResTxt(n) & HelpKeys().
// 

#include "InKey.ch"
#include "Object.ch"

static aHelpKeys:={}     //need for help system: {{indexes into aHelpTxt},...}
static Association:={}   //{{"ALIAS->FIELD","VarName",Help_RecNo()},...}

//*****************************************************************************
// ResTxt(n) --> info_string
// used instead many #define commands, because clipper has limited room
// for internal table od #define.
//
function ResTxt(n)
  do case
  #ifdef ENGLISH //------------------------------------------------------
    //
    case n==001; return "JHK, JHK-Software, Piestany"
    case n==002; return "     Welcome in program "    //top line
    case n==003; return "     "
    case n==004; return "version "               //function About(...)
    case n==005; return "Authorized user is "
    case n==006; return "All rights reserved"
    case n==007; return "end"                    //end word for help
    case n==008; return "Syntax is: "            //ParseInputParameters(...)
    case n==009; return "  /0-black and white monitor"
    case n==010; return "  /1-monochrome monitor (laptop)"
    case n==011; return "  /2-monochrome monitor (VGA)"
    case n==012; return "  /3-color monitor"
    case n==013; return "  /RECOVER ... clear busy flag, and make reindex."
    case n==014; return "Enter today date (MM/DD/YY) "   //ReadIt
    case n==015; return "Enter time (HH:MM:SS) "         //ReadIt
    case n==016; return "Enter UserID:"
    case n==017; return "Enter pasword:"
    case n==018; return "Enter new pasword:"
    case n==019; return "Replay new pasword (for confirmation):"
    case n==020; return "Locked columns:"
    case n==021; return "Memo"        //Window titles
    case n==022; return "Task list"
    case n==023; return "User ID"
    case n==024; return "Password"
    case n==025; return "Menu"
    case n==026; return "Users settings"
    case n==027; return "Change pasword"
    case n==028; return "Help: Active keys"
    case n==029; return "Backup: Save databases into "
    case n==030; return "Warning!;;To erase databases and load it from "
    case n==031; return "Restore: Load databases from "
    case n==032; return "View text file"
    case n==033; return "Select file:"
    case n==034; return "Select line:"
    case n==035; return "~View"        //View menu items
    case n==036; return "~Edit"        //(+window titles)
    case n==037; return "~Go to"
    case n==038; return "set~Index"
    case n==039; return "set~Filter"
    case n==040; return "set~Report"
    case n==041; return "~Modify"
    case n==042; return "~Index"
    case n==043; return "~Filter"
    case n==044; return "~Report"
    case n==045; return "~0.Unsorted"
    case n==046; return "~0.Filter Off"
    case n==047; return "Top lines of report"
    case n==048; return "Fields for report"
    case n==049; return "Bottom lines of report"
    case n==050; return "Record number"
    case n==051; return "RecNo"        //report show msg info
    case n==052; return "CurRec"
    case n==053; return "Index"
    case n==054; return "Filter"
    case n==055; return "Report"
    case n==056; return "Item name"    //set/modify index filter texts
    case n==057; return "Help for"
    case n==058; return "Bad"
    case n==059; return "New"
    case n==060; return "New"
    case n==061; return "Index key"
    case n==062; return "Filter expression"
    case n==063; return "Unique"
    case n==064; return "Type of index expression:"
    case n==065; return "Type of filter expression:"
    case n==066; return "Example:"
    case n==067; return "Master (selected) database:"
    case n==068; return "Available fields:"
    case n==069; return "Available functions are:"
    case n==070; return "Now this program must be reinitialized.;Program will be terminated,;after return into operating system, start it again, please."
    case n==071; return "Cannot continue."
    case n==072; return "More then one user handle program."
    case n==073; return "Too many users handle program."
    case n==074; return "Cannot save data on disk."
    case n==075; return "The new "
    case n==076; return "won't be able to be saved on disk.;You can work with it, until you will terminate the program.;Do you want to continue?"
    case n==077; return "Can't sum non-numerical field"
    case n==078; return "Local menu not defined"
    case n==079; return "Can't edit virtual record"
    case n==080; return "Reports not defined"              //report
    case n==081; return "Creating report..."               //inside window
    case n==082; return "Select fields for report"         //inside window
    case n==083; return "Fields"
    case n==084; return "Total"
    case n==085; return "SubTotal"
    case n==086; return "begin of report"                  //text in report file
    case n==087; return "end of report"                    //text ...
    case n==088; return "Terminate report:;Are you sure?"  //alert
    case n==089; return "Error in report!"
    case n==090; return "Cannot create report file,; report process aborting..."
    case n==091; return "Report file is"
    case n==092; return "Do you want do?"
    case n==093; return "Print this report?"
    case n==094; return "Cannot open report file,; report process aborting..."
    case n==095; return "No field(s) defined!"
    case n==096; return "Syntax error!"    //Alert
    case n==097; return "Quit program?"
    case n==098; return "Memory full!"
    case n==099; return "Out of range!"
    case n==100; return "guest"
    case n==101; return "Main supervisor menu"
    case n==102; return "Supervisor can do all!"
    case n==103; return "Welcome in program, supervisor!;Databases created, do not forget setup passwords!"
    case n==104; return "Append new row?"
    case n==105; return "Delete current row?"
    case n==106; return "Abort program!;Are you absolute sure?"
    case n==107; return "Can`t erase file"
    case n==108; return "Can't create index file"
    case n==109; return "Can't open index files"
    case n==110; return "Can't modify database"
    case n==111; return "Can't modify this record"
    case n==112; return "Can't create database"
    case n==113; return "Can't open database in shared mode"
    case n==114; return "Can't appen new record into database"
    case n==115; return "Can't recall current record in database"
    case n==116; return "Can't delete current record from database"
    case n==117; return "Any task(s) is(are) active, close it, please"
    case n==118; return "New password saved."
    case n==119; return "Bad password!; I cannot save it!"
    case n==120; return "Cannot save entered password,;old pasword is active!"
    case n==121; return "Task swapper:;Can't activate requested window!"
    case n==122; return {"Go back"}    //Alert answers
    case n==123; return {"Yes","No"}
    case n==124; return {"Forget item","Go back"}
    case n==125; return {"Retry","Continue"}
    case n==126; return {"Retry","Abort program"}
    case n==127; return {"Retry","Continue","Abort program"}
    case n==128; return {"Change supervisor password","Setting all"}
    case n==129; return {"~Restore          ","~Minimize       F5","ma~Ximize    Sh-F5","~Next window    F6","~Previous w..Sh-F6","~Tile           F7","~Cascade     Sh-F7","move-~Size      F8","cl~Ose         Esc","s~Witch to.. Alt-0"}
    case n==130; return {"Retry","Close","Task list","Main menu"}
    case n==131; return {"Minimize","Close","Task list","Main menu"}
    case n==132; return {"Delete file & Exit","Only exit","Go back"}
    case n==133; return "go"    //get_set_blocks in Browse
    case n==134; return "memo"
    case n==135; return "Tab=mode"      //dialog lines
    case n==136; return "P=Print"
    case n==137; return "Enter=ok"
    case n==138; return "Esc=exit,"+chr(26)+"=move,Enter=select"
    case n==139; return "Moving column(row): "+chr(26)+"=move,Other=done"
    case n==140; return "F1=help,=move,Esc=exit,Enter=select,Home=top,End=bottom"
    case n==141; return "F1=help,"+chr(26)+"=move,Esc=exit,Enter=select,Home=top,End=bottom"
    case n==142; return "F1=help,"+chr(26)+"=move,Enter=select,Home=top,End=bottom"
    case n==143; return "Ins/Del=row"
    case n==144; return "Esc=exit,Enter=done,BackSpace=delete_previous_key"
    case n==145; return "F1=help,@#F10=menu"
    case n==146; return ""+chr(26)+"=move,Esc/^Enter=exit"
    case n==147; return "F1=help,"+chr(26)+"/PgUp/PgDn/^PgUp/^PgDn=move"
    case n==148; return "F1=help,"+chr(26)+"/PgUp/PgDn=move,Esc/^Enter=exit"
    case n==149; return "F1=help,@#F10=menu"
    case n==150; return "F1=help,Esc=exit,^Enter=ok"
    case n==151; return "F1=help,Ins/Del=row,@#F10=menu"
    case n==152; return "F1=help,Esc=exit(no change),Enter=ok,"+chr(26)+"=move"
    case n==153; return "F1=help,Esc=done,Enter=done,"+chr(26)+"=move"
    case n==154; return "F1=help,Esc/^Enter=done,=move,Enter=enable_disable_item"
    case n==155; return "F1=help,"+chr(26)+"=move,NumLock"+chr(26)+"=resize,Other=done"
    case n==156; return "Testing system files..."  //dialog lines (operator waits)
    case n==157; return "Creating file "
    case n==158; return "Finding file "
    case n==159; return "Opening file "
    case n==160; return "Packing file "
    case n==161; return "Zapping file "
    case n==162; return "Reading fields..."
    case n==163; return "Reading file..."
    case n==164; return "Reading directory..."
    case n==165; return "Reading paswords..."
    case n==166; return "Reading menu structure..."
    case n==167; return "Reading database(s) structure..."
    case n==168; return "Building view(s) structure..."
    case n==169; return "Building menu structure..."
    case n==170; return "Setting filter..."
    case n==171; return "Setting relation(s)..."
    case n==172; return "Drawing window(s)..."
    case n==173; return "Saving paswords..."
    case n==174; return "Task switching..."
    case n==175; return "Please wait..."
    case n==176; return "Searching for record..."
    case n==177; return "To find"
    case n==178; return "Record not found"
    case n==179; return "~Locate for"
    case n==180; return "Level"
    case n==181; return "Property of filtered items"
    case n==182; return "Colored"   //colored and hidden must have
    case n==183; return "Hidden "   //the same length
    case n==184; return "Guest needn't a password"
    case n==185; return "Shift-F1 ..... help (if is defined) for currently edited field or menu item"
    case n==186; return "Another user is loading the databases,;try to run the program later."
    case n==187; return "Help"
    case n==188; return "A help wasn't defined."
    case n==189; return "A help is defined only for editable or menu item."
    case n==190; return "Creating a help database..."
    case n==191; return "Availability of menu items"
    case n==192; return "A filter is active in this window,;first turn it off,;then can be added a record into database."
    case n==193; return "Show only subtotal and total lines"
    case n==194; return "Col.title"
    case n==195; return "Print begin from page?"
    case n==196; return ""
    case n==197; return "Please wait, printing... (press Esc for abort) ..."
    case n==198; return "Cannot open file for printing, DOS ERROR=="
    case n==199; return "Sorry, this report don't have "
    case n==200; return " or more pages."
    case n==201; return "Cannot read file for printing, DOS ERROR=="
    case n==202; return "Abort printing, are you sure?"
    case n==203; return "Page no."
    case n==204; return "Print error! (please set up your printer)"
    case n==205; return {"Retry","Abort print"}
    //
  #else  // #define SLOVAK ---------------------------------------------------
    //
    case n==001; return "JHK, JHK-Software, Piestany"
    case n==002; return "     Vitajte v programe "    //top line
    case n==003; return "     "
    case n==004; return "verzia "                   //function About(...)
    case n==005; return "Opravneny uzivatel je "
    case n==006; return "Vsetky prava vyhradene"
    case n==007; return "koniec"                    //end word for help
    case n==008; return "Syntax je: "               //ParseInputParamaeters(...)
    case n==009; return "  /0-cierno/biely monitor"
    case n==010; return "  /1-monochromaticky monitor (laptop)"
    case n==011; return "  /2-monochromaticky monitor (VGA)"
    case n==012; return "  /3-farebny monitor"
    case n==013; return "  /RECOVER ... zmaze indikaciu nahravania databaz, a urobi reindex"
    case n==014; return "Zadajte dnesny datum (DD.MM.RR) "   //ReadIt
    case n==015; return "Zadajte presny cas (HH:MM:SS) "     //ReadIt
    case n==016; return "Zadajte uzivatelsku znacku:"
    case n==017; return "Zadajte heslo:"
    case n==018; return "Zadajte nove heslo:"
    case n==019; return "Zopakujte zadanie hesla (pre overenie spravnosti):"
    case n==020; return "Pocet zamknutych stlpcov:"
    case n==021; return "Text"        //Window titles
    case n==022; return "Zoznam okien"
    case n==023; return "Uz.znacka"
    case n==024; return "Heslo"
    case n==025; return "Menu"
    case n==026; return "Vsetky hesla"
    case n==027; return "Zmena hesla"
    case n==028; return "Napoveda: Pouzitelne klavesy"
    case n==029; return "Zaloha: Ulozenie databaz do "
    case n==030; return "Pozor!;;Zmazat databazy a nacitat ich z "
    case n==031; return "Obnovenie: Nacitanie databaz z "
    case n==032; return "Prezeranie suboru"
    case n==033; return "Vyberte subor:"
    case n==034; return "Vyberte riadok:"
    case n==035; return "~Prezeranie"        //View menu items
    case n==036; return "~Opravy"            //(+window titles)
    case n==037; return "~Vyber zaznam"
    case n==038; return "zap~Index"          //set~Index
    case n==039; return "zap~Filter"         //...
    case n==040; return "rob~Tlac"           //...
    case n==041; return "~Modifikuj"
    case n==042; return "~Index"
    case n==043; return "~Filter"
    case n==044; return "~Tlac"
    case n==045; return "~0.Vypnuty"
    case n==046; return "~0.Vypnuty"
    case n==047; return "Zahlavie hore"
    case n==048; return "Polia pre tlac"
    case n==049; return "Zahlavie dolu"
    case n==050; return "Cislo zaznamu"
    case n==051; return "Por.c"        //report show msg info
    case n==052; return "Zaznam c"
    case n==053; return "Index"
    case n==054; return "Filter"
    case n==055; return "tvar tlacovej zostavy"
    case n==056; return "Nazov polozky"    //set/modify index filter texts
    case n==057; return "Pomoc pre"
    case n==058; return "Zly"
    case n==059; return "Novy"
    case n==060; return "Nova"
    case n==061; return "Indexovy kluc"
    case n==062; return "Vyraz pre filter"
    case n==063; return "Jedinecny"
    case n==064; return "Typ vyrazu pre indexny kluc:"
    case n==065; return "Typ vyrazu pre filter:"
    case n==066; return "Priklad:"
    case n==067; return "Hlavna (vybrata) databaza:"
    case n==068; return "Dostupne polia:"
    case n==069; return "Dostupne funkcie su:"
    case n==070; return "Teraz je nutne reinicializovat program.;Program bude ukonceny,;po navrate do systemu ho prosim spustite znovu."
    case n==071; return "Nemozem pokracovat."
    case n==072; return "S programom pracuje viac ako jeden uzivatel."
    case n==073; return "Prilis mnoho uzivatelov pracuje s programom."
    case n==074; return "Nemozem ulozit udaje na disk."
    case n==075; return "Nebudem moct ulozit novy"
    case n==076; return "na disk.;Az do ukoncenia programu s nim budete moct normalne pracovat.;Chcete pokracovat v zadani?"
    case n==077; return "Nemozem suctovat nenumericke pole"
    case n==078; return "Lokalne menu nebolo definovane"
    case n==079; return "Nemozem editovat virtualny zaznam"
    case n==080; return "Ziadna zostava pre tlac nie je definovana"   //report
    case n==081; return "Vytvaram zostavu..."            //inside window
    case n==082; return "Vyber poli pre tlac"            //inside window
    case n==083; return "Polia"
    case n==084; return "Sucet"
    case n==085; return "Medzi_sucet"
    case n==086; return "zaciatok zostavy"                 //text in report file
    case n==087; return "koniec zostavy"                   //text ...
    case n==088; return "Prerusenie tlace:;Naozaj?"        //alert
    case n==089; return "Chyba pocas tlace!"
    case n==090; return "Nemozem vytvorit subor,;proces tlace je preruseny..."
    case n==091; return "Subor obsahujuci zostavu je"
    case n==092; return "Co mam urobit teraz?"
    case n==093; return "Vytlacit tuto zostavu?"
    case n==094; return "Nemozem otvorit subor z tlacovou zostavou,;proces tlace je preruseny..."
    case n==095; return "Ziadne polia nie su definovane!"
    case n==096; return "Syntakticka chyba!"    //Alert
    case n==097; return "Ukoncit program?"
    case n==098; return "Nedostatok pamati!"
    case n==099; return "Mimo rozsah!"
    case n==100; return "host"
    case n==101; return "Hlavne menu supervisora"
    case n==102; return "Supervisor moze robit vsetko!"
    case n==103; return "Vitajte v programe, supervisor!;Databazy su vytvorene, nezabudnite nastavit hesla!"
    case n==104; return "Pridat novy riadok?"
    case n==105; return "Zmazat aktualny riadok?"
    case n==106; return "Prerusenie programu!;Naozaj chcete prerusit program?"
    case n==107; return "Nemozem zmazat subor"
    case n==108; return "Nemozem vytvorit indexny subor"
    case n==109; return "Nemozem otvorit indexny subor"
    case n==110; return "Nemozem modifikovat databazu"
    case n==111; return "Nemozem modifikovat tento zaznam"
    case n==112; return "Nemozem vytvorit databazu"
    case n==113; return "Nemozem otvorit databazu v zdielanom rezime"
    case n==114; return "Nemozem pridat novy zaznam do databazy"
    case n==115; return "Nemozem obnovit (recall) zaznam v databaze"
    case n==116; return "Nemozem zmazat aktualny zaznam v databaze"
    case n==117; return "Nejake okno(a) je(su) aktivne, ukoncite ich prosim"
    case n==118; return "Nove heslo je ulozene."
    case n==119; return "Zle heslo!;Nemozem ho ulozit!"
    case n==120; return "Nemozem ulozit vlozene heslo,;stare heslo zostava aktivne!"
    case n==121; return "Kontroler okien:;Nemozem aktivovat pozadovane okno!"
    case n==122; return {"Chod naspat"}    //Alert answers
    case n==123; return {"Ano","Nie"}
    case n==124; return {"Zabudnut polozku","Chod naspat"}
    case n==125; return {"Znovu","Pokracovat dalej"}
    case n==126; return {"Znovu","Prerusit program"}
    case n==127; return {"Znovu","Pokracovat dalej","Prerusit program"}
    case n==128; return {"Zmena hesla supervisora","Vsetky hesla"}
    case n==129; return {"~Obnov            ","mi~Nimalizuj    F5","ma~Ximalizuj Sh-F5","~Dalsie okno    F6","~Predch.okno Sh-F6","d~Lazdice       F7","~Kaskada     Sh-F7","~Velkost        F8","~Zrus okno     Esc","~Chod na...  Alt-0"}
    case n==130; return {"Znovu","Zatvorit okno","Zoznam okien","Hlavne menu"}
    case n==131; return {"Minimalizovat","Zatvorit okno","Zoznam okien","Hlavne menu"}
    case n==132; return {"Zmazat subor a ukoncit","Iba ukoncit","Chod naspat"}
    case n==133; return "rob"    //get_set_blocks in Browse
    case n==134; return "text"
    case n==135; return "Tab=rezim"      //dialog lines
    case n==136; return "P=Tlac"
    case n==137; return "Enter=ok"
    case n==138; return "Esc=koniec,"+chr(26)+"=posun,Enter=vyber"
    case n==139; return "Posun stlpca(riadku): "+chr(26)+"=posun,Ine=koniec"
    case n==140; return "F1=pomoc,=posun,Esc=koniec,Enter=vyber,Home=hore,End=dolu"
    case n==141; return "F1=pomoc,"+chr(26)+"=posun,Esc=koniec,Enter=vyber,Home=hore,End=dolu"
    case n==142; return "F1=pomoc,"+chr(26)+"=posun,Enter=vyber,Home=hore,End=dolu"
    case n==143; return "Ins/Del=riadok"
    case n==144; return "Esc=koniec,Enter=koniec,BackSpace=zmaz_znak_nalavo"
    case n==145; return "F1=pomoc,@#F10=menu"
    case n==146; return ""+chr(26)+"=posun,Esc/^Enter=koniec"
    case n==147; return "F1=pomoc,"+chr(26)+"/PgUp/PgDn/^PgUp/^PgDn=posun"
    case n==148; return "F1=pomoc,"+chr(26)+"/PgUp/PgDn=posun,Esc/^Enter=koniec"
    case n==149; return "F1=pomoc,@#F10=menu"
    case n==150; return "F1=pomoc,Esc=prerus,^Enter=ok"
    case n==151; return "F1=pomoc,Ins/Del=riadok,@#F10=menu"
    case n==152; return "F1=pomoc,Esc=prerus(bez zmeny),Enter=ok,"+chr(26)+"=posun"
    case n==153; return "F1=pomoc,Esc/Enter=koniec,"+chr(26)+"=posun"
    case n==154; return "F1=pomoc,Esc/^Enter=koniec,=posun,Enter=povol/zakaz"
    case n==155; return "F1=pomoc,"+chr(26)+"=posun,NumLock"+chr(26)+"=velkost,Ine=koniec"
    case n==156; return "Testujem systemove subory..." //dialog lines (operator waits)
    case n==157; return "Vytvaram subor "
    case n==158; return "Hladam subor "
    case n==159; return "Otvaram subor "
    case n==160; return "Pakujem subor "
    case n==161; return "Vyprazdnujem subor "
    case n==162; return "Citam polia..."
    case n==163; return "Citam subor..."
    case n==164; return "Citam adresar..."
    case n==165; return "Citam heslo..."
    case n==166; return "Citam strukturu menu..."
    case n==167; return "Citam struktury databaz..."
    case n==168; return "Generujem struktury zobrazeni..."
    case n==169; return "Generujem strukturu menu..."
    case n==170; return "Nastavujem filter..."
    case n==171; return "Nastavujem relacie..."
    case n==172; return "Generujem okna..."
    case n==173; return "Ukladam hesla..."
    case n==174; return "Prepinam okna..."
    case n==175; return "Prosim cakajte..."
    case n==176; return "Hladam zaznam..."
    case n==177; return "Hladat"
    case n==178; return "Hladany zaznam nebol najdeny"
    case n==179; return "~Najdi zaznam"
    case n==180; return "Uroven"
    case n==181; return "Vlastnost odfiltrovanych udajov"
    case n==182; return "Vyfarbit"   //colored and hidden must have
    case n==183; return "Uschovat"   //the same length
    case n==184; return "Host nepotrebuje heslo"
    case n==185; return "Shift-F1 ..... napoveda (ak bola definovana) k editovanemu udaju alebo k polozke menu"
    case n==186; return "Niekto iny obnovuje databazy,;skuste spustit program neskor."
    case n==187; return "Napoveda"
    case n==188; return "Napoveda nebola definovana."
    case n==189; return "Napoveda je definovana iba pre editovatelnu polozku,;alebo pre polozku menu."
    case n==190; return "Generujem databazu napovedy..."
    case n==191; return "Pristupnost poloziek menu"
    case n==192; return "V tomto okne je aktivny filter,;najskor ho vypnite;potom je mozne pridat dalsi zaznam."
    case n==193; return "Iba riadky s medzisuctami a suctami"
    case n==194; return "Nadpis stl."
    case n==195; return "Tlac od stranky?"
    case n==196; return ""
    case n==197; return "Prosim cakajte, tlacim zostavu... (Esc==prerusenie_tlace) ..."
    case n==198; return "Nemozem otvorit subor pre tlac, DOS ERROR=="
    case n==199; return "Sorry, zostava nema "
    case n==200; return " alebo viac stranok."
    case n==201; return "Nemozem citat subor pre tlac, DOS ERROR=="
    case n==202; return "Naozaj chcete prerusit tlac?"
    case n==203; return "List c."
    case n==204; return "Chyba tlace! (prosim nastavte tlaciaren)"
    case n==205; return {"Pokracovat","Prerusit tlac"}
    //
  #endif //language support
  endcase
  return ""


//*****************************************************************************
// HelpKeys() --> true/false
// this is help for active keys in OBJECT.lib
//
function HelpKeys()
  local OldHelp1,OldHelp2,OldMsg
  local OldUp,OldDown,OldWrap
  local Rs,Cs,St:=""
  local aHelpTxt:={}
  if Empty(aHelpKeys); return(false); endif
  if Empty(ATail(aHelpKeys)); return(false); endif  //disabled help
  OldHelp1:=SetKey(K_F1,nil)
  OldHelp2:=SetKey(K_SH_F1,nil)

  #ifdef ENGLISH //----------------------------------------------------------

  AAdd(aHelpTxt,;   //## 1 ## Task
     ""+cr_lf+;
     " Task keys:"+cr_lf+;
     " Alt-0 ........ show a task list (list of all windows)"+cr_lf+;
     " Alt-1 to Alt-9 go directly into the window 1..9"+cr_lf+;
     " Esc .......... close this window"+cr_lf+;
     " Ctrl-Enter ... close this window"+cr_lf+;
     " F5 ........... minimize/restore this window"+cr_lf+;
     " Shift-F5 ..... maximize this window"+cr_lf+;
     " F6 ........... go to next window"+cr_lf+;
     " Shift-F6 ..... go to previous window"+cr_lf+;
     " F7 ........... tile all windows"+cr_lf+;
     " Shift-F7 ..... cascade all windows"+cr_lf+;
     " F8 ........... move-resize this window"+cr_lf+;
     " Alt-F10 ...... activate local object menu (can't be available)"+cr_lf+;
     " Shift-F10 .... activate task menu for current window"+cr_lf+;
     " F10 .......... activate global (main) menu"+cr_lf+;
     ""+cr_lf+;
     " ShortCuts:"+cr_lf+;
     " @#^F9 ........ Alt-F9, Shift-F9, Ctrl-F9, F9"+cr_lf+;
     " @#F10 ........ Alt-F10, Shift-F10, F10"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 2 ##  Browse:Lock+Move
     " F9 ........... move current column (row)"+cr_lf+;
     " Alt-F9 ....... lock left columns (up rows)"+cr_lf+;
     " Shift-F9 ..... hide current column (row)"+cr_lf+;
     " Ctrl-F9 ...... show previously hided column (row)"+cr_lf+;
     " cursor_keys .. move cursor (bar_cursor)"+cr_lf+;
     " Tab .......... change mode (if is available): browse or read"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 3 ##  Browse:Insert+Delete
     " Insert ....... insert (append) new row into database"+cr_lf+;
     " Delete ....... delete current row from database"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 4 ##  Browse:View
     " Enter ........ on <memo> field: show memo window"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 5 ##  Browse:Edit
     " Enter ........ edit field / done editting"+cr_lf+;
     " A..Z ......... directly edit field"+cr_lf+;
     " Esc .......... exit from field (no save changed data)"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 6 ##  BrowseMode
     " PgDn ......... move to the page down"+cr_lf+;
     " PgUp ......... move to the page up"+cr_lf+;
     " Ctrl-PgUp .... move to top of database"+cr_lf+;
     " Ctrl-PgDn .... move to bottom of database"+cr_lf+;
     " Home ......... move bar_cursor on left visible column in browse"+cr_lf+;
     " End .......... move bar_cursor on right visible column in browse"+cr_lf+;
     " Ctrl-Home .... move bar_cursor on leftmost column in browse"+cr_lf+;
     " Ctrl-End ..... move bar_cursor on rightmost column in browse"+cr_lf+;
     " Ctrl-Left .... scroll all columns on one position left"+cr_lf+;
     " Ctrl-Right ... scroll all columns on one position right"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 7 ##  FormMode
     " PgDn ......... move to next record"+cr_lf+;
     " PgUp ......... move to previous record"+cr_lf+;
     " Ctrl-PgUp .... move to top of database"+cr_lf+;
     " Ctrl-PgDn .... move to bottom of database"+cr_lf+;
     " Ctrl-Home .... move to top of record (first field)"+cr_lf+;
     " Ctrl-End ..... move to end of record (last field)"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 8 ##  Moving+Editing
     " Ctrl-Left .... move on begin of word"+cr_lf+;
     " Ctrl-Right ... move on end of word"+cr_lf+;
     " Ctrl-T ....... delete right word"+cr_lf+;
     " Ctrl-BackSp . delete left word"+cr_lf+;
     " Insert ....... swap insert/overwrite mode"+cr_lf+;
     " BackSpace ... delete character to left of cursor"+cr_lf+;
     " Delete ....... delete character at cursor"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 9 ##  ReadView
     " cursor_keys .. move cursor"+cr_lf+;
     " Enter ........ done, go further"+cr_lf+;
     " Esc .......... done"+cr_lf+;
     " Ctrl-Home .... move to top of record (first field)"+cr_lf+;
     " Ctrl-End ..... move to end of record (last field)"+cr_lf+;
     " Ctrl-Left .... move to beginning of word"+cr_lf+;
     " Ctrl-Right ... move to end of word"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 10 ##  ReadEdit
     " cursor_keys .. move cursor"+cr_lf+;
     " Enter ........ ok, go further"+cr_lf+;
     " Esc .......... abort editting"+cr_lf+;
     " Ctrl-Home .... move to top of record (first field)"+cr_lf+;
     " Ctrl-End ..... move to end of record (last field)"+cr_lf+;
     " Ctrl-Left .... move to beginning of word"+cr_lf+;
     " Ctrl-Right ... move to end of word"+cr_lf+;
     " Ctrl-T ....... delete right word"+cr_lf+;
     " Ctrl-BackSp . delete left word"+cr_lf+;
     " Insert ....... swap insert/overwrite mode"+cr_lf+;
     " BackSpace ... delete character to left of cursor"+cr_lf+;
     " Delete ....... delete character at cursor"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 11 ##  MemoView=15+11
     " Esc .......... done"+cr_lf+;
     " Ctrl-Enter ... done"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 12 ##  MemoEdit
     " cursor_keys .. move cursor"+cr_lf+;
     " Ctrl-Enter ... done (save edited data)"+cr_lf+;
     " Esc .......... abort (no save) editting"+cr_lf+;
     " Ctrl-Left .... move to beginning of word"+cr_lf+;
     " Ctrl-Right ... move to end of word"+cr_lf+;
     " Home ......... move to beginning of current line"+cr_lf+;
     " End .......... move to end of current line"+cr_lf+;
     " Ctrl-Home .... move to beginnig of current window"+cr_lf+;
     " Ctrl-End ..... move to end of current window"+cr_lf+;
     " PgUp ......... move to previous page"+cr_lf+;
     " PgDn ......... move to next page"+cr_lf+;
     " Ctrl-PgUp .... move to beginning of text"+cr_lf+;
     " Ctrl-PgDn .... move to end of text"+cr_lf+;
     " Enter ........ next (new) line"+cr_lf+;
     " Delete ....... delete character at cursor"+cr_lf+;
     " BackSpace ... delete character to left of cursor"+cr_lf+;
     " Tab .......... insert tab character or spaces"+cr_lf+;
     " Insert ....... toggle insert mode"+cr_lf+;
     " Ctrl-Y ....... delete current line"+cr_lf+;
     " Ctrl-T ....... delete right word"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 13 ##  Drag
     " cursor_keys ........ move the frame"+cr_lf+;
     " NumLock+curs_keys .. resize frame:"+cr_lf+;
     "      4 (Left) ... decrease columns"+cr_lf+;
     "      6 (Right) .. increase columns"+cr_lf+;
     "      8 (Up) ..... decrease rows"+cr_lf+;
     "      2 (Down) ... increase rows"+cr_lf+;
     " Other .............. done"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 14 ##  Security
     " Up,Down ...... move cursor"+cr_lf+;
     " Enter ........ swap enable/disable item(s)"+cr_lf+;
     " Ctrl-Enter.... done"+cr_lf+;
     " Esc .......... done"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 15 ##  Info
     " cursor_keys .. move cursor"+cr_lf+;
     " Home ......... move to beginning of current line"+cr_lf+;
     " End .......... move to end of current line"+cr_lf+;
     " Ctrl-Home .... move to beginnig of current window"+cr_lf+;
     " Ctrl-End ..... move to end of current window"+cr_lf+;
     " PgDn ......... move to the page down"+cr_lf+;
     " PgUp ......... move to the page up"+cr_lf+;
     " Ctrl-PgUp .... move to top of text"+cr_lf+;
     " Ctrl-PgDn .... move to bottom of text"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 16 ##  Menu
     " cursor_keys .. move cursor"+cr_lf+;
     " Home ......... move to beginnig of menu"+cr_lf+;
     " End .......... move to end of menu"+cr_lf+;
     " Enter ........ select the higlighted item"+cr_lf+;
     " Esc .......... exit from actual level of menu"+cr_lf+;
     " Hilited character .... quict select of this item"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 17 ##  EditIt-View
     " cursor_keys .. move cursor"+cr_lf+;
     " Enter ........ done, go further"+cr_lf+;
     " Esc .......... done"+cr_lf+;
     " Ctrl-Left .... move to beginning of word"+cr_lf+;
     " Ctrl-Right ... move to end of word"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 18 ##  EditIt-Edit: 17+18
     " Ctrl-T ....... delete right word"+cr_lf+;
     " Ctrl-BackSp . delete left word"+cr_lf+;
     " Insert ....... swap insert/overwrite mode"+cr_lf+;
     " BackSpace ... delete character to left of cursor"+cr_lf+;
     " Delete ....... delete character at cursor"+cr_lf;
    )

  #else  // #define SLOVAK ---------------------------------------------------

  AAdd(aHelpTxt,;   //## 1 ## Task
     ""+cr_lf+;
     " Riadenie okien:"+cr_lf+;
     " Alt-0 ........ ukaze zoznam vsetkych okien"+cr_lf+;
     " Alt-1 to Alt-9 prepne na okno cislo 1..9"+cr_lf+;
     " Esc .......... zatvori (zrusi) toto okno"+cr_lf+;
     " Ctrl-Enter ... zatvori (zrusi) toto okno"+cr_lf+;
     " F5 ........... zmensi na ikonu"+cr_lf+;
     " Shift-F5 ..... zvacsi na celu obrazovku"+cr_lf+;
     " F6 ........... prepne na dalsie okno"+cr_lf+;
     " Shift-F6 ..... prepne na predchadzajuce okno"+cr_lf+;
     " F7 ........... zoradi okna ako dlazdice"+cr_lf+;
     " Shift-F7 ..... zoradi okna do kaskady"+cr_lf+;
     " F8 ........... presunie - zmeni velkost okna"+cr_lf+;
     " Alt-F10 ...... aktivuje lokalne menu aktivneho okna (nemusi byt vzdy mozne)"+cr_lf+;
     " Shift-F10 .... aktivuje menu riadenia okna"+cr_lf+;
     " F10 .......... aktivuje hlavne menu programu"+cr_lf+;
     ""+cr_lf+;
     " Oznacenie klaves:"+cr_lf+;
     " @#^F9 ........ Alt-F9, Shift-F9, Ctrl-F9, F9"+cr_lf+;
     " @#F10 ........ Alt-F10, Shift-F10, F10"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 2 ##  Browse:Lock+Move
     " F9 ........... presunie aktualny stlpec (riadok)"+cr_lf+;
     " Alt-F9 ....... uzamkne lave stlpce (horne riadky)"+cr_lf+;
     " Shift-F9 ..... schova aktualny stlpec (riadok)"+cr_lf+;
     " Ctrl-F9 ...... obnovi, ukaze predtym schovany stlpec (riadok)"+cr_lf+;
     " cursor_keys .. presunie kurzor (blokovy kurzor)"+cr_lf+;
     " Tab .......... prepina mod zobrazenia (ak je to povolene): riadkovy_mod / formular"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 3 ##  Browse:Insert+Delete
     " Insert ....... vlozi (prida) novy riadok do databazy"+cr_lf+;
     " Delete ....... zmaze aktualny riadok z databazy"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 4 ##  Browse:View
     " Enter ........ na <Text> poli: zobrazi Text okno"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 5 ##  Browse:Edit
     " Enter ........ edituje pole / ukoncuje editaciu pola"+cr_lf+;
     " A..Z ......... priamo edituje pole"+cr_lf+;
     " Esc .......... prerusi editaciu pola (bez ulozenia zmien)"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 6 ##  BrowseMode
     " PgDn ......... presunie o stranku dolu"+cr_lf+;
     " PgUp ......... presunie o stranku hore"+cr_lf+;
     " Ctrl-PgUp .... presunie na zaciatok databazy"+cr_lf+;
     " Ctrl-PgDn .... presunie na koniec databazy"+cr_lf+;
     " Home ......... presunie blokovy_kurzor na lavy stlpec okna v riadkovom_zobrazeni"+cr_lf+;
     " End .......... presunie blokovy_kurzor na pravy stlpec okna v riadkovom_zobrazeni"+cr_lf+;
     " Ctrl-Home .... presunie blokovy_kurzor na najlavejsi stlpec v riadkovom zobrazeni"+cr_lf+;
     " Ctrl-End ..... presunie blokovy_kurzor na najpravejsi stlpec v riadkovom zobrazeni"+cr_lf+;
     " Ctrl-Left .... presunie vsetky stlpce o jednu poziciu dolava"+cr_lf+;
     " Ctrl-Right ... presunie vsetky stlpce o jednu poziciu doprava"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 7 ##  FormMode
     " PgDn ......... presunie na dalsi zaznam"+cr_lf+;
     " PgUp ......... presunie na predchadzajuci zaznam"+cr_lf+;
     " Ctrl-PgUp .... presunie na zaciatok databazy"+cr_lf+;
     " Ctrl-PgDn .... presunie na koniec databazy"+cr_lf+;
     " Ctrl-Home .... presunie na prve pole (zaciatok) zaznamu"+cr_lf+;
     " Ctrl-End ..... presunie na posledne pole (koniec) zaznamu"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 8 ##  Moving+Editing
     " Ctrl-Left .... presunie na zaciatok slova"+cr_lf+;
     " Ctrl-Right ... presunie na koniec slova"+cr_lf+;
     " Ctrl-T ....... zmaze slovo napravo od kurzoru"+cr_lf+;
     " Ctrl-BackSp . zmaze slovo nalavo od kurzoru"+cr_lf+;
     " Insert ....... prepina vkladaci/prepisovaci mod"+cr_lf+;
     " BackSpace ... zmaze pismeno nalavo od kurzoru"+cr_lf+;
     " Delete ....... zmaze pismeno pod kurzorom"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 9 ##  ReadView
     " kurz.sipky ... presunie kurzor"+cr_lf+;
     " Enter ........ ok, chod dalej"+cr_lf+;
     " Esc .......... koniec"+cr_lf+;
     " Ctrl-Home .... presunie na prve pole (zaciatok) zaznamu"+cr_lf+;
     " Ctrl-End ..... presunie na posledne pole (koniec) zaznamu"+cr_lf+;
     " Ctrl-Left .... presunie na zaciatok slova"+cr_lf+;
     " Ctrl-Right ... presunie na koniec slova"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 10 ##  ReadEdit
     " kurz.sipky ... presunie kurzor"+cr_lf+;
     " Enter ........ ok, chod dalej"+cr_lf+;
     " Esc .......... prerusi editaciu"+cr_lf+;
     " Ctrl-Home .... presunie na prve pole (zaciatok) zaznamu"+cr_lf+;
     " Ctrl-End ..... presunie na posledne pole (koniec) zaznamu"+cr_lf+;
     " Ctrl-Left .... presunie na zaciatok slova"+cr_lf+;
     " Ctrl-Right ... presunie na koniec slova"+cr_lf+;
     " Ctrl-T ....... zmaze slovo napravo od kurzoru"+cr_lf+;
     " Ctrl-BackSp . zmaze slovo nalavo od kurzoru"+cr_lf+;
     " Insert ....... prepina vkladaci/prepisovaci mod"+cr_lf+;
     " BackSpace ... zmaze pismeno nalavo od kurzoru"+cr_lf+;
     " Delete ....... zmaze pismeno pod kurzorom"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 11 ##  MemoView=15+11
     " Esc .......... ok, koniec"+cr_lf+;
     " Ctrl-Enter ... ok, koniec"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 12 ##  MemoEdit
     " kurz.sipky ... presunie kurzor"+cr_lf+;
     " Ctrl-Enter ... ok, koniec (uloz zmenene udaje)"+cr_lf+;
     " Esc .......... prerus, koniec (bez ulozenia zmenenych udajov)"+cr_lf+;
     " Ctrl-Left .... presunie na zaciatok slova"+cr_lf+;
     " Ctrl-Right ... presunie na koniec slova"+cr_lf+;
     " Home ......... presunie na zaciatok riadku"+cr_lf+;
     " End .......... presunie na koniec riadku"+cr_lf+;
     " Ctrl-Home .... presunie na zaciatok okna"+cr_lf+;
     " Ctrl-End ..... presunie na koniec okna"+cr_lf+;
     " PgUp ......... presunie na predchadzajucu stranku"+cr_lf+;
     " PgDn ......... presunie na dalsiu stranku"+cr_lf+;
     " Ctrl-PgUp .... presunie na zaciatok textu"+cr_lf+;
     " Ctrl-PgDn .... presunie na koniec textu"+cr_lf+;
     " Enter ........ dalsi (novy) riadok"+cr_lf+;
     " Delete ....... zmaze pismeno pod kurzorom"+cr_lf+;
     " BackSpace ... zmaze pismeno nalavo od kurzoru"+cr_lf+;
     " Tab .......... vlozi znak tabulatora alebo medzery"+cr_lf+;
     " Insert ....... prepina vkladaci/prepisovaci mod"+cr_lf+;
     " Ctrl-Y ....... zmaze aktualny riadok"+cr_lf+;
     " Ctrl-T ....... zmaze slovo napravo od kurzoru"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 13 ##  Drag
     " kurz.sipky .......... presunie ram okna"+cr_lf+;
     " NumLock+kurz.sipky: . zmeni velkost ramu okna:"+cr_lf+;
     "   4 (sipka vlavo) ... zmensi pocet stlpcov"+cr_lf+;
     "   6 (sipka vpravo) .. zvacsi pocet stlpcov"+cr_lf+;
     "   8 (sipka hore) .... zmensi pocet riadkov"+cr_lf+;
     "   2 (sipka dolu) .... zvacsi pocet riadkov"+cr_lf+;
     " Ine ................. ok, koniec"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 14 ##  Security
     " Up,Down ...... presunie kurzor"+cr_lf+;
     " Enter ........ prepnutie: povolena/zakazana polozka(y)"+cr_lf+;
     " Ctrl-Enter.... ok, koniec"+cr_lf+;
     " Esc .......... ok, koniec"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 15 ##  Info
     " kurz.sipky ... presunie kurzor"+cr_lf+;
     " Home ......... presunie na zaciatok riadku"+cr_lf+;
     " End .......... presunie na koniec riadku"+cr_lf+;
     " Ctrl-Home .... presunie na zaciatok okna"+cr_lf+;
     " Ctrl-End ..... presunie na koniec okna"+cr_lf+;
     " PgDn ......... presunie na dalsiu stranku"+cr_lf+;
     " PgUp ......... presunie na predchadzajucu stranku"+cr_lf+;
     " Ctrl-PgUp .... presunie na zaciatok textu"+cr_lf+;
     " Ctrl-PgDn .... presunie na koniec textu"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 16 ##  Menu
     " kurz.sipky ... presunie kurzor"+cr_lf+;
     " Home ......... presunie na prvu polozku menu"+cr_lf+;
     " End .......... presunie na poslednu polozku menu"+cr_lf+;
     " Enter ........ vyber oznacenej polozky"+cr_lf+;
     " Esc .......... prerusenie vyberu na tejto urovni menu"+cr_lf+;
     " Zvyraznene pismeno ... rychly vyber danej polozky"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 17 ##  EditIt-View
     " kurz.sipky ... presunie kurzor"+cr_lf+;
     " Enter ........ ok, chod dalej"+cr_lf+;
     " Esc .......... koniec"+cr_lf+;
     " Home ......... presun na zaciatok riadku"+cr_lf+;
     " End .......... presun na koniec riadku"+cr_lf+;
     " Ctrl-Left .... presunie na zaciatok slova"+cr_lf+;
     " Ctrl-Right ... presunie na koniec slova"+cr_lf;
    )
  AAdd(aHelpTxt,;   //## 18 ##  EditIt-Edit: 17+18
     " Ctrl-T ....... zmaze slovo napravo od kurzoru"+cr_lf+;
     " Ctrl-BackSp . zmaze slovo nalavo od kurzoru"+cr_lf+;
     " Insert ....... prepina vkladaci/prepisovaci mod"+cr_lf+;
     " BackSpace ... zmaze pismeno nalavo od kurzoru"+cr_lf+;
     " Delete ....... zmaze pismeno pod kurzorom"+cr_lf;
    )

  #endif  //language support


  St:=cr_lf+" "+ResTxt(185)+cr_lf+cr_lf
  AEval(ATail(aHelpKeys),{|e|St+=aHelpTxt[e]})
  St+=cr_lf+"................................................"
  St+=" "+ResTxt(007)+" ............"
  Rs:=Min(MaxRow()-5,MLCount(St,80))
  Cs:=58
  OldMsg:=SetDialog(true)
  SaveDOut(ResTxt(146))
  SetDialog(false)
  OldUp:=SetKey(K_UP,nil)
  OldDown:=SetKey(K_DOWN,nil)
  OldWrap:=SetMemoWrap(false)
  Memo({||St},false,ResTxt(028),-3,-3,Rs,Cs,,m->Color:Help)
  SetMemoWrap(OldWrap)
  SetKey(K_UP,OldUp)
  SetKey(K_DOWN,OldDown)
  SetDialog(true)
  RestDOut()
  SetDialog(OldMsg)
  SetKey(K_F1,OldHelp1)
  SetKey(K_SH_F1,OldHelp2)
  return(true)


//*****************************************************************************
// SaveHelpIdx( aNewIdx ) --> true
// save new help indexes (array of numeric items as pointers into aHelpTxt)
//
function SaveHelpIdx( New )
  if SetHelpIdx()
    AAdd(aHelpKeys,New)
  endif
  return(true)


//*****************************************************************************
// RestHelpIdx() --> true
// restore previous state of aHelpTxt
//
function RestHelpIdx()
  if SetHelpIdx()
    ATailDel(aHelpKeys)
  endif
  return(true)


//*****************************************************************************
// SetHelpIdx(lNew) --> lOld
// restore previous state of aHelpTxt
//
function SetHelpIdx(lNew)
  static lOld:=true
  return lOld update with lNew


//#############################################################################
//#############################################################################
// CanEditHelp(new) --> old
// allow to edit a help item instead view of it.
//
function CanEditHelp(new)
  static old:=true
  return old update with new


//*****************************************************************************
// HelpReserved(new,add) --> old
// Reserved a help entry items for an application programmer.
// Available indexes are 1..HelpReserved()
// Usage:
//   HelpReserved(10)  ... reserve 10 help entries (must be used before Dbf:New())
//   HelpReserved()    ... current help counter return value
//   HelpReserved(,+1) ... increment the help counter
//
function HelpReserved(new,add)
  static old:=0
  if( !Empty(new), old:=new, )
  if( !Empty(add), old+=add, )
  return(old)


//*****************************************************************************
// HelpAssoc(Txt,VarName,[N]) --> N
// Work around a Association array for scanning a help items
//
function HelpAssoc(Txt,VarName,N)
  if Empty(N)  //scan mode
    N:=AScan(Association,{|e|e[1]==Txt})
  else  //add mode
    AAdd(Association,{Txt,VarName,N})
  endif
  return(N)


//*****************************************************************************
// ChangeAssoc(Txt,VarName,[N]) --> true/false
// set new VarName/N for this association.
//
function ChangeAssoc(Txt,VarName,N)
  local i:=AScan(Association,{|e|e[1]==Txt})
  if i>0  //found
    Association[i]:={Txt,if(Empty(VarName),Association[i,2],VarName),if(Empty(N),Association[i,3],N)}
    return(true)
  endif
  return(false)


//*****************************************************************************
// ReadHelpVar() --> return "VarName" from top of stack
// ReadHelpVar("VarName") --> add "VarName" on top stack
// ReadHelpVar(nil) --> remove (pop) the last "VarName" from stack
//
function ReadHelpVar(vn)
  static st:={}
  if PCount()==0; return(ATail(st)); endif
  if !Empty(vn); AAdd(st,vn); return(vn); endif
  ASize(st,Len(st)-1)
  return(ATail(st))


//*****************************************************************************
// HelpField() --> true
// field help for currently selected item.
//
function HelpField()
  local Lt,i,oi,scr,IsF8
  returnif ReadHelpVar()==DISABLE    with false
  returnif ReadHelpVar()=="MENU->0"  with false
  returnif ReadHelpVar()=="MEMORY->" with false
  i:=HelpAssoc(ReadHelpVar())
  if i==0; Alert(ResTxt(189)); return(false); endif
  (cHelp)->(DbGoto(Association[i,3]))
  Lt:=SetLastTask()
  object oi of Info
  oi:GoodInit(ResTxt(187)+": "+Association[i,2],,,(cHelp)->RowSize,(cHelp)->ColSize,-1,m->Color:Help)
  oi:RecNo:=Association[i,3]
  oi:Buff:=(cHelp)->Text
  oi:Wrap:=false
  oi:CanPrint:=false
  oi:CanEdit:=CanEditHelp()
  oi:DoneBlock:={|o|DoDone(o)}
  IsF8:=false
  i:=SetKey(K_F8,{||IsF8:=true,StuffKey(K_CTRL_W)})
  scr:=SaveScr()
  oi:Paint(true)
  repeat
    oi:VProcess()
    if IsF8
      MyDrag(oi,scr)
      IsF8:=false
    else
      exit
    endif
  endrepeat
  oi:Done(false)
  RestScr(scr)
  SetKey(K_F8,i)
  SetLastTask(Lt)
  return(true)

static function MyDrag(oi,scr)
  oi:Frame:Init(oi:Row,oi:Col,oi:RowSize,oi:ColSize)
  oi:Frame:MaxRows:=oi:MaxRows
  oi:Frame:MaxCols:=oi:MaxCols
  oi:Frame:MinRows:=oi:MinRows
  oi:Frame:MinCols:=oi:MinCols
  if oi:Frame:Drag(true)
    oi:Row:=oi:Frame:Row             //save
    oi:Col:=oi:Frame:Col
    oi:RowSize:=oi:Frame:RowSize
    oi:ColSize:=oi:Frame:ColSize
  endif
  RestScr(scr)
  oi:Paint(true)
  return(true)

static function DoDone(oi)
  local s
  if oi:CanEdit
    s:=Select()
    select (cHelp)
    goto oi:RecNo
    net rlock continue
    if !NetErr()
      field->Text:=oi:Buff
      field->RowSize:=oi:RowSize
      field->ColSize:=oi:ColSize
      net unlock
    endif
    select (s)
  endif
  return(true)

//-------------------------------------------------- eof (c)JHK ---------------

