//*****************************************************************************
// C_Win.prg
// Simple window class for OBJECT v2.03
// Copyright (c) 1991, JHK, JHK-Software, Piestany
// Compile with: /N/M/W/A
//-----------------------------------------------------------------------------

#include "Object.ch"

create class Win from Box     //Usage sequence: Init,Paint,  Hide,Show,... Done
  export:
  var Screen   //""
  var Visible  //false
  method New=WinNew      //o:New()
  method Paint=WinPaint  //o:Paint(IsTop,lDouble)  //overwrite: save_background & set_visibility
  method Show=WinShow    //o:Show()                //you prefer this method
  method Hide=WinHide    //o:Hide()                //...
  method Done=WinDone    //o:Done()                //overwrite: hide_window & box_done
  endclass


//*****************************************************************************
// Win:New() --> self
// default values for this object
//
constructor WinNew()
  ::Screen:=""
  ::Visible:=false
  return(self)


//*****************************************************************************
// Win:Paint(IsTop,lDouble) --> true
// physically write simple window into screen.
//
method function WinPaint(IsTop,lDouble)
  local R:=::Row
  local C:=::Col
  local R2:=R+::RowSize+1
  local C2:=C+::ColSize+1
  if ::Shadow; R2++; C2++; endif
  ::Screen:=SaveScreen(R,C,R2,C2)    //save background
  ::super(Box):Paint(IsTop,lDouble)
  ::Visible:=true
  return(true)


//*****************************************************************************
// Win:Show() --> true
// show previously hided simple window.
//
method function WinShow()
  local R,C,R2,C2,Scr
  if !::Visible
    R:=::Row
    C:=::Col
    R2:=R+::RowSize+1
    C2:=C+::ColSize+1
    Scr:=::Screen
    if ::Shadow; R2++; C2++; endif
    ::Screen:=SaveScreen(R,C,R2,C2)     //save background
    if ::Shadow; R2--; C2--; endif
    RestScreen(R,C,R2,C2,Scr)             //show box
    if ::Shadow; BoxShadow(R,C,R2,C2,ListAsArray(::Color)[nShadow]); endif
    ::Visible:=true
  endif
  return(true)


//*****************************************************************************
// Win:Hide() --> true
// hide the simple window.
//
method function WinHide()
  local R,C,R2,C2,Scr
  if ::Visible
    R:=::Row
    C:=::Col
    R2:=R+::RowSize+1
    C2:=C+::ColSize+1
    Scr:=::Screen
    ::Screen:=SaveScreen(R,C,R2,C2)    //save the box
    if ::Shadow; R2++; C2++; endif
    RestScreen(R,C,R2,C2,Scr)            //restore background
    ::Visible:=false
  endif
  return(true)


//*****************************************************************************
// Win:Done() --> true
// destroy simple window.
//
method function WinDone()
  ::Hide()
  ::super(Box):Done()
  return(true)

//------------------------------------------------------- eof (c)JHK ----------

