//*****************************************************************************
// C_FInfo.prg
// File viewer class for OBJECT v2.03
// Copyright (c) 1991, JHK, JHK-Software, Piestany
// Please compile with: /N/M/W/A
//-----------------------------------------------------------------------------

#include "InKey.ch"
#include "FileIo.ch"
#include "Object.ch"

create class FInfo from Info
  export:
  var BigFile // false
  var FHandle // 0
  var FSize   // 0;
  method New=FInfoNew              //o:New()
  method Init=FInfoInit            //o:Init(FName,WinName,R,C,Rs,Cs,Clr,Shadow)
  method GoodInit=FInfoGoodInit    //o:GoodInit(FName,WinName,R,C,Rs,Cs,CurSize,Clr,Shadow)
  method Print=FInfoPrint          //o:Print()
  method VProcess=FInfoVProcess    //o:VProcess()
  method Done=FInfoDone            //o:Done()
  endclass


//*****************************************************************************
// FInfo:New() --> self
// initialize new object
//
constructor FInfoNew()
  ::BigFile:= false
  ::FHandle:= 0
  ::FSize:= 0
  return(self)


//-----------------------------------------------------------------------------
// FInfoShow(FName,R,C,Rs,Cs,Clr,Shadow) --> true/false
// create new file viewer
//
function FInfoShow(FName,R,C,Rs,Cs,Clr,Shadow)
  local FInfo
  default FName to "*.*"
  object FInfo of FInfo
  FInfo:Wrap:=false
  FInfo:super(Info):Init(ResTxt(032)+": "+FName,R,C,Rs,Cs,Clr,Shadow) //init empty window
  FInfo:Top(false)                        //paint empty window
  if Empty(FName:=GetFile(FInfo,FName))   //get file name
    FInfo:Done()
    return(false)
  endif
  PreInit(FInfo,FName)
  FInfo:RCInfo:=""                         //force redraw window
  FInfo:Name:=ResTxt(032)+": "+Fname       //selected file name
  FInfo:Paint()                            //show window name
  return(FInfo:Process())


//-----------------------------------------------------------------------------
// FInfo::GetFile(cMask) --> cFileName
// get new file name
//
static function GetFile(FInfo,cMask)
  local Ch,Dir,ar:={}
  local object Choice of Choice
  SaveDOut(ResTxt(164))
  AEval((Dir:=Directory(cMask)),{|e|AAdd(ar,PadR(e[1],13)+PadL(NTrim(e[2]),8)+" "+DtoC(e[3])+" "+e[4])})
  if Empty(ar); return(nil); endif
  Choice:FastInit(ResTxt(033)+" "+cMask,FInfo:Row+1,FInfo:Col+2,,ar)
  Ch:=Choice:Process()
  Choice:Done()
  RestDOut()
  if Ch<=0; return(""); endif
  return(Dir[Ch,1])


//*****************************************************************************
// FInfo:Init(FName,WinName,R,C,Rs,Cs,Clr,Shadow) --> true/false
// open the file, initialize the task.
//
method function FInfoInit(FName,WinName,R,C,Rs,Cs,Clr,Shadow)
  if !PreInit(self,FName); return(false); endif
  ::super(Info):Init(WinName,R,C,Rs,Cs,Clr,Shadow)
  return(true)


//*****************************************************************************
// FInfo:GoodInit(FName,WinName,R,C,Rs,Cs,CurSize,Clr,Shadow) --> true/false
// open the file, initialize the task.
//
method function FInfoGoodInit(FName,WinName,R,C,Rs,Cs,CurSize,Clr,Shadow)
  if !PreInit(self,FName); return(false); endif
  ::super(Info):GoodInit(WinName,R,C,Rs,Cs,CurSize,Clr,Shadow)
  return(true)


//*****************************************************************************
// FInfo::PreInit(FName) -->true/false
// open the file,read first block
//
static function PreInit(FInfo,FName)
  local Opened,FHandle
  SaveDOut(ResTxt(163))
  FInfo:FName:=FName
  if (Opened:=((FHandle:=FInfo:FHandle:=FOpen(FName))>=0))
    FInfo:BigFile:=((FInfo:FSize:=FSeek(FHandle,0,FS_END))>15000)
    FSeek(FHandle,0)
    GoodRead(FInfo,false,true,if(FInfo:BigFile,15000,FInfo:FSize))  //may be change SeeTop/SeeBottom
    if !FInfo:BigFile; FClose(FHandle); endif  //small file
    FInfo:SeeTop:=true
    FInfo:SeeBottom:=!FInfo:BigFile
  endif
  RestDOut()
  return(Opened)


//*****************************************************************************
// FInfo:Print() --> true
// printing all file
//
method function FInfoPrint()
  PrintFile(::FName)
  ::Printed:=true
  return(true)


//*****************************************************************************
// FInfo:VProcess() --> true
// virtual process
//
method function FInfoVProcess()
  local Ch
  if ::BigFile
    SaveDOut(ResTxt(163))
    repeat
      ::super(Info):VProcess()
      Ch:=LastKey()
      do case
        case Ch==K_UP
          MoveUp(self,+1)
        case Ch==K_DOWN
          MoveDown(self,+1)
        case Ch==K_PGUP
          MoveUp(self,-::TextRow+1)
        case Ch==K_PGDN
          MoveDown(self,::TextRow+(::RowSize-1)-::TextMax)
        case Ch==K_CTRL_PGUP
          FSeek(::FHandle,0)
          GoodRead(self,false,true)
          ::TextRow:=1
        case Ch==K_CTRL_PGDN
          FSeek(::FHandle,-15000,FS_END)
          GoodRead(self,true,false)
          ::TextRow:=::TextMax-::RowSize+1
      endcase
    until Ch==nSwapTask or Ch==K_ESC or Ch==K_CTRL_RET
    RestDOut()
  else
    ::super(Info):VProcess()
  endif
  return(true)


static function MoveUp(FInfo,Ofs)
  local Count,x
  Count:=Min(FSeek(FInfo:FHandle,0,FS_RELATIVE),10000)
  FInfo:SeeTop:=(x:=FSeek(FInfo:FHandle,-Count,FS_RELATIVE))==0
  FInfo:SeeBottom:=x+15000==FInfo:FSize
  Count-=GoodRead(FInfo,FSeek(FInfo:FHandle,0,FS_RELATIVE)<>0,true)-3
  FInfo:TextRow:=MLCount(SubStr(FInfo:Buff,1,Count),250)-Ofs
  if FInfo:TextRow<1; FInfo:TextRow:=1; endif
  return(true)


static function MoveDown(FInfo,Ofs)
  local FPos,Count
  FPos:=Min(FSeek(FInfo:FHandle,0,FS_RELATIVE)+10000,FInfo:FSize-15000)
  Count:=FSeek(FInfo:FHandle,0,FS_RELATIVE)+Len(FInfo:Buff)-FPos
  FSeek(FInfo:FHandle,FPos)
  Count-=GoodRead(FInfo,true,FPos+15000<FInfo:FSize)-3
  FInfo:TextRow:=MLCount(SubStr(FInfo:Buff,1,Count),250)+Ofs-FInfo:RowSize
  if FInfo:TextRow+FInfo:RowSize-1>FInfo:TextMax; FInfo:TextRow:=FInfo:TextMax-FInfo:RowSize+1; endif
  return(true)


static function GoodRead(FInfo,lTopCorection,lBottomCorection,nBytes) //strip truncated lines
  local i,j,x
  default nBytes to 15000
  FInfo:Buff:=FReadStr(FInfo:FHandle,nBytes)
  i:=if(lTopCorection, At(cr_lf,FInfo:Buff)+2, 1)                    //cr_lf begin corection :text will be without first cr_lf
  j:=if(lBottomCorection, RAt(cr_lf,FInfo:Buff)-1, Len(FInfo:Buff))  //cr_lf end corection   :...                  last ...
  FSeek(FInfo:FHandle,-nBytes-1+i,FS_RELATIVE)                       //seek corection: FilePointer (seek) will be keept in begin of text in FInfo:Buff
  FInfo:Buff:=SubStr(FInfo:Buff,i,j-i+1)
  FInfo:TextMax:=MLCount(FInfo:Buff,if(FInfo:Wrap,FInfo:ColSize,250))
  FInfo:SeeBottom:=FSeek(FInfo:FHandle,0,FS_RELATIVE)>=FInfo:FSize-15000
  FInfo:SeeTop:=!FInfo:SeeBottom
  return(i-1) //bytes of top_corection


//*****************************************************************************
// FInfo:Done() --> true/false
// close file
//
method function FInfoDone()
  returnif !::super(Info):Done(true) with false
  if ::BigFile; FClose(::FHandle); endif
  return(true)

//------------------------------------------------------- eof (c)JHK ----------

