//*****************************************************************************
// C_Box.prg
// Box class for OBJECT v2.03
// Copyright (c) 1991, JHK, JHK-Software, Piestany
// Compile with: /N/M/W/A
//-----------------------------------------------------------------------------

#include "Box.ch"
#include "SetCurs.ch"
#include "Object.ch"

create class Box from Loc
  export:
  var Name    // ""
  var RowSize // MaxRow()-7
  var ColSize // MaxCol()-9
  var Color   // m->Color:Edit
  var Shadow  // true
  method New=BoxNew              //o:New()
  method Init=BoxInit            //o:Init(Name,R,C,Rs,Cs,Clr,Shadow)
  method GoodInit=BoxGoodInit    //o:GoodInit(Name,R,C,Rs,Cs,CurSize,Clr,Shadow)
  method Paint=BoxPaint          //o:Paint(IsTop,lDouble)
  method SayTitle=BoxSayTitle    //o:SayTitle(IsTop)
  method Scroll=BoxScroll        //o:Scroll(dRow)
  method Done=BoxDone            //o:Done()
  endclass


//*****************************************************************************
// Box:New() --> self
// initialize new object
//
constructor BoxNew()
  ::Name:= ""
  ::RowSize:= MaxRow()-7
  ::ColSize:= MaxCol()-9
  ::Color:= m->Color:Edit
  ::Shadow:= true
  return(self)


//*****************************************************************************
// Box:Init(Name,R,C,Rs,Cs,Clr,Shadow) --> true
// initialize new box.
//
method function BoxInit(Name,R,C,Rs,Cs,Clr,Shadow)
  ::super(Loc):Init(R,C)
  store value Name into ::Name
  store value Rs into ::RowSize
  store value Cs into ::ColSize
  store value Clr into ::Color
  store value Shadow into ::Shadow
  if m->tColor==0; ::Shadow:=false; endif
  return(true)


//*****************************************************************************
// Box:GoodInit(Name,R,C,Rs,Cs,CurSize,Clr,Shadow) --> true
// initialize new box.
//
method function BoxGoodInit(Name,R,C,Rs,Cs,CurSize,Clr,Shadow)
  local S
  ::Row:=Row()
  ::Col:=Col()                    //Ŀ
  ::RowSize:=MaxRow()/2           //for menu use, you must set cursor            
  ::ColSize:=MaxCol()/2           //into right corner of current item            
  default CurSize to 1            //CurSize is current item column size (ColSize)
  S:=if(CurSize<=0,1,0)           //for positioning around physical cursor       
  if CurSize<0; CurSize:=0; endif //set CurSize<=0                               
  ::super(Loc):Init(R,C)          //
  store value Name into ::Name
  store value Rs into ::RowSize
  store value Cs into ::ColSize
  store value Clr into ::Color
  store value Shadow into ::Shadow
  if m->tColor==0; ::Shadow:=false; endif
  R:=::Row
  C:=::Col
  Rs:=::RowSize
  Cs:=::ColSize
  if (C+Cs+2)>MaxCol()             //try right
    if (C-CurSize-Cs+S-3)<0        //right fail, try left
      C:=Int((MaxCol()-Cs-1)/2)    //left fail, make centre
      fill empty S with 1
    else
      C-=(CurSize+Cs-S+3)    //left ok.
    endif
  else
    C++    //right ok.
  endif
  if (R+Rs+1+S)>=MaxRow()          //try down
    if (Rs+1)>=(R-S)               //down fail, try up
      R:=Int((MaxRow()-Rs-3)/2+1)  //up fail, make centre
    else
      R-=(Rs+1+S)   //up ok.
    endif
  else
    R+=S            //down ok.
  endif
  if R<0 or R+Rs+1>MaxRow()-1; R:=Int((MaxRow()-Rs-3)/2+1); endif
  if C<0 or C+CS+1>MaxCol();   C:=Int((MaxCol()-Cs-1)/2);   endif
  ::Row:=R
  ::Col:=C
  return(true)


//*****************************************************************************
// Box:Paint(IsTop,lDouble) --> true
// physically write box into screen.
//
method function BoxPaint(IsTop,lDouble)
  local BFrame
  local R:=::Row
  local C:=::Col
  local R2:=R+::RowSize+1
  local C2:=C+::ColSize+1
  local Clr:=::Color
  default IsTop to true
  default lDouble to IsTop
  BFrame:=if(lDouble, B_DOUBLE, B_SINGLE)
  @ R,C,R2,C2 box BFrame+" " color Clr
  ::SayTitle(IsTop)
  if ::Shadow
    BoxShadow(R,C,R2,C2,ListAsArray(Clr)[nShadow])
  endif
  return(true)


//*****************************************************************************
// Box:SayTitle(IsTop) --> true
// refresh window name
//
method function BoxSayTitle(IsTop)
  local Name,Clr,Curs
  default IsTop to true
  Curs:=SetCursor(SC_NONE)
  Clr:=::Color
  if !Empty(::Name) and ::ColSize>=9
    @ ::Row,::Col+4 say "[" color Clr
    DevOut(" "+Left(::Name,::ColSize-10)+" ",ListAsArray(Clr)[if(IsTop,nTitle,nNormal)])
    DevOut("]",Clr)
  endif
  SetCursor(Curs)
  return(true)


//*****************************************************************************
// Box:Scroll(dRow) --> true
// scroll inside the box
//
method function BoxScroll(dRow)
  default dRow to 1
  SetColor(::Color)
  Scroll(::Row+1,::Col+1,::Row+::RowSize,::Col+::ColSize,dRow)
  return(true)


//*****************************************************************************
// Box:Done() --> true
// destroy the box.
//
method function BoxDone()
  return(true)

//------------------------------------------------------- eof (c)JHK ----------

