//*****************************************************************************
// OBJECT1.PRG
// Standart object initializer for OBJECT v2.03
// Copyright (c) 1991, JHK, JHK-Software, Piestany
// Please compile with: /N/M/W/A
//-----------------------------------------------------------------------------

#include "Set.ch"
#include "Box.ch"
#include "InKey.ch"
#include "Object.ch"
#include "SetCurs.ch"

static aDosScrn:={}    //static_array_Screen_data: DOS screen, used in ObjectInit()
static aAboutScrn:={}  //static_array_Screen_data: before AboutOn() screen
static lAbout:=false   //for AboutOff() in C_MENU.PRG

//*****************************************************************************
// ObjectInit([cp],cProgName,nVersion,nYear,[cUser],[cAuthor],[cSpecLine]) --> true
// define colors, init object system (define class), show entry screen
// cp=nUserColorDefinition, may be 0,1,2 (black_white,monochrom,color)
//
function ObjectInit(cp,cProgName,nVersion,nYear,cUser,cAuthor,cSpecLine)
  local cTime1,cTime2,dDate
  //
  set exact on
  set confirm on
  #ifndef ENGLISH
    set date german
  #endif
  set deleted on
  set softseek on
  set epoch to 1970
  set scoreboard off
  set exclusive off
  set wrap on
  set bell on
  //
  public tColor:=0   //Typ color
  set errors file to cErrFile
  ParseInputPars(cp,cProgName,nVersion,nYear,cAuthor)
  SetKey(K_F1,{||HelpKeys()})
  SetKey(K_SH_F1,{||HelpField()})
  SetKey(K_ALT_F10,{||Alert(ResTxt(078))})
  public object Color of Color  //only one color definition for all program.
  aDosScrn:=SaveScr()
  SetColor(m->Color:Desk)
  DrawBasicScreen(cProgName)
  AboutOn(cProgName,nVersion,nYear,cUser,cAuthor,cSpecLine)
  DOut("")
  if SetDateTime()
    dDate:=Date()
    dDate:=EditItPrim(dDate,ResTxt(014),,MaxRow()-5)
    if dDate<>Date()
      GoodRun("date "+DtoC(dDate))
    endif
    cTime1:=cTime2:=Time()
    cTime2:=EditItPrim(cTime1,ResTxt(015),,MaxRow()-5)
    if !(cTime1==cTime2)
      GoodRun("time "+cTime2)
    endif
  endif
  return(true)


//*****************************************************************************
// ObjectDone() --> true
// close databases, restore screen
//
function ObjectDone(lCanContinue)
  default lCanContinue to true
  if lCanContinue; LogOff(); endif
  close all
  RestScr(aDosScrn)
  SetPos(Row()-1,0)         //don't allow free ms-dos line
  if !lCanContinue;  quit; endif
  return(true)


//*****************************************************************************
// ParseInputPars(cDOScommandLineParameter,cProgName,nVersion,nYear,cAuthor) --> true
// work around DOS command line parameter
//
static function ParseInputPars(cp,cProgName,nVersion,nYear,cAuthor)
  default cp to "/"+if(IsColor(),"3","0")
  if "/RECOVER" $ Upper(cp)
    net use (cIFR) new
    LogSet(998)
    net close
    cp := "/"+if(IsColor(),"3","0")
  endif
  if !(SubStr(cp,2,1) $ "0123")
    default cAuthor to ResTxt(001)
    ?? cProgName+" v"+Transform(nVersion,"9.99")+"  (c)"+Transform(nYear,"9999")+", "+ResTxt(001)
    ? ResTxt(008)+cProgName+" [/0|1|2|3|RECOVER] <Enter>"
    ? ResTxt(009)
    ? ResTxt(010)
    ? ResTxt(011)
    ? ResTxt(012)
    ? ResTxt(013)
    ?
    quit    //do not insert LogOff(), because database are NOT OPENED!
  endif
  m->tColor:=Val(SubStr(cp,2,1))        //see ErrorSys.prg and C_Color.prg
  return(true)


//*****************************************************************************
// SaveScr(R,C,R2,C2) --> ScreenArray
// Save screen data into array
//
function SaveScr(R,C,R2,C2)
  local sA:={}                //screen array
  default R to 0
  default C to 0
  default R2 to MaxRow()
  default C2 to MaxCol()
  AAdd(sA,R)                      //1
  AAdd(sA,C)                      //2
  AAdd(sA,R2)                     //3
  AAdd(sA,C2)                     //4
  AAdd(sA,Row())                  //5
  AAdd(sA,Col())                  //6
  AAdd(sA,SetCursor())            //7
  AAdd(sA,SetColor())             //8
  AAdd(sA,SaveScreen(R,C,R2,C2))  //9
  return(sA)


//*****************************************************************************
// RestScr(saScreen) --> true
// Complete restore screen previously saved vith SaveScr()
//
function RestScr(sA)
  SetPos(sA[5],sA[6])
  SetCursor(sA[7])
  SetColor(sA[8])
  RestScreen(sA[1],sA[2],sA[3],sA[4],sA[9])
  sA:=nil  //release memory
  return(true)



//*****************************************************************************
// DrawBasicScreen(PrgName) --> true
//
static function DrawBasicScreen(PrgName)
  if !Empty(PrgName)
    @ 0,0 say PadC( ResTxt(002)+PrgName+ResTxt(003), MaxCol()+1 ) color m->Color:Menu
  else
    @ 0,0,0,MaxCol() box " " color m->Color:Menu
  endif
  @ 1,0,        MaxRow()-1,MaxCol() box "" color m->Color:Desk
  @ MaxRow(),0, MaxRow(),  MaxCol() box " " color m->Color:Menu
  return(true)


//*****************************************************************************
// AboutOn(cProgName,nVersion,nYear,[cUser],[cAuthor]) --> true
// thank my brother for writting this function.
//
function AboutOn(cProgName, nVersion, nYear, cEndUser, cAuthor, cSpecLine)
  local cCharColor,cBoxColor,aChars
  local i,j,cP1,cP2,cP3,cP4,cP5,cP6,cP7,cP8,cP9,cP10

  if lAbout; return( nil ); endif

  cCharColor:=ListAsArray(m->Color:Desk)[nEnhanced]
  cBoxColor:=ListAsArray(m->Color:Menu)[nNormal]
  aChars:={ ;
  {" ۱  ",;
   "۱  ۱ ",;
   "۱ ۱ ",;
   "۱۱ ",;
   "۱۱ ",;
   "۱ ۱ ",;
   " ۱  "},;
  ;
  {"  ۱  ",;
   "۱  ",;
   "  ۱  ",;
   "  ۱  ",;
   "  ۱  ",;
   "  ۱  ",;
   " ۱ "},;
  ;
  {" ۱  ",;
   "۱  ۱ ",;
   "     ۱ ",;
   "   ۱   ",;
   " ۱     ",;
   "۱      ",;
   "۱ "},;
  ;
  {" ۱  ",;
   "۱  ۱ ",;
   "     ۱ ",;
   "  ۱  ",;
   "     ۱ ",;
   "۱  ۱ ",;
   " ۱  "},;
  ;
  {"    ۱  ",;
   "   ۱  ",;
   "  ۱۱  ",;
   " ۱ ۱  ",;
   "۱ ",;
   "     ۱  ",;
   "    ۱ "},;
  ;
  {"۱ ",;
   "۱      ",;
   "۱  ",;
   "     ۱ ",;
   "     ۱ ",;
   "۱  ۱ ",;
   " ۱  "},;
  ;
  {" ۱  ",;
   "۱  ۱ ",;
   "۱      ",;
   "۱  ",;
   "۱  ۱ ",;
   "۱  ۱ ",;
   " ۱  "},;
  ;
  {"۱ ",;
   "۱  ۱ ",;
   "     ۱ ",;
   "    ۱  ",;
   "   ۱   ",;
   "  ۱    ",;
   "  ۱    "},;
  ;
  {" ۱  ",;
   "۱  ۱ ",;
   "۱  ۱ ",;
   " ۱  ",;
   "۱  ۱ ",;
   "۱  ۱ ",;
   " ۱  "},;
  ;
  {" ۱  ",;
   "۱  ۱ ",;
   "۱  ۱ ",;
   " ۱ ",;
   "     ۱ ",;
   "۱  ۱ ",;
   " ۱  "},;
  ;
  nil,nil,nil,nil,nil,nil,nil,;
  ;
  {" ۱  ",;
   "۱  ۱ ",;
   "۱  ۱ ",;
   "۱ ",;
   "۱  ۱ ",;
   "۱  ۱ ",;
   "۱  ۱ "},;
  ;
  {"۱  ",;
   " ۱  ۱ ",;
   " ۱  ۱ ",;
   " ۱   ",;
   " ۱  ۱ ",;
   " ۱  ۱ ",;
   "۱  "},;
  ;
  {" ۱  ",;
   "۱  ۱ ",;
   "۱      ",;
   "۱      ",;
   "۱      ",;
   "۱  ۱ ",;
   " ۱  "},;
  ;
  {"۱  ",;
   " ۱  ۱ ",;
   " ۱  ۱ ",;
   " ۱  ۱ ",;
   " ۱  ۱ ",;
   " ۱  ۱ ",;
   "۱  "},;
  ;
  {"۱ ",;
   "۱     ",;
   "۱     ",;
   "۱  ",;
   "۱     ",;
   "۱     ",;
   "۱ "},;
  ;
  {"۱ ",;
   "۱     ",;
   "۱     ",;
   "۱  ",;
   "۱     ",;
   "۱     ",;
   "۱     "},;
  ;
  {" ۱  ",;
   "۱  ۱ ",;
   "۱      ",;
   "۱      ",;
   "۱ ۱ ",;
   "۱  ۱ ",;
   " ۱  "},;
  ;
  {"۱  ۱ ",;
   "۱  ۱ ",;
   "۱  ۱ ",;
   "۱ ",;
   "۱  ۱ ",;
   "۱  ۱ ",;
   "۱  ۱ "},;
  ;
  {" ۱  ",;
   " ۱  ",;
   " ۱  ",;
   " ۱  ",;
   " ۱  ",;
   " ۱  ",;
   " ۱  "},;
  ;
  {"     ۱ ",;
   "     ۱ ",;
   "     ۱ ",;
   "     ۱ ",;
   "     ۱ ",;
   "۱  ۱ ",;
   " ۱  "},;
  ;
  {"۱  ۱ ",;
   "۱ ۱  ",;
   "۱۱   ",;
   "۱    ",;
   "۱۱   ",;
   "۱ ۱  ",;
   "۱  ۱ "},;
  ;
  {"۱     ",;
   "۱     ",;
   "۱     ",;
   "۱     ",;
   "۱     ",;
   "۱     ",;
   "۱ "},;
  ;
  {"۱   ۱ ",;
   "۱ ۱ ",;
   "۱ ",;
   "۱۱۱ ",;
   "۱   ۱ ",;
   "۱   ۱ ",;
   "۱   ۱ "},;
  ;
  {"۱   ۱ ",;
   "۱  ۱ ",;
   "۱ ۱ ",;
   "۱۱۱ ",;
   "۱ ۱ ",;
   "۱  ۱ ",;
   "۱   ۱ "},;
  ;
  {" ۱  ",;
   "۱  ۱ ",;
   "۱  ۱ ",;
   "۱  ۱ ",;
   "۱  ۱ ",;
   "۱  ۱ ",;
   " ۱  "},;
  ;
  {"۱  ",;
   "۱  ۱ ",;
   "۱  ۱ ",;
   "۱  ",;
   "۱      ",;
   "۱      ",;
   "۱      "},;
  ;
  {" ۱    ",;
   "۱  ۱   ",;
   "۱  ۱   ",;
   "۱  ۱   ",;
   "۱ ۱   ",;
   "۱  ۱  ",;
   " ۱۱ "},;
  ;
  {"۱  ",;
   "۱  ۱ ",;
   "۱  ۱ ",;
   "۱  ",;
   "۱۱   ",;
   "۱ ۱  ",;
   "۱  ۱ "},;
  ;
  {" ۱  ",;
   "۱  ۱ ",;
   "۱      ",;
   " ۱  ",;
   "     ۱ ",;
   "۱  ۱ ",;
   " ۱  "},;
  ;
  {"۱ ",;
   "   ۱    ",;
   "   ۱    ",;
   "   ۱    ",;
   "   ۱    ",;
   "   ۱    ",;
   "   ۱    "},;
  ;
  {"۱  ۱ ",;
   "۱  ۱ ",;
   "۱  ۱ ",;
   "۱  ۱ ",;
   "۱  ۱ ",;
   "۱  ۱ ",;
   " ۱  "},;
  ;
  {"۱   ۱ ",;
   "۱   ۱ ",;
   "۱   ۱ ",;
   "۱   ۱ ",;
   " ۱ ۱  ",;
   "  ۱   ",;
   "   ۱    "},;
  ;
  {"۱   ۱ ",;
   "۱   ۱ ",;
   "۱   ۱ ",;
   "۱۱۱ ",;
   "۱ ",;
   "۱ ۱ ",;
   "۱   ۱ "},;
  ;
  {"۱   ۱ ",;
   " ۱ ۱  ",;
   "  ۱   ",;
   "   ۱    ",;
   "  ۱   ",;
   " ۱ ۱  ",;
   "۱   ۱ "},;
  ;
  {"۱   ۱ ",;
   "۱   ۱ ",;
   " ۱ ۱  ",;
   "  ۱   ",;
   "   ۱    ",;
   "   ۱    ",;
   "   ۱    "},;
  ;
  {"۱ ",;
   "     ۱  ",;
   "    ۱   ",;
   "   ۱    ",;
   "  ۱     ",;
   " ۱      ",;
   "۱ "},;
  ;
  {"      ",;
   "      ",;
   "      ",;
   "      ",;
   "      ",;
   "      ",;
   "      "},;
  ;
  {"       ",;
   "       ",;
   "       ",;
   "       ",;
   "       ",;
   "       ",;
   "۱ "} }

  aAboutScrn:=SaveScr(1,0,MaxRow()-1)
  SetCursor(SC_NONE)

  default cAuthor  to ResTxt(001)
  default cEndUser to ""

  if Len(cProgName)>8; Abort("ProgName too long."); endif
  cProgName := StrTran( Upper(cProgName), " ", "[")
  cProgName := StrTran( Upper(cProgName), "_", "\")

  cP1:=cP2:=cP3:=cP4:=cP5:=cP6:=cP7:=cP8:=cP9:=cP10:=""

  for i:=1 to Len(cProgName)
    j := Asc( SubStr( cProgName, i, 1 ) ) - Asc("0") + 1
    cP1 += aChars[j,1]
    cP2 += aChars[j,2]
    cP3 += aChars[j,3]
    cP4 += aChars[j,4]
    cP5 += aChars[j,5]
    cP6 += aChars[j,6]
    cP7 += aChars[j,7]
  endfor

  i:=Len(cP1)-1
  cP1 :=Left(cP1,i)
  cP2 :=Left(cP2,i)
  cP3 :=Left(cP3,i)
  cP4 :=Left(cP4,i)
  cP5 :=Left(cP5,i)
  cP6 :=Left(cP6,i)
  cP7 :=Left(cP7,i)
  cP8 :=ResTxt(004)+Transform(nVersion,"9.99")
  cP9 :=iif(cEndUser=="","",ResTxt(005)+cEndUser)
  cP10:="Copyright (c) "+LTrim(Str(nYear))+", "+cAuthor

  @ 3,2,19,77 box B_DOUBLE_SINGLE+" " color cBoxColor

  @ 3+2,3 say Padc(cP1,74) color cCharColor
  @ 3+3,3 say Padc(cP2,74) color cCharColor
  @ 3+4,3 say Padc(cP3,74) color cCharColor
  @ 3+5,3 say Padc(cP4,74) color cCharColor
  @ 3+6,3 say Padc(cP5,74) color cCharColor
  @ 3+7,3 say Padc(cP6,74) color cCharColor
  @ 3+8,3 say Padc(cP7,74) color cCharColor
  if cSpecLine<>nil
    @ 3+10,3 say Padc(cP8,74) color cBoxColor
    @ 3+11,3 say Padc(cSpecLine,74) color cBoxColor
  else
    @ 3+11,3 say Padc(cP8,74) color cBoxColor
  endif
  @ 3+12,3 say Padc(cP9,74) color cBoxColor
  @ 3+13,3 say Padc(cP10,74) color cBoxColor
  @ 3+14,3 say Padc(ResTxt(006),74) color cBoxColor
  lAbout:=true
  return(true)  //AboutOn()


//*****************************************************************************
// AboutOff(lKeepCursor) --> true/false
// Restore screen previously modified vith AboutOn(...)
//
function AboutOff(lKeepCursor)
  local R:=Row(),C:=Col()
  if lAbout
    lAbout:=false
    RestScr(aAboutScrn)
    if lKeepCursor; SetPos(R,C); endif
    return(true)
  endif
  return(false)

//-------------------------------------------------- eof (c)JHK ---------------
