//*****************************************************************************
// C_Loc.prg
// Location class for OBJECT v2.03
// Copyright (c) 1991, JHK, JHK-Software, Piestany
// Please compile with: /N/M/W/A
//-----------------------------------------------------------------------------

#include "Object.ch"

create class Loc
  export:
  var Row     // 3
  var Col     // 4
  method New=LocNew              //o:New()
  method Init=LocInit            //o:Init(Row,Col)  //save parameters into instvar vars
  method Get=LocGet              //o:Get()          //save location
  method Set=LocSet              //o:Set()          //restore location
  endclass


//*****************************************************************************
// Loc:New() --> self
// initialize new object
//
constructor LocNew()
  ::Row:= 3
  ::Col:= 4
  return(self)


//*****************************************************************************
// Loc:Init(Row,Col) --> true
// initialize location
//
method function LocInit(Row,Col)
  store value Row into ::Row
  store value Col into ::Col
  return(true)


//*****************************************************************************
// Loc:Get() --> true
// get current location from hw and save it
//
method function LocGet()
  ::Row:=Row()          //save row
  ::Col:=Col()          //save col
  return(true)


//*****************************************************************************
// Loc:Set() --> true
// Set current location into hw
//
method function LocSet()
  SetPos(::Row,::Col) //restore location
  return(true)

//------------------------------------------------------- eof (c)JHK ----------

