//*****************************************************************************
// C_Cursor.prg
// Cursor class for OBJECT v2.03
// Copyright (c) 1991, JHK, JHK-Software, Piestany
// Please compile with: /N/M/W/A
//-----------------------------------------------------------------------------

#include "Object.ch"
#include "SetCurs.ch"


create class Cursor from Loc
  export:
  var Size                  // SC_NONE
  method New=CursorNew      //o:New()
  method Init=CursorInit    //o:Init(Row,Col,Size)     //save parameters into instvar vars
  method Get=CursorGet      //o:Get()                  //save cursor
  method Set=CursorSet      //o:Set()                  //restore cursor
  endclass


//*****************************************************************************
// Cursor:New() --> self
// initialize new object
//
constructor CursorNew()
  ::Size:= SC_NONE
  return(self)


//*****************************************************************************
// Cursor:Init(Row,Col,Size) --> true
// initialize cursor object.
//
method function CursorInit(Row,Col,Size)
  ::super(Loc):Init(Row,Col)
  store value Size into ::Size
  return(true)


//*****************************************************************************
// Cursor:Get() --> true
// get current cursor from hw and put it into instvars of Cursor.
//
method function CursorGet()
  ::super(Loc):Get()   //save Row,Col
  ::Size:=SetCursor()  //save cursor size
  return(true)


//*****************************************************************************
// Cursor:Set() --> true
// Set cursor from instvars into hw.
//
method function CursorSet()
  ::super(Loc):Set()   //set position of cursor
  SetCursor(::Size)    //restore cursor size
  return(true)

//------------------------------------------------------- eof (c)JHK ----------

