//*****************************************************************************
// C_Choice.prg
// AChoice menu class for OBJECT v2.03
// Copyright (c) 1991, JHK, JHK-Software, Piestany
// Compile with: /N/M/W/A
//-----------------------------------------------------------------------------

#include "InKey.ch"
#include "AChoice.ch"
#include "Object.ch"

static CurChoice:=nil   //currently active choice object

create class Choice from Win
  export:
  var Items      // {}                  //{"item1",...}
  var SelItems   // {}                  //{lSelectable,...}
  var Cursor     // (object of Cursor)
  var Choice     // 1                   //user selected
  var Top        // 0                   //top item in menu
  var CanAppend  // false               //append/delete command allowed
  var InsBlock   // {|o|nil}            //array insert_row_code_block
  var DelBlock   // {|o|nil}            //array delete_row_code_block
  var InRow      // 0                   //input values, need for reinit
  var InCol      // 0                   // after Ins/Del command
  var InCurSize  // 0                    // ...
  method New=ChoiceNew                   //o:New()
  method Init=ChoiceInit                 //o:Init(Name,R,C,CurSize,Items,SelItems,Clr,Shadow)
  method FastInit=ChoiceFastInit         //o:FastInit(Name,R,C,CurSize,Items,SelItems,Clr,Shadow)
  method Process=ChoiceProcess           //o:Process()
  method Done=ChoiceDone                 //o:Done()
  endclass


//*****************************************************************************
// Choice:New() --> self
// initialize new object
//
constructor ChoiceNew()
  ::Items:= {}
  ::SelItems:= {}
  ::Cursor:= (object of Cursor)
  ::Choice:= 1
  ::Top:= 0
  ::CanAppend:= false
  ::InsBlock:= {|o|nil}
  ::DelBlock:= {|o|nil}
  ::InRow:= 0
  ::InCol:= 0
  ::InCurSize:= 0
  return(self)


//*****************************************************************************
// Choice:Init(Name,R,C,CurSize,Items,SelItems,Clr,Shadow) --> true
// initialize new simple menu and draw it.
//
method function ChoiceInit(Name,R,C,CurSize,Items,SelItems,Clr,Shadow)
  local Color
  ::FastInit(Name,R,C,CurSize,Items,SelItems,Clr,Shadow)
  ::Paint()
  Color:=SetColor(::Color)
  StuffKey(K_ENTER)
  AChoice(::Row+1,::Col+2,::Row+::RowSize,::Col+::ColSize-1,Items,SelItems,,::Choice,::Top)
  ShowTime()
  SetColor(Color)
  return(true)


//*****************************************************************************
// Choice:FastInit(Name,R,C,CurSize,Items,SelItems,Clr,Shadow) --> true
// initialize new simple menu, without drawing.
//
method function ChoiceFastInit(Name,R,C,CurSize,Items,SelItems,Clr,Shadow)
  local Rs,Cs
  ::InRow:=R
  ::InCol:=C
  ::InCurSize:=CurSize
  Rs:=Min(Len(Items),MaxRow()-7)
  Cs:=Min(aWidth(Items)+2,MaxCol()-9)
  if Empty(SelItems)
    SelItems:=Array(Len(Items))
    AFill(SelItems,true)
  endif
  ::Cursor:Get()
  ::super(Win):GoodInit(Name,R,C,Rs,Cs,CurSize,Clr,Shadow)
  ::Items:=Items
  ::SelItems:=SelItems
  return(true)


//*****************************************************************************
// Choice:Process() --> nChoice
// allow user select one from menu items.
//
method function ChoiceProcess()
  local Key
  local Home,End
  local OldChoice:=CurChoice
  local Color:=SetColor(::Color)
  CurChoice:=self
  SaveDOut(ResTxt(140)+if(::CanAppend,","+ResTxt(143),""))
  Home:=SetKey(K_HOME,{||StuffKey(K_CTRL_PGUP)})
  End:=SetKey(K_END,{||StuffKey(K_CTRL_PGDN)})
  SaveHelpIdx({16})
  repeat
    if !::Visible; ::Paint(); endif
    DisableHelp()
    SetKey(nWaitForKey,{||WaitKey()})
    StuffKey(nWaitForKey)
    AChoice(::Row+1,::Col+2,::Row+::RowSize,::Col+::ColSize-1,::Items,::SelItems,"AChoiceFnc",::Choice,::Top)
    SetKey(nWaitForKey,)
    EnableHelp()
    if ::Choice==0
      Key:=LastKey()
      if Key==K_INS; Eval(::InsBlock,self); endif
      if Key==K_DEL; Eval(::DelBlock,self); endif
      if Key==K_INS or Key==K_DEL
        ::Hide()
        ::FastInit(::Name,::InRow,::InCol,::InCurSize,::Items,::SelItems,::Color,::Shadow)
      endif
    endif
  until ::Choice<>0
  RestHelpIdx()
  SetKey(K_HOME,Home)
  SetKey(K_END,End)
  RestDOut()
  CurChoice:=OldChoice
  SetColor(Color)
  return(::Choice)


static procedure WaitKey()
  @ CurChoice:Row+CurChoice:Top+1,CurChoice:Col+2 say CurChoice:Items[CurChoice:Choice] color ListAsArray(SetColor())[nEnhanced]
  while NextKey()==0; ShowTime(); endwhile
  @ CurChoice:Row+CurChoice:Top+1,CurChoice:Col+2 say CurChoice:Items[CurChoice:Choice]
  return


function AChoiceFnc(Mode,Idx,Top)
  local nKey:=LastKey()
  local r:=AC_CONT
  CurChoice:Top:=Top
  CurChoice:Choice:=Idx
  if Mode==AC_HITTOP and Set(_SET_WRAP)
    StuffKey(K_CTRL_PGDN)
  elseif Mode==AC_HITBOTTOM and Set(_SET_WRAP)
    StuffKey(K_CTRL_PGUP)
  elseif Mode==AC_EXCEPT
    if Upper(Chr(nKey)) $ "ABCDEFGHIJKLMNOPQRSTUYVWXYZ0123456789"
      StuffKeys(" ")
      retur(AC_GOTO)
    elseif nKey==K_ENTER or nKey==K_CTRL_RET
      CurChoice:Choice:=Idx
      r:=AC_SELECT
    elseif nKey==K_ESC or nKey==nSwapTask
      CurChoice:Choice:=-Idx
      r:=AC_ABORT
    elseif (nKey==K_INS or nKey==K_DEL) and CurChoice:CanAppend
      CurChoice:Choice:=0
      r:=AC_SELECT
    endif
  endif
  if NextKey()==0; StuffKey(nWaitForKey); endif
  return(r)


//*****************************************************************************
// Choice:Done() --> true
// destroy the simple menu.
//
method function ChoiceDone()
  ::Hide()
  ::Cursor:Set()
  return(true)

//------------------------------------------------------- eof (c)JHK ----------

