//*****************************************************************************
// C_Brows.prg
// Simple Browse class for OBJECT v2.03
// Copyright (c) 1991, JHK, JHK-Software, Piestany
// Please compile with: /N/M/W/A
//-----------------------------------------------------------------------------

#include "Set.ch"
#include "InKey.ch"
#include "Object.ch"
#include "SetCurs.ch"

static originSkipper     //TBrowseNew():SkipBlock

create class Browse from Task
  export:
  var MoreRecords      // true                  //used only for help F1
  var MaskFeature      // false                 //see the Mask class
  var CanShowSkip      // false                 //see Browse::EndInit()
  var CanEdit          // true                  //editting allowed
  var CanAppend        // true                  //append allowed (copy last array item)
  var CanSwap          // true                  //swap state of browse
  var CanSkip          // true                  //allow skip for Form mode
  var FormActive       // false                 //current state of this object
  var CanMoveCursor    // true                  //move cursor after edit field in direction...
  var Direction        // K_RIGHT               //can be: Up,Down,Left,Right
  var QuickEdit        // true                  //directly edit in Browse (else need press K_ENTER)
  var SetConfirm       // Set(_SET_CONFIRM)     //local SET CONFIRM value
  var AddMsg           // ""                    //append this message into dialogue line
  var InsBlock         // {|o|nil}              //insert_row_code_block
  var DelBlock         // {|o|nil}              //delete_row_code_block
  var PreSkip          // nil       //{||true}  //preSkip function
  var PostSkip         // nil       //{||nil}   //postSkip function
  var InfoBlock        // {|o|nil}              //evaluate before waiting for key
  var TestVRecord      // {|o,g|true}           //disable editing for virtual record, (abstract method for DBrowse)
  var GetList          // {}                    //List of all gets in current object
  var DoGetList        // {}                    //List of all DoGet code_blocks in current object
  var DelGet           // {}                    //list temporary deleted gets from GetList
  var DelDoGet         // {}                    //list temporary deleted DoGets from DoGetList
  var Tb               // nil                   //TBrowse object
  var Freeze           // 0                     //freeze for TBrowse and Form
  var FormTop          // 1                     //form: first column in window
  var Form             // (object of Window)    //form: R,C,Rs,Cs,MaxRows,MaxCols (used only as record structure)
  var SetUp            // false                  //after method PostInit() will be always true!
  method New=BrowseNew                       //o:New()
  method Init=BrowseInit                     //o:Init(Name,R,C,Rs,Cs,Clr,Shadow)
  method GoodInit=BrowseGoodInit             //o:GoodInit(Name,R,C,Rs,Cs,CurSize,Clr,Shadow)
  method AddBlock=BrowseAddBlock             //o:AddBlock(LongName,ShortName,VarName,Block,DoGet,Picture,When,Valid)
  method AddGet=BrowseAddGet                 //o:AddGet(Get,DoGet)
  method PostInit=BrowsePostInit             //o:PostInit()         //need for good initialize of form state this object
  method DoGet=BrowseDoGet                   //o:DoGet()            //process editting for one field
  method VPaint=BrowseVPaint                 //o:VPaint()           //draw inside window
  method SwapForm=BrowseSwapForm             //o:SwapForm()         //change current state of this object
  method VProcess=BrowseVProcess             //o:VProcess()         //Done() will be wirtual
  method Process=BrowseProcess               //o:Process()          //look for SetUp (has been PostInit()?)
  method DoForm=BrowseDoForm                 //o:DoForm()           //called from VProcess(), Form mode
  method DoBrowse=BrowseDoBrowse             //o:DoBrowse()         //called from VProcess(), Browse mode
  method FormPaint=BrowseFormPaint           //o:FormPaint()        //VPaint() for Form
  method MaskPaint=BrowseMaskPaint     //abstract method defined in Mask class !!!
  endclass


//*****************************************************************************
// Browse:New() --> self
// initialize new object
//
constructor BrowseNew()
  ::Color+=", "+ListAsArray(m->Color:Desk)[nNormal]
  ::MoreRecords:= true
  ::MaskFeature:= false
  ::CanShowSkip:= false
  ::CanEdit:= true
  ::CanAppend:= true
  ::CanSwap:= true
  ::CanSkip:= true
  //::PreSkip:= {||true}
  //::PostSkip:= {||nil}
  ::FormActive:= false
  ::CanMoveCursor:= true
  ::Direction:= K_RIGHT
  ::QuickEdit:= true
  ::SetConfirm:= Set(_SET_CONFIRM)
  ::AddMsg:= ""
  ::InsBlock:= {|o|nil}
  ::DelBlock:= {|o|nil}
  ::InfoBlock:= {|o|nil}
  ::TestVRecord:= {|o,g|true}  //self_object,Get_object
  ::GetList:= {}
  ::DoGetList:= {}
  ::DelGet:= {}
  ::DelDoGet:= {}
  ::Tb:= nil
  ::Freeze:= 0
  ::FormTop:= 1
  ::Form:= (object of Window)
  ::SetUp:= false
  return(self)


//*****************************************************************************
// Browse:Init(Name,R,C,Rs,Cs,Clr,Shadow) --> true
// initialize new view object
//
method function BrowseInit(Name,R,C,Rs,Cs,Clr,Shadow)
  ::super(Task):Init(Name,R,C,Rs,Cs,Clr,Shadow)
  return(EndInit(self))


//*****************************************************************************
// Browse:GoodInit(Name,R,C,Rs,Cs,CurSize,Clr,Shadow) --> true
// initialize new view object
//
method function BrowseGoodInit(Name,R,C,Rs,Cs,CurSize,Clr,Shadow)
  ::super(Task):GoodInit(Name,R,C,Rs,Cs,CurSize,Clr,Shadow)
  return(EndInit(self))


//-----------------------------------------------------------------------------
// Browse::EndInit() --> nil
// initialize TBrowse object
//
static function EndInit(Browse)
  local b:=TBrowseDb()
  originSkipper:=b:SkipBlock
  b:Freeze:=Browse:Freeze
  b:HeadSep:=""
  b:ColSep:="   "
  b:ColPos:=1
  Browse:Tb:=b
  return(true)


//*****************************************************************************
// Browse:AddBlock(LongName,ShortName,VarName,Block,DoGet,Picture,When,Valid) --> nil
// create simple_get_object and add it into Browse
//
method function BrowseAddBlock(LongName,ShortName,VarName,Block,DoGet,Picture,When,Valid)
  local Get
  local OldC:=SetColor(::Color)
  default ShortName to ""
  default LongName to ShortName
  default VarName to ShortName
  if( At("->",VarName)==0, VarName:="MEMORY->"+VarName, )
  Get:=GetNew(0,0,Block,VarName)
  Get:Picture:=Picture
  Get:PreBlock:=When
  Get:PostBlock:=Valid
  Get:Cargo:=Array(nLenCargo)
  Get:Cargo[nLongName]:=LongName
  Get:Cargo[nShortName]:=ShortName
  return(::AddGet(Get,DoGet))


//*****************************************************************************
// Browse:AddGet(Get,DoGet) --> true
// add new get field into object
//
method function BrowseAddGet(Get,DoGet)
  local c
  default DoGet to {|o|o:DoGet()}
  AAdd(::GetList,Get)
  AAdd(::DoGetList,DoGet)
  c:=TbColumnNew(Get:Cargo[nShortName],{|v|Transform(Eval(Get:Block,v),Get:Picture)})
  c:DefColor:={nNormal,nUnSelect}
  ::Tb:AddColumn(c)
  if Empty(c:Heading); ::Tb:HeadSep:=nil; endif
  return(true)


//*****************************************************************************
// Browse:PostInit() --> true
//need for good initialize of form state this object
//
method function BrowsePostInit()
  local ar:={}
  local MCol:=0
  local Rs:=Min(::Tb:ColCount,MaxRow()-3)
  local Cs:=Len(::Name)+9
  IEval(::Tb:ColCount,{|i|Cs:=Max(Cs,GetColSize(@MCol,@ar,::GetList[i]))})
  Cs++
  IEval(::Tb:ColCount,{|i|SetColSize(ar[i],::GetList[i],Cs)})
  Cs:=Min( Max(Cs+2, Len(::Name)+11), MaxCol()-1)
  ::Form:super(Box):GoodInit(,-3,-3,Rs,Cs)
  ::Form:MaxRows:=Rs
  ::Form:MaxCols:=Cs
  ::Form:MinCols:=MCol+3
  if ::FormActive
    SwapRCInfo(self)
  endif
  if !Empty(::PreSkip) or !Empty(::PostSkip) or ::CanShowSkip
    ::Tb:SkipBlock:={|n|Skipper(n,self)}
    default ::PreSkip:={||true}
    default ::PostSkip:= {||nil}
  endif
  ::Tb:Freeze:=::Freeze
  ::Tb:ColPos:=::Freeze+1
  ::SetUp:=true
  return(true)

static function Skipper(n,Browse)
  local i:=0
  if Eval(Browse:PreSkip,Browse)
    if Browse:CanShowSkip; SaveDOut(ResTxt(176)); endif
    i:=Eval(originSkipper,n)
    if Browse:CanShowSkip; RestDOut(); endif
    Eval(Browse:PostSkip,Browse)
  endif
  return(i)

static function GetColSize(MCol,ar,get)
  local ln
  ln:=Len(Transform(get:VarGet(),Get:Picture))
  AAdd(ar,ln)
  MCol:=Max(MCol,ln)
  return(Len(get:Cargo[nLongName])+ln)

static function SetColSize(ln,get,Cs)
  get:Cargo[nLongName]:=" "+PadR(get:Cargo[nLongName],Cs-ln,".")
  return(true)


//*****************************************************************************
// Browse:DoGet() --> true
// default DoGet method: editting for one field in Browse mode
//
method function BrowseDoGet()
  local Pict
  local n:=::Tb:ColPos
  local Get:=::GetList[n]
  if ::FormActive and ::MaskFeature
    Get:Row:=::Row+Get:Cargo[nRowOffset]
    Get:Col:=::Col+Get:Cargo[nColOffset]
    EditGet(Get,::CanEdit)
  elseif ::FormActive
    Get:Row:=::Row+::Freeze-::FormTop+::Tb:ColPos+1
    Get:Col:=::Col+Get:Cargo[nColOffset]
    EditGet(Get,::CanEdit)
  else //!FormActive
    if ::CanEdit
      Pict:=Get:Picture                          //save picure
      SetGoodSize(@Get,::Tb:ColWidth(n))
      EditGetMsg(Get,::CanEdit)
      Get:Picture:=Pict                          //restore picture
      ::Tb:RefreshCurrent()
      if LastKey()==K_ENTER and ::CanMoveCursor; StuffKey(::Direction); endif
    else //!CanEdit
      if NextKey()<>0 and NextKey()<>K_ENTER; InkeyWait(); endif
    endif
  endif
  return(true)


//-----------------------------------------------------------------------------
// SetGoodSize(get,nSize) --> true
// set good size for edited string, used in method DoGet().
//
static function SetGoodSize(g,nSize)
  local c
  if !(g:Type=="C"); return(true); endif  //not a string
  c:=Transform(g:VarGet(),g:Picture)
  if Len(c)<=nSize; return(true); endif   //size is ok
  c:="@S"+NTrim(nSize)
  if Empty(g:Picture);           g:Picture:=c
  elseif Left(g:Picture,1)=="@"; g:Picture:=c+SubStr(g:Picture,2)
  else;                          g:Picture:=c+" "+g:Picture
  endif
  return(true)


//*****************************************************************************
// Browse:VPaint() --> true
// paint this object, this method is called from Window:Paint()!
//
method function BrowseVPaint()
  local t,b,au
  //DispEnd()  //begin is in Window:Paint()
    ::Tb:ColorSpec:=::Color
    if ::MaskFeature and ::FormActive  //abstract rutine for class Mask
      ::MaskPaint()
    elseif ::FormActive
      if ::Tb:ColPos<::FormTop                           //ColPos is OutOfRange (up) ?
        ::FormTop:=::Tb:ColPos                           //yes, correct it
      elseif ::FormTop+::RowSize-::Freeze<=::Tb:ColPos   //ColPos is OutOfRange (down) ?
        ::FormTop:=::Tb:ColPos-::RowSize+::Freeze+1      //yes, correct it
      endif
      //if Len(::DoGet)-::FormTop+1<::RowSize   //update FormTop
      //  ::FormTop:=Len(::DoGet)-::RowSize+1   //for maximize
      //endif                                   //window
      ::FormPaint()
    else
      t:=Second()
      b:=::Tb
      au:=b:AutoLite
      b:nTop:=::Row+1
      b:nLeft:=::Col+1
      b:nBottom:=::Row+::RowSize
      b:nRight:=::Col+::ColSize
      b:Configure()
      b:AutoLite:=false
      while !b:Stabilize() and Second()-t<nVPaintWaitSec and NextKey()==0; endwhile
      b:AutoLite:=au
    endif
  //DispBegin()
  return(true)


//-----------------------------------------------------------------------------
// Browse:FormPaint() --> true
// VPaint() for Form
//
method function BrowseFormPaint()
  local j:=Min(::RowSize-::Freeze,::Tb:ColCount-::FormTop+1)
  local ClrNorm:=::Color
  local ClrUns:=ListAsArray(::Color)[nUnSelect]
  IEval(::Freeze,{|i|DispRow(self,i,::GetList[i],@ClrNorm,@ClrUns)})
  IEval(j,{|i|DispRow(self,i+::Freeze,::GetList[i+::FormTop-1],@ClrNorm,@ClrUns)})
  return(true)


//-----------------------------------------------------------------------------
// Browse::DispRow() --> true
// display one row from form
//
static function DispRow(Browse,i,Get,ClrNorm,ClrUns)
  local s1:=Get:Cargo[nLongName]
  local s2:=Transform(Get:VarGet(),Get:Picture)
  SetPos(Browse:Row+i,Browse:Col+1)
  DispOut(Left(s1,Browse:ColSize-Len(s2)-2),ClrNorm)
  DispOut(".",ClrNorm)
  Get:Cargo[nColOffset]:=Col()-Browse:Col
  DispOut(s2,ClrUns)
  DispOut(" ",ClrNorm)
  return(true)


//*****************************************************************************
// Browse:SwapForm() --> true
// reconfigure this object
//
method function BrowseSwapForm()
  SwapRCInfo(self)
  ::FormActive:=!::FormActive
  ::RePaint()
  return(true)

static function SwapRCInfo(Browse)
  Swap(Browse:Row,Browse:Form:Row)
  Swap(Browse:Col,Browse:Form:Col)
  Swap(Browse:RowSize,Browse:Form:RowSize)
  Swap(Browse:ColSize,Browse:Form:ColSize)
  Swap(Browse:MaxRows,Browse:Form:MaxRows)
  Swap(Browse:MaxCols,Browse:Form:MaxCols)
  Swap(Browse:MinRows,Browse:Form:MinRows)
  Swap(Browse:MinCols,Browse:Form:MinCols)
  return(true)


//*****************************************************************************
// Browse:VProcess() --> true
// main edit loop
//
method function BrowseVProcess()
  local ah
  ::Tb:ColorSpec:=::Color
  Set(_SET_CONFIRM,::SetConfirm)
  repeat
    if ::FormActive
      ah:={2}
      if( ::MoreRecords, AAdd(ah,7), )
      AAdd(ah,if(::CanEdit,10,9))
    else
      ah:={2}
      if( ::CanAppend, AAdd(ah,3), )
      AAdd(ah, if(::CanEdit,5,4) )
      AAdd(ah, 6)
    endif
    if( !::UpFlag, AAdd(ah,1), )
    SaveHelpIdx(ah)
    if(::FormActive, ::DoForm(), ::DoBrowse())
    RestHelpIdx()
    if LastKey()==K_TAB and ::CanSwap; ::SwapForm(); endif
  until LastKey()<>K_TAB
  return(true)


//*****************************************************************************
// Browse:Process() --> nil
// work around PostInit()
//
method function BrowseProcess()
  if !::SetUp; ::PostInit(); endif
  return(::super(Task):Process())


//*****************************************************************************
// Browse:DoForm() --> true
// VProcess() for Form, main form loop
//
method function BrowseDoForm()
  local Ch,Get
  local c1:=::Color
  local c2:=ListAsArray(::Color)[nUnSelect]
  SaveDOut(if(::UpFlag,ResTxt(150),ResTxt(149))+if(::CanSwap,","+ResTxt(135),"")+if(!Empty(::AddMsg),","+::AddMsg,""))
  repeat
    if ::Tb:ColPos<=::Freeze       //lock frozen columns
      ::Tb:ColPos:=::Freeze+1
    endif
    if ::FormTop+::RowSize-::Freeze<=::Tb:ColPos   //ColPos is OutOfRange (down) ?
      ::FormTop:=::Tb:ColPos-::RowSize-::Freeze+1  //yes, correct it
    endif
    Eval(::InfoBlock, self)
    Eval(::DoGetList[::Tb:ColPos], self)
    Ch:=LastKey()
    do case
      case Ch==K_F9     and !::MaskFeature;  MoveColumn(self)
      case Ch==K_ALT_F9 and !::MaskFeature;  Freeze(self)
      *
      case Ch==K_SH_F9;     HideColumn(self)
      case Ch==K_CTRL_F9;   ShowColumn(self)
      *
      case Ch==K_UP;        GetUp(self,c1,c2)
      case Ch==K_DOWN;      GetDown(self,c1,c2)
      case Ch==K_ENTER;     GetDown(self,c1,c2)
      case Ch==K_CTRL_HOME; GetGoTop(self)
      case Ch==K_CTRL_END;  GetGoBottom(self)
      *
      case Ch==K_PGUP;      GetDbSkip(self,{||DbSkip(-1)})
      case Ch==K_PGDN;      GetDbSkip(self,{||DbSkip(+1)})
      case Ch==K_CTRL_PGUP; GetDbSkip(self,{||DbGoTop()})
      case Ch==K_CTRL_PGDN; GetDbSkip(self,{||DbGoBottom()})
      *
      case Ch==K_TAB;       exitif ::CanSwap  //task:swap (form<->browse)
      case Ch==K_ESC;       exit                   //task:done()
      case Ch==K_CTRL_RET;  exit                   //task:done()
      case Ch==nSwapTask;   exit                   //standart task swapping
    endcase
  endrepeat
  RestDOut()
  return(true)


static function GetUp(Browse,c1,c2)
  local R,C
  local n:=Browse:Tb:ColPos
  if n>Browse:Freeze+1
    n--
    if n<Browse:FormTop
      Browse:FormTop--
      if !Browse:MaskFeature
        R:=Browse:Row+Browse:Freeze+1
        C:=Browse:Col+1
        Scroll(R,C,R+Browse:RowSize-Browse:Freeze-1,C+Browse:ColSize-1,-1)
        DispRow(Browse,Browse:Freeze+n-Browse:FormTop+1,Browse:GetList[n],c1,c2)
      endif
    endif
  endif
  Browse:Tb:ColPos:=n
  return(true)


static function GetDown(Browse,c1,c2)
  local R,C
  local n:=Browse:Tb:ColPos
  if n<Len(Browse:GetList)
    n++
    if n>Browse:FormTop+Browse:RowSize-Browse:Freeze-1
      Browse:FormTop++
      if !Browse:MaskFeature
        R:=Browse:Row+Browse:Freeze+1
        C:=Browse:Col+1
        Scroll(R,C,R+Browse:RowSize-Browse:Freeze-1,C+Browse:ColSize-1,+1)
        DispRow(Browse,Browse:Freeze+n-Browse:FormTop+1,Browse:GetList[n],c1,c2)
      endif
    endif
  endif
  Browse:Tb:ColPos:=n
  return(true)


static function GetPgUp(Browse)
  local n:=Browse:Tb:ColPos
  if n>Browse:Freeze+1
    n-=Browse:RowSize-Browse:Freeze
    Browse:FormTop-=Browse:RowSize-Browse:Freeze
    if n<Browse:Freeze+1; n:=Browse:Freeze+1; endif
    if Browse:FormTop<Browse:Freeze+1; Browse:FormTop:=Browse:Freeze+1; endif
    if !Browse:MaskFeature
      Browse:Scroll(0)
      Browse:FormPaint(Browse)
    endif
  endif
  Browse:Tb:ColPos:=n
  return(true)


static function GetPgDn(Browse)
  local n:=Browse:Tb:ColPos
  if n<Len(Browse:GetList)
    n+=Browse:RowSize-Browse:Freeze
    if n>Len(Browse:GetList); n:=Len(Browse:GetList); endif
    if Browse:FormTop+Browse:RowSize-Browse:Freeze<Len(Browse:GetList)
      Browse:FormTop+=Browse:RowSize-Browse:Freeze
    endif
    if !Browse:MaskFeature
      Browse:Scroll(0)
      Browse:FormPaint(Browse)
    endif
  endif
  Browse:Tb:ColPos:=n
  return(true)


static function GetGoTop(Browse)
  if Browse:Tb:ColPos>Browse:Freeze+1
    Browse:Tb:ColPos:=Browse:FormTop:=Browse:Freeze+1
    if !Browse:MaskFeature
      Browse:FormPaint(Browse)
    endif
  endif
  return(true)


static function GetGoBottom(Browse)
  Browse:Tb:ColPos:=Len(Browse:GetList)
  Browse:FormTop:=Browse:Tb:ColPos-Browse:RowSize+Browse:Freeze+1
  if Browse:FormTop<Browse:Freeze+1; Browse:FormTop:=Browse:Freeze+1; endif
  if !Browse:MaskFeature
    Browse:FormPaint(Browse)
  endif
  return(true)


static function GetDbSkip(Browse,bBlock)
  local Rn
  if Browse:CanSkip
    if Empty(Browse:PreSkip) or Eval(Browse:PreSkip,Browse)
      if Browse:CanShowSkip; SaveDOut(ResTxt(176)); endif
      Rn:=RecNo()
      Eval(bBlock)            //can be: DbSkip(n),DbGoTop(),DbGoBottom()
      if RecNo()<=LastRec()   //not a virtual record
        Browse:RecNo:=RecNo()
        if Browse:MaskFeature
          Browse:MaskPaint()
        else
          Browse:FormPaint()
        endif
        Browse:SaveIn()
      else
        Go Rn
      endif
      if Browse:CanShowSkip; RestDOut(); endif
      if( !Empty(Browse:PostSkip), Eval(Browse:PostSkip,Browse), )
    endif
  endif
  return(true)


//*****************************************************************************
// Browse:DoBrowse() --> true
// VProcess() for Browse, main browse loop
//
method function BrowseDoBrowse()
  local Ch,g,x
  local b:=::Tb
  if b:nTop<>::Row+1 or b:nLeft<>::Col+1
    b:nTop:=::Row+1
    b:nLeft:=::Col+1
    b:nBottom:=::Row+::RowSize
    b:nRight:=::Col+::ColSize
    b:Configure()
  endif
  SaveDOut(if(::UpFlag,ResTxt(150),if(::CanAppend,ResTxt(151),ResTxt(149)))+if(::CanSwap,","+ResTxt(135),"")+if(!Empty(::AddMsg),","+::AddMsg,""))
  repeat
    if ::Tb:ColPos<=::Freeze       //lock frozen columns
      ::Tb:ColPos:=::Freeze+1
    endif
    while !::Tb:Stabilize() and NextKey()==0; endwhile
    SetCursor(SC_NONE)
    Eval(::InfoBlock, self)
    ReadHelpVar(::GetList[::Tb:ColPos]:Name)
    Ch:=PauseKey(0)
    ReadHelpVar("")
    do case
      case Ch==K_F9;      MoveColumn(self)
      case Ch==K_ALT_F9;  Freeze(self)
      case Ch==K_SH_F9;   HideColumn(self)
      case Ch==K_CTRL_F9; ShowColumn(self)
      *
      case Ch==K_DOWN;       ::Tb:Down(); ::Direction:=Ch
      case Ch==K_UP;         ::Tb:Up(); ::Direction:=Ch
      case Ch==K_PGDN;       ::Tb:PageDown()
      case Ch==K_PGUP;       ::Tb:PageUp()
      case Ch==K_CTRL_PGUP;  ::Tb:GoTop()
      case Ch==K_CTRL_PGDN;  ::Tb:GoBottom()
      *
      case Ch==K_HOME;       ::Tb:Home()
      case Ch==K_END;        ::Tb:End()
      case Ch==K_LEFT;       ::Tb:Left(); ::Direction:=Ch
      case Ch==K_RIGHT;      ::Tb:Right(); ::Direction:=Ch
      case Ch==K_CTRL_LEFT;  ::Tb:PanLeft()
      case Ch==K_CTRL_RIGHT; ::Tb:PanRight()
      case Ch==K_CTRL_HOME;  ::Tb:PanHome()
      case Ch==K_CTRL_END;   ::Tb:PanEnd()
      *
      case Ch==K_INS;  if ::CanAppend; Eval(::InsBlock, self); endif
      case Ch==K_DEL;  if ::CanAppend; Eval(::DelBlock, self); endif
      *
      case Ch==K_TAB;       exitif ::CanSwap   //task:swap (form<->browse)
      case Ch==K_ESC;       exit                    //task:done()
      case Ch==K_CTRL_RET;  exit                    //task:done()
      case Ch==nSwapTask;   exit                    //standart task swapping
      *
      otherwise
        if (Ch==K_ENTER or ::QuickEdit)
          while !::Tb:Stabilize(); endwhile
          SaveDOut(::AddMsg)
          g:=::GetList[::Tb:ColPos]
          g:Row:=Row()
          g:Col:=Col()
          if Transform(g:VarGet(),)==ResTxt(134)  //DBrowse! Memo_field in get!
            if Eval(::TestVRecord,self,g)
              SaveHelpIdx(if(::CanEdit,{12,1},{15,11,1}))
              Eval(g:PostBlock,g,::CanEdit)
              RestHelpIdx()
            endif
          else
            if LastKey()<>K_ENTER; StuffKey(LastKey()); endif
            SaveHelpIdx(if( ::CanEdit, {2,8,1}, {2,1}))
            Eval(::DoGetList[::Tb:ColPos], self)
            RestHelpIdx()
          endif
          RestDOut()
          exitif LastKey()==nSwapTask
        endif
    endcase
  endrepeat
  if !::IsDead; ::Tb:DeHilite(); endif
  RestDOut()
  return(true)


//-----------------------------------------------------------------------------
// Browse::Freeze() --> true
// lock any columns in Browse or rows in Form
//
static function Freeze(Browse)
  SaveDOut(Browse:AddMsg)
  Browse:Freeze:=EditItPrim(Browse:Freeze,ResTxt(020),,Browse:Row+Int(Browse:RowSize/2-1))
  RestDOut()
  if Browse:Freeze<0; Browse:Freeze:=0; Bell(); endif
  if Browse:Freeze>=Browse:Tb:ColCount; Browse:Freeze:=Browse:Tb:ColCount-1; Bell(); endif
  Browse:Tb:Freeze:=Browse:Freeze
  if Browse:Freeze>=Browse:FormTop; Browse:FormTop:=Browse:Freeze+1; endif
  if Browse:FormActive; Browse:Scroll(0); Browse:FormPaint(Browse); endif
  return(true)


//-----------------------------------------------------------------------------
// Browse::MoveColumn() --> true
// move current TbColumn
//
static function MoveColumn(Browse)
  local Ch,Col,Curs,R,Clr,n,i
  SaveDOut(ResTxt(139))
  Curs:=SetCursor()
  Clr:=Chr(Color2Num(ListAsArray(Browse:Color)[nUnSelect]))
  n:=Browse:Tb:ColPos
  repeat
    if Browse:FormActive
      SetCursor(SC_NONE)
      R:=Browse:Row+Browse:Freeze+n-Browse:FormTop+1
      RestScreen(R,Browse:Col+1,R,Browse:Col+Browse:ColSize, Transform(SaveScreen(R,Browse:Col+1,R,Browse:Col+Browse:ColSize), Replicate("X"+Clr,Browse:ColSize)))
    endif
    Ch:=PauseKey(0)
    do case
      case Ch=K_LEFT or Ch==K_UP
        if n>Browse:Freeze+1
          i:=n
          Col:=Browse:Tb:DelColumn(n)
          Browse:Tb:Left()
          n:=Browse:Tb:ColPos
          Browse:Tb:InsColumn(n,Col)
          Swap(Browse:GetList[i],Browse:GetList[n])
          Swap(Browse:DoGetList[i],Browse:DoGetList[n])
          if n<Browse:FormTop
            Browse:FormTop--
          endif
        endif
      case Ch=K_RIGHT or Ch==K_DOWN
        if n<Browse:Tb:ColCount
          i:=n
          Col:=Browse:Tb:DelColumn(n)
          Browse:Tb:Right()
          n:=Browse:Tb:ColPos
          Browse:Tb:InsColumn(n,Col)
          Swap(Browse:GetList[i],Browse:GetList[n])
          Swap(Browse:DoGetList[i],Browse:DoGetList[n])
          if n>=Browse:FormTop+Browse:RowSize-Browse:Freeze
            Browse:FormTop++
          endif
        endif
      otherwise
        Ch:=nSwapTask
    endcase
    if Browse:FormActive
      Browse:FormPaint(Browse)
    else
      while !Browse:Tb:Stabilize() and NextKey()==0; endwhile
    endif
  until Ch==nSwapTask
  SetCursor(Curs)
  RestDOut()
  return(true)


//-----------------------------------------------------------------------------
// Browse::HideColumn() --> true
// hide current TbColumn
//
static function HideColumn(Browse)
  local n:=Browse:Tb:ColPos
  returnif n<=Browse:Freeze with false
  returnif Len(Browse:GetList)<=(Browse:Freeze+1) with false
  Browse:Tb:DelColumn(n)
  AAdd(Browse:DelGet,ATrueDel(Browse:GetList,n))
  AAdd(Browse:DelDoGet,ATrueDel(Browse:DoGetList,n))
  if n>Browse:Tb:ColCount
    Browse:Tb:ColPos:=Browse:Tb:ColCount
  endif
  if Browse:FormActive
    Browse:Scroll(0)
    Browse:FormPaint(Browse)
  endif
  return(true)


//-----------------------------------------------------------------------------
// Browse::ShowColumn() --> true
// hide current TbColumn
//
static function ShowColumn(Browse)
  local n,g,c
  if !Empty(Browse:DelGet)
    n:=Browse:Tb:colPos
    ATrueIns(Browse:GetList,n,g:=ATailDel(Browse:DelGet))
    ATrueIns(Browse:DoGetList,n,ATailDel(Browse:DelDoGet))
    c:=TbColumnNew(g:Cargo[nShortName],g:Block)
    c:DefColor:={nNormal,nUnSelect}
    Browse:Tb:InsColumn(n,c)
    if Browse:FormActive
      Browse:FormPaint(Browse)
    endif
  endif
  return(true)


//-----------------------------------------------------------------------------
// Browse:MaskPaint() --> true
// abstract method for Mask() class
//
method function BrowseMaskPaint()
return(true)

//------------------------------------------------------- eof (c)JHK ----------

