/* This program changes the number of file handles that OS/2 provides it */
/* and executes another program giving the environment to that process */
/* Author: LaVern R. Ogden */
/*   Date: 11/22/92 */

#define INCL_DOSFILEMGR
#define INCL_DOSPROCESS

#include <os2.h>
#include <stdio.h>
#include <process.h>

static PID pidProc;

void main(int argc,char **argv) {
  LONG ReqCount;  /* number to add to maximum handle count */
  ULONG CurMaxFH; /* new count of handles */
  APIRET rc;      /* return code */

  if (argc<3) {
    printf("Not enough parameters were entered. Two or more are required.\n");
    exit(0);
  } 

  ReqCount=12;
  rc=DosSetRelMaxFH(&ReqCount,&CurMaxFH);

  if (rc!=0) {
    printf("DosSetRelMaxFH error: return code = %ld",rc);
    return;
  }

/*  printf("Number of available handles: %d\n",CurMaxFH); */

  pidProc = spawnvp(P_WAIT,argv[1], &argv[1]);
  if (pidProc==-1) {
    printf("Error occurred when running new process\n");  /* error occurred */
  }

  return;
}

