
:userdoc.
.* ******************************************************************
.*
.* OS/2 Presentation Manager Game Development Guide
.* Version 2.0 by Antonino Iannella, February 25th, 1996
.*
.* ******************************************************************
.*
:title.OS/2 PM Game Development Guide! Oh joy!
.*
:h1 res=1.Primer
.*
:font facename=Helv size=100x90.
:color fc=red.
:hp6.
:p.OS/2 Presentation Manager Game Development Guide
.*
:font facename=Helv size=30x20.
:p.Version 2.0 - by Antonino Iannella, February 25th, 1996
.*
:ehp6.
:font facename=default size=0x0.
:color fc=default.
.*
:artwork align=center name='finalin.bmp'.
.*
:p.Choose a section below:
.*
:ul.
:link reftype=hd res=2.
:li.Introduction
:elink.
:link reftype=hd res=3.
:li.Copyright information and distribution rights
:elink.
:link reftype=hd res=4.
:li.Archive contents
:elink.
:link reftype=hd res=7.
:li.Revision history
:elink.
:eul.
.*
:h2 res=2.Introduction
.*
:p.This document is intended to be a guide for OS/2 users (or wannabes) to see more high-quality 
native OS/2 games.  It is not designed to teach people how to write games, only as a reference 
guide for more information.  Alot of this guide also relates to writing general OS/2 applications.
.*
:p.If anyone finds mistakes in this guide, or has some information to contribute, please
:link reftype=hd res=24.
contact the author.
:elink.
Please do so even if you found this guide useful or not!
.*
:artwork align=center name='warpwv.bmp'.
.*
:h2 res=3.Copyright information and distribution rights
.*
:p.This guide's author is 
:link reftype=hd res=24.
Antonino Iannella.  
:elink.
 It is released into the public domain, and may be used by anyone.  It is freely distributable using any
medium or site.  It may not be sold. The author has no authority over the way that it is distributed.
  It may not be distributed on
the 
:link reftype=hd res=26.
Microsoft Network (MSN) 
:elink.
or used by 
:link reftype=hd res=26.
Microsoft 
:elink.
in any way.  A breach of this policy will result in legal action.
.*
:p.The author shall not be made responsible for any errors, or damage caused by this guide's 
contents, so don't hit your grandmother with it!
.*
:artwork align=center name='dalivis.bmp'.
.*
:hp1.
:p.This is what people who break this law will look like! &colon.-) (Courtesy of Salvador Dali).
:ehp1.
.*
:h2 res=4.GamDev2.ZIP archive contents
.*
:p.This archive must be distibuted with
:ul.
:li.GamDev2.inf     This file
:link reftype=hd res=5.
:li.FILE_ID.DIZ
:elink.
     BBS information file
:link reftype=hd res=6.
:li.GamDev2.txt
:elink.
     Site information file
:eul.
.*
:artwork align=center name='warn.bmp'.
.*
:h3 res=5.FILE_ID.DIZ
.*
:lines.

GamDev2.zip - PM Game development guide
A guide for finding more information relating
to OS/2 PM game development.
In OS/2 INF format.
by Mr Antonino Iannella
9308390r@lux.levels.unisa.edu.au

:elines.
.*
:h3 res=6.GamDev2.txt
.*
:lines.

       OS/2 Upload Information Template for ftp-os2.nmsu.edu

Archive Name:  GamDev2.zip
Program Description: (keep it under 60 characters)

A guide for finding more information relating to PM game development.

Operating System Versions:   OS/2 2.0 and above
Program Source:        none
Replaces:               none

Your name:             Antonino Iannella
Your email address:    9308390r@lux.levels.unisa.edu.au

Proposed directory for placement:    /pub/os2/info

:elines.
.*
:h2 res=7.Revision history
.*
:lines.

Version 1.0 - An Email message to a colleague gave me the idea to make a reference guide.
Version 1.1 - An introduction was added.
Version 2.0 - A large amount of information was added, so it was decided to format the 
               guide in OS/2 INF format, then distribute it.
Version 2.+ - Well? Please send any contribution you may have to the author!

:elines.
.*
:h1 res=8.Things to learn
.*
:p.This section has some suggestions regarding the OS/2 Warp Presentation Manager programming.
:ul.
:link reftype=hd res=9.
:li.Get Warped!
:elink.
:link reftype=hd res=10.
:li.Choose a standard programming language
:elink.
:link reftype=hd res=11.
:li.OS/2 Warp Presentation Manager programming
:elink.
:link reftype=hd res=12.
:li.GPI programming
:elink.
:link reftype=hd res=13.
:li.Other PM technologies
:elink.
:eul.
.*
:artwork align=left name='birds1.bmp'.
.*
:h2 res=9.Get Warped!
.*
:p.What are you waiting for? Go on, try it!   OS/2 Warp is one of the most advanced and powerful 
operating systems in the world.  Some of the many features are
:ul.
:li.Robust, and reliable,
:li.Object orientation,
:li.Complete 32-bit architecture,
:li.Real pre-emptive multitasking,
:li.Easier to program than other platforms, and
:li.Excellent multimedia support.
:eul.
.*
:artwork align=center name='wrdybk.bmp'.
.*
:p.Now take advantage of the wide range of native applications.  You can even run most DOS and 
Windows applications.  Whatever you do, get 
:hp1.
Galactic Civilisations.
:ehp1.
 This game by
:link reftype=hd res=22.
Stardock Systems
:elink.
is a must!
.*
:h2 res=10.Choose a standard programming language
.*
:p.Find a commonly-used language to program in.  It is important to know one!  My personal 
preference is C.  Alot of OS/2 applications, and games, are written in C (or C++).  Lots of source code
examples are, too.
.*
:artwork align=center name='os2small.bmp'.
.*
:p.If object-oriented programming is your scene, go for C++.  The
:link reftype=hd res=18.
Warp Entertainment Toolkit 
:elink.
is aimed at C++ developers.  REXX is also a popular language.  It is interpreted, rather than 
compiled.  A REXX program will run slower than an equivalent C or C++ program.  However, REXX 
programs are easy to write, and quite powerful.  Multimedia with OS/2 REXX is easy, too.  Refer to  
the MCIREXX.INF in your MMOS2 directory, if available.
.*
:h2 res=11.OS/2 Warp Presentation Manager programming
.*
:p.Learn to program the OS/2 Presentation Manager in C (or your language of choice).  Knowing 
basic PM programming will let you design a user interface for your game.  The PM API functions 
may look overwhelming to the uninitiated.  It is hard work to learn (and understand!) how to do the 
simplest tasks, however PM programming allows you to write powerful applications with minimal 
code.
.*
:h2 res=12.GPI programming
.*
:p.The Graphics Programming Interface (GPI) is the method to draw primitive graphics in a PM 
window.  It also handles bitmaps, metafiles, animation and other things.  It is very functional, and 
sometimes complicated.  I don't know much about it.
.*
:artwork align=center name='cube.bmp'.
.*
:h2 res=13.Other PM technologies
.*
:p.OS/2 Warp has many extra technologies which greatly enhance games.  They are
:ul.
:li.DIVE - Direct Interface to Video Extensions.  It allows for really fast graphics or real-time video, and
can play AVI or FLI-format files effectively.
.*
:li.MMPM - Multimedia Presentation Manager.  Allows easy-to-use multimedia features, such as 
playing WAV or MID-format files.
.*
:li.SOM
.*
:artwork runin name='object8.bmp'.
.*
- System Object Model.  This lets the system and its applications have the concept of 'objects'.
A directory is an object.  An icon is an object.  Your chess game opponent on a future, 
high-technology  WAN which might extend into an unfathomable dimension, full of highly-developed 
alien life - but who are on the Internet - is also treated as an object.
:eul.
.*
:artwork align=center name='start.bmp'.
.*
:p.Other technologies include DART, enDIVE, 3D animation, Real-Time MIDI, DirectDMA and 
networking features.
.*
:h1 res=14.Miscellaneous suggestions
.*
:p.For more information on creating OS/2 Warp games, including an overview of the Warp 
Entertainment Toolkit, see http&colon.//www.austin.ibm.com/os2games.
.*
:artwork align=center name='sdp_bgnd.bmp'.
.*
:p.Join the IBM Solution Developer's Programme in your country.  It may also be referred to as the 
Developer Assistance Programme (DAP).  Also, join the Worldwide DAP (Email 
wwdap@vnet.ibm.com).  This gives you access to development software, including the Developer's 
Connection CD-ROM.
.*
:p.Join 
:artwork runin name='team_log.bmp'.
:artlink.
:link reftype=hd res=20. 
:eartlink.
.*
:p.Join Club OpenDoc, see http&colon.//www.software.ibm.com/clubopendoc/index.html (or Email 
Club_OpenDoc@aussmtp.austin.ibm.com).
.*
:artwork align=center name='clubtitl.bmp'.
.*
:p.Do not be afraid to
:link reftype=hd res=15.
buy a book
:elink.
on the topic you are after!
.*
:p.Get all the issues of 
:link reftype=hd res=20.
EDM/2 magazine 
:elink.
that you can!  There are many excellent articles about PM programming.  The 'Gearing up for 
Games' series gives an introduction to Warp gaming technologies, like DIVE.
.*
:p.You will probably be spending alot of time in front of a computer.  Be patient, and have regular 
breaks.
.*
:p.Don't be afraid to try things.  Have fun while you are trying it.
.*
:p.Read the newsgroup rec.sys.programmer FAQ.  It provides many useful references to books, 
companies, sites and techniques useful for game development.  Most of the information relates to 
DOS programming, so it may not be useful for PM programming, except for techniques like artificial 
intelligence or virtual reality.
.*
:p.Games and animation may be resource-intensive; you may experience device driver problems.  
.*
:p.Learn threads and semaphores.  It is possible to write a simple text-based program where one 
can create, destroy, and pass messages between threads.  Get a sound understanding of 
multithreading.  Semaphores are useful to synchronise events.
.*
:p.Don't program in Ada.
.*
:p.People who 8514 video adapters cannot use (or view) DIVE instances.  DIVE is not really 
necessary if you do not need to update large graphics regularly; GPI functions are sufficient in these 
cases.
.*
:artwork align=center name='diveplan.bmp'.
.*
:h1 res=15.Book Recommendations
.*
:p.Books may be ordered through the IBM SDP (DAP), or at your local bookshop.  All the books 
listed are in English, unless stated otherwise.
.*
:hp2.
:p.Learning to Program the OS/2 2.0 Presentation Manager by Example - Stephen Knight
:ehp2.
.*
:p.This book is a reasonable beginner's book, for PM C.  It explains basic concept very well.  It deals 
with basic PM window creation, simple GPI programming, help files, some GPI animation (which I 
couldn't understand), amongst other things.  It uses one big example, which is a slide puzzle game.  
 At times it may be hard to follow the large chunks of sample code.
.*
:hp2.
:p.The Art of OS/2 Warp Programming - Catherine Panov, Larry Salomon, Arthur Panov
:ehp2.
.*
:p.This may be a better PM C beginner's book than the former.  It deals with more concepts relating 
to PM programming, even multitasking.  See http&colon.//www.iqpac.com/tao/index.shtml
.*
:artwork align=center name='theart.bmp'.
.*
:hp2.
:p.Programming the OS/2 Warp GPI  - Stephen Knight, Jeffrey Ryan
:ehp2.
.*
:p.This book explains GPI programming in C.  It is for beginning to intermediate programmer, and 
appears to explain difficult GPI concepts.  It also uses one big example to illustrate all concepts.  
See http&colon.//www.wiley.com/compbooks/i5.html
.*
:artwork align=center name='pgpi.bmp'.
.*
:hp2.
:p.Programming Multimedia in OS/2
:ehp2.
.*
:p.This book is written for OS/2 2.1, so it does not explain all the features which were introduced with 
OS/2 Warp.  it might be worth a miss, until it gets revised!
.*
:hp2.
:p.System-Programmierung OS/2 - Frank Eckgold (in German)
:ehp2.
.*
:p.Quite a good reference but many typographical errors and mistakes in the early edition.  It has 
some useful examples.
.*
:hp2.
:p.The Ultimate OS/2 Programmer's Manual - John Mueller
:ehp2.
.*
:p.It is a good reference, but that's it.  It has no sample programs. It is not a stand-alone buy, but an 
additional book where you will quickly find what you are looking for.
.*
:hp2.
:p.OS/2 Programmierung - T. Legenkamp, J. Bredno (in German)
:ehp2.
.*
:p.It is a good introductory book with some samples, but no use at all as a reference.  It has some 
information not available in the other books.
.*
:hp2.
:p.OS/2 Multimedia Programmierung - T. Legenkamp (in German)
:ehp2.
.*
:p.The only reference to MMOS/2.  It has the most important information on MMOS/2 but that's it.  It 
is easier to use than the online help from Visualage C/C++!
.*
:h1 res=16.Other resources
.*
:p.This section lists useful resources which any OS/2 developer should consider.
:ul.
:link reftype=hd res=17.
:li.Compilers
:elink.
:link reftype=hd res=18.
:li.Software
:elink.
:eul.
.*
:h2 res=17.Compilers
.*
:p.Get one.  I prefer EMX/GNU C.  It has a C, C++, and an Objective C compiler.  It's free.  It does 
the job.  Some commercial compilers are
:ul.
:li.IBM VisualAge C/C++ - Nice compiler.  Loads of features, good user interface.  American students 
get it very cheaply.

:li.Watcom C/C++ - Arguably better than VisualAge.  Can cross-compile for multiple operating systems.

:li.Borland C/C++ - Uses their infamous IDE interface.  If you are considering this compiler, consider 
GNU C.

:li.VisPro C/C++ - It is from Canada.  Any opinion would be appreciated.
:eul.
.*
:p.For REXX development there is
.*
:ul.
:li.DrDialog - Cute, useable, and free

:li.The commercial compilers Watcom VX-REXX, and VisPro REXX are good for graphical 
development of PM applications using REXX.
:eul.
.*
:artwork align=center name='mainhed.bmp'.
:hp1.
:p.This is what people who are frustrated with their compiler look like! &colon.-)
:ehp1.
.*
:h2 res=18.Software
.*
:p.Subscribe to the Developer's Connection CDROMs through the IBM SDP.  It is your life blood.  It 
is about US$200 for 4 sets of CD-ROMs, which are distributed quarterly.  If you can't afford it, ask for 
the
:hp1.
Promotional DevCon.
:ehp1.
They give you one (but ONLY one) set out of good will, for free!  With the 
money you have now saved, buy a CD-ROM drive so you can use them &colon.-).
.*
:artwork align=right name='freestuf.bmp'.
.*
:p.Get the Hobbes OS/2 CD-ROM (Email info@cdrom.com).  It is about US$30.  You get the entire 
OS/2 hobbes.nmsu.edu site on two cdroms, which comes in handy.  If you develop software that 
they put on the CD-ROM, they will even send you one as a gift, because they are nice.
.*
:artwork align=center name='pinkrose.bmp'.
.*
:p.OS/2 Warp Developer's Toolkit - THE tool for OS/2 developers.  It has got necessary software, documentation, and examples for
Assembler, C, C++, SOM, and REXX.  It's on the DevCon.  Install it.
.*
:p.OS/2 Warp Entertainment Toolkit - This may be another package to get if you intend to write 
games, particularly in C++.  It includes new technologies like 3D rendering, animation, and a joystick 
driver.
.*
:p.Hyperwise - Allows easy creation of OS/2 and Windows help files.  It's really nice.  It can even 
import and export in HTML format.  Unfortunately, there is only a demonstration version of it on the 
DevCon.  If anyone can suggest a nice, freely-available INF creation tool, please do so!
.*
:artwork align=center name='ibm.bmp'.
.*
:p.Object REXX - This gives REXX object-oriented abilities.  It may be worth a look.  It's on the 
DevCon.
.*
:p.DrDialog - My favourite REXX tool!  It allows the graphical creation of simple PM applications 
using REXX.  It's on the DevCon.
.*
:p.Prominare Designer - This allows excellent graphical creation of OS/2 applications.  The 
demonstration version (PDD.ZIP) has a dialog creation tool (which is perfectly usable) and rivals that 
in the  Warp Developer's Toolkit.  See http&colon.//www.prominare.com/prominare.  You may need the 
LOADDSKF.EXE utility to decompress the demonstration version archive.
.*
:artwork align=center name='logosmal.bmp'.
.*
:p.Guidelines - Graphical PM application development tool which builds using your C++ compiler.  
Very nice.  The base package may be free. See ftp&colon.//hobbes.nmsu.edu/os2/dev32/gui*.
.*
:p.
:link reftype=hd res=26.
Paint Shop Pro
:elink.
- (psp311.zip, available in Windows sites like SimTel, in the 'graphics' directory) is a good shareware 
graphics viewer/editor.  It rivals 
:link reftype=hd res=26.
Adobe Photoshop.
:elink.
 You will undoubtedly use it for editing images for your next hot OS/2 game!  Unfortunately, it's not
native, so why not contact the creators and tell them that it would be better if it was?
.*
:p.
:link reftype=hd res=21.
POVRAY
:elink.
- This is useful for creating rendered graphics, like those in the film
:link reftype=hd res=26.
:hp1.
Toy Story.
:ehp1.
:elink.
 It is also free.  The graphics in a native OS/2 game,
:link reftype=hd res=22.
:hp1.
Toyland
:ehp1.
:elink.
, were created using this.  If you don't want to learn its modelling language, get a 
shareware modeller like PovCad 3D.  Unfortunately, it's a Windows application, so
why not tell the author that 'native is better'?
.*
:artwork align=center name='planets.bmp'.
.*
:h1 res=19.Information references available via the Internet
.*
:artwork align=center name='home_igl.bmp'.
.*
:p.This section lists some Internet (with World Wide Web sites) of interest
to OS/2 users and developers.
:ul.
:link reftype=hd res=20.
:li.OS/2 game development related
:elink.
:link reftype=hd res=21.
:li.Game development related
:elink.
:link reftype=hd res=22.
:li.General OS/2 related
:elink.
:link reftype=hd res=23.
:li.Miscellaneous sites
:elink.
:eul.
.*
:h2 res=20.OS/2 game development related
.*
:p.There are two main OS/2 repositories on the internet.  They are
:hp9.
ftp-os2.cdrom.com
:ehp9.
, and
:hp9.
hobbes.nmsu.edu.
:ehp9.
There are mirrors around the world, like ftp.latrobe.edu.au.  OS/2 information
and software may be found at these sites.  Various source code samples are provided in the
:hp9.
/dev16
:ehp9.
and
:hp9.
/dev32
:ehp9.
directories.
.*
:lines.
IBM OS/2 Warp games home page
This is the starting point for looking for OS/2 game-specific information.
http&colon.//www.austin.ibm.com/os2games

OS/2 Game Development Council
http&colon.//naftalab.bus.utexas.edu/os2games

The Ultimate OS/2 games page
http&colon.//www.cc.gatech.edu/people/home/buie/os2games.html

Team OS/2 Online
There are lots of excellent links to all kinds of information.  Become a member here.
http&colon.//www.teamos2.org

EDM/2 Magazine
This electronic magazine is so good, it should be put on the World Heritage List.
Get all the issues!
http&colon.//www.iqpac.com

See newsgroups comp.sys.os2.programmer.*, comp.os2.os2.misc.games

For a general OS/2 programming FAQ, see
http&colon.//www.connix.com/~kiernasj/os2_prog.faq.html.
This may come in somewhat useful.

For a list of OS/2-related books, see ftp&colon.//hobbes.nmsu.edu/os2/info/os2books.txt.
:elines.
.*
:h2 res=21.Game development related
.*
:p.Here are some sites relating to game development techniques and resources.
.*
:lines.

Games domain
A useful nice site relating to all aspects of gaming.
http&colon.//www.gamesdomain.co.uk

POVRAY archive and a mirror
ftp&colon.//ftp.povray.org (or ftp&colon.//uniwa.uwa.edu.au/pub/povray)

The rec.sys.programmer.games newsgroup.  Get its FAQ as well.
The author is gavin@senator.demon.co.uk.

Game developer magazine
http&colon.//www.mfi.com/gdmag

The X2ftp site (:hp9.x2ftp.oulu.fi:ehp9.), contains alot of information on designing DOS games.
Most of it is irrelevant to PM games.  Try the Games Programming Encyclopaedia.
:elines.
.*
:h2 res=22.General OS/2 related
.*
:p.Here is a list of sites for all OS/2 users.
.*
:lines.

There is a general OS/2 FAQ.  Look for it on the :link reftype=hd res=20.Team OS/2:elink. site.

DOS and Windows games settings list
http&colon.//eyelab.msu.edu/os2games

Rainald in Toyland
http&colon.//www.uni-koeln.de/~a0085/Toyland.html or
http&colon.//www.wilmington.net/bmtmicro/catalog/toyland/Toyland.html
.*
:artwork align=center name='toyland.bmp'.
.*

Stardock!
http&colon.//oeonline.com/~stardock/index.html
.*
:artwork align=center name='sds.bmp'.
.*

OS/2 software solutions
http&colon.//www.mfi.com/os2dev/cgi-bin/

OS/2 e-Zine!
http&colon.//www.isisnet.com./haligonian/os2

#OS/2 Internet Relay Channel (IRC) group.

:elines.
.*
:h2 res=23.Miscellaneous sites
.*
:p.This section contains some of my favourite World-Wide Web sites.  Visit them!
.*
:lines.
Antonino's very own home page!  Rejoice in its spendour!
http&colon.//www.tripod.com/~antonino/index.html

University of South Australia
http&colon.//www.unisa.edu.au
.*
:artwork align=center name='mainlogo.bmp'.
.*

Joan Grove's home page
Want to know how Microsoft treats its employees?
http&colon.//www.seasun.com/redrose
.*
:artwork align=center name='w95holz.bmp'.
.*

Windows 95 hate page
http&colon.//alfred.uid.no/People/wolf/grana
Also try to find the Official Anti-Microsoft home page.

Zero Micro Software home page
http&colon.//www.micros0ft.com

The Unofficial Brady Bunch home page
http&colon.//www.teleport.com/~btucker/bradys.shtml

The Calvin and Hobbes archive
http&colon.//www.eng.hawaii.edu/Contribs/justin/Archive/Index.html

Bite me!  This is Illtel
http&colon.//wonderland.illtel.denver.co.us

The official DefFX home page
http&colon.//www.geko.com.au/vrx/dfx/html/def-fx.html
.*
:artwork align=center name='deffx.bmp'.
.*

:elines.
.*
:h1 res=24.Author contact details
.*
:p.I have been looking for information on how to program OS/2 applications (and games) for some 
time.  I wrote this guide because I found that there is no similar source of information for beginners.  
The road to success with PM programming is long and hard, but the end result is rewarding.  My
best advice is to buy books which suit you.
.*
:p.Please send comments, suggestions, or improvements to
.*
:cgraphic.

       ****    ****       *  ****  Operate at a higher level.
     *    *  *    *     *  *    *
    *    *  *         *       *    Mr Antonino Iannella
   *    *   ****    *      *       Computer Systems Engineering
  *    *  *    *  *     *          9308390r@lux.levels.unisa.edu.au
  ****    ****  *      ******      http&colon.//www.tripod.com/~antonino/index.html

General Application Error in Module MS&colon.WIN-95.
This version will now self-destruct!

Would you fix your house if the windows need replacing?
So why not fix your computer by replacing its Windows?

:ecgraphic.
:font facename=default.
.*
:p.Pretty cool, eh?
.*
:artwork align=right name='ibm_os2.bmp'.
.*
:h2 res=25.Acknowledgements
.*
:p.The following wonderful people helped with the compilation of this guide.
.*
:ul.

:li.Joan Grove

:li.Dan Libby

:li.Dan Rhoads

:li.Timur Tabi

:li.Rainald Menge

:li.Jeff Chang

:li.Bedrich Smetana

:li.Nicholas Pioch

:li.Larry Salomon

:li.Tom Stevic

:li.Toby Flugel

:li.Thomas

:li.Gerardo Diaz

:li.Mark Rosenberg

:li.University of South Australia ITU

:eul.

.* This part is hidden from the user!
.* I did this to guarantee these individuals' privacy, while still keeping their addresses
.* in this document.  I am so cool...
.*
:hide key=' '.
:lines.

Joan Grove, redrose@halcyon.com

Dan Libby, dandaman@aloha.com

Dan Rhoads, drhoads@ibm.net

Timur Tabi, timur@vnet.ibm.com

Rainald Menge, menge@rrz.uni-koeln.de

Jeff Chang, gozigen@aol.com

Bedrich Smetana, Bedrich_Smetana@idg.com

Nicholas Pioch, WebMuseum, pioch@netscape.com

Larry Salomon, os2man@panix.com

Tom Stevic, stevic@ibm.net

Toby Flugel, toby@annex.com

Thomas, ThomasC2@aol.com

Mark Rosenberg, marks@rosenberg.sdi.agate.net

Gerardo Diaz, gerdiaz@ibm.net

University of South Australia ITU

:elines.
:ehide.
.*
.* End of hidden section!
.*
:h2 res=26.Registered trademarks
.*
:p.This section lists some of the trademarks which belong to their owners.
.*
.*
:lines.
OS/2, Hyperwise, and VisualAge C++ are trademarks of the IBM Corporation.

OpenDoc is an industry standard, probably belonging to companies like Motorola,
Apple, DEC, IBM, but definitely not Microsoft.

Windows and the Microsoft Network are trademarks of the Microsoft Corporation.
'Windoze' isn't, however.

Paint Shop Pro is a trademark of JASC Products.

Photoshop is a trademark of Adobe Systems, Inc.

Prominare Designer is a trademark of Prominare.

Netscape is a trademark of the Mozilla Corporation.

Galactic Civilisations is a trademark of Stardock Systems.

The pictures are copyright of Joan Grove, IBM, Mozilla, the WebMuseum, IQPac Inc,
Rainald Mange, Stardock Systems, Salvador Dali, Graham Griffiths,
the University of South Australia, and anyone else on the Internet 
whom I have not acknowledged.

Toy Story is a Walt Disney production.

:elines.
:euserdoc.
.*
.* The end of my guide! Have a nice day.  Good luck.
.*
