unit Rspform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    YourRock: TRadioButton;
    YourScissors: TRadioButton;
    YourPaper: TRadioButton;
    MyRock: TRadioButton;
    MyScissors: TRadioButton;
    MyPaper: TRadioButton;
    Message: TLabel;
    Why: TLabel;
    Games: TLabel;
    You: TLabel;
    Me: TLabel;
    procedure YourRockClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

type
   RockScissorsPaper = (Rock, Scissors, Paper);
   ResultType = (YouWin, IWin, Tie);

var
  Form1: TForm1;
  GamesPlayed, YourWins, MyWins : Longint;

implementation

{$R *.DFM}

procedure TForm1.YourRockClick(Sender: TObject);
var WinType,
   UserChoice, MyChoice: RockScissorsPaper;
   I                   : Integer;
   Result              : ResultType;
begin
   If YourRock.Checked then UserChoice := Rock
   else if YourScissors.Checked then UserChoice := Scissors
   else UserChoice := Paper;

   MyChoice := Rock;
   for I := 1 to 100 do
   begin
      If MyChoice = Paper then MyChoice := Rock
      else MyChoice := Succ(MyChoice);
      case MyChoice of
         Rock       : MyRock.Checked := true;
         Scissors   : MyScissors.Checked := true;
         Paper      : MyPaper.Checked := true;
         end;
      Update;
      If Random(10) = 0 then break;
      end;

   case UserChoice of
      Rock         : case MyChoice of
         Rock         :Result := Tie;
         Scissors     : Result := YouWin;
         Paper        : Result := IWin;
         end;
      Scissors     : case MyChoice of
         Rock         :Result := IWin;
         Scissors     : Result := Tie;
         Paper        : Result := YouWin;
         end;
      Paper        : case MyChoice of
         Rock         :Result := YouWin;
         Scissors     : Result := IWin;
         Paper        : Result := Tie;
         end;
      end;

   case Result of
      IWin : begin
         Message.Caption := 'I Win!';
         Inc(MyWins);
         WinType := MyChoice;
         end;
      YouWin: begin
         Message.Caption := 'You Win!';
         Inc(YourWins);
         WinType := UserChoice;
         end;
      Tie   : Message.Caption := 'Tie';
      end;

   If Result = Tie then Why.Caption := ''
   else case WinType of
      Rock    : Why.Caption := 'Rock crushes scissors.';
      Scissors: Why.Caption := 'Scissors cuts paper.';
      Paper   : Why.Caption := 'Paper covers rock.';
      end;

   Inc(GamesPlayed);
   Games.Caption := 'Games: ' + IntToStr(GamesPlayed);
   You.Caption := 'You: '+IntToStr(YourWins);
   Me.Caption := 'Me: '+IntToStr(MyWins);
   end;

end.
