unit Parsefrm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    UserInput: TEdit;
    Words: TListBox;
    Add: TButton;
    procedure AddClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.AddClick(Sender: TObject);
(* Version 1 *)
{var S, T: String;
    Index, FirstChar: Integer;
begin
   S := UserInput.Text;
   FirstChar := 1;
   For Index := 1 to Length(S) do
   if Copy(S, Index, 1) = ' ' then
   begin
      T := Copy(S, FirstChar, Index-FirstChar);
      Words.Items.Add(T);
      FirstChar := Index + 1;
      end;
   end;}
(* Version 2 *)
{
var
   S, T            : String;
   InWord          : Boolean;
   Index, FirstChar: Integer;
begin
   S := UserInput.Text + ' ';
   InWord := False;
   Index := 1;
   FirstChar := 1;

   while (Index <= Length(S)) do
   begin
      T := Copy(S, Index, 1);
      If ((T >= '0') and (T <= '9')) or
         ((T >= 'A') and (T <= 'Z')) or
         ((T >= 'a') and (T <= 'z')) or
         (T = '_') then
      begin
         If not InWord then FirstChar := Index;
         InWord := true;
         end
      else begin
         if InWord then begin
            T := Copy(S, FirstChar, Index-FirstChar);
            Words.Items.Add(T);
            end;
         InWord := false;
         end;
      Index := Index + 1;
      end;
   end;
   }
(*Version 2.5*)
   var
      S, T              :String;
      InWord, InComment : Boolean;
      Index, FirstChar  : Integer;
   begin
      S := UserInput.Text + ' ';
      InWord := False;
      InComment := False;
      Index := 1;
      FirstChar := 1;

      while Index <= Length(S) do
      begin
         T := Copy(S, Index, 1);
         If (T = '{') or InComment then {Delete commented out characters}
         begin
            If T = '}' then InComment := false
            else InComment := true;
            Delete(S, Index, 1);
            Continue;
            end;
         If T = '*' then break;
      If ((T >= '0') and (T <= '9')) or
         ((T >= 'A') and (T <= 'Z')) or
         ((T >= 'a') and (T <= 'z')) or
         (T = '_') then
      begin
         If not InWord then FirstChar := Index;
         InWord := true;
         end
      else begin
         if InWord then begin
            T := Copy(S, FirstChar, Index-FirstChar);
            Words.Items.Add(T);
            end;
         InWord := false;
         end;
      Index := Index + 1;
      end;
   end;

end.
