unit Libde;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TBookEntry = class(TForm)
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    GroupBox4: TGroupBox;
    GroupBox5: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    AuthorFirst: TEdit;
    AuthorLast: TEdit;
    PublisherName: TEdit;
    PublicationDate: TEdit;
    LendeeFirst: TEdit;
    LendeeLast: TEdit;
    LentOut: TCheckBox;
    Fiction: TCheckBox;
    Technical: TCheckBox;
    Humor: TCheckBox;
    Reference: TCheckBox;
    HowTo: TCheckBox;
    Philosophy: TCheckBox;
    Suspense: TCheckBox;
    Science: TCheckBox;
    Fantasy: TCheckBox;
    Horror: TCheckBox;
    Western: TCheckBox;
    Romance: TCheckBox;
    Excellent: TRadioButton;
    Good: TRadioButton;
    Fair: TRadioButton;
    Poor: TRadioButton;
    Title: TEdit;
    OK: TButton;
    Help: TButton;
    Restore: TButton;
    Cancel: TButton;
    procedure OKClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

type
   Genres = (gFiction, gTechnical, gHumor, gReference, gHowTo, gPhilosophy,
             gSuspense, gScience, gFantasy, gHorror, gWestern, gRomance);
   Conditions = (cExcellent, cGood, cFair, cPoor);

   GenreSet = Set of Genres;

   LibraryEntry = record
      BookTitle, BookAuthor, BookPublisher : String[30];
      BookDate                             : Word;
      BookLentOut                          : Boolean;
      BookLendee                           : String[30];
      BookGenre                            : GenreSet;
      BookCondition                        : Conditions;
      end;

  BookFields = (BookTitle, BookAuthor, BookPublisher,
             BookDate, BookLentOut, BookLendee,
             BookGenre, BookCondition);

var
  BookEntry: TBookEntry;
  Book    : LibraryEntry;
  Lib     : File of LibraryEntry;

implementation

{$R *.DFM}

procedure AddGenreToSet(var ASet: GenreSet; AGenre: Genres; DoIt: Boolean);
begin
   If DoIt then ASet := ASet + [AGenre];
   end;

procedure TBookEntry.OKClick(Sender: TObject);
begin
   with Book do
   begin
      BookTitle     := Title.Text;
      BookAuthor    := AuthorLast.Text + ', ' + AuthorFirst.Text;
      BookPublisher := PublisherName.Text;
      BookDate      := 0;
      BookLentOut   := LentOut.Checked;
      BookLendee    := LendeeLast.Text + ', ' + LendeeFirst.Text;
      BookGenre     := [];

      AddGenreToSet(BookGenre, gFiction, Fiction.Checked);
      AddGenreToSet(BookGenre, gTechnical, Technical.Checked);
      AddGenreToSet(BookGenre, gHumor, Humor.Checked);
      AddGenreToSet(BookGenre, gReference, Reference.Checked);
      AddGenreToSet(BookGenre, gHowTo, HowTo.Checked);
      AddGenreToSet(BookGenre, gPhilosophy, Philosophy.Checked);
      AddGenreToSet(BookGenre, gSuspense, Suspense.Checked);
      AddGenreToSet(BookGenre, gScience, Science.Checked);
      AddGenreToSet(BookGenre, gFantasy, Fantasy.Checked);
      AddGenreToSet(BookGenre, gHorror, Horror.Checked);
      AddGenreToSet(BookGenre, gWestern, Western.Checked);
      AddGenreToSet(BookGenre, gRomance, Romance.Checked);

      If Excellent.Checked then BookCondition := cExcellent
      else if Good.Checked then BookCondition := cGood
      else if Fair.Checked then BookCondition := cFair
      else if Poor.Checked then BookCondition := cPoor;
      end;
   end;

end.
