//------------------------------------------------------------------
// Parser.cpp - Definition of the gpParser class.
//
// Copyright 1994 Prodis Incorporated.
//
// Purpose: The Syntax class pairs syntactic patterns (REs) with
//          tokens (ints)
//
// Architect: AKJ
// Developer: AKJ
//
// Modification History:
//------------------------------------------------------------------

#include <stdlib.h>
#include <parser\parser.h>

gpParser::gpParser ( )
  {
    plSyntax = new SyntaxList;
  }
  
gpParser::gpParser (SyntaxList *plPat)
  {
    plSyntax = plPat;
  }

int gpParser::Parse (gpString &sLine, StringList &lsStrings)
  {
    Syntax *sCurrent;

    if (sCurrent = plSyntax->Seek (sLine))
      {
        lsStrings.Clear ();
        sCurrent->reSyntax->DumpParameters (lsStrings);
        return sCurrent->Token();
      }
      
    return (0);  
  }
   
void gpParser::AddSyntax (Syntax *pNew)
  {
    plSyntax->AddItem (pNew);
  }

void gpParser::AddSyntax (char *cExpress, int nNewToken)
  {
    plSyntax->AddItem (new Syntax(cExpress, nNewToken));
  }  
