//------------------------------------------------------------------
// gpString.h - Declaration of the gpString class.
//
// Copyright 1994 Prodis Incorporated.
//
// Architect: TDE
// Developer: AKJ
//
//------------------------------------------------------------------

#ifndef GPSTRING_H
#define GPSTRING_H

#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#define NPOS 32000

typedef unsigned size_t;

// StripType is used with ::Strip()
enum StripType { Trailing, Leading, Both, All };

// Direction and Inclusive are used 
// with ::FindString() and ::FindChar()
enum Direction { Forward, Backward };
enum Inclusive { Of, NotOf };

class gpString
  {
    protected :

      char *cText;
      
      size_t nSize;

      int CharIsOfString(char cChar, char *cBuffer);
      
    public :

    // Constructors:
      gpString (const char *cString);
      gpString (char cChar);
      gpString (size_t nNewSize, char cFill = ' ');
      gpString ( );
      gpString (gpString &sString);

    // Destructor:
      ~gpString ( );

    // Size-related functions:
      size_t Length ( ) {return strlen(cText);}
      void Resize (size_t nNew);
      size_t Size ( ) {return nSize;}

    // Case Conversion - returns a copy:
      gpString ToUpper ( );
      gpString ToLower ( );

    // Assignment Operators:

      // Return the character in the string at a given offset.
      char &operator[] (int nPos) {return *(cText+nPos);}

      // Type conversion to char *.
      operator char *( );

      // Assign one string to another.
      gpString &operator= (gpString &oString);

      // Append another string to this one.
      gpString &operator+= (gpString &oString);
      
      // Concatenate two strings.
      gpString operator+ (gpString &oString);

    // Relational operators:
	
      // Compare two strings for equality.
      virtual int operator== (gpString &oString);
      virtual int operator== (char *cString)
            {return operator==(gpString(cString));}

      // Compare two strings for inequality.
      int operator!= (gpString &oString);	
      int operator!= (char *cString) 
            {return operator!=(gpString(cString));}

      // Compare two strings for exclusive alphanumeric precedence. 
      int operator< (gpString &oString);	    
      int operator< (char *cString)
            {return operator<(gpString(cString));}

      // Compare two strings for exclusive alphanumeric antecedence.
      int operator> (gpString &oString);
      int operator> (char *cString)  
            {return operator>(gpString(cString));}

      // Compare two strings for inclusive alphanumeric precedence. 
      int operator<= (gpString &oString);
      int operator<= (char *cString) 
            {return operator<=(gpString(cString));}

      // Compare two strings for inclusive alphanumeric antecedence.
      int operator>= (gpString &oString);
      int operator>= (char *cString) 
            {return operator>=(gpString(cString));}

    // Search Functions:

      // Find the target substring within this string.
      size_t FindSubstring (gpString &sTarget
              , Direction dDirect = Forward, size_t nStart = 0);
      
      // Find any character of the target string.
      size_t FindChar (Inclusive iIsOf, gpString &sTarget
              , Direction dDirect = Forward, size_t nStart = 0);
      
    // Edit Routines:
      
      // Insert the new string at the given position.
      gpString &Insert (gpString &sNew, size_t nPos);
      
      // Remove nSize characters starting with position nPos.
      gpString &Remove (size_t nPos, size_t nSize = NPOS);
      
      // Replace nSize characters with the new string.
      gpString &Replace (size_t nPos, size_t nSize, gpString &sNew);
      
      // Remove the given characters at the given positions.
      // We default to stripping leading and trailing whitespace.
      gpString &Strip (StripType s = Both
              , gpString &sTarget = gpString (" \t"));
  };    

#endif
