//------------------------------------------------------------------
// Syntoken.h - "System" Syntax tokens.
//
// Copyright 1994 Prodis Incorporated.
//
// Architect: AKJ
// Developer: AKJ
//
// Modification History:
//------------------------------------------------------------------

// Define "non-language" tokens:
#define TK_UNRECOGNIZED         0
#define TK_NOOP                 1
#define TK_REWIND               2
#define TK_COMMENT              3

// Define flow-control tokens:
#define TK_IF                   10
#define TK_ELSE                 11
#define TK_MISMATCHED_ELSE      12
#define TK_ENDIF                13
#define TK_MISMATCHED_ENDIF     14
#define TK_LABEL                15
#define TK_GOTO                 16
#define TK_WHILE                17
#define TK_ENDWHILE             18
#define TK_MISMATCHED_ENDWHILE  19

// Define Expression realational tokens:
// (These are just here because we ALWAYS seem to need them.)
#define TK_EQUALS               901
#define TK_NOT_EQUAL            902
#define TK_GREATER_THAN         903
#define TK_LESS_THAN            904
#define TK_GREATER_OR_EQUAL     905
#define TK_LESS_OR_EQUAL        906
#define TK_AND                  907
#define TK_OR                   908
#define TK_NOT                  909

// Define the base for "user-defined" (app-specific) tokens.
// Additional definitions should be of the form:
//      #define TK_SOMETOKEN  (TK_USERDEF + n)
#define TK_USERDEF              1000

