//------------------------------------------------------------------
// Syntax.h - Declation of the Syntax and SyntaxList classes.
//
// Copyright 1994 Prodis Incorporated.
//
// Purpose: The Syntax class pairs syntactic patterns (REs) with
//          tokens (ints)
//
// Architect: AKJ
// Developer: AKJ
//
// Modification History:
//------------------------------------------------------------------

#ifndef PATTERN__H
#define PATTERN__H
#include <listbase\listbase.h>
#include <gpregexp\gpregexp.h>
#include <parser\syntoken.h>

class Syntax  
  {
    protected:
      int nToken;
      
    public:
      gpRegExp *reSyntax;
      
      // Constructors:
      Syntax ( );
      Syntax (gpRegExp *reExpress, int nNewToken = TK_NOOP);
      Syntax (char *cExpress, int nNewToken = TK_NOOP);

      // Return the Token.
      int Token ( ) {return nToken;}
  };
  
class SyntaxList : public List
  {
    public :

      Syntax *pCurrent;

      Syntax *pFirst;

      Syntax *pLast;

      SyntaxList ( );

      ~SyntaxList ( );

      Syntax *Reset ( );

      Syntax *GetNext ( );

      Syntax *AddItem (Syntax *pNew);

      Syntax *Peek ( );

      Syntax *Seek (gpString &sName);
      
      Syntax *Seek (char *sName);
  };
       
#endif
