//------------------------------------------------------------------
// Flow.h - Declaration of the gpFlowControl class.
//
// Copyright 1994 Prodis Incorporated.
//
// Purpose: The gpFlowControl class controls the execution order
//          of a macro or script.
//
// Architect: TDE
// Developer: AKJ
//
// Modification History:
//------------------------------------------------------------------

#ifndef FLOW__H
#define FLOW__H

#include <parser\parser.h>
#include <parser\states.h>
 
struct ControlBlock;
typedef enum {CB_IF, CB_ELSE, CB_WHILE, CB_GOTO, CB_NORMAL} CBType;
class gpFlowControl
  {
    protected : 
      int nState;
      int anLines[50];
      gpParser *pParser;
      StringList lLabels;
      gpString sTargetLabel;
      ControlBlock *cbTop;
      
      ControlBlock *PopOffControlStack ( );
      void PushOntoControlStack (CBType cbType, int nLine, int lTrue = 0);
      void ResetState (void);
                                        
    public :
      gpFlowControl ( );
      gpFlowControl (SyntaxList *lsNewTable);
      int Parse (gpString &sLine, StringList &lsParms, int nLine = 0);
      void AddSyntax (char *cExpress, int nNewToken = TK_NOOP);
      void AddSyntax (Syntax *sNew);
      void PostExpressionValue (int lTrue);
  };                     

#endif  
