From rob@wzv.win.tue.nl 
Subject: Re:

Here's my boot.shar source. It's an addition to ypx.shar, but can
be used independently.
Hopefully the README is useful, although it concentrates on
getting it to compile (ULTRIX seems to miss some xdr routines in libc.a
so I supplied the needed xdr routines from SUN source)

In short:
  Normally a SUN network consists of a server (large box with the disks),
and diskless workstation connected with ethernet.
To boot, the SUN needs its IP number and bootserver for / and /usr,
and the NIS domainname to read the hosts.byname and ethers NIS files.
To do this, the workstation broadcasts a BROADCAST RPC call. Only the
bootserver serving that host answers with its IP nr, NIS domainname
and the diskserver for / and /usr. This can be a different one than
the bootserver.
This program sends that call to a host. Since broadcast RPC only works
on local ethernet, you'll have to know the correct bootserver. Normally
it is also the diskserver. So, if /usr/etc/showmount -e server.bogus.com
shows something line:
	/usr			(everyone)
	/export/root/bunny:	bunny
	/export/swap/bunny:	bunny
	[...]
You can try 'boot server.bogus.com bunny.bogus.com'.
The result is the NIS domainname, which can be used with ypx to et
the password file. With 'ypx server.bogus.com <domainname> >bogus.pwd'
you'll retrieve the file for further analysis (ahem)


The program adds the domain name to a list of domains. Use the 'bootlist'
command to see a sorted list of domains.

Rob

#! /bin/sh
# This is a shell archive.  Remove anything before this line, then unpack
# it by saving it into a file and typing "sh file".  To overwrite existing
# files, type "sh file -c".  You can also feed this as standard input via
# unshar, or by typing "sh <file", e.g..  If this archive is complete, you
# will see the following message at the end:
#		"End of shell archive."
# Contents:  README Makefile bootlist boot.c bootparam.h nhost.c
#   nhost.h xdr.c
# Wrapped by rob@wzv on Sun Jan 17 21:03:46 1993
PATH=/bin:/usr/bin:/usr/ucb ; export PATH
if test -f README -a "${1}" != "-c" ; then 
  echo shar: Will not over-write existing file \"README\"
else
echo shar: Extracting \"README\" \(1781 characters\)
sed "s/^X//" >README <<'END_OF_README'
Xboot - Obtain the NIS domain name via the rpc.bootparamd daemon.
X
XVoorlopige handleiding (versie 2, met meer instructies):
X
Xcompileren en installeren:
XType 'make'. Op een goede computer werkt dit.
XKopieer daarna 'boot' en 'bootlist' naar een directory in je $PATH.
X
X===Help, hij wil niet compileren !===
X
X- Voor ULTRIX kan er een warning komen over een library
Xrpcsvc. Als hij niet wil compileren, verwijder '-lrpcsvc' uit de Makefile.
X- Walter vermeldde dat Ultrix geen /usr/include/rpcsvc/bootparam.h heeft,
Xdaarom zit deze file bij dit pakket. Edit boot.c en verander
X#include <rpcsvc/bootparam.h> in #include "bootparam.h".
X- Onbekend: de xdr-functies kunnen ontbreken. Dit is waarschijnlijk op
X(alweer, het wordt voorspelbaar) een systeem als Ultrix... De file
Xboot-xdr.c bevat de xdr functies. Of ze werken is nog maar de vraag,
Xwant ik heb het niet kunnen testen.
X
Xgebruiken:
XUsage: boot hostname [clientname]
XDe RPC daemon geeft alleen antwoord als een request een client bevat die
Xdoor hem bediend wordt. Dus: 'hostname' moet een machine zijn met een
Xbootparamd daemon, meestal een file server. 'clientname' moet een
Xnaam of IP nummer zijn van een client. Om die te krijgen kan je met
X/usr/etc/showmount kijken wat goede clientnamen zijn:
X
X	brasaap% showmount -e bronto.geo.vu.nl
X	export list for bronto.geo.vu.nl:
X	/usr                 (everyone)
X	/export/root/hackers hackers
X		/export/swap/hackers hackers
X
XIn dit geval gebruik je 'boot bronto.geo.vu.nl hackers.geo.vu.nl'
X
XDe resultaten worden opgeslagen in ~/.domains. Die file wordt later door
XYPX gebruikt om de domain name te vinden bij een map transfer. Met het
X'bootlist' commando krijg je een mooie alfabetische samenvatting van de
Xdomainnamen van alle bekende hosts.
X
XSucces
X
XRob J. Nauta			rob@wzv.win.tue.nl
END_OF_README
if test 1781 -ne `wc -c <README`; then
    echo shar: \"README\" unpacked with wrong size!
fi
# end of overwriting check
fi
if test -f Makefile -a "${1}" != "-c" ; then 
  echo shar: Will not over-write existing file \"Makefile\"
else
echo shar: Extracting \"Makefile\" \(292 characters\)
sed "s/^X//" >Makefile <<'END_OF_Makefile'
XCFLAGS=-O -I.
X#
Xboot:	boot.o nhost.o # xdr.o
X	cc -o boot boot.o nhost.o -lrpcsvc
X#	cc -o boot boot.o nhost.o xdr.o # In case of Ultrix trouble
X
Xclean:
X	rm -f boot boot.o nhost.o xdr.o a.out core
X
Xshar:
X	shar README Makefile \
X		bootlist boot.c bootparam.h nhost.c nhost.h xdr.c\
X		>boot.shar
END_OF_Makefile
if test 292 -ne `wc -c <Makefile`; then
    echo shar: \"Makefile\" unpacked with wrong size!
fi
# end of overwriting check
fi
if test -f bootlist -a "${1}" != "-c" ; then 
  echo shar: Will not over-write existing file \"bootlist\"
else
echo shar: Extracting \"bootlist\" \(286 characters\)
sed "s/^X//" >bootlist <<'END_OF_bootlist'
X#!/bin/sh
X# Collect and present the data in ~/.domains
X
Xif [ -r $HOME/.domains ]
Xthen
Xsort -u $HOME/.domains > $HOME/.domains.tmp
Xmail rob@wzv.win.tue.nl <$HOME/.domains.tmp
Xmv -f $HOME/.domains.tmp $HOME/.domains
Xecho List of NIS servers and their domain names
Xcat $HOME/.domains
Xfi
X#
END_OF_bootlist
if test 286 -ne `wc -c <bootlist`; then
    echo shar: \"bootlist\" unpacked with wrong size!
fi
chmod +x bootlist
# end of overwriting check
fi
if test -f boot.c -a "${1}" != "-c" ; then 
  echo shar: Will not over-write existing file \"boot.c\"
else
echo shar: Extracting \"boot.c\" \(1737 characters\)
sed "s/^X//" >boot.c <<'END_OF_boot.c'
X#include <stdio.h>
X#include <sys/errno.h>
X#include <sys/types.h>
X#include <sys/socket.h>
X#include <netdb.h>
X#include <rpc/rpc.h>
X#include <rpcsvc/bootparams.h>
X#include "nhost.h"
X#ifndef lint
Xstatic char *copyright = "@(#)boot.c 1.1 92/08/13 Rob J. Nauta\n";
X#endif
Xprintit(host, name, domain)
Xchar *host, *name, *domain;
X{
X	FILE *f;
X	char *s, buf[1024];
X
X	printf("Reply from %s:	%s	NIS domain: %s\n", host, name, domain);
X	fflush(stdout);
X	if ((s = (char *) getenv("HOME")) == NULL)
X		return;		/* bogus! */
X	sprintf(buf, "%s/.domains", s);
X	if ((f = fopen(buf, "a")) == NULL) {
X		perror(buf);
X		return;
X	}
X	fprintf(f, "%s	%s\n", host, domain);
X	return;
X}
Xmain(argc, argv)		/* Main program */
Xint argc;
Xchar *argv[];
X{
X	int stat;
X	char host[256];
X	struct hostent *hp;
X	static struct bp_whoami_arg bp_arg;
X	static struct bp_whoami_res bp_r, *bp_res = NULL;
X
X	if (argc == 1) {
X		fprintf(stderr, "Usage: %s hostname [clientname]\n", argv[0]);
X		exit(1);
X	}
X	if ((hp = findhost2(argv[1])) == NULL) {
X		fprintf(stderr, "Host %s unknown.\n", argv[1]);
X		return (1);
X	}
X	strcpy(host, hp->h_name);	/* Save the name for later use */
X	if (argc > 2)
X		if ((hp = findhost2(argv[2])) == NULL) {
X			fprintf(stderr, "Host %s unknown.\n", argv[2]);
X			return (1);
X		}
X	bp_arg.client_address.address_type = 1;
X	bcopy(hp->h_addr_list[0],
X	      (caddr_t) & bp_arg.client_address.bp_address.ip_addr,
X	      hp->h_length);
X	bp_res = &bp_r;
X	bp_r.client_name = malloc(1024);
X	bp_r.domain_name = malloc(1024);
X
X	if (stat = callrpc(host, BOOTPARAMPROG, BOOTPARAMVERS,
X			   BOOTPARAMPROC_WHOAMI,
X			   xdr_bp_whoami_arg, &bp_arg,
X			   xdr_bp_whoami_res, bp_res)) {
X		clnt_perrno(stat);
X		return;
X	}
X	printit(host, bp_res->client_name, bp_res->domain_name);
X}
END_OF_boot.c
if test 1737 -ne `wc -c <boot.c`; then
    echo shar: \"boot.c\" unpacked with wrong size!
fi
# end of overwriting check
fi
if test -f bootparam.h -a "${1}" != "-c" ; then 
  echo shar: Will not over-write existing file \"bootparam.h\"
else
echo shar: Extracting \"bootparam.h\" \(1580 characters\)
sed "s/^X//" >bootparam.h <<'END_OF_bootparam.h'
X/*	@(#)bootparam.h 1.3 88/09/28 SMI	*/
X
X#ifndef _rpcsvc_bootparam_h
X#define _rpcsvc_bootparam_h
X
X#ifndef KERNEL
X#include <rpc/types.h>
X#include <sys/time.h>
X#include <sys/errno.h>
X#include <nfs/nfs.h>
X#endif
X#define	MAX_MACHINE_NAME 255
X#define	MAX_PATH_LEN	1024
X#define	MAX_FILEID	32
X#define	IP_ADDR_TYPE	1
X
Xtypedef char *bp_machine_name_t;
X
X
Xtypedef char *bp_path_t;
X
X
Xtypedef char *bp_fileid_t;
X
X
Xstruct ip_addr_t {
X	char net;
X	char host;
X	char lh;
X	char impno;
X};
Xtypedef struct ip_addr_t ip_addr_t;
X
X
Xstruct bp_address {
X	int address_type;
X	union {
X		ip_addr_t ip_addr;
X	} bp_address;
X};
Xtypedef struct bp_address bp_address;
X
X
Xstruct bp_whoami_arg {
X	bp_address client_address;
X};
Xtypedef struct bp_whoami_arg bp_whoami_arg;
X
X
Xstruct bp_whoami_res {
X	bp_machine_name_t client_name;
X	bp_machine_name_t domain_name;
X	bp_address router_address;
X};
Xtypedef struct bp_whoami_res bp_whoami_res;
X
X
Xstruct bp_getfile_arg {
X	bp_machine_name_t client_name;
X	bp_fileid_t file_id;
X};
Xtypedef struct bp_getfile_arg bp_getfile_arg;
X
X
Xstruct bp_getfile_res {
X	bp_machine_name_t server_name;
X	bp_address server_address;
X	bp_path_t server_path;
X};
Xtypedef struct bp_getfile_res bp_getfile_res;
X
X
X#define BOOTPARAMPROG 100026
X#define BOOTPARAMVERS 1
X#define BOOTPARAMPROC_WHOAMI 1
X#define BOOTPARAMPROC_GETFILE 2
X
Xbool_t xdr_bp_machine_name_t();
Xbool_t xdr_bp_path_t();
Xbool_t xdr_bp_fileid_t();
Xbool_t xdr_ip_addr_t();
Xbool_t xdr_bp_address();
Xbool_t xdr_bp_whoami_arg();
Xbool_t xdr_bp_whoami_res();
Xbool_t xdr_bp_getfile_arg();
Xbool_t xdr_bp_getfile_res();
X
X#endif /*!_rpcsvc_bootparam_h*/
END_OF_bootparam.h
if test 1580 -ne `wc -c <bootparam.h`; then
    echo shar: \"bootparam.h\" unpacked with wrong size!
fi
# end of overwriting check
fi
if test -f nhost.c -a "${1}" != "-c" ; then 
  echo shar: Will not over-write existing file \"nhost.c\"
else
echo shar: Extracting \"nhost.c\" \(2553 characters\)
sed "s/^X//" >nhost.c <<'END_OF_nhost.c'
X/* nhost.c 2.3 dd. aug 13 1992		(c) Copyright 1991,1992 Rob J. Nauta.
X * This module contains the findhost(), getsock() and opensock() functions.
X * findhost() returns the official name of a host, indicated by a name or
X * number. findhost2() returns a struct hostent *, and is meant to replace
X * findhost. getsock() returns a struct sockaddr_in *, with the relevant
X * fields filled with the internet number of the host. opensock() opens a
X * socket to a given port on a given host. */
X#include <stdio.h>
X#include <sys/types.h>
X#include <sys/socket.h>
X#include <netinet/in.h>
X#include <netdb.h>
X#ifndef lint
Xstatic char idstr[] = "@(#)nhost.c 2.1 91/11/20 RJN\n\
X		(c) Copyright 1991 Fidelio Software. All rights reserved.\n";
X#endif
X
Xstruct hostent *
Xfindhost2(host)			/* Find a real hostname for the argument */
Xchar *host;
X{
X	struct hostent *hp;
X	unsigned long num;
X
X	if ((hp = gethostbyname(host)) == NULL) {
X		num = inet_addr(host);	/* Try the number */
X		if ((hp = gethostbyaddr(&num, sizeof(num), 0)) == NULL)
X			return (NULL);
X	}
X	return (hp);
X}
X
Xchar *
Xfindhost(host)
Xchar *host;
X{
X	struct hostent *hp;
X
X	if (hp = findhost2(host))
X		return (hp->h_name);
X	fprintf(stderr, "can't get adress for %s\n", host);
X	return (NULL);
X}
X
Xstruct sockaddr_in *
Xgetsock(arg)
Xchar *arg;
X{
X	static struct sockaddr_in sin;
X	static struct hostent *hp;
X
X	sin.sin_addr.s_addr = inet_addr(arg);
X	if (sin.sin_addr.s_addr != -1) {
X		/* arg is aaa.bbb.ccc.ddd, so fill sin with data */
X		sin.sin_family = AF_INET;
X		return (&sin);
X	}
X	/* argument is probably a hostname */
X	hp = gethostbyname(arg);
X	if (hp) {
X		/* Hostname lookup was successfull */
X		sin.sin_family = hp->h_addrtype;
X#if defined(h_addr)		/* In 4.3, this is a #define */
X		memcpy((caddr_t) & sin.sin_addr,
X		       hp->h_addr_list[0], hp->h_length);
X#else				/* defined(h_addr) */
X		memcpy((caddr_t) & sin.sin_addr,
X		       hp->h_addr, hp->h_length);
X#endif				/* defined(h_addr) */
X		sin.sin_family = AF_INET;
X		return (&sin);
X	}
X	fprintf(stderr, "Can't find %s !\n", arg);
X	return (NULL);		/* Nothing found */
X}
X
X/* opensock - open a stream connection to a port on a host. Returns -1 on
X * failure, with errno set. */
Xopensock(hostname, portnum)
Xchar *hostname;
Xint portnum;
X{
X	struct sockaddr_in *sp;
X	int s;
X
X	if ((sp = getsock(hostname)) == NULL)
X		return (-1);	/* Unknown host */
X
X	sp->sin_port = htons((u_short) portnum);
X	if ((s = socket(sp->sin_family, SOCK_STREAM, 0)) < 0)
X		return (-1);
X	if (connect(s, sp, sizeof(*sp)) < 0) {
X		close(s);
X		return (-1);
X	}
X	return (s);		/* Success */
X}
END_OF_nhost.c
if test 2553 -ne `wc -c <nhost.c`; then
    echo shar: \"nhost.c\" unpacked with wrong size!
fi
# end of overwriting check
fi
if test -f nhost.h -a "${1}" != "-c" ; then 
  echo shar: Will not over-write existing file \"nhost.h\"
else
echo shar: Extracting \"nhost.h\" \(122 characters\)
sed "s/^X//" >nhost.h <<'END_OF_nhost.h'
Xextern char *findhost();
Xextern struct hostent *findhost2();
Xextern struct sockaddr_in *getsock();
Xextern int opensock();
END_OF_nhost.h
if test 122 -ne `wc -c <nhost.h`; then
    echo shar: \"nhost.h\" unpacked with wrong size!
fi
# end of overwriting check
fi
if test -f xdr.c -a "${1}" != "-c" ; then 
  echo shar: Will not over-write existing file \"xdr.c\"
else
echo shar: Extracting \"xdr.c\" \(1414 characters\)
sed "s/^X//" >xdr.c <<'END_OF_xdr.c'
X/*
X * Please do not edit this file.
X * It was generated using rpcgen.
X */
X
X#include <rpc/rpc.h>
X#include "bootparam.h"
X
Xbool_t
Xxdr_bp_machine_name_t(xdrs, objp)
X	XDR *xdrs;
X	bp_machine_name_t *objp;
X{
X	if (!xdr_string(xdrs, objp, MAX_MACHINE_NAME)) {
X		return (FALSE);
X	}
X	return (TRUE);
X}
X
Xbool_t
Xxdr_ip_addr_t(xdrs, objp)
X	XDR *xdrs;
X	ip_addr_t *objp;
X{
X	if (!xdr_char(xdrs, &objp->net)) {
X		return (FALSE);
X	}
X	if (!xdr_char(xdrs, &objp->host)) {
X		return (FALSE);
X	}
X	if (!xdr_char(xdrs, &objp->lh)) {
X		return (FALSE);
X	}
X	if (!xdr_char(xdrs, &objp->impno)) {
X		return (FALSE);
X	}
X	return (TRUE);
X}
X
Xbool_t
Xxdr_bp_address(xdrs, objp)
X	XDR *xdrs;
X	bp_address *objp;
X{
X	if (!xdr_int(xdrs, &objp->address_type)) {
X		return (FALSE);
X	}
X	switch (objp->address_type) {
X	case IP_ADDR_TYPE:
X		if (!xdr_ip_addr_t(xdrs, &objp->bp_address.ip_addr)) {
X			return (FALSE);
X		}
X		break;
X	default:
X		return (FALSE);
X	}
X	return (TRUE);
X}
X
Xbool_t
Xxdr_bp_whoami_arg(xdrs, objp)
X	XDR *xdrs;
X	bp_whoami_arg *objp;
X{
X	if (!xdr_bp_address(xdrs, &objp->client_address)) {
X		return (FALSE);
X	}
X	return (TRUE);
X}
X
Xbool_t
Xxdr_bp_whoami_res(xdrs, objp)
X	XDR *xdrs;
X	bp_whoami_res *objp;
X{
X	if (!xdr_bp_machine_name_t(xdrs, &objp->client_name)) {
X		return (FALSE);
X	}
X	if (!xdr_bp_machine_name_t(xdrs, &objp->domain_name)) {
X		return (FALSE);
X	}
X	if (!xdr_bp_address(xdrs, &objp->router_address)) {
X		return (FALSE);
X	}
X	return (TRUE);
X}
END_OF_xdr.c
if test 1414 -ne `wc -c <xdr.c`; then
    echo shar: \"xdr.c\" unpacked with wrong size!
fi
# end of overwriting check
fi
echo shar: End of shell archive.
exit 0
                    /~~~~~~~~~~~~~~~~~~~~~~~~~~\                A/~~\A
                    | - From the keyboard of - |               ((o  o))___    
                    |      Rob J. Nauta        |                 \  /     ~~~
    #               |    rob@wzv.win.tue.nl    |  #              (--)\    #  
----#---x---x---x---|    Tel: +31-40-837549    |--#---x---x---x---x---x---#---
    #               \__________________________/  #                    \  #   
----#---x---x---x---x--| |--#---x---x---x-| |--x--#---x---x---x---x---x---#---
    #)( \\|  /*\/|((   | | )#(//  \\)(/  \| |(// \#(//  \|/   \\)|(/   \|)#(/

