PROGRAM Demo2;

{ ********************************************************************** }
{ Demo fr den Drucker-BGI-Treiber.                                      }
{                                                                        }
{ (C) 1991, 92   Ullrich von Bassewitz                                   }
{                                                                        }
{ Am Beispiel einer kompletten Grafik-Ausgabe wird die Anwendung des     }
{ Drucker-BGI-Treibers gezeigt.                                          }
{                                                                        }
{ ACHTUNG: Der Druckertreiber und die Vektorfonts mssen sich im         }
{          aktuellen Verzeichnis befinden !                              }
{                                                                        }
{ ********************************************************************** }



{ Ullrich von Bassewitz am 29.07.1992 }

{ Diverse Compiler-Switches: }

{$F-     Force Far Calls Off  }
{$O-     No Overlays Allowed  }
{$A+     Align Data at Word Boundary }
{$B-     Short Circuit Boolean Evaluation }
{$I-     I/O Checking Off     }
{$D+     Debug Information On }
{$L+     Local Symbols On     }
{$G-     No 286-Code }
{$M      16384, $10000, 655360 }

{$IFDEF Debug }
  {$R+	 Range Checking On    }
  {$S+	 Stack Checking On    }
{$ELSE}
  {$R-	 Range Checking Off   }
  {$S-	 Stack Checking Off   }
{$ENDIF}


{ nderungsliste

29.07.92  Uz    ......  Erstellt

04.10.93  Uz           Angapasst an V 3.0 von PRINTER.BGI

}



{ ---------------------------------------------------------------------- }



USES
  Graph,
  CRT,
  DOS;







CONST
  { Die folgende Variable gibt an, in welchem Modus sich die Grafik
    gerade befindet.
  }
  Graphics : (gNone, gScreen, gPrinter) = gNone;



  { Das folgende Array enthlt den Opcode fr einen absoluten Sprung ($EA).
    Die folgenden 4 Bytes werden mit dem alten Int10-Vektor beschrieben,
    so da ein Anspringen des alten INT10 ber dieses kurze Stck Code
    mglich ist.
  }
  Int10Jmp : ARRAY [1..5] OF BYTE = ($EA, $00, $00, $00, $00);

  { Und noch ein Merker, ob unser Int10-Handler installiert ist }
  Int10Installed : BOOLEAN = FALSE;



  { Palettentyp fr die Drucker-Settings }
  Settings          : PaletteType = (
    Size            : 8;       { Wird auf MaxColor+1 gesetzt }
    Colors          : (
      0,                       { Reserved }
      0,                       { Quality = keypad setting }
      0,                       { Shingling = None }
      1,                       { Depletion = 50% }
      -1, -1, -1, -1, -1, -1,  { Reserved }
      -1, -1, -1, -1, -1, -1   { Unbenutzte Eintrge }
    )
  );








VAR
  MaxX, MaxY     : INTEGER;   { Auflsung }
  MaxColor       : WORD;      { Anzahl Farben }
  PrinterMode    : INTEGER;   { Druckermodus }
  MaxX2, MaxY2   : INTEGER;   { Jeweils MaxX/2 und MaxY/2 }
  MaxX10, MaxY10 : INTEGER;   { Jeweils MaxX/10 und MaxY/10 }

  { Registerinhalte der Modus-Abfrage vom Programmstart }
  ModeRegs       : Registers;



{ -------------------------------------------------------------------------- }
{ INT10-Handler }



PROCEDURE Int10; ASSEMBLER;
{ Diese Prozedur ist eigentlich eine INTERRUPT-Prozedur, da sie aber sowieso
  in Assembler geschrieben ist, mu das der Compiler nicht wissen.
  Die Prozedur verlt sich allerdings auf ein Verhalten des Compilers, das
  in Version 6 immer so ist, das in spteren Versionen aber evtl. schaltbar
  sein knnte: Bei einer Prozedur ohne Parameter und ohne lokale Variablen
  erzeugt der Compiler keinen Stackframe via PUSH BP/MOV BP, SP.
  Ein weiterer Effekt _kann_ in den Super-VGA-Modi auftreten: In diesen Modi
  werden Moduswechsel nicht immer mit AH=0 durchgefhrt, evtl. ist der Code
  anzupassen (z.B. VESA-Spezifikation).
}


ASM
  cmp     ah, 0                    { Ist es ein Moduswechsel ? }
  jz      @@L2                     { Ja --> komplett ignorieren ! }

{ Es ist kein Moduswechsel. Ist es eine Modus-Abfrage ? }

  cmp     ah, 0Fh
  jnz     @@L1

{ Modus-Abfrage. Die gespeicherten Daten vom Programmstart liefern. Dies
  ist deshalb wichtig, weil Turbo-Pascal sich beim Einschalten der Grafik
  diese Werte merkt um sie beim CloseGraph wiederherzustellen. Da aber
  beim zweiten Einschalten der Grafik ein Grafik-Modus aktiv ist (aufgrund
  des verbogenen Int10) merkt sich Turbo dann diese Werte und stellt am Ende
  der Grafik einen Grafikmodus ein. Um dies zu verhindern werden hier
  die Werte geliefert, die das Programm bei Start ermittelt hat.
  Im Prinzip knnte die Abfrage (und das Merken/Zurckliefern der Werte)
  auch wegfallen, wenn nach dem CloseGraph der Videomodus nochmals explizit
  auf einen vernnftigen Wert gesetzt wird.
}
  push    ds
  mov     ax, SEG @DATA            { DS auf's Datensegment setzen }
  mov     ax, [ModeRegs.&AX]       { Daten holen }
  mov     bh, [ModeRegs.&BH]
  pop     ds                       { Altes ds wieder
  iret                             { oder auch jmp @@L2 ... }

{ Alten INT10 aufrufen }

@@L1:
  jmp     FAR PTR Int10Jmp

{ Ende }

@@L2:
  iret

END;





PROCEDURE InstallInt10Handler;
{ Sichert den alten Vektor und installiert den eigenen.
  ACHTUNG: Da die Speicherung in einer globalen Variablen erfolgt, ist der
  Vektor futsch, wenn diese Prozedur zweimal hintereinander aufgerufen wird,
  ohne das eine De-Installierung dazwischenliegt.
}

TYPE
  PPointer = ^POINTER;

BEGIN
  { Das folgende, etwas wild aussehende Konstrukt bewirkt, das GetIntVec
    den Zeiger direkt dort speichert wo er hin soll, nmlich im Array
    Int10Jmp, ab Index 2.
    (Das Konstrukt bedeutet: Bilde einen generischen Zeiger, der auf
    Int10Jmp [2] zeigt. Wandle diesen generischen Zeiger in einen Zeiger
    auf einen Zeiger um und dereferenziere dann diesen Zeiger...)
  }
  GetIntVec ($10, PPointer (@Int10Jmp [2])^);
  SetIntVec ($10, @Int10);
  Int10Installed := TRUE;
END;





PROCEDURE DeinstallInt10Handler;
{ Setzt den orginalen Int10-Vektor wieder }

TYPE
  PPointer = ^POINTER;

BEGIN
  SetIntVec ($10, PPointer (@Int10Jmp [2])^);
  Int10Installed := FALSE;
END;





{ -------------------------------------------------------------------------- }
{ Kleinkruscht }


PROCEDURE GraphOff;
{ Schaltet wenn ntig die Grafik aus }

BEGIN
  IF (Graphics <> gNone) THEN BEGIN
    CloseGraph;
    Graphics := gNone;
  END;
END;



PROCEDURE Abort (Msg: STRING);

BEGIN
  { Grafik abschalten wenn sie eingeschaltet ist }
  GraphOff;

  { Eigenen Handler fr den Int10 wieder rcksetzen wenn ntig. Auerdem
    in diesem Fall den Modus 3 setzen, weil u.U. die Mglichkeit besteht,
    da sich der Bildschirm noch im Grafik-Modus befindet.
  }
  IF (Int10Installed) THEN BEGIN
    DeinstallInt10Handler;
    ASM
      push    bp
      mov     ax, 0003h
      int     10h
      pop     bp
    END;
  END;

  { Meldung ausgeben und Ende }
  Writeln (Msg);
  Halt (1);
END;





PROCEDURE SetVars;
{ Diverse Variablen rechnen bzw. holen }
BEGIN
  MaxX := GetMaxX + 1;
  MaxY := GetMaxY + 1;

  { Faktoren fr die Skalierung rechnen }
  MaxX2  := MaxX DIV 2;
  MaxY2  := MaxY DIV 2;
  MaxX10 := MaxX DIV 10;
  MaxY10 := MaxY DIV 10;
END;




FUNCTION FileHandle (VAR F: FILE): INTEGER; ASSEMBLER;
{ Gibt das Handle zurck, das eine Dateivariable benutzt }
ASM
  les     di, [F]
  mov     ax, es:[di]           { Handle nach ax }
END;




{ -------------------------------------------------------------------------- }
{ Einschalten der Grafik }


PROCEDURE ScreenGraph;
{ Schaltet die Bildschirmgrafik ein }

VAR
  GraphDriver, GraphMode : INTEGER;
  I                      : WORD;
  Result                 : INTEGER;

BEGIN
  GraphDriver := Detect;
  InitGraph (GraphDriver, GraphMode, '');
  Result := GraphResult;
  IF (Result < 0) THEN BEGIN
    Abort ('Fehler beim Einschalten der Grafik: ' + GraphErrorMsg (Result));
  END;

  { Jetzt vermerken, da die Grafik an ist }
  Graphics := gScreen;

  { Diverse Werte holen und merken }
  SetVars;
  MaxColor := GetMaxColor;
END;






PROCEDURE PrinterGraph;
{ Schaltet die Druckergrafik ein }

VAR
  GraphDriver : INTEGER;
  I           : WORD;
  Result      : INTEGER;

BEGIN
  GraphDriver := InstallUserDriver ('PRINTER', NIL);
  IF (GraphDriver < 0) THEN BEGIN
    Abort ('Fehler beim Installieren von PRINTER.BGI');
  END;

  { Grafik einschalten, Palette setzen }
  InitGraph (GraphDriver, PrinterMode, '');
  Result := SHORTINT (GraphResult);
  IF (Result < 0) THEN BEGIN
    Abort ('Fehler beim Einschalten der Grafik: ' + GraphErrorMsg (Result));
  END;

  { Jetzt vermerken, da die Grafik an ist }
  Graphics := gPrinter;

  { Diverse Werte holen und merken }
  SetVars;
  MaxColor := GetMaxColor;
  Settings.Size := MaxColor+1;

  { Die Drucker-Einstellungen schicken }
  SetAllPalette (Settings);
END;



{ -------------------------------------------------------------------------- }





FUNCTION RandomColor : WORD;
{ Sucht eine vernnftig sichtbare Farbe zufallsgesteuert raus }
BEGIN
  IF (Graphics = gScreen) THEN BEGIN
    { Ausgaben gehen auf den Bildschirm, einer der oberen 8 Farben
      raussuchen.
    }
    RandomColor := Random (7) + 8;     { Kein Wei }
  END ELSE BEGIN
    { Drucker }
    IF (MaxColor = 7) THEN BEGIN
      { HPDJ 500C }
      RandomColor := Random (6) + 1;   { Kein Wei, kein Schwarz }
    END ELSE BEGIN
      { Schwarz-Wei Drucker }
      RandomColor := 1;                { Nur Schwarz, sorry }
    END;
  END;
END;







FUNCTION RandomFillStyle : WORD;
{ Sucht zufallsgesteuert ein Fllmuster aus }
BEGIN
  RandomFillStyle := Random (11) + 2;    { Kein SolidFill/EmptyFill }
END;





PROCEDURE MakeScreen;
{ Dies ist die Prozedur die die Grafik auf den Bildschirm bringt. Die Grafik
  wird mglichst unabhngig von der Auflsung skaliert, wobei dies nicht
  immer ganz problemlos ist, da die Druckertreiber ein anderes X/Y-Verhltnis
  haben. Aber versuchen kann man's ja zumindest ...
}

CONST
  { Titel des Bildes }
  Title = 'Kufer von SVGA.BGI';

  { verschiedene Prozentzahlen, mssen zusammen 100 ergeben }
  PieSliceCount = 3;
  Vert : ARRAY [1..PieSliceCount] OF WORD = (
    14, 55, 31
  );

  { Die entsprechenden Texte dazu }
  Desc : ARRAY [1..PieSliceCount] OF STRING [40] = (
    'Uni''s & Schulen',
    'Private Anwender',
    'Kommerzielle Anwender'
  );


VAR
  X, Y           : INTEGER;
  StartAngle     : WORD;      { Startwinkel in Grad }
  EndAngle       : WORD;      { EndWinkel in Grad }
  MidAngle       : REAL;      { Zwischenwert zw. Start und Ende in rad }
  Color          : WORD;      { Zeichenfarbe }
  I              : WORD;
  HorJustify     : WORD;
  VerJustify     : WORD;


BEGIN
  { Erst mal einen Rahmen um das Ganze ziehen }
  SetColor (MaxColor);
  Rectangle (0, 0, MaxX-1, MaxY-1);

  { berschrift setzen }
  SetTextStyle (TriplexFont, HorizDir, 4);
  SetTextJustify (CenterText, CenterText);
  SetUserCharSize (MaxX10, 50, MaxY10, 50);     { Auflsungsunabhngig skalieren }
  OutTextXY (MaxX2, (3 * TextHeight (Title)) DIV 2, Title);

  { Dicke Linien als Begrenzung verwenden }
  SetLineStyle (SolidLn, 0, ThickWidth);

  { Das Tortendiagramm in die Mitte setzen }
  StartAngle := 0;
  FOR I := 1 TO PieSliceCount DO BEGIN

    { Farbe fr Umrandung ist immer MaxColor }
    SetColor (MaxColor);

    { Fllmuster holen und setzen }
    SetFillStyle (RandomFillStyle, RandomColor);

    { Kuchenstck zeichnen. Das Kuchenstck wird etwas aus der Mitte heraus-
      geschoben, der X-/Y-Anteil dieser Verschiebung wird anhand des mittleren
      Winkels berechnet, den das Kuchenstck hat.
    }
    EndAngle := StartAngle + (36 * Vert [I]) DIV 10;
    MidAngle := ((360 - ((StartAngle + EndAngle) DIV 2)) / 180) * PI;

    X := MaxX2 + Round (Cos (MidAngle) * (MaxX10 DIV 5));
    Y := MaxY2 + Round (Sin (MidAngle) * (MaxY10 DIV 5));
    PieSlice (X, Y, StartAngle, EndAngle, MaxX10 * 2);

    { Der jetzige Endwinkel wird zum neuen Startwinkel }
    StartAngle := EndAngle;

    { Den Text neben dem Kuchenstck ausgeben. Dazu zuerst die Text-
      Einstellungen vornehmen.
    }
    SetColor (MaxColor);
    SetTextStyle (SmallFont, HorizDir, 4);
    SetUserCharSize (MaxX10, 40, MaxY10, 40);     { Auflsungsunabhngig skalieren }
    IF (MidAngle > (PI / 2)) AND (MidAngle < (3 * (PI / 2))) THEN BEGIN
      { Kuchenstck liegt links, Justify entsprechend einstellen }
      HorJustify := RightText;
    END ELSE BEGIN
      { Kuchenstck liegt rechts, Justify entsprechend einstellen }
      HorJustify := LeftText;
    END;
    IF (MidAngle > 0) AND (MidAngle < PI ) THEN BEGIN
      { Kuchenstck liegt oben, Justify entsprechend einstellen }
      VerJustify := TopText;
    END ELSE BEGIN
      { Kuchenstck liegt rechts, Justify entsprechend einstellen }
      VerJustify := BottomText;
    END;
    SetTextJustify (HorJustify, VerJustify);

    { Position berechnen }
    X := MaxX2 + Round (Cos (MidAngle) * ((MaxX2 DIV 2) + (MaxX10 DIV 5)));
    Y := MaxY2 + Round (Sin (MidAngle) * ((MaxY2 DIV 2) + (MaxY10 DIV 5)));

    { Text ausgeben }
    OutTextXY (X, Y, Desc [I]);

  END;
END;




{ -------------------------------------------------------------------------- }
{ Ausgabe einer Meldungszeile auf dem Bildschirm }


PROCEDURE GraphMsg (Msg: STRING; Color: WORD);

BEGIN
  { Farbe setzen }
  SetColor (Color);

  { Text skalieren und ausgeben }
  SetTextStyle (TriplexFont, HorizDir, 4);
  SetTextJustify (CenterText, CenterText);
  SetUserCharSize (MaxX10, 70, MaxY10, 70);     { Auflsungsunabhngig skalieren }
  OutTextXY (MaxX2, MaxY - MaxY10, Msg);
END;



{ -------------------------------------------------------------------------- }
{ Ausdruck }





PROCEDURE Print;

BEGIN
  { Die Meldung ausgeben, da gedruckt wird }
  GraphMsg ('Es wird gedruckt ...', MaxColor);

  { Den Int10-Handler installieren, damit der Bildschirm nicht gelscht wird. }
  InstallInt10Handler;

  { Dann CloseGraph ausfhren }
  CloseGraph;

  { Grafik neu einschalten, aber mit Druckertreiber }
  PrinterGraph;

  { Nochmals Ausgabe des Bildes, diesmal auf Drucker }
  MakeScreen;

  { Grafik abschalten, CloseGraph druckt gleichzeitig }
  CloseGraph;

  { Und die Bildschirm-Grafik wieder installieren }
  ScreenGraph;

  { Die Meldung lschen indem sie in Hintergrundfarbe geschrieben wird }
  GraphMsg ('Es wird gedruckt ...', Black);

  { Zum Schlu den alten Int10-Vektor restaurieren }
  DeinstallInt10Handler;
END;

{ -------------------------------------------------------------------------- }
{ Drucker-Auswahl, Optionen-Auswahl usw. }



PROCEDURE ChoosePrinter;
{ Bietet ein Menue und lt den Drucker auswhlen }

VAR
  I : WORD;

BEGIN
  { Menue fr Druck-Modus bringen und Auswahl holen }
  Writeln (' 0 -> EPSON  8-Nadel,       240 *  72 DPI');
  Writeln (' 1 -> EPSON  8-Nadel,       240 * 216 DPI');
  Writeln (' 2 -> EPSON 24-Nadel,       180 * 180 DPI');
  Writeln (' 3 -> EPSON 24-Nadel,       360 * 180 DPI');
  Writeln (' 4 -> EPSON 24-Nadel,       360 * 360 DPI');
  Writeln (' 5 -> NEC P6,               360 * 360 DPI');
  Writeln (' 6 -> IBM Proprinter X24,   180 * 180 DPI');
  Writeln (' 7 -> IBM Proprinter X24,   360 * 180 DPI');
  Writeln ('14 -> Benutzermodus 1');
  Writeln ('15 -> Benutzermodus 2');
  Writeln ('16 -> HP-LaserJet            75 * 75  DPI');
  Writeln ('17 -> HP-LaserJet           100 * 100 DPI');
  Writeln ('18 -> HP-LaserJet           150 * 150 DPI');
  Writeln ('19 -> HP-LaserJet           300 * 300 DPI');
  Writeln ('20 -> HP-LaserJet            75 * 75  DPI ohne Kompression');
  Writeln ('21 -> HP-LaserJet           100 * 100 DPI ohne Kompression');
  Writeln ('22 -> HP-LaserJet           150 * 150 DPI ohne Kompression');
  Writeln ('23 -> HP-LaserJet           300 * 300 DPI ohne Kompression');
  Writeln ('24 -> HP-DeskJet 500C,       75 * 75  DPI');
  Writeln ('25 -> HP-DeskJet 500C,      100 * 100 DPI');
  Writeln ('26 -> HP-DeskJet 500C,      150 * 150 DPI');
  Writeln ('27 -> HP-DeskJet 500C,      300 * 300 DPI');
  Writeln ('32 -> HP-LaserJet           600 * 600 DPI');
  Writeln;

  { Eingabe holen }
  Write   ('Ihre Auswahl: ');
  Readln (PrinterMode);
  Writeln;

  { Eingabe prfen }
  IF (PrinterMode < 0) OR (PrinterMode > 32) OR
     ((PrinterMode >= 8) AND (PrinterMode <= 13)) OR
     ((PrinterMode >= 28) AND (PrinterMode <= 31)) THEN BEGIN
    Abort ('Ungltiger Modus.');
  END;
END;





PROCEDURE ChooseOptions;
{ Bietet ein Menue und lt eventuelle Optionen whlen }

VAR
  FileName : PathStr;
  F        : FILE;

BEGIN
  IF (PrinterMode >= 16) AND (PrinterMode <= 23) THEN BEGIN
    { Nur in den LaserJet-Modi }
    Writeln ('Ausgabequalitt:');
    Writeln ('0  -->   wie am Drucker eingestellt');
    Writeln ('1  -->   Draft');
    Writeln ('2  -->   Letter Quality');
    Writeln;
    Write   ('Auswahl ? '); Readln (Settings.Colors [1]);
    Writeln;

    IF (Settings.Colors [1] < 0) OR (Settings.Colors [1] > 2) THEN BEGIN
      Abort ('Ungltiger Wert');
    END;

  END ELSE IF (PrinterMode >= 24) AND (PrinterMode <= 27) THEN BEGIN

    Writeln ('Ausgabequalitt:');
    Writeln ('0  -->   wie am Drucker eingestellt');
    Writeln ('1  -->   Draft');
    Writeln ('2  -->   Letter Quality');
    Writeln;
    Write   ('Auswahl ? '); Readln (Settings.Colors [1]);
    Writeln;

    IF (Settings.Colors [1] < 0) OR (Settings.Colors [1] > 2) THEN BEGIN
      Abort ('Ungltiger Wert');
    END;

    Writeln ('Shingling:');
    Writeln ('0  -->   keines (Default)');
    Writeln ('1  -->   50% (zwei Durchgnge)');
    Writeln ('2  -->   25% (vier Durchgnge)');
    Writeln;
    Write   ('Auswahl ? '); Readln (Settings.Colors [2]);
    Writeln;

    IF (Settings.Colors [2] < 0) OR (Settings.Colors [2] > 2) THEN BEGIN
      Abort ('Ungltiger Wert');
    END;

    Writeln ('Depletion:');
    Writeln ('0  -->   keine');
    Writeln ('1  -->   25% (Default)');
    Writeln ('2  -->   50%');
    Writeln;
    Write   ('Auswahl ? '); Readln (Settings.Colors [3]);
    Writeln;

    IF (Settings.Colors [3] < 0) OR (Settings.Colors [3] > 2) THEN BEGIN
      Abort ('Ungltiger Wert');
    END;
  END;

  { Abfragen ob in eine Datei gedruckt werden soll }
  Write ('Dateiname fr Ausgabe (keine Angabe = Gert PRN): ');
  FileName := '';
  ReadLn (FileName);

  IF (FileName <> '') THEN BEGIN
    { Jetzt kommt's - Dateiumleitung in Pascal ! }

    { Beliebige Datei mit bergebenem Namen ffnen }
    Assign (F, FileName);
    ReWrite (F, 1);                { Fehlercheck fehlt hier , $I+ (hoffentlich) }

    { Achtung: Es darf nur ein dup ausgefhrt werden, wenn das Handle nicht
      bereits den gewnschten Wert hat. Das ist zwar hier korrekt, weil bei
      Programmstart das Handle 4 immer offen ist, das von F verwendete Handle
      also immer ungleich 4 ist, das mu jedoch nicht immer so sein (z.B.
      wenn der Code in eine Funktion gepackt wird, die mehrfach aufgerufen
      wird).
    }
    IF (FileHandle (F) <> 4) THEN BEGIN

      { DUP2 ausfhren }
      ASM
        mov     bx, WORD PTR [F]           { Datei-Handle holen }
        mov     cx, 4                      { Drucker-Handle }
        mov     ax, 4600h                  { Force duplicate file handle }
        int     21h
        jnc     @@L1                       { Springe wenn kein Fehler }
        mov     [InOutRes], ax             { Fehlercode merken }
      @@L1:
      END;
      IF (IOResult <> 0) THEN BEGIN
        { dup2 ging schief }
        Writeln ('Fehler bei der Umleitung nach ', Filename);
        Halt (1);
      END;

      { Orginale Datei kann geschlossen werden (Fehlercheck fehlt hier) }
      Close (F);

    END;

  END;
END;






PROCEDURE ClosePrinterHandle; ASSEMBLER;
{ Schliet das Handle mit der Nummer 4 bei Programmende. Ist evtl. notwendig
  wenn in eine Datei gedruckt wurde (obwohl DOS eigentlich offene Dateien bei
  Programmende schliet), schadet aber nichts, wenn das Handle nicht
  umgeleitet wurde, der Drucker ist dann halt nicht mehr ansprechbar. Da
  der Aufruf aber sowieso bei Programmende erfolgt macht das nix.
}
ASM
  mov     ah, 3Eh
  mov     bx, 4             { Handle 4 }
  int     21h
  jnc     @@L1              { Springe wenn kein Fehler }
  mov     [InOutRes], ax    { Code fr IOResult merken }
@@L1:
END;





PROCEDURE GetVideoMode;
{ Holt beim Programmstart die Daten des eingestellten Videomodus nach
  ModeRegs.
}

BEGIN
  ModeRegs.AH := $0F;
  Intr ($10, ModeRegs);
END;




{ -------------------------------------------------------------------------- }
{ Hauptprogramm }



BEGIN
  { Titel ausgeben }
  Writeln ('BGI-Treiber Demo  Copyright (C) Ullrich von Bassewitz 1992, 93');
  Writeln;

  Writeln ('Dieses Programm zeigt die Anwendung eines Druckertreibers parallel');
  Writeln ('zu einer Bildschirmgrafik.');
  Writeln ('Um das Programm laufen zu lassen bentigen Sie folgende Dateien');
  Writeln ('im aktuellen Verzeichnis:');
  Writeln ('   - PRINTER.BGI            (der Druckertreiber)');
  Writeln ('   - EGAVGA.BGI             (Grafiktreiber fr den Bildschirm)');
  Writeln ('   - *.CHR                  (Vektorzeichenstze)');
  Writeln ('Weiter mit einer Taste oder Abbruch mit Ctrl-Break...');
  REPEAT UNTIL (ReadKey <> #00);
  Writeln;

  { Zufallsgenerator initialisieren }
  Randomize;

  { Die Werte des eingestellten Bildschirm-Modus holen }
  GetVideoMode;

  { Drucker auswhlen lassen }
  ChoosePrinter;

  { Eventuelle Optionen whlen }
  ChooseOptions;

  { Vor dem ersten Einschalten der Grafik den Puffer erhhen, sonst klappt
    bei den hohen Auflsungen das Fllen nicht mehr.
  }
  SetGraphBufSize (8192);           { 8 KB }

  { Bildschirm-Grafik einschalten }
  ScreenGraph;

  { Ausgabe auf Bildschirm vornehmen }
  MakeScreen;

  { Auf Taste warten }
  GraphMsg ('Drucken mit beliebiger Taste...', MaxColor);
  REPEAT UNTIL (ReadKey <> #00);
  GraphMsg ('Drucken mit beliebiger Taste...', Black);

  { Ausdruck durchfhren, dabei Bildschirminhalt behalten }
  Print;

  { Nochmal auf Taste warten, dann Ende }
  GraphMsg ('Beliebige Taste fr Programmende...', MaxColor);
  REPEAT UNTIL (ReadKey <> #00);

  { Grafik abschalten }
  GraphOff;

  { Druckerhandle schlieen }
  ClosePrinterHandle;
END.
