/******************************************************************************/
/*                                                                            */
/*      Modul zur Ansteuerung der seriellen Schnittstelle ber INT 14H        */
/*                                                                            */
/* (C) 1992 by                                                                */
/*     Ullrich von Bassewitz                                                  */
/*     Zwehrenbhlstrae 33                                                   */
/*     D-7400 Tbingen                                                        */
/*                                                                            */
/******************************************************************************/




#ifndef __I14_H
#define __I14_H




// Definitionen fr Parity und Baudrate
enum TParity    { pNone, pOdd, pEven };
enum TBaudRate  { bd110, bd150, bd300, bd600, bd1200, bd2400,
                  bd4800, bd9600 };






class far SerialPort {

private:
    unsigned    PortNr;                 // Nummer des Ausgabeports
    unsigned    MaxTries;               // Anzahl Wiederholungen bei Timeout

    // Privater Copy-Kontruktor
    SerialPort (const& SerialPort)      {}      // leer

public:
    // Konstruktor
    SerialPort (unsigned Port,
                TBaudRate Baudrate,
                TParity Parity,
                unsigned StopBits,
                unsigned DataBits);

    // Destruktor (virtuell erzwingen)
    virtual ~SerialPort ()      {}      // Keine Aktion

    // Methoden
    virtual void Error (unsigned Errno);// Fehlerbehandlung
    virtual int HandShakeOk ()  = 0;    // pure virtual
    void SetTimeoutRetries (unsigned Tries)     { MaxTries = Tries; }
    virtual void OutByte (char B);      // Ausgabe eines Zeichens
    void OutString (char far *S);       // Ausgabe einer Zeichenkette
    virtual char InByte ();             // Zeichen holen
    virtual int ByteAvail ();           // Prft ob ein Zeichen da ist
    virtual void CheckPortStatus (unsigned S);  // Prft den bergebenen Status

};




class far HardWiredPort : public SerialPort {

public:
    // Konstruktor
    HardWiredPort (unsigned Port,
                   TBaudRate Baudrate,
                   TParity Parity,
                   unsigned StopBits,
                   unsigned DataBits) :
        SerialPort (Port, Baudrate, Parity, StopBits, DataBits)  {}

    // Neue HandshakeOk-Methode
    virtual int HandShakeOk ();

};





class far XonXoffPort : public SerialPort {

private:
    // Merker wenn angehalten wg. Handshake
    int         Stopped;

public:
    // Konstruktor
    XonXoffPort (unsigned Port,
                 TBaudRate Baudrate,
                 TParity Parity,
                 unsigned StopBits,
                 unsigned DataBits) :
        SerialPort (Port, Baudrate, Parity, StopBits, DataBits),
        Stopped (0)  { }

    // Neue HandshakeOk-Methode
    virtual int HandShakeOk ();

};



/*****************************************************************************/
/*                                                                           */
/* Die Funktion gibt die Datei auf die serielle Schnittstelle aus. Benutzt   */
/* wird dazu das ROM-BIOS, also der Interrupt 14h. Die bergebenen Parameter */
/* haben folgende Bedeutung:                                                 */
/*                                                                           */
/*   FileName        ist der Name der auszugebenden Datei.                   */
/*   PreString       ist ein String, der vor dieser Datei noch auf die       */
/*                   Schnittstelle ausgegeben wird. Dies kann z.B. ein       */
/*                   Steuerstring sein, der dem Plotter das Protokoll        */
/*                   mitteilt.                                               */
/*   Port            ist ein bereits initialisiertes Schnittstellenobjekt.   */
/*                                                                           */
/* Das Ergebnis ist 0 wenn die Datei erfolgreich ausgegeben werden konnte    */
/* und entspricht bei Fehlern errno. Bei Fehlern bei der Ausgabe auf die     */
/* Schnittstelle erfolgt ein Programmabbruch, es sei denn, es wird ein       */
/* Objekt bergeben, bei dem die Error-Funktion berdefiniert worden ist.    */
/*                                                                           */
/* ------------------------------------------------------------------------- */



// Ausgabefunktion
int far Plot (char far *FileName, char far *PreString, SerialPort far &Port);



//
// Ende von I14.H
//

#endif
