/******************************************************************************/
/*                                                                            */
/*                   Demo-Programm zum PLOTTER.BGI Treiber                    */
/*                                                                            */
/* (C) 1992 by                                                                */
/*     Ullrich von Bassewitz                                                  */
/*     Zwehrenbhlstrae 33                                                   */
/*     D-7400 Tbingen                                                        */
/*                                                                            */
/******************************************************************************/





#include <io.h>
#include <sys\stat.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <graphics.h>
#include "i14.h"




// Konstanten TRUE und FALSE
const unsigned TRUE = 1;
const unsigned FALSE = 0;




static unsigned GraphIsOn = TRUE;               // TRUE wenn Grafik an
static char TempName []   = "PLOTDEMO.TMP";     // Name der temporren Datei



// *** Port-Einstellungen ***
const unsigned PortNr           = 2;
const TBaudRate Baudrate        = bd9600;
const TParity Parity            = pNone;
const unsigned StopBits         = 1;
const unsigned DataBits         = 8;




int     MaxX;
int     MaxY;



/******************************************************************************/


void GraphicsOff ()
// Schaltet die Grafik aus
{
    if (GraphIsOn) {
        // Grafik beenden
        closegraph ();

        // Handle 3 schlieen
        (void) close (3);

        GraphIsOn = FALSE;

    }
}






void Error (char *Msg)
{
    GraphicsOff ();
    fprintf (stderr, "%s\n", Msg);
    exit (1);
}





void GraphicsOn ()
// Schaltet die Grafik ein, lenkt die Ausgabe fr Handle 3 um
{
    int GraphDriver, GraphMode;
    int Result;
    int Handle;
    char Buf [256];


    // Treiber installieren
    if ((GraphDriver = installuserdriver ("PLOTTER", NULL)) < 0) {
        Error ("Fehler beim Installieren von PLOTTER.BGI");
    }

    // Grafik einschalten, DIN A4 = Modus 0
    // ACHTUNG: Die folgende Variable _BGI_auto ist eine undokumentierte
    // Variable, die im ursprnglichen BGI-Konzept dafr vorgesehen war, das
    // Lschen des Bildschirms zu unterdrcken, indem sie vom Treiber
    // (PLOTTER.BGI) auf einen "magischen" Wert gesetzt wird (zumindest habe
    // ich die Doku im Device Drivers Toolkit so verstanden). Aufgrund eines
    // der vielen Fehler im Grafik Kernel funktioniert dies jedoch nicht, da
    // das Lschen des Bildschirms *vor* dem Aufruf des Treibers geschieht, so
    // da dieser danach diese Variable setzen kann wie er lustig ist,
    // allerdings ohne Wirkung...
    // In der "C"-Version ist diese Variable jedoch ffentlich zugnglich und
    // kann so vor dem Einschalten des Grafik-Modus vom Programm gesetzt werden.
    // Es gibt jedoch keine Garantie dafr, da dieses Vorgehen mit spteren
    // Versionen des Grafik-Kernels kompatibel ist (es ist jedoch anzunehmen,
    // da sich an der GRAPHICS Library nicht mehr viel ndern wird).
    extern char _BGI_auto;
    _BGI_auto = 0xA5;           // Bildschirm nicht lschen
    GraphMode = 0;
    initgraph (&GraphDriver, &GraphMode, "");
    if ((Result = (char) graphresult ()) != 0) {
        strcpy (Buf, "Fehler bei der Initialisierung: ");
        strcat (Buf, grapherrormsg (Result));
        Error (Buf);
    }

    // Handle umleiten
    if ((Handle = creat (TempName, S_IWRITE)) < 0) {
        Error ("Fehler beim Erzeugen der temporren Datei.");
    }
    (void) dup2 (Handle, 3);
    (void) close (Handle);

    // Randwerte des Modus abholen
    MaxX = getmaxx ();
    MaxY = getmaxy ();

    // Vermerken, da die Grafik eingeschaltet ist
    GraphIsOn = TRUE;
}




/******************************************************************************/


void Border (int X1, int Y1, int X2, int Y2)
{
    setcolor (0);
    setlinestyle (SOLID_LINE, 0, NORM_WIDTH);
    rectangle (X1, Y1, X2, Y2);
}





void SetText (unsigned Font, unsigned Size)
// Setzt einen Font in der bergebenen Gre
{
    settextstyle (Font, HORIZ_DIR, 4);
    settextjustify (LEFT_TEXT, TOP_TEXT);
    setusercharsize ((Size * 50) / 10, 10, (Size * 50) / 10, 10);
}



void Demo1 ()
{
    static const char DemoText [] = "Demo von PLOTTER.BGI !";
    static const unsigned Dist = 50;

    int WX1, WY1, WX2, WY2;
    int X, Y;



    // Ausgabebereich festlegen
    WX1 = 0;
    WY1 = 0;
    WX2 = (MaxX / 2) - 50;
    WY2 = (MaxY / 2) - 50;

    // Rahmen ziehen
    Border (WX1, WY1, WX2, WY2);

    setcolor (1);

    X = 200; Y = 100;
    SetText (TRIPLEX_FONT, 25);
    outtextxy (X, Y, DemoText);
    Y += textheight (DemoText) + Dist;

    SetText (SANS_SERIF_FONT, 25);
    outtextxy (X, Y, DemoText);
    Y += textheight (DemoText) + Dist;

    SetText (GOTHIC_FONT, 25);
    outtextxy (X, Y, DemoText);
    Y += textheight (DemoText) + Dist;

    SetText (5, 25);
    outtextxy (X, Y, DemoText);
    Y += textheight (DemoText) + Dist;

    SetText (6, 25);
    outtextxy (X, Y, DemoText);
}







void Kurve1 (int XE, int XS, int Y0, int YH, unsigned Perioden, int Sign)
{
    static const Dist = 2;

    int X, Y, LastX, LastY;
    int G;

    LastX = 0x7FFF; LastY = 0x7FFF;
    for (G = 0; G <= Perioden * 360; G += Dist) {
        X = (( double (XE - XS) / (double (Perioden) * 360.0)) * double (G)) + XS;
        Y = Y0 - Sign * (double (YH) * cos ((M_PI / 180.0) * double (G)));
        if ((LastX != 0x7FFF) && (LastY != 0x7FFF)) {
            line (LastX, LastY, X, Y);
        }
        LastX = X;
        LastY = Y;
    }
}





void Kurve2 (int XE, int XS, int Y0, int YH, unsigned Periode1, unsigned Periode2)
{
    static const Dist = 2;

    int X, Y, LastX, LastY;
    int G;

    LastX = 0x7FFF; LastY = 0x7FFF;
    for (G = 0; G <= Periode2 * 360; G += Dist) {
        X = (( double (XE - XS) / (double (Periode2) * 360.0)) * double (G)) + XS;
        Y = Y0 - (double (YH) * cos ((M_PI / 180.0) * double (G)) *
                cos ((M_PI / 180.0) * (double (G) / double (Periode2))
                * double (Periode1)));
        if ((LastX != 0x7FFF) && (LastY != 0x7FFF)) {
            line (LastX, LastY, X, Y);
        }
        LastX = X;
        LastY = Y;
    }
}





void Demo2 ()
{
    int WX1, WY1, WX2, WY2;
    int Y0, YH, XS, XE;


    // Ausgabebereich festlegen
    WX1 = (MaxX / 2) + 50; WY1 = 0;
    WX2 = MaxX; WY2 = (MaxY / 2) - 50;

    // Rahmen ziehen
    Border (WX1, WY1, WX2, WY2);

    // Diagramm festlegen
    Y0 = (WY1 + WY2) / 2;
    YH = (Y0 - WY1) - 400;
    XS = WX1 + 600;
    XE = WX2 - 400;

    setlinestyle (SOLID_LINE, 0, NORM_WIDTH);
    line (XS - 200, Y0, XE, Y0);
    line (XS, Y0 - YH - 200, XS, Y0 + YH + 200);

    setcolor (1);
    Kurve1 (XE, XS, Y0, YH, 1, 1);
    Kurve1 (XE, XS, Y0, YH, 1, -1);
    setcolor (0);
    Kurve2 (XE, XS, Y0, YH, 1, 20);
}









void Demo3 ()
{
    int WX1, WY1, WX2, WY2;

    // Ausgabebereich festlegen
    WX1 = 0; WY1 = (MaxY / 2) + 50;
    WX2 = (MaxX / 2) - 50; WY2 = MaxY;

    // Rahmen ziehen
    Border (WX1, WY1, WX2, WY2);

    // Geflltes Ellipsenstck ausgeben
    setcolor (0);
    setfillstyle (SLASH_FILL, 1);
    sector (WX1 + (WX2 - WX1) / 2, WY1 + (WY2 - WY1) / 2,
            20, 340,
            (WX2 - WX1) / 2 - 500, (WY2 - WY1) / 2 - 500);
}





void Demo4 ()
{
    static const int Rad = 500;
    static const int Count = 6;
    static const int Styles [Count] = {
        EMPTY_FILL, LINE_FILL, SLASH_FILL, BKSLASH_FILL, HATCH_FILL, XHATCH_FILL
    };
    int WX1, WY1, WX2, WY2;


    // Ausgabebereich festlegen
    WX1 = (MaxX / 2) + 50; WY1 = (MaxY / 2) + 50;
    WX2 = MaxX; WY2 = MaxY;

    // Rahmen ziehen
    Border (WX1, WY1, WX2, WY2);

    // 6 verschieden gefllte Kreise
    setcolor (1);
    for (int I = 0; I < Count; I++) {
        setfillstyle (Styles [I], 0);
        pieslice (WX1 + ((WX2 - WX1) / 4) * ((I % 3) + 1),
                  WY1 + ((WY2 - WY1) / 3) * ((I / 3) + 1),
                  0, 360, Rad);
    }
}






void MakeDemo ()
// Erzeugt diverse Ausgaben
{
    Demo1 ();
    Demo2 ();
    Demo3 ();
    Demo4 ();
}





void Output ()
// Gibt den Inhalt der temporren Datei auf den Plotter aus und lscht diese
{
    char Buf [200];

    // Seriellen Port initialisieren
    HardWiredPort Port (PortNr, Baudrate, Parity, StopBits, DataBits);

    // Timeout-Zeit hochsetzen
    Port.SetTimeoutRetries (100);

    // Datei ausgeben
    int Result = Plot (TempName, NULL, Port);
    if (Result) {
        sprintf (Buf, "Fehler %i bei der Ausgabe auf den Plotter.");
        Error (Buf);
    }

    // Temporre Datei lschen
    unlink (TempName);
}




/******************************************************************************/





int main ()
{
    // Ausgaben nicht puffern
    setbuf (stdout, 0);

    printf ("Dieses Programm demonstriert die Ausgabe von Grafik auf den Plotter.\n"
            "Der Treiber PLOTTER.BGI und die Vektorzeichenstze mssen sich dazu\n"
            "im aktuellen Verzeichnis befinden. Die Ausgabe erfolgt auf COM2 mit\n"
            "9600 Baud und Hardware-Handshake. Fr andere Einstellungen mu das\n"
            "Programm gendert und neu bersetzt werden.\n"
            "Bitte legen Sie ein Blatt Papier (DIN A4) in den Plotter und setzen\n"
            "Sie zwei Stifte (Positionen 1 und 2) ein.\n"
            "\n"
            "Abbruch mit ESC oder weiter mit beliebiger Taste...");
    if (getc (stdin) == 0x1B) {
        printf ("\n");
        return 0;
    }

    printf ("\n");
    GraphicsOn ();
    printf ("Temporre Datei wird erzeugt...\n");
    MakeDemo ();
    GraphicsOff ();

    printf ("\n");
    GraphicsOn ();
    printf ("Temporre Datei wird erzeugt...\n");
    MakeDemo ();
    GraphicsOff ();

    printf ("Es wird geplottet...\n");
    Output ();

    return 0;
}
