PROGRAM oop3dk1;
  {zeigt mittels Flat-Shading alle vordef.konvexen Koerper, K.-system}
  {sowie Beispiel einer Raumkurve und Raumflaeche}

uses oop3d,graph,oopdraw,graphwc,shapes;
type
     ku=object(kurve3d) 			{Kugeloxodrom}
          function fx(t:real):real;virtual;  
          function fy(t:real):real;virtual;
          function fz(t:real):real;virtual;
        end;
var w,r0,r:real;
    screen:device;
    bo:fillbox;wu:fillwuerfel;te:filltetraeder;ok:filloktaeder;dod:filldodekaeder;
    ik:fillikosaeder;plx:fillplanex;ply:fillplaney;plz:fillplanez;
    ma:fillmatarea;co:coordsystem;k3:ku;ls:lightscene;
const c=0.2;

{----------------------------------------------}
 {Kugeloxodrom}

function ku.fx(t:real):real;
begin
  w:=arctan(exp(c*t));r0:=1/(sqrt(1+exp(2*c*t)));r:=r0*sin(w);
  fx:=10*r*cos(t)
end;

function ku.fy(t:real):real;
begin
  w:=arctan(exp(c*t));r0:=1/(sqrt(1+exp(2*c*t)));r:=r0*sin(w);
  fy:=10*r*sin(t);
end;

function ku.fz(t:real):real;
begin
  w:=arctan(exp(c*t));r0:=1/(sqrt(1+exp(2*c*t)));r:=r0*sin(w);
  fz:=10*r0*cos(w);
end;
{----------------------------------------------}

begin
   OpenGraphic256('c:\tp\bgi');
   screen.init;
   message('Moment bitte !',lightred);
   ls.init;				{Lightscene initialisieren}
   bo.init;				{Box}
   bo.scal(10,10,7);
   bo.fattr(blue,1);
   wu.init;				{Wuerfel}
   wu.scal(10,10,10);
   wu.fattr(green,1);
   te.init;				{Tetraeder}
   te.scal(10,10,10);
   te.fattr(cyan,1);
   ok.init;ok.scal(12,12,12);		{Oktaeder}
   ok.fattr(red,1);
   dod.init;dod.scal(8,8,8);		{Dodekaeder}
   dod.fattr(magenta,1);
   ik.init;ik.scal(7,7,7);		{Ikosaeder}
   ik.fattr(yellow,1);
   plx.init;plx.scal(2,2,2);		{PlaneX}
   plx.fattr(magenta,1);plx.rot(0,0,-40);
   ply.init;ply.scal(2,2,2);		{PlaneY}
   ply.fattr(blue,1);
   plz.init;plz.scal(2,2,2);		{PlaneZ}
   plz.fattr(cyan,1);
   ma.init(25,-100,-100,100,100);	{Raumflaeche}
   ma.fattr(red,1);
   ma.scal(0.6,0.6,0.2);ma.rot(20,0,0);
   k3.init(120,-20,20);
   k3.scal(15,15,15);			{Raumkurve}
   co.init;co.scal(0.5,0.5,0.5);	{Koordinatensystem}
   ls.setlsource(-90,65,1000);
   ls.rot(0,0,20);
   ls.orthproj(-90,80);			{Projektion}
   ls.hlhsr;ls.painter;
   ls.cshade;ls.lattr(0,0,1);co.lattr(white,0,1);k3.lattr(lightred,0,1);
   bo.copy(100,500);wu.copy(250,500);te.copy(400,500);ok.copy(550,500);
   dod.copy(700,500);k3.copy(400,250);
   ik.copy(100,150);plx.copy(250,150);ply.copy(400,150);plz.copy(550,150);
   ma.copy(700,150);
   message('Darstellung konvexer Koerper,Bsp.Kurve,Flaeche',lightred);
   co.show;
   wait;
   Graph.CloseGraph;
end.{oop3dk1}