;****************************************************************************
; Filename: SETBUF.ASM
;   Author: Adam Seychell
;  Version: 0.0
;  Created: 1995.April.29
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: void @setbuf(FILE *stream, char *buf);
;  Comment: sets current buffer of IO stream.
;    Input: Eax = file pointer
;           Edx = pointer of buffer, If NUL then use no buffering
;   Output: Nothing.
;****************************************************************************
; Function: int @setvbuf(FILE *stream, char *buf, int type, size_t size);
;  Comment: sets current buffer of IO stream.
;    Input: Eax = file pointer
;           Edx = pointer of buffer, If NUL then malloc a new one
;           Ecx = Buffer type _IOFBF,_IONBF ,ect
;         [esp] = buffer size
;   Output: On success, setvbuf returns 0, otherwize non-zero.
;****************************************************************************

        Include STDDEF.INC

        Codeseg
;-------------------------------------------------------------------------
Proc setbuf,2
        Mov     Ecx,_IOFBF
        TestZ   Edx
        jnz @@F
        Mov     Ecx,_IONBF
@@F:
        Push    BUFSIZ
        Call    @setvbuf
        add     Esp,4
        Ret

Endp





;-------------------------------------------------------------------------
Proc setvbuf,4
        Push    Edi
        Mov     Edi,Eax

        Mov     Eax,[esp+2*4]           ; get buffer size
        Cmp     Ecx,_IONBF
        jne @@gbuf
        Mov     Eax,1
@@gbuf: Mov     [Edi + FILE._buffersize],Eax

        Push    Edx
        call    @fflush
        Mov     Eax,[Edi + FILE._base]  ; Free old buffer
        Call    @free
        Pop     Eax
        TestZ   Eax                 ; if buf* != zero then malloc new
        Jnz   @@gotit
        Mov     Eax,[esp+2*4]       ; get buffer size
        Call    @malloc
        TestZ   Eax
        Jz     @@error
@@gotit:
        Mov     [Edi + FILE._base],Eax
        Clear   Eax
        Pop     Edi
        Ret
@@error:
        Or      [Edi + FILE._mode], 08
        Mov     al,1
        Pop     Edi
        Ret
Endp

        End
