/* This file is SYSEMX.C
**
** contains :
**
**	- int21 32bit handler (called from adosx32.asm)
**	- int21 emx syscall handler
**
** Copyright (c) Rainer Schnitker 92,93
*/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <malloc.h>
#include <io.h>
#include <time.h>
#include <errno.h>
#include <bios.h>
#include <sys/timeb.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "DPMI.H"
#include "DPMIDOS.H"
#include "PROCESS.H"
#include "SIGNALS.H"
#include "GNUAOUT.H"
#include "START32.H"
#include "CDOSX32.H"
#include "COPY32.H"
#include "EXCEP32.H"
#include "RSX.H"
#include "DEBUG.H"
#include "PTRACE.H"
#include "TERMIO.H"
#include "DOSERRNO.H"

#define EMSDOS 37

static int time_reached(unsigned long time)
{
    if (time <= time_tic)
	return 1;
    else
	return 0;
}

static void set_ecx_error(int err)
{
    EAX = -1L;
    ECX = (long) err;
}

static void set_no_error(void)
{
    EAX = ECX = 0L;
}

static void set_eax_return(DWORD reg_eax)
{
    EAX = reg_eax;
    ECX = 0L;
}

static int i_21_7f(void)
{
    int i, ret;
    long temp;

    switch (EAX & 0xff) {	/* al=? */
    case 0x00:			/* oldbrk_eax sbrk(inc_edx) ; err:eax=-1 */
	EAX = getmem(EDX, npz);
	break;

    case 0x01:			/* eax=0 brk(newbrk_edx) ; err:eax=-1 */
	if (EDX <= npz->brk_value)
	    EAX = -1L;
	else if ((EAX = getmem(EDX - npz->brk_value, npz)) != -1L)
	    EAX = 0L;
	break;

    case 0x02:			/* maxbrk_eax ulimit(cmd_ecx,newlimit_edx) errno:ecx */
	if (ECX == 3L) {
	    FREEMEMINFO fm;
	    GetFreeMemInfo(&fm);
	    set_eax_return(fm.LargestFree + npz->brk_value);
	} else
	    set_ecx_error(EINVAL);
	break;

    case 0x03:			/* not used: void vmstat ; err:- */
	break;

    case 0x04:			/* not used: eax umask(edx) ; err:- */
	EAX = EDX;
	break;

    case 0x05:			/* eax getpid(void) err:- */
	EAX = (DWORD) npz->pid;
	break;

    case 0x06:			/* eax spawnve(proc_env *edx) err:carry errno:eax */
	{
            PROCESS_ENV pe;
            char filename[128];
	    char **argp, **envp;
	    char *envmem, *argmem;

	    /* get process data, check mode */
	    cpy32_16(DS, EDX, &pe, sizeof(PROCESS_ENV));
	    pe.mode &= 0xff;
	    if (pe.mode == P_NOWAIT || pe.mode == P_SESSION || pe.mode == P_DETACH) {
		EAX = EINVAL;
		return CARRY_ON;
	    }
	    /* get args and env from caller */
	    if ( (argmem = (char *) malloc((WORD) pe.arg_size )) == NULL
		|| (envmem = (char *) malloc((WORD) pe.env_size)) == NULL
		|| (argp = (char **) malloc((pe.arg_count + 1) * sizeof(char *))) == NULL
		|| (envp = (char **) malloc((pe.env_count + 1) * sizeof(char *))) == NULL ) {
		printf("argmem,envmem to large\n");
		if (argmem != NULL)
		    free(argmem);
		if (envmem != NULL)
		    free(envmem);
		if (argp != NULL)
		    free(argp);
		if (envp != NULL)
		    free(envp);
		EAX = E2BIG;
		return CARRY_ON;
	    }
	    /* get args from user ds, built arg-vector */
	    cpy32_16(DS, pe.arg_off, argmem, pe.arg_size);
	    for (i = 0; i < (int) pe.arg_count; i++) {
		argmem++;	/* skip flag */
		argp[i] = argmem;
		argmem += strlen(argp[i]) + 1;
	    }
	    argp[i] = NULL;

	    /* get env from user ds, built env-vector */
	    cpy32_16(DS, pe.env_off, envmem, pe.env_size);
	    for (i = 0; i < (int) pe.env_count; i++) {
		envp[i] = envmem;
		envmem += (strlen(envp[i]) + 1);
	    }
	    envp[i] = NULL;

	    /* get filename */
	    cpy32_16(DS, pe.fname_off, filename, 128);

	    /* load a.out prg */
	    ret = exec32(pe.mode, filename, pe.arg_count, argp, pe.env_count, envp);

	    /* if error, try a real-mode prg */
	    if (ret == ENOEXEC && pe.mode == P_WAIT)
		ret = realmode_prg(filename, argp, envp);

	    free(argmem);
	    free(envmem);
	    free(argp);
	    free(envp);

	    /* check error and return */
	    if (ret) {
		EAX = (DWORD) ret;
		return CARRY_ON;
	    } else
		return CARRY_OFF;
	}

	/* case 0x07: nothing */

    case 0x08:			/* eax ptrace(ebx,edi,edx,ecx) err:ecx!=0 eax=-1 */
	{
	    WORD pid_now = npz->pid;
	    if ((ret = do_ptrace(BX, DI, EDX, ECX, &temp)) != 0)
		set_ecx_error(ret);
	    else if (pid_now == npz->pid)	/* save if same process */
		set_eax_return(temp);
	}
	break;

    case 0x09:			/* eax=child_id wait(status_edx) ; errno:ecx */
	if ((ret = sys_wait(&i)) != -1) {
	    EDX = (DWORD) (unsigned) i;
	    set_eax_return((DWORD) ret);
	} else
	    set_ecx_error(ESRCH);
	break;

    case 0x0a:			/* get emx-version ; err:- */
	EAX = 0x302e3866;	/* emx0.8f */
	EBX = 1L << 6;		/* dpmi 0.9 bit */
	ECX = 0L;		/* reserved */
	EDX = 0L;
	break;

    case 0x0b:			/* eax_pages memavail(void) ; err:- */
	{
	    FREEMEMINFO fm;

	    GetFreeMemInfo(&fm);
	    EAX = fm.MaxUnlockedPages;
	}
	break;

    case 0x0c:			/* (*prevh) signal(signo_ecx,address_edx) err:eax=-1 */
	if (ECX >= MAX_SIGNALS || ECX == SIGKILL) {
	    EAX = SIG_ERR;
	    break;
	}
	EAX = npz->sigs[CX];	/* return prev handler */

	if (EDX == SIG_DFL || EDX == SIG_IGN)
	    npz->sigs[CX] = EDX;
	else if (EDX == SIG_ACK)
	    npz->sig_ack &= ~(1L << CX);
	else if (verify_illegal(npz, EDX, 4))	/* user handler */
	    EAX = SIG_ERR;
	else
	    npz->sigs[CX] = EDX;

	break;

    case 0x0d:			/* eax=0 kill(id_edx,signo_ecx) errno:ecx eax=-1 */
	{
	    NEWPROCESS *p;
	    if (!(p = find_process(DX))) {
		set_ecx_error(ESRCH);
		break;
	    }
	    else if (send_signal(p, CX)) {
		set_ecx_error(EINVAL);
		break;
	    }
	    else
		set_no_error();
	    /* to simulate multitasking, we switch to child */
	    if (p->pptr->pid == npz->pid) {
		npz->p_status = PS_SYS_KILL;
		switch_to_process(p);
		npz->p_status = PS_RUN;
	    }
	}
	break;

    case 0x0e:			/* eax raise(ecx) errno:ecx eax=-1 */
	if (send_signal(npz, CX))
	    set_ecx_error(EINVAL);
	break;

    case 0x0f:			/* uflags */
	break;

    case 0x10:			/* void unwind(void) err:no */
	break;

    case 0x11:			/* core(handle_ebx) err:carry errno */
	EAX = EINVAL;
	return CARRY_ON;

    case 0x12:			/* portaccess(ecx,edx) ecx=first edx=last, err:cy errno:eax */
	/* dpmi-server must allow this */
	ECX = 0L;		/* first port *
	EDX = 0x3ffL;		/* last port */
	EAX = 0L;
	break;

    case 0x13:			/* eax memaccess(ebx,ecx,edx) err:carry errno:eax */
	/* under DPMI it's better to used a different segment */
	/* memaccess destroy protection -> limit 0xffffffff */
	/* must use wrap-around to access memory */

	if (opt_memaccess && EBX >= 0xA0000L && ECX <= 0xFFFFFL) {
	    EAX = EBX - npz->dsbase;
	    return CARRY_OFF;
	} else {
	    EAX = EINVAL;
	    return CARRY_ON;
	}

    case 0x14:			/* eax ioctl2(ebx,ecx,edx) errno:ecx eax=-1*/
	if ((ECX >= TCGETA && ECX <= TCFLSH) || ECX == FIONREAD) {
	    if (EBX == 0) {
		if (!(ret = kbd_ioctl(CX, EDX)))
		    set_no_error();
		else
		    set_ecx_error(ret);
	    } else
		set_ecx_error(EBADF);
	} else if (ECX == FGETHTYPE) {
	    tr.eax = 0x4400;
	    tr.ebx = EBX;
	    if (realdos())
		set_ecx_error(EBADF);
	    else {
		i = (WORD) tr.edx;
		if (!(i & 128))
		    temp = HT_FILE;
		else if (i & 3)
		    temp = HT_DEV_CON;
		else if (i & 4)
		    temp = HT_DEV_NUL;
		else if (i & 8)
		    temp = HT_DEV_CLK;
		else
		    temp = HT_DEV_OTHER;

		set_no_error();
		store32(DS, EDX, temp);
	    }
	} else
	    set_ecx_error(EBUSY);

	break;

    case 0x15:			/* eax=sec alarm(sec_edx) err:no */
	if (time_tic < npz->time_alarm)	/* there seconds left */
	    EAX = (npz->time_alarm - time_tic) * 10 / 182;
	else
	    EAX = 0;

	if (EDX == 0)		/* clear alarm */
	    npz->time_alarm = 0;
	else			/* set alarm */
	    npz->time_alarm = time_tic + EDX * 182 / 10;
	break;

	/* case 0x16: internal emx */

    case 0x17:			/* eax=0 sleep(edx) err:no */
	{
	    unsigned long timel;

	    timel = time_tic + EDX * 182 / 10;
	    for (;;)
		if (time_reached(timel))
		    break;
	    EAX = 0;
	}
	break;

    case 0x18:			/* chsize(handle_ebx,lenght_edx) err:carry eax=errno */
	tr.eax = 0x4200L ;
	tr.ebx = EBX ;
	tr.ecx = EDX >> 16 ;
	tr.edx = EDX & 0xFFFF ;
	tr.flags = FLAGS & ~1 ;
	if (realdos()) {
	    EAX = (DWORD) doserror_to_errno((WORD)tr.eax);
	    return CARRY_ON ;
	}
	tr.eax = 0x4000L ;
	tr.ebx = EBX ;
        tr.ecx = 0;
	tr.edx = (DWORD)(WORD)iobuf;
	tr.flags = FLAGS & ~1 ;
	if (realdos()) {
	    EAX = (DWORD) doserror_to_errno((WORD)tr.eax);
	    return CARRY_ON ;
	}
	EAX = 0;
	return CARRY_OFF ;

    case 0x19:			/* eax fcntl(handle ebx,req ecx,arg edx) errno:ecx */
	if (ECX != F_SETFL && (EDX & ~(FCNTL_NDELAY | FCNTL_APPEND)) == 0)
	    set_ecx_error(EINVAL);
	else if (EBX == 0) {
	    set_fcntl_flag(DX);
	    set_no_error();
	} else
	    set_ecx_error(EBADF);
	break;

    case 0x1a:			/* eax pipe(edx,ecx) errno:ecx*/
	set_ecx_error(EMSDOS);
	break;

    case 0x1b:			/* eax fsync(ebx) errno:ecx */
	set_ecx_error(EMSDOS);
	break;

    case 0x1c:			/* eax fork(void) errno:ecx */
	if ((ret = sys_fork()) != 0)
	    set_ecx_error(ret);
	else {
	    set_eax_return((DWORD) npz->cptr->pid);
	    npz->p_status = PS_SYS_FORK;
	    switch_to_process(npz->cptr);
	    npz->p_status = PS_RUN;
	    set_no_error();
	}
	break;

    case 0x1d:			/* void scrsize(EDX) */
	store32(DS, EDX + 0, (*(unsigned short far *)(0x0040004a)));
	store32(DS, EDX + 4, (*(unsigned char far *)(0x00400084))+1);
	break;

    case 0x1e:			/* void select(edx) errno:ecx */
	set_ecx_error(EMSDOS);
	break;

    case 0x1f:			/* eax syserrno(void) */
	EAX = (DWORD) errno;
	break;

    case 0x20:			/* eax stat(name_edx,struc_edi) errno:ecx */
	{
	    struct stat st;
	    long stat32[13];

	    strcpy32_16(DS, EDX, iobuf);
	    if (!stat(iobuf, &st)) {
		stat32[0] = (long) st.st_dev;
		stat32[1] = (long) st.st_ino;
		stat32[2] = (long) st.st_mode;
		stat32[3] = 1;	/* st_nlink */
		stat32[4] = 0;	/* st_uid */
		stat32[5] = 0;	/* st_gid */
		stat32[6] = 0;	/* st_rdev */
		stat32[7] = st.st_size;
		stat32[8] = st.st_atime;
		stat32[9] = st.st_mtime;
		stat32[10] = st.st_ctime;
		stat32[11] = 0;	/* attribut file _A_NORMAL */
		stat32[12] = 0;
		cpy16_32(DS, EDI, stat32, 13 * sizeof(DWORD));
		set_no_error();
	    } else
		set_ecx_error(errno);
	}
	break;

    case 0x21:			/* eax fstat(ebx,edi) errno:ecx */
	{
	    struct stat st;
	    long stat32[13];

	    if (!fstat(BX, &st)) {
		stat32[0] = (long) st.st_dev;
		stat32[1] = (long) st.st_ino;
		stat32[2] = (long) st.st_mode;
		stat32[3] = 1;	/* st_nlink */
		stat32[4] = 0;	/* st_uid */
		stat32[5] = 0;	/* st_gid */
		stat32[6] = 0;	/* st_rdev */
		stat32[7] = st.st_size;
		stat32[8] = st.st_atime;
		stat32[9] = st.st_mtime;
		stat32[10] = st.st_ctime;
		stat32[11] = 0; /* _A_NORMAL  attribut file */ ;
		stat32[12] = 0;
		cpy16_32(DS, EDI, stat32, 13 * 4);
		set_no_error();
	    } else
		set_ecx_error(errno);
	}
	break;

	/* case 0x22: nothing */

    case 0x23:			/* filesys(edx,edi,ecx) errno:ecx */
	strcpy32_16(DS, EDI, (char *) "FAT");
	set_no_error();
	break;

    case 0x24:			/* eax utimes(name_edx,struc_esi) errno:ecx */
	/* set access and modif time of file  */
	set_ecx_error(EMSDOS);
	break;

    case 0x25:			/* eax ftruncate(ebx,edx) errno:ecx */
	if ((temp = filelength(BX)) == -1)
	    temp = 0;		/* bug? -1: if just opened */
	if (temp > (long) EDX) {
	    if (chsize(BX, EDX))
		set_ecx_error(errno);
	    else
		set_no_error();
	} else
	    set_no_error();
	break;

    case 0x26:			/* eax clock(void) err:no */
	/* clk_tck = 100 ; timer 18.2 pre sec */
	EAX = (time_tic - npz->time_tic) * 500 / 91;
	EDX = 0;
	break;

    case 0x27:			/* void ftime(edx) err:no */
	{
	    struct timeb tb;
	    long tm[4];
	    ftime(&tb);
	    tm[0] = tb.time;
	    tm[1] = (long) tb.millitm;
	    tm[2] = (long) tb.timezone;
	    tm[3] = 0;
	    cpy16_32(DS, EDX, tm, 16);
	}
	break;

    case 0x28:			/* eax umask(edx) err:no */
	EAX = (long) umask(DX);
	break;

    case 0x29:			/* eax getppid(void) err:no */
	EAX = (DWORD) npz->pptr->pid;
	break;

    case 0x2a:			/* void nls_memupr(edx,ecx) err:no */
	/* buffer to upper case */
	break;

    case 0x2b:			/* eax open(edx,ecx) errno:ecx */
	/* pathname <= sizeof(iobuf) ! */
	strcpy32_16(DS, EDX, iobuf);

	if (ECX & 0x10000) {	/* create */
	    (WORD) tr.ecx = CX >> 8;
	    tr.eax = 0x3C00 ;
	} else {		/* open */
	    tr.eax = 0x3D00L | (CX & 0xff);
	}
	tr.edx = (DWORD) (WORD) iobuf ;
	tr.flags = FLAGS & ~1 ;
	if (realdos())
	    set_ecx_error( doserror_to_errno((WORD)tr.eax));
	else
	    set_eax_return(tr.eax);
	break;

    case 0x2c:			/* eax newthread(edx) errno:ecx */
	set_ecx_error(EMSDOS);
	break;

    case 0x2d:			/* eax endthread(void) errno:ecx */
	set_ecx_error(EMSDOS);
	break;

    case 0x2e:
	set_ecx_error(EMSDOS);
	break;

    case 0x2f:			/* read_kbd (edx) err:carry*/
	{
	    int key;

	    if (DX & 2) {	/* wait */
		while (_bios_keybrd(kready))
		    _bios_keybrd(kread);
		key = _bios_keybrd(kread);
	    } else
	     /* no wait */ if ((key = _bios_keybrd(kready)) != 0)
		key = _bios_keybrd(kread);
	    else {
		EAX = -1;
		return CARRY_ON;
	    }

	    if ((key & 0xff) == 0xE0)
		key = 0;

	    if (DX & 1)		/* echo */
		if ((key & 0xff) >= 32)
		    putchar(key & 0xff);

	    if (DX & 4 && (char) key == 3)	/* signal */
		send_signal(npz, SIGINT);

	    EAX = (DWORD) (0 | (key & 0xff));

	    return CARRY_OFF;
	}

    case 0x30:			/* sleep2 ; err:-*/
	{
	    unsigned long timel;

	    timel = time_tic + EDX / 55;
	    for (;;)
		if (time_reached(timel))
		    break;
	}
	break;

    default:
	printf("!!Unknown DOS call: %04X %08lX %08lX %08lX\n", AX, EBX, ECX, EDX);
	set_ecx_error(EIO);
	return CARRY_ON;

    }				/* switch al */

    return CARRY_NON;

}

void int21(void)
{
    WORD ret;

    if (opt_print_syscalls)
	printf("DOS 21h: %04X %08lX %08lX %08lX",
	       AX, EBX, ECX, EDX);

    if ((AX & 0xff00) == 0x7f00)/* emx functions */
	ret = i_21_7f();
#ifdef _DJGPP_
    else if ((AX & 0xff00) == 0xff00)	/* go32 functions */
	ret = i_21_ff();
#endif
    else {			/* DOS functions */
	ret = int21normal();
	/* if DOS indicates an error (carry-flag set), convert error code */
	if (ret == CARRY_NON && (FLAGS & 1))
	    EAX = (DWORD) doserror_to_errno(AX);
    }

    if (ret == CARRY_ON)
	EFLAGS |= 1;
    else if (ret == CARRY_OFF)
	EFLAGS &= ~1L;

    if (opt_print_syscalls)
	printf(" ret=%lX\n",EAX);

    if (npz->time_alarm != 0 && time_reached(npz->time_alarm)) {
	npz->time_alarm = 0;
	send_signal(npz, SIGALRM);
    }
    /* stack check */
    if (npz->init_brk - ESP + 0x1000 >= npz->stacksize) {
	puts("stack too small!!");
	printf("esp %lX top %lX size %lX\n",ESP,npz->init_brk,npz->stacksize);
	send_signal(npz, SIGKILL);
    }
}
