/* This file is RSX.C
** contains :
**
**      - get options
**      - switch protected mode
**      - check copro, install emu
**      - load first a.out prg
**
** Copyright (c) Rainer Schnitker '92 '93
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include "DPMI.H"
#include "PROCESS.H"
#include "START32.H"
#include "LOADPRG.H"
#include "FPU.H"
#include "RSX.H"

/* command-line options */
char copro = 1;			/* prg need 387 : 0=no 1=yes 3=emulate */
char opt_printall = 0;		/* show all information */
char opt_print_syscalls = 0;	/* show every sys_call */
char opt_memaccess = 0;		/* allows memaccess */
char opt_allow = 0;		/* allow execute stack */
char opt_debug = 0;		/* debug prg */
int opt_stackval = 0;		/* stack size in KB */

int kread;                      /* keyboard read */
int kready;                     /* keyboard check */
char **org_env;			/* org. environment to rsx */
int org_envc;			/* org. env items */
WORD emu_sel = 0;		/* emu data-sel */
DWORD copro_struct;		/* address of soft-387 struct */
POINTER16_32 emu_entry;		/* entry address emu (for init) */

static char *emu_name;		/* emu filename */
static char version[] = "alpha v0.51";
static char filename[128];

/* load emu & init */
static int emu387(char *filename)
{
    printf("load 387 emulation ..");

    if (load_protected_program(filename, npz))
	return -1;

    /* init some emu vars for long-jmp, emu data selector access */
    emu_sel = npz->data32sel;
    emu_entry.off = npz->entry;
    emu_entry.sel = npz->code32sel;
    LockLinRegion(npz->memaddress, npz->membytes);

    /* emu_init call emulator to install exception handler */
    copro_struct = emu_init();
    /* return the 387-register struct, need for switching prgs */

    puts(" and init");

    return 0;
}

/* get one options for rsx */
/* return last read char pos, if successful */
static char *scan_for_option(char *s)
{
    int z;

    switch (*s) {
    case 'a':			/* DOS features */
	for (++s; *s > ' '; ++s) {
	    if (*s == 'm')
		opt_memaccess = 1;
	    else if (*s == 'c')
		opt_allow = 1;
	    else if (*s == 'i' || *s == 'w')
		continue;
	    else
		return NULL;
	}
	if (*(--s) == 'a')
	    return NULL;
	else
	    break;

    case 'c':			/* core */
	break;

    case 'e':                   /* assume no 387 used */
	copro = 0;
	break;

    case 'f':
    case 's':			/* stack size */
	if (!isdigit(*(++s)))
	    return NULL;
	sscanf(s, "%d %n", &opt_stackval, &z);
	return s + z;

    case 'o':			/* print messages to stdout */
	break;

    case 'p':			/* don't use lower DOS mem (ok for dpmi) */
	break;

    case 'P':			/* print syscalls */
	opt_printall = 1;
	break;

    case 'I':			/* print syscalls */
	opt_print_syscalls = 1;
	break;

    case 'S':
	opt_debug = 1;
	break;

    default:
	return NULL;
    }

    return s;
}

static void get_keyboard_type()
{
    if ( (*(unsigned char _far *)0x00400096 ) & 0x10 ) {
        kread = 0x10;           /* services for enhanced keyboards */
        kready = 0x11;
    } else {
        kread = 0;              /* services for other keyboards */
        kready = 1;
    }
}

#ifdef __TURBOC__

int _bios_keybrd(int mode)
{
    _AH = (char)mode ;
    asm    mov	  dl,ah ;
    asm    and	  dl,0x0F ;
    asm    int	  0x16 ;
    asm    jne	  L1 ;
    asm    cmp	  dl,0x01 ;
    asm    jne	  L1 ;
    asm    xor	  ax,ax ;
    asm    jmp	  L2 ;
L1:
    asm    cmp	  dl,0x02 ;
    asm    je	  L2 ;
    asm    or	  ax,ax ;
    asm    jne	  L2 ;
    asm    dec	  ax ;
L2:
    return _AX ;
}

unsigned int stklen = 8192;

#endif

void main(int argc, char **argv, char **env)
{
    int i;
    char *s;

    printf("RSX dpmi-extender %s (c) Rainer Schnitker '92'93\n", version);

    /* save environment, env-size */
    for (org_envc = 0; env[org_envc] != NULL; org_envc++)
	;
    org_env = env;

    /* get enviroment options */
    for (s = getenv("RSXOPT"); *s != 0; ++s) {
	while (*s == ' ')
	    ++s;
	if (*s == '-') {
	    s = scan_for_option(++s);
	    if (s == NULL) {
		puts("error in RSXOPT");
		exit(1);
	    }
	} else
	    break;
    }

    /* get command-line options */
    for (i = 1; i <= argc; i++) {
	s = argv[i];
	if (*s == '-') {
	    s = scan_for_option(++s);
	    if (s == NULL) {
		printf("bad option %s\n", argv[i]);
		exit(1);
	    }
	} else
	    break;
    }


    /* copro required, 387 there ? */
    if (copro && !npx_installed())
	copro = 3;

    if (argc <= i) {
	puts("no filename defined");
	exit(1);
    }
    strcat(filename, argv[i]);

    get_keyboard_type();

    fflush(stdin);
    fflush(stdout);

    if (real_to_protected(1))
	exit(1);


    /* now protected mode! */

    if (hangin_extender()) {
	puts("ERROR: can't hang in extensions");
	protected_to_real(1);
    }
    /* init process-tables */
    init_this_process();

    /* hang in emulation */
    if (copro == 3) {
	emu_name = getenv("RSX387");
	if (emu_name == NULL) {
	    puts("Can't find emu");
	    shut_down(2);
	}
	if (emu387(emu_name) == -1) {
	    printf("Can't load emu %s\n", emu_name);
	    shut_down(2);
	}
    }

    i = exec32(P_WAIT, filename, argc - i, argv + i, org_envc, org_env);

    if (i == ENOEXEC)
	puts("Not a valid a.out format");
    else
	puts(strerror(i));

    shut_down(1);
    /* never reached */
}
