/* Copyright    Rainer Schnitker 92,93 */

#ifndef _DPMI_TYPES
#define _DPMI_TYPES

typedef unsigned char   BYTE;
typedef BYTE far        *LPBYTE;
typedef unsigned int    WORD;
typedef WORD far        *LPWORD;
typedef unsigned long   DWORD;
typedef DWORD far       *LPDWORD;
#endif

#define N_MAGIC(exec) ((exec).a_info & 0xffff)
#define OMAGIC 0x107
#define NMAGIC 0x108
#define ZMAGIC 0x10B

#define SEGMENT_SIZE 0x10000L
#define N_TXTADDR(x) 0x10000L
#define N_DATADDR(x) (SEGMENT_SIZE + ((N_TXTADDR(x)+(x).a_text-1) & ~(SEGMENT_SIZE-1)))
#define N_BSSADDR(x) (N_DATADDR(x) + (x).a_data)

#define _N_HDROFF(x) (1024 - sizeof (struct exec))
#define N_TXTOFF(x) _N_HDROFF((x)) + sizeof (struct exec)
#define N_DATOFF(x) (N_TXTOFF(x) + (x).a_text)
#define N_TRELOFF(x) (N_DATOFF(x) + (x).a_data)
#define N_DRELOFF(x) (N_TRELOFF(x) + (x).a_trsize)
#define N_SYMOFF(x) (N_DRELOFF(x) + (x).a_drsize)
#define N_STROFF(x) (N_SYMOFF(x) + (x).a_syms)


typedef struct exec {
    DWORD a_info;     /* Use macros N_MAGIC, etc for access */
    DWORD a_text;     /* length of text, in bytes */
    DWORD a_data;     /* length of data, in bytes */
    DWORD a_bss;      /* length of uninitialized data area for file, in bytes */
    DWORD a_syms;     /* length of symbol table data in file, in bytes */
    DWORD a_entry;    /* start address */
    DWORD a_trsize;   /* length of relocation info for text, in bytes */
    DWORD a_drsize;   /* length of relocation info for data, in bytes */
    } GNUOUT ;

struct exe_hdr {
    WORD signatur;
    WORD low;
    WORD high;
    WORD reloc;
    WORD hdr_para;
    } ;

struct emx_hdr {
        char sig[18];
        unsigned long next_hdr;
        } ;
