;
; COPY32.ASM (c) Rainer Schnitker 92,93
;

;
; copy to or from 32bit segments
;

	.386p

DGROUP group _DATA

_DATA segment word public 'DATA' use16
_DATA ends

_TEXT segment byte public 'CODE' use16
        assume cs:_TEXT,ds:DGROUP


	;
	; void store32(WORD ds,DWORD offset,DWORD value)
	;
public _store32
_store32 proc near
	; stack: 4 = WORD ds32, 6 = DWORD off32, 10 = DWORD value
	push	bp
	mov	bp,sp
        push    ds
	push	ebx
        push    eax
	mov	ax,word ptr [bp+4]		; get user ds
        mov     ds,ax
	mov	eax,dword ptr [bp+6]		; get user offset
	mov	ebx,dword ptr [bp+10]		; get value
	mov	[eax],ebx
        pop     eax
	pop	ebx
        pop     ds
	pop	bp
        ret
_store32 endp


	;
	; DWORD read32(WORD ds,DWORD offset)
	;
public _read32
_read32 proc near
	; stack: 4 = WORD ds32, 6 = DWORD off32
        push    bp
	mov	bp,sp
        push    ds
	mov	ax,word ptr [bp+4]		; get user ds
        mov     ds,ax
	mov	eax,dword ptr [bp+6]		; get user offset
        mov     edx,[eax]
	movzx	eax,dx				; convert result
	shr	edx,16				; in DX:AX
        pop     ds
        pop     bp
	ret
_read32 endp


	;
	; void bzero32(WORD ds,DWORD offset,DWORD size)
	;
public _bzero32
_bzero32 proc near
	; stack: 4 = WORD ds32, 6 = DWORD off32, 10 = DWORD bytes
	push	bp
	mov	bp,sp
        push    es
        push    esi
        push    edi
	mov	ax,word ptr [bp+4]		; get user ds
	mov	es,ax
	mov	edi,dword ptr [bp+6]		; get user offset
	mov	ecx,dword ptr [bp+10]		; get size
	xor	eax,eax 			; store 0
        cld

        rep
	db 067h 				; use es:edi
        stosb

	pop	edi
        pop     esi
        pop     es
	pop	bp
	ret
_bzero32 endp


	;
	; void cpy16_32(WORD ds,DWORD off,void *off16,DWORD size)
	;
public _cpy16_32
_cpy16_32 proc near
	; stack: 4 = ds32, 6 = DWORD off32, 10 = p16, 12 = DWORD bytes
	push	bp
	mov	bp,sp
        push    es
        push    esi
        push    edi
	mov	ax,word ptr [bp+4]		; get user ds
	mov	es,ax				; dest = ES:EDI
	mov	edi,dword ptr [bp+6]		; get user 32bit offset
	movzx	esi, word ptr [bp+10]		; source offset (DS:SI)
	mov	ecx,dword ptr [bp+12]		; get size
        cld

	push	ecx
	shr	ecx,00000002H
	jecxz	@byte_cpy16_32
        rep
        db 067h                                 ; use es:edi
	movsd

@byte_cpy16_32:
	pop	ecx
	and	ecx,00000003H
	jecxz	@end_cpy16_32
	rep
	db 067h 				; use es:edi
	movsb

@end_cpy16_32:
	pop	edi
        pop     esi
        pop     es
	pop	bp
	ret
_cpy16_32 endp


	;
	; void cpy32_16(WORD ds,DWORD off,WORD ds16,WORD,off16,DWORD size)
	;
public _cpy32_16
	; stack: 4 = WORD ds32, 6 = DWORD off32, 10 = p16, 12 = DWORD bytes
_cpy32_16 proc near
	push	bp
	mov	bp,sp
        push    ds
        push    esi
        push    edi
	mov	ax,ds
	mov	es,ax				; dest segment
	movzx	edi, word ptr [bp+10]		; get dest 16bit offset
	mov	ax,word ptr [bp+4]		; get user ds
	mov	ds,ax				; source = DS:ESI
	mov	esi,dword ptr [bp+6]		; get user 32bit offset
	mov	ecx,[bp+12]			; get size
        cld

	push	ecx
	shr	ecx,00000002H
	jecxz	@byte_cpy32_16
        rep
        db 067h                                 ; use es:edi
	movsd

@byte_cpy32_16:
	pop	ecx
	and	ecx,00000003H
	jecxz	@end_cpy32_16
	rep
	db 067h 				; use es:edi
	movsb

@end_cpy32_16:
	pop	edi
        pop     esi
        pop     ds
	pop	bp
	ret
_cpy32_16 endp


	;
	; void strcpy16_32(WORD ds,DWORD off,WORD ds16,WORD,off16)
	;
public _strcpy16_32
_strcpy16_32 proc near
	; stack: 4 = WORD ds32, 6 = DWORD off32 , 10=word p16
	push	bp
	mov	bp,sp
        push    es
        push    esi
        push    edi
	mov	ax,word ptr [bp+4]		; get user ds
	mov	es,ax				; dest = ES:EDI
	mov	edi,dword ptr [bp+6]		; get user 32bit offset
	movzx	esi,word ptr [bp+10]		; source offset (DS:SI)
        cld

@cp16_32:
        db 067H                 ; use edi,esi
        lodsb                   ; copy ds:esi -> es:edi
        db 067H                 ; use edi,esi
        stosb
        or al,al
	jnz @cp16_32

        pop     edi
        pop     esi
        pop     es
	pop	bp
	ret
_strcpy16_32 endp


	;
	; void strcpy32_16(WORD ds,DWORD off,WORD ds16,WORD,off16)
	;
public _strcpy32_16
_strcpy32_16 proc near
	; stack: 4 = WORD ds32, 6 = DWORD off32 ,10 = WORD p16
	push	bp
	mov	bp,sp
        push    ds
        push    esi
        push    edi
	mov	ax,ds
	mov	es,ax				; dest segment
        movzx   edi, word ptr [bp+10]           ; get dest offset
	mov	ax,word ptr [bp+4]		; get user ds
	mov	ds,ax				; source = DS:ESI
	mov	esi,dword ptr [bp+6]		; get user offset
        cld

@cp32_16:
	db 067H 		; use edi,esi
        lodsb                   ; copy ds:esi -> es:edi
        db 067H                 ; use edi,esi
        stosb
        or al,al
	jnz @cp32_16

        pop     edi
        pop     esi
        pop     ds
	pop	bp
	ret
_strcpy32_16 endp

	;
	; void cpy32_32(WORD s_ds,DWORD s_off,WORD d_ds,DWORD d_off,DWORD size)
	;
public _cpy32_32
_cpy32_32 proc near
	; stack: 4 = source_ds32, 6 = DWORD source_off32
	;	10 = ds32, 12= DWORD off32, 16= DWORD bytes
	push	bp
	mov	bp,sp
	push	ds
        push    es
        push    esi
        push    edi
	mov	ax,word ptr [bp+4]		; get source dataseg
	mov	ds,ax				; source = DS:ESI
        mov     esi,dword ptr [bp+6]            ; get source offset

	mov	ax,word ptr [bp+10]		; get dest dataseg
	mov	es,ax				; dest = ES:EDI
	mov	edi,dword ptr [bp+12]		; get dest offset

	mov	ecx,dword ptr [bp+16]		; get size
        cld

	push	ecx
	shr	ecx,dword ptr 00000002H
	jecxz	@byte_cpy32_32
        rep
	db 067h 				; use edi,esi
	movsd

@byte_cpy32_32:
	pop	ecx
	and	ecx,dword ptr 00000003H
	jecxz	@end_cpy32_32
	rep
	db 067h 				; use edi,esi
	movsb

@end_cpy32_32:
	pop	edi
        pop     esi
        pop     es
	pop	ds
	pop	bp
	ret
_cpy32_32 endp


_TEXT ends

      end
