#if defined( Uses_TInputLong ) && !defined( __TInputLong )
#define __TInputLong

//flags for TInputLong constructor

const
  ilHex = 1,          //will enable hex input with leading '0x'
  ilBlankEqZero = 2,  //No input (blank) will be interpreted as '0'
  ilDisplayHex = 4;   //Number displayed as hex when possible

class far TRect;
class far TEvent;

class TInputLong : public TInputLine
{

public:

    TInputLong( const TRect& bounds, int aMaxLen, long lowerLim,
		    long upperLim, ushort flags, const char* labelName = 0 );
    ~TInputLong();

    virtual ushort dataSize();
    virtual void getData( void *rec );
    virtual void handleEvent( TEvent& event );
    virtual void setData( void *rec );
    virtual Boolean rangeCheck();
    virtual void error();
    virtual Boolean valid(ushort command);

    ushort ilOptions;
    long lLim, uLim;
    char* label;

private:

    virtual const char *streamableName() const
	{ return name; }

protected:

    TInputLong( StreamableInit );
    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:

    static const char * const near name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TInputLong& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TInputLong*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TInputLong& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TInputLong* cl )
    { return os << (TStreamable *)cl; }

#endif  // Uses_TInputLong

