
#ifndef _dos_unix_h
#define _dos_unix_h

#include <stddef.h>
#include <wattcp/tcp.h>              /* for htonl(), etc. */

typedef unsigned short u_short;
typedef unsigned int   u_int;
typedef unsigned long  u_long;

typedef char *         caddr_t;

typedef struct timeval {
      long     tv_sec;     /* seconds since Jan. 1, 1970 */
      long     tv_usec;    /* and microseconds */
};

typedef struct timezone {
      int      tz_minuteswest;   /* of Greenwich */
      int      tz_dsttime;       /* type of dst correction to apply */
};

/*
 * IP Protocols:  see /etc/protocols on a BSD machine.
 */
typedef enum ip_protos {
      IPPROTO_ICMP = 1,
      IPPROTO_TCP =  6,
      IPPROTO_UDP =  17,
};

/* IMPLEMENT THESE! */
int gettimeofday( struct timeval *tp, struct timezone *tzp );

#define bcopy( src, dst, len )     ( memcpy( dst, src, len ) )
/* void bcopy( const void *src, void *dst, size_t len ); */
#define bzero(src, len)     ( memset( src, '\0', len ) )
/* void bzero( char *b, size_t len ); */

#define streq( str0, str1 )   ( !strcmp( str0, str1) )

#endif /* def _dosunix_h */
