
/*
 * These routines are for MS-DOS... similiar to Unix, but a little simpler.
 */

#include <rpc/dosunix.h>
#include <rpc/dos_rpc.h>
#include <string.h>

/*
 * Looks up an IP protocol by name.
 */
int dos_getprotobyname(char *proto)
{
   int i;

   struct proto_info {
      char *proto_id;
      int  proto_num;
   };
#define NUM_PROTOS 2    /* number of protocols in table */
   static struct proto_info proto_table[] = {
         "tcp", IPPROTO_TCP,
         "udp", IPPROTO_UDP
   };

   for( i = 0 ; i < NUM_PROTOS ; i++ )
   {
      if( streq( proto, proto_table[i].proto_id ) )
             return proto_table[i].proto_num;
   }
   return (-1);
}
