#include <stdio.h>
#include <time.h>
#include <conio.h>
#include <fcntl.h>
#include <tcp.h>

#define MAXCHANNELS     8
#define MAXBUFFERLEN    256
#define READSIZE        512

#define NIL             0
#define INIT            1
#define WAITING         2
#define ACTIVE          3
#define SENDING         4
#define CLOSED          5

char* state[6] =
{
   "-NIL-",
   "INIT",
   "WAITING",
   "ACTIVE",
   "SENDING",
   "CLOSING"
};

struct channel
{
   tcp_Socket s;
   int        status;
   int        buflen;
   char       buffer[MAXBUFFERLEN + 1];
   int        fd;
   long       hits;
};

struct channel ch[MAXCHANNELS];

char* ErrorMsg;
long  errors = 0;

Box( int x, int y, char* t )
{
   int i;

   textcolor( BLACK );
   textbackground( LIGHTGRAY );
   gotoxy( x, y );
   cprintf( " %-35s", t );
   for( i = 0; i < 2; i++ )
   {
      gotoxy( x, y + i + 1 );
      cputs( "                                    " );
      textbackground( BLACK );
      cputs( "  " );
      textbackground( LIGHTGRAY );
   }
   gotoxy( x+2, y + 1 + i );
   textbackground( BLACK );
   cputs( "                                    " );
}

DrawScreen()
{
   int i;

   _wscroll = 0;
   clrscr();
   textbackground( LIGHTGRAY );
   textcolor( RED );
   cputs( " GS version 1.1 " );
   textcolor( BLACK );
   cputs( " Copyright 1994 by Mark Morley              mark@IslandNet.com " );
   textcolor( BLUE );
   textbackground( BLACK );
   for( i = 0; i < 23; i++ )
      cputs( "\r\n" );
   textcolor( BLACK );
   textbackground( LIGHTGRAY );
   cputs( "\r\n Hits: 0            Errors: 0                                                  " );
   Box( 2, 4, "Channel 1" );
   Box( 2, 9, "Channel 2" );
   Box( 2, 14, "Channel 3" );
   Box( 2, 19, "Channel 4" );
   Box( 41, 4, "Channel 5" );
   Box( 41, 9, "Channel 6" );
   Box( 41, 14, "Channel 7" );
   Box( 41, 19, "Channel 8" );
}

Status( int c, char* text )
{
   textbackground( LIGHTGRAY );
   switch( ch[c].status )
   {
      case INIT         : textcolor( RED );
                          break;
      case WAITING      : textcolor( BLACK );
                          break;
      case ACTIVE       : textcolor( YELLOW );
                          break;
      case SENDING      : textcolor( LIGHTGREEN );
                          break;
      case CLOSED       : textcolor( BLUE );
                          break;
      default           : textcolor( WHITE );
                          break;
   }
   switch( c )
   {
      case 7 : gotoxy( 25, 4 );   cprintf( "%12s", state[ch[c].status] );   break;
      case 6 : gotoxy( 25, 9 );   cprintf( "%12s", state[ch[c].status] );   break;
      case 5 : gotoxy( 25, 14 );  cprintf( "%12s", state[ch[c].status] );   break;
      case 4 : gotoxy( 25, 19 );  cprintf( "%12s", state[ch[c].status] );   break;
      case 3 : gotoxy( 64, 4 );   cprintf( "%12s", state[ch[c].status] );   break;
      case 2 : gotoxy( 64, 9 );   cprintf( "%12s", state[ch[c].status] );   break;
      case 1 : gotoxy( 64, 14 );  cprintf( "%12s", state[ch[c].status] );   break;
      case 0 : gotoxy( 64, 19 );  cprintf( "%12s", state[ch[c].status] );   break;
   }
   if( text )
   {
      textcolor( WHITE );
      switch( c )
      {
         case 7 : gotoxy( 3, 5 );    cprintf( "%-34.34s", text );  break;
         case 6 : gotoxy( 3, 10 );   cprintf( "%-34.34s", text );  break;
         case 5 : gotoxy( 3, 15 );   cprintf( "%-34.34s", text );  break;
         case 4 : gotoxy( 3, 20 );   cprintf( "%-34.34s", text );  break;
         case 3 : gotoxy( 42, 5 );   cprintf( "%-34.34s", text );  break;
         case 2 : gotoxy( 42, 10 );  cprintf( "%-34.34s", text );  break;
         case 1 : gotoxy( 42, 15 );  cprintf( "%-34.34s", text );  break;
         case 0 : gotoxy( 42, 20 );  cprintf( "%-34.34s", text );  break;
      }
   }
   textcolor( BLACK );
}


int OpenFile( int c, char* file )
{
   char  buf[100];
   char* s;
   int   r = 1;

   for( s = file; *s; s++ )
   {
      if( *s == '/' )
         *s = '\\';
      else if( *s == '.' && *(s + 1) == '.' )
         *s = ' ';
   }
   if( (s = getenv( "GSROOT" )) == NULL )
      strcpy( buf, "ROOT" );
   else
      strcpy( buf, s );
   switch( *file )
   {
      case 0    : strcat( buf, "\\CACHE" );
                  ErrorMsg = "ERROR - The root menu is unavailable!\n";
                  break;
      case 'i'  : ErrorMsg = "ERROR - You can't request this item.\n";
                  break;
      case '1'  : strcat( buf, &file[1] );
                  strcat( buf, "\\CACHE" );
                  ErrorMsg = "ERROR - This menu is unavailable.\n";
                  break;
      default   : strcat( buf, &file[1] );
                  ErrorMsg = "ERROR - This file is unavailable.\n";
                  break;
   }
   strlwr( buf );
   textbackground( LIGHTGRAY );
   if( (ch[c].fd = open( buf, O_RDONLY|O_BINARY )) != -1 )
      textcolor( BLACK );
   else
   {
      r = 0;
      textcolor( RED );
      errors++;
      gotoxy( 29, 25 );
      cprintf( "%ld", errors );
   }
   switch( c )
   {
      case 7 : gotoxy( 3, 6 );     cprintf( "%-35.35s", buf );   break;
      case 6 : gotoxy( 3, 11 );    cprintf( "%-35.35s", buf );   break;
      case 5 : gotoxy( 3, 16 );    cprintf( "%-35.35s", buf );   break;
      case 4 : gotoxy( 3, 21 );    cprintf( "%-35.35s", buf );   break;
      case 3 : gotoxy( 42, 6 );    cprintf( "%-35.35s", buf );   break;
      case 2 : gotoxy( 42, 11 );   cprintf( "%-35.35s", buf );   break;
      case 1 : gotoxy( 42, 16 );   cprintf( "%-35.35s", buf );   break;
      case 0 : gotoxy( 42, 21 );   cprintf( "%-35.35s", buf );   break;
   }
   return r;
}

void main()
{
   int             i;
   int             c;
   char            tw[] = "--\\\\||//";
   int             twi;
   char            buf[READSIZE + 1];
   long            hits = 0;
   struct sockaddr sa;
   long            t;
   FILE*           lf;

   _setcursortype( _NOCURSOR );
   DrawScreen();

   lf = fopen( "gs.log", "a" );
   time( &t );
   fprintf( lf, "%.24s  GS Started\n", ctime( &t ) );

   sock_init();

   for( i = 0; i < MAXCHANNELS; i++ )
   {
      ch[i].status = INIT;
      Status( i, "0.0.0.0" );
      ch[i].buflen = 0;
      ch[i].hits = 0L;
   }

   i = 0;
   twi = 0;
   while( !kbhit() || getch() != 27 )
   {
      gotoxy( 78, 25 );
      putch( tw[twi++] );
      putch( '\b' );
      if( twi == 8 )
         twi = 0;
      tcp_tick( &ch[i].s );
      switch( ch[i].status )
      {
         case INIT      : tcp_listen( &ch[i].s, 70, 0L, 0, NULL, 0 );
                          ch[i].status = WAITING;
                          Status( i, NULL );
                          ch[i].buflen = 0;
                          ch[i].fd = -1;
                          break;
         case WAITING   : tcp_tick( NULL );
                          if( sock_established( &ch[i].s ) )
                          {
                             ch[i].status = ACTIVE;
                             getpeername( &ch[i].s, &sa, NULL );
                             time( &t );
                             fprintf( lf, "%.24s  %s connected on %d\n", ctime( &t ), inet_ntoa( buf, sa.s_ip ), 7 - i );
                             Status( i, inet_ntoa( buf, sa.s_ip ) );
                             hits++;
                             gotoxy( 8, 25 );
                             cprintf( "%ld", hits );
                          }
                          break;
         case ACTIVE    : if( !tcp_tick( &ch[i].s ) )
                          {
                             sock_close( &ch[i].s );
                             ch[i].status = CLOSED;
                             Status( i, NULL );
                          }
                          else if( sock_dataready( &ch[i].s ) )
                          {
                             if( (c = sock_getc( &ch[i].s )) == '\r' || c == '\n' )
                             {
                                ch[i].buffer[ch[i].buflen] = 0;
                                time( &t );
                                if( OpenFile( i, ch[i].buffer ) )
                                {
                                   fprintf( lf, "%.24s  '%s' sent on %d\n", ctime( &t ), ch[i].buffer, 7 - i );
                                   ch[i].status = SENDING;
                                }
                                else
                                {
                                   fprintf( lf, "%.24s  Failed to send '%s' on %d\n", ctime( &t ), ch[i].buffer, 7 - i );
                                   sock_close( &ch[i].s );
                                   ch[i].status = CLOSED;
                                }
                                Status( i, NULL );
                             }
                             else
                                ch[i].buffer[ch[i].buflen++] = c;
                          }
                          break;
         case SENDING   : if( ch[i].fd == -1 )
                             sock_puts( &ch[i].s, ErrorMsg );
                          else
                          {
                             if( (c = read( ch[i].fd, buf, READSIZE )) > 0 )
                                sock_write( &ch[i].s, buf, c );
                          }
                          if( ch[i].fd == -1 || c < READSIZE )
                          {
                             close( ch[i].fd );
                             ch[i].fd = 0;
                             sock_close( &ch[i].s );
                             ch[i].status = CLOSED;
                             Status( i, NULL );
                          }
                          break;
         case CLOSED    : if( !tcp_tick( &ch[i].s ) )
                          {
		             ch[i].status = INIT;
                             Status( i, NULL );
                          }
                          break;
      }
      i++;
      if( i == MAXCHANNELS )
         i = 0;
   }

   for( i = 0; i < MAXCHANNELS; i++ )
      sock_close( &ch[i].s );

   time( &t );
   fprintf( lf, "%.24s  GS Halted\n", ctime( &t ) );

   fclose( lf );

   textcolor( LIGHTGRAY );
   textbackground( BLACK );
   clrscr();
   _setcursortype( _NORMALCURSOR );
}