/* CFILE.INC - Included into all .C files to set up config.h inclusion
   and PVCS setup. 
   $Header:   E:/pcdirs/vcs/tek/rge.c_v   1.0   15 Jan 1990 20:02:16   bkc  $
   Revision History --------------------------------------------------
   $Log:   E:/pcdirs/vcs/tek/rge.c_v  $
 * 
 *    Rev 1.0   15 Jan 1990 20:02:16   bkc
*/
#include "config.h"
static char ident[]={"$Workfile:   rgv.c  $ $Revision:   1.0  $"};

/* cu-notic.txt         NCSA Telnet version 2.2C     2/3/89
   Notice:
        Portions of this file have been modified by
        The Educational Resources Center of Clarkson University.

        All modifications made by Clarkson University are hereby placed
        in the public domain, provided the following statement remain in
        all source files.

        "Portions Developed by the Educational Resources Center, 
                Clarkson University"

        Bugs and comments to bkc@omnigate.clarkson.edu
                                bkc@clgw.bitnet

        Brad Clements
        Educational Resources Center
        Clarkson University
*/



/*

rgv.c by Aaron Contorer for NCSA

Thanks to Bruce Orchard for contributions to this code

graphics routines for drawing on VGA
Input coordinate space = 0..4095 by 0..4095
MUST BE COMPILED WITH LARGE MEMORY MODEL!

*/

#include <stdio.h>
	/* used for debugging only */
#include <dos.h>
	/* used for VGA init call */

#include "newwin.h"
     
#define TRUE -1
#define FALSE 0
#define INXMAX 4096
#define INYMAX 4096
#define SCRNXHI 639
#define SCRNYHI 479
#define MAXRW 32
	/* max. number of real windows */

extern char *malloc();

static int VGAactive;		/* number of currently VGAactive window */
static char *VGAname = "Enhanced Graphics Adaptor, 640 x 350";
#define VGAxmax 640
#define VGAymax 480
static int VGAbytes=80;	/* number of bytes per line */

/* Current status of an VGA window */
struct VGAWIN {
	char inuse; /* true if window in use */
	int pencolor, rotation, size;
	int winbot,winleft,wintall,winwide;
		/* position of the window in virtual space */
	};


static struct VGAWIN VGAwins[MAXRW];

static  int     egastartmode;   /* what mode we started in */
extern  int     rgdevice,autovideo;

VGAsetup()
/* prepare variables for use in other functions */
{
        union REGS io;          /* modified BKC 10/12/88 to support 
                                 large window sizes, ie: 43 line mode */
        if(!egastartmode) {     /* for some reason this is called
                                   after entering tekmode, so if set
                                   already, we skip it 
                                */
                io.x.ax=0x0f00;
                int86(0x10,&io,&io);
                egastartmode = io.x.ax & 0xFF;        
        }                        
}


RGVgmode()
/* go into VGA graphics mode */
{
	union REGS in;
	in.x.ax = 0x12;
	int86(0x10,&in,&in);
}

RGVtmode()
/* go into VGA 80x25 color text mode */
{
	union REGS in;
	in.x.ax = 3;
	int86(0x10,&in,&in);
        ega43();                        /* go into ega 43 line mode if they requested it */
	VGAactive = -1;
}

vgareset()
{
   	union REGS in;
        unsigned char far *b;

        if((rgdevice != 1) || ((NUMLINES != 41) && (NUMLINES != 33)) || !autovideo)
           return;

        in.x.ax = 3; /* egastartmode;    */    /* put back to what it was when
                                           we started, might be in hi-res
                                           mode anyway
                                        */
	int86(0x10,&in,&in); 

}

RGVclrscr(w)
int w;
/*
	Clear the screen.
*/
{
	if (w == VGAactive) {
		VGAsetup();
		RGVgmode();
	}
}


int RGVnewwin()
/*
	Set up a new window; return its number.
	Returns -1 if cannot create window.
*/
{
	int w=0;

	while (w<MAXRW && VGAwins[w].inuse) w++;
	if (w==MAXRW) return(-1); /* no windows available */
	VGAwins[w].pencolor = 7;
	VGAwins[w].winbot = 0;
	VGAwins[w].wintall = 3120;
	VGAwins[w].winleft = 0;
	VGAwins[w].winwide = 4096;
	VGAwins[w].inuse = TRUE;
	return(w);
}


RGVclose(w)
int w;
{
	union REGS in;
#ifdef  REDICULOUS
	in.x.ax = 3;
#else
        in.x.ax = egastartmode;        /* put back to what it was when
                                           we started, might be in hi-res
                                           mode anyway
                                        */
#endif        
	int86(0x10,&in,&in);

	if (VGAactive==w) {
		RGVclrscr();
		VGAactive=-1;
	}
	VGAwins[w].inuse = FALSE;
}


RGVpoint(w,x,y)
int w,x,y;
/* set pixel at location (x,y) -- no range checking performed */
{
	int x2,y2; /* on-screen coordinates */

	if (w == VGAactive) {
		x2=(int) ((VGAxmax*(long)x)/INXMAX);
		y2=SCRNYHI-(int) (((long)y*VGAymax)/INYMAX);
		EGAset (x2, y2, VGAwins[w].pencolor);
	}
}


RGVpagedone(w)
int w;
/*
	Do whatever has to be done when the drawing is all done.
	(For printers, that means eject page.)
*/
{
	/* do nothing for VGA */
}


RGVdataline(w,data,count)
int w,count;
char *data;
/*
	Copy 'count' bytes of data to screen starting at current
	cursor location.
*/
{
	/* Function not supported yet. */
}


RGVpencolor(w,color)
int w,color;
/*
	Change pen color to the specified color.
*/
{
#ifdef	OLDSTUFF
	if (!color)
		color = 1;
	color &= 0x7;
				/* flip color scale */
	VGAwins[w].pencolor = 8 - color;
#else
	VGAwins[w].pencolor = color & 0xf;
#endif
}


RGVcharmode(w,rotation,size)
/*
	Set description of future device-supported graphtext.
	Rotation=quadrant.
*/
{
	/* No rotatable device-supported graphtext is available on VGA. */
}

/* Not yet supported: */
RGVshowcur() {}
RGVlockcur() {}
RGVhidecur() {}

#ifndef	_MSC_
static int abs(x)
int x;
{
  if (x>=0) return(x);
  else return(-x);
}
#endif

RGVdrawline(w,x0,y0,x1,y1)
int w,x0,y0,x1,y1;
/* draw a line from (x0,y0) to (x1,y1) */
/* uses Bresenham's Line Algorithm */
{
	int x,y,dx,dy,d,temp,
	dx2,dy2,		/* 2dx and 2dy */
	direction;		/* +1 or -1, used for slope */
	char transpose;	/* true if switching x and y for vertical-ish line */

	if (w != VGAactive) return;

	x0 = (int) (((long) x0 * VGAxmax) / INXMAX);
	y0 = VGAymax - 1 - (int) ((VGAymax*(long) y0) / INYMAX);
	x1 = (int) (((long) x1 * VGAxmax) / INXMAX);
	y1 = VGAymax - 1 - (int) ((VGAymax*(long) y1) / INYMAX);

	if (abs(y1-y0) > abs(x1-x0)) {
		/* transpose vertical-ish to horizontal-ish */
		temp=x1; x1=y1; y1=temp;
		temp=x0; x0=y0; y0=temp;
		transpose=TRUE;
	} else transpose=FALSE;

	/* make sure line is left to right */
	if (x1 < x0) {
		temp=x1; x1=x0; x0=temp;
		temp=y1; y1=y0; y0=temp;
	}

	/* SPECIAL CASE: 1 POINT */
	if (x1==x0 && y1==y0) {
		EGAset (x1, y1, VGAwins[w].pencolor);
		return(0);
	}


	/* ANY LINE > 1 POINT */

	x=x0;
	y=y0;
	dx=x1-x0;
	if (y1 >= y0) {
		dy=y1-y0;
		direction=1;
	} else {
		dy=y0-y1;
		direction= -1;
	}
	dx2=dx<<1;
	dy2=dy<<1;

	d = (dy<<1) - dx;

	if (transpose) {	
		/* CASE OF VERTICALISH (TRANSPOSED) LINES */
		while (x <= x1) {
			if (y>=0 && y<VGAxmax && x>=0 && x<VGAymax)
				EGAset (y, x, VGAwins[w].pencolor);
			while (d >= 0) {
				y += direction;
				d -= dx2;
			}
			d += dy2;
			x++;
		}

	} else {
		/* CASE OF HORIZONTALISH LINES */
		while (x <= x1) {
			if (x>=0 && x<VGAxmax && y>=0 && y<VGAymax)
				EGAset (x, y, VGAwins[w].pencolor);
			while (d >= 0) {
				y += direction;
				d -= dx2;
			}
			d += dy2;
			x++;
		}
	} /* end horizontalish */

} /* end RGVdrawline() */


RGVbell(w)
int w;
/* Ring bell in window w */
{
	if (w == VGAactive) putchar(7);
}


char *RGVdevname()
/* return name of device that this RG supports */
{
	return(VGAname);
}


RGVinit()
/* initialize all RGV variables */
{
	int i;
	VGAsetup();
	for (i=0; i<MAXRW; i++) {
		VGAwins[i].inuse = FALSE;
	}
	VGAactive = -1;
}


RGVuncover(w)
int w;
/*
	Make this window visible, hiding all others.
	Caller should follow this with clrscr and redraw to show the current
	contents of the window.
*/
{
	VGAactive = w;
}

RGVinfo(w,a,b,c,d,v) {}
