/* CFILE.INC - Included into all .C files to set up config.h inclusion
   and PVCS setup. 
   $Header:   E:/pcdirs/vcs/tek/rgp.c_v   1.0   15 Jan 1990 20:01:44   bkc  $
   Revision History --------------------------------------------------
   $Log:   E:/pcdirs/vcs/tek/rgp.c_v  $
 * 
 *    Rev 1.0   15 Jan 1990 20:01:44   bkc
*/
#include "config.h"
static char ident[]={"$Workfile:   rgp.c  $ $Revision:   1.0  $"};

/* cu-notic.txt         NCSA Telnet version 2.2C     2/3/89
   Notice:
        Portions of this file have been modified by
        The Educational Resources Center of Clarkson University.

        All modifications made by Clarkson University are hereby placed
        in the public domain, provided the following statement remain in
        all source files.

        "Portions Developed by the Educational Resources Center, 
                Clarkson University"

        Bugs and comments to bkc@omnigate.clarkson.edu
                                bkc@clgw.bitnet

        Brad Clements
        Educational Resources Center
        Clarkson University
*/


/*

rgp.c by Aaron Contorer for NCSA

Routines for PostScript output.  Only 1 window output at a time.

*/

#define TRUE 1
#define FALSE 0

static char *psname = "PostScript output";
static char busy; /* is device already in use */
static int winbot,winleft,wintall,winwide;
	/* position and size of window into virtual space */
static int (*outfunc)();
	/* the function to call with pointer to strings */
static char pstext[100];
	/* the string containing the PostScript output text */
static char PSblank, PSnopath;

static signore(s)
char *s;
/* Ignore the string pointer passed here. */
{}


RGPoutfunc(f)
int (*f)();
/*
	Specify the function that is to be called with pointers to all
	the PostScript strings.
*/
{
	outfunc = f;
}


static stroke()
{
	if (!PSnopath) (*outfunc)(" S ");
}

static PSenv()
/* set up PostScript environment for new page */
{
	/* Map 4k x 4k graphics onto 11x8 inch paper space,
	leaving margins and preserving 4x3 aspect ratio. */

	(*outfunc)("533 72 translate\n");
	(*outfunc)("90 rotate\n");
	(*outfunc)("newpath\n 1 setlinewidth\n 0.16 0.12 scale\n");
}

static psbegin()
/* set up PS environment for whole new printout */
{
	(*outfunc)("%! PostScript code from NCSA software\n");
	(*outfunc)("% National Center for Supercomputing Applications\n");
	(*outfunc)("% at the University of Illinois\n\n");
	(*outfunc)("/M { moveto } def\n");
	(*outfunc)("/L { lineto } def\n");
	(*outfunc)("/N { newpath } def\n");
	(*outfunc)("/S { stroke } def\n");
	(*outfunc)("/R { rlineto } def\n");
	(*outfunc)("/H { 0 0 moveto newpath } def\n");
}

int RGPnewwin()
{
	if (busy) return(-1);
	else {
		busy=TRUE;
		psbegin();
		PSnopath=TRUE;
		pstext[0] = '\0';
		PSblank=TRUE;
		return(0);
	}
}

RGPclrscr(w){
	RGPpagedone(w);
}

RGPclose(w) {
	RGPclrscr(w);
	busy=FALSE;
}

RGPpoint(w,x,y) {
	(*outfunc)("3 0 R -3 0 R\n");
	PSblank=FALSE;
	PSnopath=FALSE;
} 

RGPdrawline(w,x0,y0,x1,y1)
int w,x0,y0,x1,y1;
{
	stroke();
	if (PSblank) {
		PSenv();
		PSblank=FALSE;
	}
	sprintf(pstext,"H %d %d M %d %d L\n",x0,y0,x1,y1);
	(*outfunc)(pstext);
	PSnopath=FALSE;
}

RGPpagedone(w) {
	if (!PSblank) {
		stroke();
		(*outfunc)("showpage\n");
		(*outfunc)("% ++ DONE\n");
	}
	PSblank=TRUE;
}

RGPdataline(w,data,count) {}
RGPpencolor(w,color){}
RGPcharmode(w,rotation,size) {}
RGPshowcur() {}
RGPlockcur() {}
RGPhidecur() {}
RGPbell(w) {}
RGPuncover(w) {}

char *RGPdevname() {
	return(psname);
}

RGPinit() {
	busy=FALSE;
	PSblank=TRUE;
	PSnopath=TRUE;
	outfunc=signore;
}

RGPinfo(w,a,b,c,d,v) {}

RGPgmode() {}
RGPtmode() {}
