/* CFILE.INC - Included into all .C files to set up config.h inclusion
   and PVCS setup. 
   $Header:   E:/pcdirs/vcs/tek/rghp.c_v   1.0   15 Jan 1990 20:02:04   bkc  $
   Revision History --------------------------------------------------
   $Log:   E:/pcdirs/vcs/tek/rghp.c_v  $
 * 
 *    Rev 1.0   15 Jan 1990 20:02:04   bkc
*/
#include "config.h"
static char ident[]={"$Workfile:   rghp.c  $ $Revision:   1.0  $"};

/* cu-notic.txt         NCSA Telnet version 2.2C     2/3/89
   Notice:
        Portions of this file have been modified by
        The Educational Resources Center of Clarkson University.

        All modifications made by Clarkson University are hereby placed
        in the public domain, provided the following statement remain in
        all source files.

        "Portions Developed by the Educational Resources Center, 
                Clarkson University"

        Bugs and comments to bkc@omnigate.clarkson.edu
                                bkc@clgw.bitnet

        Brad Clements
        Educational Resources Center
        Clarkson University
*/


/*

rghp.c by Aaron Contorer for NCSA

Routines for HP-GL plotter output.  Only 1 window output at a time.

*/

#define TRUE 1
#define FALSE 0

static char *HPname = "Hewlett-Packard HP-GL plotter";
static char busy; /* is device already in use */
static int winbot,winleft,wintall,winwide;
	/* position and size of window into virtual space */
static int (*outfunc)();
	/* the function to call with pointer to strings */
static char HPtext[100];
	/* the string containing the HP-GL output text */
static int HPpenx,HPpeny;
static int HPblank;
static int HPcolor;

static signore(s)
char *s;
/* Ignore the string pointer passed here. */
{}


RGHPoutfunc(f)
int (*f)();
/*
	Specify the function that is to be called with pointers to all
	the HP-GL strings.
*/
{
	outfunc = f;
}


static HPbegin()
/* set up environment for whole new printout */
{
	(*outfunc)("IN;SP1;SC-50,4370,-100,4120;PU0,0;");
	HPpenx = HPpeny = 0;
}

int RGHPnewwin()
{
	if (busy) return(-1);

	HPtext[0] = '\0';
	HPpenx = HPpeny = 0;
	HPblank = TRUE;
	HPcolor = 100;
	return(0);
}

RGHPclrscr(w){
	RGHPpagedone(w);
}

RGHPclose(w) {
	RGHPclrscr(w);
	busy=FALSE;
}

RGHPpoint(w,x,y) {
	(*outfunc)("PD;PU;");
} 

RGHPdrawline(w,x0,y0,x1,y1)
int w,x0,y0,x1,y1;
{
	if (HPblank) {
		HPbegin();
		HPblank = FALSE;
	}

	if (x0 != HPpenx || y0 != HPpeny) {
		/* only move pen if not already there */
		sprintf(HPtext,"PU%d,%d;",x0, y0);
		(*outfunc)(HPtext);
	}
	sprintf(HPtext,"PD%d,%d;",x1, y1);
	(*outfunc)(HPtext);
	HPpenx=x1;
	HPpeny=y1;
}

RGHPpagedone(w) {
	(*outfunc)("PG;");
	HPblank = TRUE;
}

RGHPdataline(w,data,count) {}

RGHPpencolor(w,color) {
	color &= 7;
	if (color) {
		sprintf(HPtext,"SP%d;",color);
		(*outfunc)(HPtext);
	}
}

RGHPcharmode(w,rotation,size) {}
RGHPshowcur() {}
RGHPlockcur() {}
RGHPhidecur() {}
RGHPbell(w) {}
RGHPuncover(w) {}

char *RGHPdevname() {
	return(HPname);
}

RGHPinit() {
	busy=FALSE;
	outfunc=signore;
}

RGHPinfo(w,a,b,c,d,v) {}

RGHPgmode() {}
RGHPtmode() {}
