/* CFILE.INC - Included into all .C files to set up config.h inclusion
   and PVCS setup. 
   $Header:   E:/pcdirs/vcs/tools.c_v   1.0   15 Jan 1990 19:26:38   bkc  $
   Revision History --------------------------------------------------
   $Log:   E:/pcdirs/vcs/tools.c_v  $
 * 
 *    Rev 1.0   15 Jan 1990 19:26:38   bkc
*/
#include "config.h"
static char ident[]={"$Workfile:   tools.c  $ $Revision:   1.0  $"};

/* cu-notic.txt         NCSA Telnet version 2.2C     2/3/89
   Notice:
        Portions of this file have been modified by
        The Educational Resources Center of Clarkson University.

        All modifications made by Clarkson University are hereby placed
        in the public domain, provided the following statement remain in
        all source files.

        "Portions Developed by the Educational Resources Center, 
                Clarkson University"

        Bugs and comments to bkc@omnigate.clarkson.edu
                                bkc@clgw.bitnet

        Brad Clements
        Educational Resources Center
        Clarkson University
*/


/*
*      TOOLS.C
*
****************************************************************************
*                                                                          *
*      part of:                                                            *
*      TCP/IP kernel for NCSA Telnet                                       *
*      by Tim Krauskopf                                                    *
*                                                                          *
*      National Center for Supercomputing Applications                     *
*      152 Computing Applications Building                                 *
*      605 E. Springfield Ave.                                             *
*      Champaign, IL  61820                                                *
*                                                                          *
****************************************************************************
*
*  Portions of the driver code that are not specific to a particular protocol
*
*/
#include "stdio.h"
#if  defined(__TURBOC__)||defined(_MSC_)
#include        <time.h>
#endif
#include "protocol.h"
#include "data.h"


/************************************************************************/
/*  netsleep
*      sleep, while demuxing packets, so we don't miss anything
*
*/
netsleep(n)
	int n;
	{
	int i,nmux,redir;
	int32 t,gt,start;
	struct port *p;
	uint8 *pc;

	redir = 0;
	start = n_clicks(NULL);
#ifdef  XDEBUG
        printf("netsleep(%d) ",n);
#endif
	if (n)
		t = start + n*TICKSPERSEC;
	else
		t = start;

	do {
		nmux = demux(1);				/* demux all packets */

/*
*  if there were packets in the incoming packet buffer, then more might
*  have arrived while we were processing them.  This gives absolute priority
*  to packets coming in from the network.
*/
		if (nmux)
			continue;
/*
*  Check for any ICMP redirect events.
*/
		if (IREDIR == netgetevent(ICMPCLASS,&i,&i))
			redir = 1;
/*
*  Check each port to see if action is necessary.
*  This now sends all Ack packets, due to p->lasttime being set to 0L.
*  Waiting for nmux == 0 for sending ACKs makes sure that the network
*  has a much higher priority and reduces the number of unnecessary ACKs.
*/
		gt = n_clicks(NULL);

		for (i=0; i < NPORTS; i++) {
			p = portlist[i];
			if ((p != NULL) && (p->state > SLISTEN)) {
				if(p->flags & PORT_FLAGS_LOOPBACK)
				       	continue;
				if (!p->out.lasttime) /* forcing acks */
					transq(p);				/* takes care of all ACKs */

				else if ((p->out.contain > 0) || (p->state > SEST) || (p->state == SSYNR)) {
/*
*  if a retransmission timeout occurs, exponential back-off.
*  This number returns toward the correct value by the RTT measurement
*  code in ackcheck.
*
*  fix: 5/12/88, if timer was at MAXRTO, transq didn't get hit - TK
*/
#ifndef  NONAGLE
                                        if(p->out.ack >= p->out.uack && (p->out.contain > 0) && p->state == SEST)
                                                transq(p);      /* nagle... send more data if all data is acked */
#endif
					if ((p->out.lasttime + p->rto < gt)) {
						if (p->rto < MAXRTO) {
						       	if(p->rto < MINRTO)
							       	p->rto = MINRTO;
							else
								p->rto <<= 1;		/* double it */
					        }
                        /* SLOW START */
						if(p->state != SSYNR) {
	                                                p->out.cwnd = p->sendsize;
       	                                         p->out.ssthresh = p->out.size >> 1;
               	                                 if(p->out.ssthresh < (p->sendsize << 1))
                       	                                 p->out.ssthresh = p->sendsize << 1;
						}

						transq(p);
					} /* end if p->out.lasttime + p->rto < gt */
				} /* end if p->contain > 0 */

				if ((p->out.lasttime + POKEINTERVAL < gt) && 
					(p->state == SEST))
					transq(p);
/*
*  check to see if ICMP redirection occurred and needs servicing.
*  If it needs servicing, try to get the new hardware address for the new 
*  gateway.  If getdlayer fails, we assume an ARP was sent, another ICMP
*  redirect will occur, this routine will reactivate, and then the hardware
*  address will be available in the cache.
*  Check all ports to see if they match the redirected address.
*/
				if (redir && comparen(p->tcpout.i.ipdest,nnicmpsave,4)) {
					pc = getdlayer(nnicmpnew);
					if (pc != NULL)
						movebytes(p->tcpout.d.dest,pc,DADDLEN);
				}
			 	if(p->nextstate && p->state != SCLOSED && (p->alarm < time(NULL))) {
					/* do something with this port */
					if(p->nextstate == SCLOSED) {
						netputevent(CONCLASS,CONCLOSE,i); /* i has portnum */
						p->state = SCLOSED;
					}
				 	else 
					       	p->state = p->nextstate;
					p->alarm = 0;
					p->nextstate = 0;
			        }
			}
		}
		redir = 0;				/* reset flag for next demux */

	} while ((t > n_clicks(NULL)) 		/* done yet? */
		&& (n_clicks(NULL) >= start));  /* allow for wraparound of timer */


	return(nmux);				/* will demux once, even for sleep(0) */

}

/***************************************************************************/
/*  enqueue
*   add something to a TCP queue.  Used by both 'write()' and tcpinterpret
*   WINDOWSIZE is the size limitation of the advertised window.
*/
enqueue(wind,buffer,nbytes)
	struct window *wind;
	char *buffer;
	int nbytes;
	{
	int i;

	i = WINDOWSIZE - wind->contain;
	if (i <= 0 || nbytes == 0)
		return(0);						/* no room at the inn */

	if (nbytes > i)
		nbytes = i;

	i = wind->where - wind->endlim;		/* room at end */
	i += WINDOWSIZE;

	if (i < nbytes) {
		movebytes(wind->endlim,buffer,i);
		movebytes(wind->where,(char *)(buffer+i),nbytes-i);
		wind->endlim = wind->where + nbytes - i;
	} 
	else {
		movebytes(wind->endlim,buffer,nbytes);		/* fits in one chunk */
		wind->endlim += nbytes;
	}
	wind->contain += nbytes;			/* more stuff here */

	return(nbytes);

}

/*************************************************************************/
/* dequeue
*     used by read, this copies data out of the queue and then
*  deallocates it from the queue.
*  cpqueue and rmqueue are very similar and are to be used by tcpsend
*  to store unacknowledged data.
*
*  returns number of bytes copied from the queue
*/
dequeue(wind,buffer,nbytes)
	struct window *wind;
	char *buffer;
        int nbytes;				/* maximum number to copy out */
	{
	int i;

	if (wind->contain == 0)
		return(0);

	if (wind->contain < nbytes)
		nbytes = wind->contain;

	i = wind->endbuf - wind->base;

	if (i <= nbytes) {
		movebytes(buffer,wind->base,i);
		movebytes((char *)(buffer+i),wind->where,nbytes-i);
		wind->base = wind->where + nbytes-i;
	}
	else {
		movebytes( buffer, wind->base, nbytes);
		if (wind->contain == nbytes) 
			wind->base = wind->endlim = wind->where;
		else
			wind->base += nbytes;
	}
	
	wind->contain -= nbytes;

	return(nbytes);

}

#ifdef notneeded
/**************************************************************************/
/*  cpqueue
*       does the same thing as dequeue, but does not deallocate the data
*   used when transmitting TCP data.  When the data is ACKed, then 
*   rmqueue is called to deallocate the correct amount of data.
*/
cpqueue(wind,buffer,nbytes)
	struct window *wind;
	char *buffer;
	int nbytes;				/* maximum number to copy out */
	{
	int i;

	if (wind->contain == 0)
		return(0);

	if (wind->contain < nbytes)
		nbytes = wind->contain;

	i = wind->endbuf - wind->base;

	if (i < nbytes) {
		movebytes(buffer,wind->base,i);
		movebytes((char *)(buffer+i),wind->where,nbytes-i);
	}
	else 
		movebytes( buffer, wind->base, nbytes);
	
	return(nbytes);

}
#endif

/**************************************************************************/
/*  rmqueue
*     does the queue deallocation that is left out of cpqueue
*
*   rmqueue of WINDOWSIZE or greater bytes will empty the queue
*/
rmqueue(wind,nbytes)
	struct window *wind;
	int nbytes;					/* number to remove */
	{
	int i;

	if (wind->contain < nbytes)
		nbytes = wind->contain;

	i = wind->endbuf - wind->base;

	if (i <= nbytes) 
		wind->base = wind->where+nbytes-i;
	else {
		if (wind->contain == nbytes)
			wind->base = wind->endlim = wind->where;
		else
			wind->base += nbytes;
	}
	
	wind->contain -= nbytes;

	return(nbytes);

}


/************************************************************************/
/*  transq
*
*   Needed for TCP, not as general as cpqueue, 
*   but is required for efficient transmit of the whole window.
*
*   Transmit the entire queue (window) to the other host without expecting
*   any sort of acknowledgement.
*
*/
transq(prt)
	struct port *prt;
	{
	uint bites;
	int i,j,n;
	struct window *wind;
	uint32 saveseq;
	uint8 *endb,*whereb,*baseb;

	if (prt == NULL) {
		nnerror(406);		/* NULL port for trans */
		return(-1);
	}

	wind = &prt->out;
/*
*   find out how many bytes the other side will allow us to send (window)
*/
	bites = wind->size;

        if(wind->cwnd < bites) {
                bites = (wind->cwnd/prt->sendsize) * prt->sendsize;
                if(!bites)
                        bites = prt->sendsize;
        }
restart:;
	if (wind->contain < bites)
		bites = wind->contain;

/*
*  set up the tcp packet for this, ACK field is same for all packets
*/
	prt->tcpout.t.ack = longswap(prt->in.nxt);
/*
*  any more flags should be set?
*/
	if (wind->push && (bites > 0)) 			/* is push indicator on? */
		prt->tcpout.t.flags |= TPUSH;
        else
                prt->tcpout.t.flags &= ~TPUSH;          /* else clear push */
/* we never set push flag unless we are actually sending data */

	if ((bites <= 0) || prt->state != SEST) {	/* if no data to send . . . */
	        if(prt->state == SEST && !prt->out.size) {
			if(prt->out.cwnd)
			       tcpsend(prt,0);
			else
			       if(prt->out.lasttime < n_clicks(NULL)) { /* timed out waiting for window open */
					bites = prt->sendsize;
				 	prt->out.lasttime = n_clicks(NULL) + 5 * TICKSPERSEC;
				 	goto restart;
			       }
			prt->out.cwnd = 0;
			prt->out.lasttime = n_clicks(NULL) + 5 * TICKSPERSEC;
			return(0);

		}
		tcpsend(prt,0);				/* just a retransmission or ACK */
		return(0);
	}

/*
*  we have data to send, get the correct sequence #'s 
*  To be really real, we should check wraparound sequence # in the loop.
*/
	saveseq = wind->nxt; /* nxt; */

	whereb = wind->where;
	endb = wind->endbuf;
	baseb = wind->base;
/*
*  in a loop, transmit the entire queue of data 
*/
	for (i=0 ; i < bites; i += prt->sendsize) {
		n = prt->sendsize;
		if (i + n > bites)
			n = bites - i;

		j = endb - baseb;

		if (j < n) {
			movebytes(prt->tcpout.x.data,baseb,j);
			movebytes((char *)(prt->tcpout.x.data+j),whereb,n-j);
			baseb = whereb + n-j;
		}
		else {
			movebytes( prt->tcpout.x.data, baseb, n);
			baseb += n;
		}

		tcpsend(prt,n);						/* send it */
		wind->nxt += n;
	}
        wind->uack = wind->nxt;
	wind->nxt = saveseq; 					/* get back first seq # */

	return(0);
}
